/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.gateway.external.tools;

import com.mapr.fs.gateway.external.GatewaySink;
import java.io.IOException;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;

class ExternalOutputFormat
extends FileOutputFormat<ImmutableBytesWritable, Result> {
    private static final String PROP_EXT_DST_TABLE = "external.destination.table";
    private static final String PROP_IS_COMPARE = "external.is_comapre";

    ExternalOutputFormat() {
    }

    public static void setDestinationTable(Job job, String dest) {
        job.getConfiguration().set(PROP_EXT_DST_TABLE, dest);
    }

    public static String getDestinationTable(TaskAttemptContext job) {
        return job.getConfiguration().get(PROP_EXT_DST_TABLE);
    }

    public static void setIsCompare(Job job, boolean isCompare) {
        job.getConfiguration().setBoolean(PROP_IS_COMPARE, isCompare);
    }

    public static boolean getIsCompare(TaskAttemptContext job) {
        return job.getConfiguration().getBoolean(PROP_IS_COMPARE, false);
    }

    public RecordWriter<ImmutableBytesWritable, Result> getRecordWriter(TaskAttemptContext job) throws IOException {
        return new ExternalRecordWriter(job);
    }

    class ExternalRecordWriter
    extends RecordWriter<ImmutableBytesWritable, Result> {
        private GatewaySink sink;
        private boolean isCompare = false;

        public ExternalRecordWriter(TaskAttemptContext job) throws IOException {
            this.isCompare = ExternalOutputFormat.getIsCompare(job);
            this.sink = new GatewaySink();
            if (this.sink.OpenStream(ExternalOutputFormat.getDestinationTable(job)) != 0) {
                throw new IOException("Failed to open GatewaySink");
            }
        }

        public void close(TaskAttemptContext job) throws IOException {
            if (this.sink.CloseStream() != 0) {
                throw new IOException("Failed to close GatewaySink");
            }
        }

        public void write(ImmutableBytesWritable key, Result value) throws IOException {
            if (this.isCompare) {
                boolean compareRet = false;
                try {
                    compareRet = this.sink.CompareStream(value);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new IOException("Exception while comparing stream: " + e.getMessage());
                }
                if (!compareRet) {
                    throw new IOException("Tables do not match");
                }
            } else if (this.sink.AppendStream(value) != 0) {
                throw new IOException("Failed to append to GatewaySink stream");
            }
        }
    }
}

