/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.gateway.external;

import com.mapr.fs.gateway.external.GatewayClassLoader;
import com.mapr.fs.gateway.external.MapRExternalSink;
import com.mapr.fs.gateway.external.MapRImplExternalSink;
import com.mapr.fs.hbase.ResultConverter;
import com.mapr.fs.jni.MapRResult;
import com.mapr.fs.jni.ParsedRow;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.client.Result;
import org.yaml.snakeyaml.Yaml;

public class GatewaySink {
    public static final Log LOG = LogFactory.getLog(GatewaySink.class);
    public static Configuration conf;
    public static FileSystem fs;
    public static GatewayClassLoader cloader;
    public static final String EXT_ELASTICSEARCH = ".es";
    private Map<Integer, String> familyIdMap;
    private MapRExternalSink client = null;
    private String sinkConfigFile = null;

    public static void init() {
        try {
            conf = new Configuration();
            fs = FileSystem.get((Configuration)conf);
            Class<GatewaySink> cls = GatewaySink.class;
            ClassLoader parentClassLoader = cls.getClassLoader();
            cloader = new GatewayClassLoader(parentClassLoader);
            cloader.setLocalPath("/opt/mapr/lib/external");
        }
        catch (Exception e) {
            LOG.error((Object)"Error loading the gatewaySink Class");
            LOG.error((Object)e);
        }
    }

    public static String verifyDstSanity(String dstPath) throws IOException {
        String replicaClassName = null;
        String sinkJarPath = null;
        FSDataInputStream sinkConfStream = fs.open(new Path(dstPath));
        Yaml yaml = new Yaml();
        Map sinkConfMap = (Map)yaml.load((InputStream)sinkConfStream);
        sinkConfStream.close();
        sinkJarPath = (String)sinkConfMap.get("sink.class.path");
        if (sinkJarPath == null) {
            throw new IOException("sink.class.path NOT FOUND in external replica config file " + dstPath);
        }
        replicaClassName = (String)sinkConfMap.get("sink.class.name");
        if (replicaClassName == null && dstPath.endsWith(EXT_ELASTICSEARCH)) {
            replicaClassName = "com.mapr.fs.external.es.ESSink";
        }
        if (replicaClassName == null) {
            throw new IOException("sink.class.name NOT FOUND in external replica config file or unknown file extension");
        }
        try {
            Class sinkClass = cloader.loadClass(sinkJarPath, replicaClassName);
            MapRExternalSink temp_client = (MapRExternalSink)sinkClass.newInstance();
            temp_client.verifyConfigMapSanity(sinkConfMap);
        }
        catch (Exception e) {
            throw new IOException("Can not load the external sink for replica :" + dstPath + " Exception:" + e);
        }
        return replicaClassName;
    }

    public int OpenStream(String sConfigFile) {
        return this.OpenStream(sConfigFile, null, null, null);
    }

    public int OpenStream(String sConfigFile, String gatewayConfigFile, int[] familyIds, String[] familyNames) {
        this.sinkConfigFile = sConfigFile;
        LOG.info((Object)(">OpenStream for " + this.sinkConfigFile));
        if (familyIds != null) {
            this.familyIdMap = new HashMap<Integer, String>();
            for (int i = 0; i < familyIds.length; ++i) {
                this.familyIdMap.put(familyIds[i], familyNames[i]);
            }
        }
        try {
            FSDataInputStream sinkConfStream = fs.open(new Path(this.sinkConfigFile));
            Yaml yaml = new Yaml();
            Map sinkConfMap = (Map)yaml.load((InputStream)sinkConfStream);
            sinkConfStream.close();
            String sinkJarPath = (String)sinkConfMap.get("sink.class.path");
            String sinkClassName = (String)sinkConfMap.get("sink.class.name");
            if (sinkClassName == null) {
                sinkClassName = "com.mapr.fs.external.es.ESSink";
            }
            Class sinkClass = cloader.loadClass(sinkJarPath, sinkClassName);
            this.client = (MapRExternalSink)sinkClass.newInstance();
            if (gatewayConfigFile != null) {
                this.client.loadConfig(gatewayConfigFile);
            }
            if (this.client instanceof MapRImplExternalSink) {
                ((MapRImplExternalSink)this.client).connect(this.sinkConfigFile, this.familyIdMap);
            } else {
                this.client.connect(this.sinkConfigFile);
            }
        }
        catch (Exception e) {
            LOG.error((Object)("<OpenStream returning with error for " + this.sinkConfigFile));
            LOG.error((Object)e);
            return 1;
        }
        LOG.info((Object)("<OpenStream for " + this.sinkConfigFile));
        return 0;
    }

    private void AppendDeleteColumn(MapRResult result) throws IOException {
        byte[] key = new byte[result.keyLength];
        System.arraycopy(result.bufBytes, 0, key, 0, result.keyLength);
        int cellPos = 0;
        int colPos = 0;
        for (int f = 0; f < result.cfIds.length; ++f) {
            String fam = this.familyIdMap.get(result.cfIds[f]);
            int c = 0;
            while (c < result.cellsPerFamily[f]) {
                byte[] column = new byte[result.getColumnLengths()[colPos]];
                System.arraycopy(result.bufBytes, result.getColumnOffsets()[colPos], column, 0, result.getColumnLengths()[colPos]);
                cellPos += result.versions()[colPos] - 1;
                c += result.versions()[colPos] - 1;
                if (result.getColumnOffsets()[colPos] == 0) {
                    this.client.deleteColumnFamily(new String(key, "UTF-8"), fam);
                } else if (result.getIsColDelete()[cellPos] == 1 || result.getIsColDeleteExact()[cellPos] == 1) {
                    this.client.deleteColumn(new String(key, "UTF-8"), fam, new String(column, "UTF-8"));
                }
                ++cellPos;
                ++c;
                ++colPos;
            }
        }
    }

    public int AppendStream(MapRResult[] results) {
        try {
            ParsedRow prow = new ParsedRow();
            for (MapRResult result : results) {
                result.DecodeByteBuf(prow);
                byte[] key = new byte[result.keyLength];
                System.arraycopy(result.bufBytes, 0, key, 0, result.keyLength);
                if (result.getIsDelete()) {
                    this.client.delete(new String(key, "UTF-8"));
                    continue;
                }
                if (this.client instanceof MapRImplExternalSink && ((MapRImplExternalSink)this.client).useMapRResult()) {
                    ((MapRImplExternalSink)this.client).update(result);
                    continue;
                }
                this.AppendDeleteColumn(result);
                this.client.update(ResultConverter.toHBaseResult((MapRResult)result, null, this.familyIdMap));
            }
        }
        catch (Exception e) {
            LOG.error((Object)("<AppendStream returning with error: " + e.getMessage() + " for" + this.sinkConfigFile));
            LOG.error((Object)e);
            return 1;
        }
        LOG.debug((Object)("<AppendStream for " + this.sinkConfigFile + " nRows:" + results.length));
        return 0;
    }

    public int AppendStream(Result result) {
        try {
            this.client.update(result);
        }
        catch (Exception e) {
            LOG.error((Object)("AppendStream failed: " + e.getMessage()));
            LOG.error((Object)e);
            return 1;
        }
        return 0;
    }

    public boolean CompareStream(Result result) throws IOException {
        return this.client.compare(result);
    }

    public int FlushStream() {
        LOG.debug((Object)(">FlushStream for " + this.sinkConfigFile));
        try {
            this.client.flush();
        }
        catch (Exception e) {
            LOG.error((Object)("<FlushStream failed: " + e.getMessage() + " for " + this.sinkConfigFile));
            LOG.error((Object)e);
            return 1;
        }
        LOG.debug((Object)("<FlushStream for " + this.sinkConfigFile));
        return 0;
    }

    public int CloseStream() {
        LOG.info((Object)(">CloseStream for " + this.sinkConfigFile));
        try {
            this.client.close();
        }
        catch (Exception e) {
            LOG.error((Object)("<CloseStream failed: " + e.getMessage() + " for " + this.sinkConfigFile));
            LOG.error((Object)e);
            return 1;
        }
        LOG.info((Object)("<CloseStream for " + this.sinkConfigFile));
        return 0;
    }

    static {
        GatewaySink.init();
    }
}

