/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.gateway;

import com.mapr.fs.gateway.Gateway;
import com.mapr.fs.gateway.conf.GatewayConfiguration;
import com.mapr.fs.gateway.conf.GatewayConfigurationHolder;
import com.mapr.fs.gateway.jni.GatewayNative;
import com.mapr.log4j.LogFlusher;
import java.io.IOException;
import java.util.Enumeration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.log4j.Logger;

public class GatewayServer
implements Runnable {
    private static final Log LOG;
    Gateway gateway;
    GatewayConfiguration conf;
    boolean shutdownInProg = false;
    Thread t;

    public GatewayConfiguration getConf() {
        return this.conf;
    }

    void start() throws Exception {
        this.t = new Thread(this);
        this.t.start();
    }

    void stop() {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Shutdown: Stopping Gateway");
        }
        System.exit(0);
    }

    void join() {
        try {
            this.t.join();
        }
        catch (InterruptedException e) {
            System.err.println("ERROR: thread join failed");
        }
    }

    public static void flushLogBuffer() {
        try {
            Enumeration allAppenders = Logger.getRootLogger().getAllAppenders();
            while (allAppenders.hasMoreElements()) {
                Object nextElement = allAppenders.nextElement();
                if (!(nextElement instanceof LogFlusher)) continue;
                LogFlusher f = (LogFlusher)nextElement;
                f.flush();
            }
        }
        catch (RuntimeException e) {
            System.err.println("ERROR: Failed flushing logs");
        }
    }

    public void setShutdownInProg() {
        this.shutdownInProg = true;
    }

    @Override
    public void run() {
        this.startGatewayJNI();
    }

    GatewayServer(Gateway gateway, int numWorkerThreads) throws Exception {
        this.gateway = gateway;
        this.conf = GatewayConfigurationHolder.getInstance();
    }

    private void startGatewayJNI() {
        try {
            FileSystem fs = FileSystem.get((Configuration)new Configuration());
            fs.close();
        }
        catch (IOException e) {
            LOG.info((Object)("Exception " + e));
            return;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Starting Gateway JNI ");
        }
        GatewayNative.startGatewayJNI(this.conf.getNumReceiveThreads(), this.conf.getPutMemMb(), this.conf.getGatewayPort(), this.conf.getMfsPortOffset(), this.conf.getNumFlushThreads(), this.conf.getLogSizeMb(), this.conf.getHostName(), this.conf.getLogFilePath(), this.conf.getConfFileName());
    }

    static {
        try {
            String gatewayNativeLibPath = null;
            String maprHome = System.getenv("MAPR_HOME");
            if (maprHome == null) {
                maprHome = "/opt/mapr";
            }
            gatewayNativeLibPath = maprHome + "/lib/libGatewayNative.so";
            System.load(maprHome + "/lib/libMapRClient.so.1");
            System.load(gatewayNativeLibPath);
        }
        catch (Throwable throwable) {
            System.err.println("Unable to load libGatewayNative.so : " + throwable.getMessage());
            System.exit(1);
        }
        LOG = LogFactory.getLog(GatewayServer.class);
    }
}

