/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tests.rowcol;

import com.mapr.db.MapRDB;
import com.mapr.db.impl.MapRDBTableImplHelper;
import com.mapr.db.rowcol.InsertContext;
import com.mapr.db.rowcol.KeyValue;
import com.mapr.db.rowcol.MutationImpl;
import com.mapr.db.rowcol.RowcolCodec;
import com.mapr.db.rowcol.TimeDescriptor;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.SimpleTest;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.ojai.FieldPath;

@Category(value={SimpleTest.class})
public class MutationTest
extends BaseTest {
    @Test
    public void SetRecordMutation() throws IOException {
        MutationImpl mutation = (MutationImpl)MapRDB.newMutation();
        mutation.set("a.b", 10).set("a.d", "Anurag").set("Address.zip", 94086).set("Address.Street", "Washington Avenue").set("Field1", 1000.0);
        Assert.assertEquals((Object)mutation.needsReadOnServer(), (Object)true);
        ByteBuffer b = mutation.rowcolSerialize();
        Document rec = RowcolCodec.decode((ByteBuffer)b, null, (boolean)true, (boolean)false, (boolean)true);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)((KeyValue)rec)), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)((KeyValue)rec)), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)((KeyValue)rec)), (Object)false);
        KeyValue kv = (KeyValue)rec.getValue("a");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.NONE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("a.b");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.SET);
        Assert.assertEquals((long)kv.getInt(), (long)10L);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)true);
        kv = (KeyValue)rec.getValue("a.d");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.SET);
        Assert.assertEquals((Object)kv.getString(), (Object)"Anurag");
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)true);
        kv = (KeyValue)rec.getValue("Address");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.NONE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("Address.zip");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.SET);
        Assert.assertEquals((long)kv.getInt(), (long)94086L);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)true);
        kv = (KeyValue)rec.getValue("Address.Street");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.SET);
        Assert.assertEquals((Object)kv.getString(), (Object)"Washington Avenue");
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)true);
        kv = (KeyValue)rec.getValue("Field1");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.SET);
        Assert.assertEquals((double)kv.getDouble(), (double)1000.0, (double)0.0);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)true);
    }

    @Test
    public void SetOrReplaceWithoutArrayRecordMutation() throws IOException {
        MutationImpl mutation = (MutationImpl)MapRDB.newMutation();
        mutation.setOrReplace("a.b", 10).setOrReplace("a.d", "Anurag").setOrReplace("Address.zip", 94086).setOrReplace("Address.Street", "Washington Avenue").setOrReplace("Field1", 1000.0);
        Assert.assertEquals((Object)mutation.needsReadOnServer(), (Object)false);
    }

    @Test
    public void SetOrReplaceRecordMutation() throws IOException {
        MutationImpl mutation = (MutationImpl)MapRDB.newMutation();
        mutation.setOrReplace("a.b", 10).setOrReplace("a.d", "Anurag").setOrReplace("Address.zip", 94086).setOrReplace("Address.Street", "Washington Avenue").setOrReplace("Field1", 1000.0).setOrReplace("Array1[50][100]", "Hello").setOrReplace("Array1[5][10]", 1.1).setOrReplace("A1[1].A2[2].A3[3]", -500);
        Assert.assertEquals((Object)mutation.needsReadOnServer(), (Object)true);
        ByteBuffer b = mutation.rowcolSerialize();
        Document rec = RowcolCodec.decode((ByteBuffer)b, null, (boolean)true, (boolean)false, (boolean)true);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)((KeyValue)rec)), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)((KeyValue)rec)), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)((KeyValue)rec)), (Object)false);
        KeyValue kv = (KeyValue)rec.getValue("a");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.NONE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("Array1");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.NONE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("Array1[50]");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.NONE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("Array1[50][100]");
        Assert.assertEquals((Object)kv.getString(), (Object)"Hello");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.SET_OR_REPLACE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)true);
        kv = (KeyValue)rec.getValue("Array1[5]");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.NONE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("Array1[5][10]");
        Assert.assertEquals((double)kv.getDouble(), (double)1.1, (double)0.0);
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.SET_OR_REPLACE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)true);
        kv = (KeyValue)rec.getValue("A1");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.NONE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("A1[1]");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.NONE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("A1[1].A2");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.NONE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("A1[1].A2[2]");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.NONE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("A1[1].A2[2].A3");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.NONE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("A1[1].A2[2].A3[3]");
        Assert.assertEquals((long)kv.getInt(), (long)-500L);
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.SET_OR_REPLACE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)true);
        kv = (KeyValue)rec.getValue("a.b");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.SET_OR_REPLACE);
        Assert.assertEquals((long)kv.getInt(), (long)10L);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)true);
        kv = (KeyValue)rec.getValue("a.d");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.SET_OR_REPLACE);
        Assert.assertEquals((Object)kv.getString(), (Object)"Anurag");
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)true);
        kv = (KeyValue)rec.getValue("Address");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.NONE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("Address.zip");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.SET_OR_REPLACE);
        Assert.assertEquals((long)kv.getInt(), (long)94086L);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)true);
        kv = (KeyValue)rec.getValue("Address.Street");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.SET_OR_REPLACE);
        Assert.assertEquals((Object)kv.getString(), (Object)"Washington Avenue");
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)true);
        kv = (KeyValue)rec.getValue("Field1");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.SET_OR_REPLACE);
        Assert.assertEquals((double)kv.getDouble(), (double)1000.0, (double)0.0);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)true);
    }

    @Test
    public void IncrementRecordMutation() throws IOException {
        MutationImpl mutation = (MutationImpl)MapRDB.newMutation();
        mutation.increment("a.b", 10).increment("a.d", 500.325423).increment("Address.zip", 94086).increment("Field1", new BigDecimal("100.1231213434235235234")).increment("Array1[50][100]", -500000000000L).increment("Array1[5][10]", -1.234E-7).increment("A1[1].A2[2].A3[3]", new BigDecimal("-1.11111111111111111111111111"));
        Assert.assertEquals((Object)mutation.needsReadOnServer(), (Object)true);
        ByteBuffer b = mutation.rowcolSerialize();
        Document rec = RowcolCodec.decode((ByteBuffer)b, null, (boolean)true, (boolean)false, (boolean)true);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)((KeyValue)rec)), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)((KeyValue)rec)), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)((KeyValue)rec)), (Object)false);
        KeyValue kv = (KeyValue)rec.getValue("a");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.NONE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("a.b");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.INCREMENT);
        Assert.assertEquals((long)kv.getInt(), (long)10L);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("a.d");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.INCREMENT);
        Assert.assertEquals((double)kv.getDouble(), (double)500.325423, (double)0.0);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("Address");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.NONE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("Address.zip");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.INCREMENT);
        Assert.assertEquals((long)kv.getInt(), (long)94086L);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("Field1");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.INCREMENT);
        Assert.assertEquals((Object)kv.getDecimal(), (Object)new BigDecimal("100.1231213434235235234"));
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("Array1");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.NONE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("Array1[50]");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.NONE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("Array1[50][100]");
        Assert.assertEquals((double)kv.getLong(), (double)-5.0E11, (double)0.0);
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.INCREMENT);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("Array1[5]");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.NONE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("Array1[5][10]");
        Assert.assertEquals((double)kv.getDouble(), (double)-1.234E-7, (double)0.0);
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.INCREMENT);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("A1");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.NONE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("A1[1]");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.NONE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("A1[1].A2");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.NONE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("A1[1].A2[2]");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.NONE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("A1[1].A2[2].A3");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.NONE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("A1[1].A2[2].A3[3]");
        Assert.assertEquals((Object)kv.getDecimal(), (Object)new BigDecimal("-1.11111111111111111111111111"));
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.INCREMENT);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
    }

    @Test
    public void DeleteRecordMutation() throws IOException {
        MutationImpl mutation = (MutationImpl)MapRDB.newMutation();
        mutation.delete("a.b").delete("a.d").delete("Address.zip").delete("Address.Street").delete("Field1");
        Assert.assertEquals((Object)mutation.needsReadOnServer(), (Object)false);
        ByteBuffer b = mutation.rowcolSerialize();
        Document rec = RowcolCodec.decode((ByteBuffer)b, null, (boolean)true, (boolean)false, (boolean)true);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)((KeyValue)rec)), (Object)false);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)((KeyValue)rec)), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)((KeyValue)rec)), (Object)false);
        KeyValue kv = (KeyValue)rec.getValue("a");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.NONE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)false);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("a.b");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.DELETE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)false);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)true);
        kv = (KeyValue)rec.getValue("a.d");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.DELETE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)false);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)true);
        kv = (KeyValue)rec.getValue("Address");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.NONE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)false);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("Address.zip");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.DELETE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)false);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)true);
        kv = (KeyValue)rec.getValue("Address.Street");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.DELETE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)false);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)true);
        kv = (KeyValue)rec.getValue("Field1");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.DELETE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)false);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)true);
    }

    @Test
    public void MixedOpRecordMutation() throws IOException {
        MutationImpl mutation = (MutationImpl)MapRDB.newMutation();
        mutation.set("a.b", 10).delete("a.c").set("b.c", 5000).delete("b").set("a.c.f", "Hello").delete("Address.Street").delete("Field1");
        Assert.assertEquals((Object)mutation.needsReadOnServer(), (Object)true);
        ByteBuffer b = mutation.rowcolSerialize();
        Document rec = RowcolCodec.decode((ByteBuffer)b, null, (boolean)true, (boolean)false, (boolean)true);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)((KeyValue)rec)), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)((KeyValue)rec)), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)((KeyValue)rec)), (Object)false);
        KeyValue kv = (KeyValue)rec.getValue("a");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.NONE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("a.b");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.SET);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)true);
        kv = (KeyValue)rec.getValue("b");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.DELETE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)false);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)true);
        kv = (KeyValue)rec.getValue("a.c.f");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.SET);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)true);
        kv = (KeyValue)rec.getValue("Address");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.NONE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)false);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("Address.Street");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.DELETE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)false);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)true);
        kv = (KeyValue)rec.getValue("Field1");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.DELETE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)false);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)true);
    }

    @Test
    public void ArraySetRecordMutation() throws IOException {
        MutationImpl mutation = (MutationImpl)MapRDB.newMutation();
        mutation.set("a[5]", 10).set("a[10]", "Anurag").set("b[2000]", 10.0).set("twodim[20][30]", "TWODIM20_30").set("twodim[200][300]", "TWODIM200_300");
        Assert.assertEquals((Object)mutation.needsReadOnServer(), (Object)true);
        ByteBuffer b = mutation.rowcolSerialize();
        Document rec = RowcolCodec.decode((ByteBuffer)b, null, (boolean)true, (boolean)false, (boolean)true);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)((KeyValue)rec)), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)((KeyValue)rec)), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)((KeyValue)rec)), (Object)false);
        KeyValue kv = (KeyValue)rec.getValue("a");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.NONE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("a[5]");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.SET);
        Assert.assertEquals((long)kv.getInt(), (long)10L);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)true);
        kv = (KeyValue)rec.getValue("a[10]");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.SET);
        Assert.assertEquals((Object)kv.getString(), (Object)"Anurag");
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)true);
        kv = (KeyValue)rec.getValue("b[2000]");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.SET);
        Assert.assertEquals((double)kv.getDouble(), (double)10.0, (double)0.0);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)true);
        kv = (KeyValue)rec.getValue("twodim");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.NONE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("twodim[20]");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.NONE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("twodim[200]");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.NONE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("twodim[20][30]");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.SET);
        Assert.assertEquals((Object)kv.getString(), (Object)"TWODIM20_30");
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)true);
        kv = (KeyValue)rec.getValue("twodim[200][300]");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.SET);
        Assert.assertEquals((Object)kv.getString(), (Object)"TWODIM200_300");
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)true);
    }

    @Test
    public void ArrayDeleteRecordMutation() throws IOException {
        MutationImpl mutation = (MutationImpl)MapRDB.newMutation();
        mutation.delete("a[5]").delete("a[10]").delete("b[2000]").delete("twodim[20][30]").delete("twodim[200][300]").delete("Field1[5].Field2[6].Field3");
        Assert.assertEquals((Object)mutation.needsReadOnServer(), (Object)true);
        ByteBuffer b = mutation.rowcolSerialize();
        Document rec = RowcolCodec.decode((ByteBuffer)b, null, (boolean)true, (boolean)false, (boolean)true);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)((KeyValue)rec)), (Object)false);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)((KeyValue)rec)), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)((KeyValue)rec)), (Object)false);
        KeyValue kv = (KeyValue)rec.getValue("a");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.NONE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)false);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("a[5]");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.DELETE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)false);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)true);
        kv = (KeyValue)rec.getValue("a[10]");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.DELETE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)false);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)true);
        kv = (KeyValue)rec.getValue("b[2000]");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.DELETE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)false);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)true);
        kv = (KeyValue)rec.getValue("twodim");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.NONE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)false);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("twodim[20]");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.NONE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)false);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("twodim[200]");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.NONE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)false);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("twodim[20][30]");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.DELETE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)false);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)true);
        kv = (KeyValue)rec.getValue("twodim[200][300]");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.DELETE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)false);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)true);
        kv = (KeyValue)rec.getValue("Field1");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.NONE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)false);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("Field1[5]");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.NONE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)false);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("Field1[5].Field2");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.NONE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)false);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("Field1[5].Field2[6]");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.NONE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)false);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("Field1[5].Field2[6].Field3");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.DELETE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)false);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)true);
    }

    @Test
    public void mutationFieldsNeedReadTest() throws IOException {
        LinkedHashMap<FieldPath, Integer> pathCFIdMap = new LinkedHashMap<FieldPath, Integer>();
        pathCFIdMap.put(FieldPath.parseFrom((String)""), 100);
        pathCFIdMap.put(FieldPath.parseFrom((String)"a.b"), 200);
        pathCFIdMap.put(FieldPath.parseFrom((String)"a.b.c.d"), 300);
        pathCFIdMap.put(FieldPath.parseFrom((String)"x.y"), 400);
        MutationImpl mutation = (MutationImpl)MapRDB.newMutation();
        mutation.delete("a").setOrReplace("x.y.z", 100);
        Assert.assertEquals((Object)mutation.needsReadOnServer(), (Object)false);
        Assert.assertEquals((Object)mutation.getFieldsNeedRead(pathCFIdMap), null);
        mutation = (MutationImpl)MapRDB.newMutation();
        mutation.delete("a.b.c").setOrReplace("x.y.z[1]", 100);
        Assert.assertEquals((Object)mutation.needsReadOnServer(), (Object)true);
        Map map = mutation.getFieldsNeedRead(pathCFIdMap);
        Assert.assertEquals((long)map.entrySet().size(), (long)1L);
        String got = (String)((List)map.get(400)).get(0);
        Assert.assertEquals((Object)"v.z[1]", (Object)got);
        mutation = (MutationImpl)MapRDB.newMutation();
        mutation.set("a.b.c", 5000).append("x.y.z", "append").increment("a.b.c.d.e", 5);
        Assert.assertEquals((Object)mutation.needsReadOnServer(), (Object)true);
        map = mutation.getFieldsNeedRead(pathCFIdMap);
        Assert.assertEquals((long)map.entrySet().size(), (long)3L);
        got = (String)((List)map.get(200)).get(0);
        Assert.assertEquals((Object)"v.c", (Object)got);
        got = (String)((List)map.get(300)).get(0);
        Assert.assertEquals((Object)"v.e", (Object)got);
        got = (String)((List)map.get(400)).get(0);
        Assert.assertEquals((Object)"v.z", (Object)got);
    }

    @Test
    public void testMergeFieldPathList() throws IOException {
        LinkedHashMap<Integer, List<String>> map1 = new LinkedHashMap<Integer, List<String>>();
        LinkedHashMap<Integer, List<String>> map2 = new LinkedHashMap<Integer, List<String>>();
        map1.put(1, Arrays.asList("a.b.c", "c.d.e", "c.d.f"));
        map1.put(2, Arrays.asList("a[100][200]", "a.b[200][300]", "v.x[100]"));
        map1.put(3, Arrays.asList("v.a.y[1]", "v.p.q", "v.f"));
        map2.put(1, Arrays.asList("a.b.c", "c.d.e", "l.m"));
        map2.put(2, Arrays.asList("a[100][200]", "a.b[200][301]", "v.x[10]"));
        map2.put(4, Arrays.asList("v.a.y[1]", "v.p.q", "v.f"));
        Map mergedMap = MapRDBTableImplHelper.mergeFieldPathList(map1, map2);
        Assert.assertEquals((long)4L, (long)mergedMap.keySet().size());
        Assert.assertEquals(Arrays.asList("a.b.c", "c.d.e", "c.d.f", "l.m"), mergedMap.get(1));
        Assert.assertEquals(Arrays.asList("a[100][200]", "a.b[200][300]", "a.b[200][301]", "v.x[10]", "v.x[100]"), mergedMap.get(2));
        Assert.assertEquals(Arrays.asList("v.a.y[1]", "v.p.q", "v.f"), mergedMap.get(3));
        Assert.assertEquals(Arrays.asList("v.a.y[1]", "v.p.q", "v.f"), mergedMap.get(4));
    }
}

