/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tests.ojai;

import com.mapr.db.MapRDB;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.SimpleTest;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.ojai.Document;
import org.ojai.DocumentBuilder;
import org.ojai.store.DocumentMutation;
import org.ojai.types.ODate;
import org.ojai.types.OTime;
import org.ojai.types.OTimestamp;

@Category(value={SimpleTest.class})
public class TestDBDocumentBuilder
extends BaseTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test
    public void testAllTypesWithWriter() {
        DocumentBuilder writer = MapRDB.newDocumentBuilder();
        writer.addNewMap();
        writer.put("a", "santanu");
        writer.put("b", true);
        writer.putNewMap("map");
        writer.put("c", 11111);
        writer.put("d", new BigDecimal(1234567.89));
        writer.endMap();
        writer.putNewArray("array");
        writer.add(false);
        writer.add(OTimestamp.parse((String)"2015-06-29T12:33:22.000-07:00"));
        writer.add("xyz");
        writer.add(123.456);
        writer.addNewArray();
        writer.add("abracadabra");
        writer.add((short)3333);
        writer.addNewMap();
        writer.put("elem1", 32660);
        writer.put("elem2", "mapr");
        writer.endMap();
        writer.endArray();
        writer.setArrayIndex(100);
        writer.add((byte)127);
        writer.endArray();
        writer.putNull("null");
        writer.put("date", new ODate(System.currentTimeMillis()));
        writer.put("time", OTime.parse((String)"19:30:45"));
        writer.endMap();
        Document rec = writer.getDocument();
        Assert.assertEquals((Object)"santanu", (Object)rec.getString("a"));
        Assert.assertEquals((long)11111L, (long)rec.getInt("map.c"));
        Assert.assertEquals((Object)"xyz", (Object)rec.getString("array[2]"));
        Assert.assertEquals((long)127L, (long)rec.getByte("array[100]"));
    }

    @Test
    public void testWrongArrayInsertion() {
        DocumentBuilder writer = MapRDB.newDocumentBuilder();
        writer.addNewMap();
        writer.put("a", "santanu");
        writer.put("b", true);
        this.exception.expect(IllegalStateException.class);
        writer.add(12345678L);
    }

    @Test
    public void testPutinArrayContext() {
        DocumentBuilder writer = MapRDB.newDocumentBuilder();
        writer.addNewMap();
        writer.put("a", "santanu");
        writer.put("b", true);
        writer.putNewMap("map");
        writer.put("c", 11111);
        writer.put("d", new BigDecimal(1234567.89));
        writer.endMap();
        writer.putNewArray("array");
        writer.add(false);
        writer.add(OTimestamp.parse((String)"2015-06-29T12:33:22.000-07:00"));
        writer.add("xyz");
        this.exception.expect(IllegalStateException.class);
        writer.put("field1", new BigDecimal(1.23456789015E7));
    }

    @Test
    public void testBuildOnlyOnce() {
        DocumentBuilder writer = MapRDB.newDocumentBuilder();
        writer.addNewMap();
        writer.put("a", "santanu");
        writer.put("b", true);
        writer.putNewMap("map");
        writer.put("c", 11111);
        writer.put("d", new BigDecimal(1234567.89));
        writer.endMap();
        writer.putNewArray("array");
        writer.add(false);
        writer.add(OTimestamp.parse((String)"2015-06-29T12:33:22.000-07:00"));
        writer.add("xyz");
        writer.endArray();
        writer.endMap();
        Document rec = writer.getDocument();
        Assert.assertEquals((Object)true, (Object)rec.getString("array[2]").equals("xyz"));
        this.exception.expect(IllegalStateException.class);
        writer.endMap();
    }

    @Test
    public void testGetRecordBeforeComplete() {
        DocumentBuilder writer = MapRDB.newDocumentBuilder();
        writer.addNewMap();
        writer.put("a", "santanu");
        writer.put("b", true);
        writer.putNewMap("map");
        writer.put("c", 11111);
        writer.put("d", new BigDecimal(1234567.89));
        writer.endMap();
        writer.putNewArray("array");
        writer.add(false);
        writer.add(OTimestamp.parse((String)"2015-06-29T12:33:22.000-07:00"));
        writer.add("xyz");
        this.exception.expect(IllegalStateException.class);
        writer.getDocument();
    }

    @Test
    public void testPutAfterBuild() {
        DocumentBuilder writer = MapRDB.newDocumentBuilder();
        writer.addNewMap();
        writer.put("a", "santanu");
        writer.put("b", true);
        writer.endMap();
        writer.getDocument();
        this.exception.expect(IllegalStateException.class);
        writer.put("c", 12345);
    }

    @Test
    public void testMultiLevelRecord() {
        DocumentBuilder writer = MapRDB.newDocumentBuilder();
        writer.addNewMap();
        writer.put("a", "abracadabra");
        writer.putNewArray("b");
        writer.add(123456789L);
        writer.addNewMap();
        writer.put("c", true);
        writer.putNewMap("cc");
        writer.put("c2.111", "abc");
        writer.endMap();
        writer.putNewArray("d.array2");
        writer.add(123.4567f);
        writer.addNewArray();
        writer.add(999.111);
        writer.add(false);
        writer.endArray();
        writer.add("nnnnn");
        writer.endArray();
        writer.endMap();
        writer.add("xyz");
        writer.endArray();
        writer.endMap();
        Document rec = writer.getDocument();
        Assert.assertEquals((Object)"abracadabra", (Object)rec.getString("a"));
        Assert.assertEquals((Object)true, (Object)rec.getBoolean("b[1].c"));
        Assert.assertEquals((Object)"abc", (Object)rec.getString("b[1].cc.`c2.111`"));
    }

    @Test
    public void testFieldNameOnlyAsLeaf() {
        DocumentBuilder writer = MapRDB.newDocumentBuilder();
        writer.addNewMap();
        writer.put("b", true);
        writer.put("a.v.x", "abracadabra");
        writer.put("x", 111.333);
        writer.put("_id", "k1");
        writer.endMap();
        Document rec = writer.getDocument();
        Assert.assertEquals((Object)true, (Object)rec.getString("`a.v.x`").equals("abracadabra"));
    }

    @Test
    public void testInsertMap() {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("a", "xyz");
        m.put("b", true);
        ArrayList<Number> l = new ArrayList<Number>();
        l.add(1234);
        l.add(111.2222);
        m.put("c", l);
        DocumentBuilder writer = MapRDB.newDocumentBuilder();
        writer.addNewMap();
        writer.put("map", m);
        writer.endMap();
        Document r = writer.getDocument();
        Assert.assertEquals((Object)true, (Object)r.getBoolean("map.b"));
        Assert.assertEquals((long)1234L, (long)r.getInt("map.c[0]"));
    }

    @Test
    @Ignore(value="Enable after bug 19423 is fixed")
    public void testMutationWithFlags() {
        DocumentBuilder writer = MapRDB.newDocumentBuilder();
        writer.addNewMap();
        writer.putNewMap("b");
        writer.put("val1", 100);
        writer.put("val2", true);
        writer.endMap();
        writer.putNewMap("c");
        writer.put("val3", "bonjour");
        writer.put("val4", 999.8888);
        writer.endMap();
        writer.endMap();
        Document r = writer.getDocument();
        DocumentMutation mutation = MapRDB.newMutation();
        mutation.setOrReplace("a", r);
        Document r2 = MapRDB.newDocument();
        r2.set("x", "xyz");
        r2.set("y", 111);
        mutation.merge("a", r2);
    }
}

