/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.rowcol;

import com.mapr.db.impl.Constants;
import com.mapr.db.impl.IdCodec;
import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.db.rowcol.KeyValue;
import com.mapr.db.rowcol.KeyValueBuilder;
import com.mapr.db.rowcol.MutationImpl;
import com.mapr.db.rowcol.SerializationContext;
import com.mapr.db.rowcol.SerializedFamilyInfo;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import org.ojai.Document;
import org.ojai.FieldPath;
import org.ojai.store.DocumentMutation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowcolCodec {
    static Logger logger = LoggerFactory.getLogger(RowcolCodec.class);

    public static DBDocumentImpl getDBDocument(Document r) {
        if (r instanceof DBDocumentImpl) {
            return (DBDocumentImpl)r;
        }
        return (DBDocumentImpl)KeyValueBuilder.initFrom(r);
    }

    public static SerializedFamilyInfo[] encode(Document document, Map<FieldPath, Integer> jsonPathMap, boolean isBulkLoad, boolean useCached) {
        DBDocumentImpl rec = RowcolCodec.getDBDocument(document);
        if (useCached && rec.cachedBuffer != null) {
            SerializationContext ctx = new SerializationContext();
            return ctx.getSerializedBuffers(rec.cachedBuffer.jsonPathMap, rec.cachedBuffer.map);
        }
        if (rec.getNeedDOMStruct()) {
            rec.getDOMFromCachedBuffer();
        }
        SerializationContext ctx = new SerializationContext();
        ctx.setFullRecordOp(true);
        ctx.setStoreRowTS(isBulkLoad);
        ctx.serializeFamilies(rec, jsonPathMap);
        return ctx.getSerializedBuffers();
    }

    public static SerializedFamilyInfo[] encode(Document document, Map<FieldPath, Integer> jsonPathMap) {
        return RowcolCodec.encode(document, jsonPathMap, false, false);
    }

    public static ByteBuffer encode(Document document) {
        SerializedFamilyInfo[] familyInfo = RowcolCodec.encode(document, Constants.DEFAULT_FAMILY_MAP, false, false);
        assert (familyInfo.length == 1);
        return familyInfo[0].getByteBuffer();
    }

    public static void decodeInternal(Map<Integer, ByteBuffer> map, Map<FieldPath, Integer> jsonPathMap, Map<Integer, String> idToCFNameMap, boolean insertionOrder, boolean decodeTimestamp, boolean preserveDeleteFlags, DBDocumentImpl outDoc) {
        SerializationContext ctx = new SerializationContext();
        if (decodeTimestamp) {
            ctx.setDecodeTimestamp(decodeTimestamp);
        }
        ctx.setPreserveDeleteTime(preserveDeleteFlags);
        ctx.decode(map, jsonPathMap, idToCFNameMap, insertionOrder, outDoc);
    }

    public static DBDocumentImpl decode(Map<Integer, ByteBuffer> map, Map<FieldPath, Integer> jsonPathMap, Map<Integer, String> idToCFNameMap) {
        DBDocumentImpl doc = new DBDocumentImpl();
        RowcolCodec.decodeInternal(map, jsonPathMap, idToCFNameMap, false, false, false, doc);
        return doc;
    }

    public static DBDocumentImpl decode(Map<Integer, ByteBuffer> map, Map<FieldPath, Integer> jsonPathMap, Map<Integer, String> idToCFNameMap, ByteBuffer rowKey, boolean excludeId, boolean cacheEncoded, boolean insertionOrder, boolean decodeTimestamp, boolean preserveDeleteFlags) {
        if (rowKey != null && !rowKey.hasRemaining()) {
            KeyValue kv = KeyValueBuilder.initFrom("");
            logger.info("create rowkey " + kv.getString() + " from buffer=(" + rowKey + ")");
            DBDocumentImpl doc = new DBDocumentImpl();
            doc.setId(kv, excludeId);
            return doc;
        }
        if (!cacheEncoded) {
            DBDocumentImpl doc = new DBDocumentImpl();
            doc.setId(IdCodec.decode(rowKey), excludeId);
            RowcolCodec.decodeInternal(map, jsonPathMap, idToCFNameMap, insertionOrder, decodeTimestamp, preserveDeleteFlags, doc);
            return doc;
        }
        DBDocumentImpl r = new DBDocumentImpl();
        r.setId(IdCodec.decode(rowKey), excludeId);
        r.setSerializedJson(map, jsonPathMap, idToCFNameMap, IdCodec.decode(rowKey), excludeId, insertionOrder, decodeTimestamp, preserveDeleteFlags);
        return r;
    }

    public static Document decode(ByteBuffer input) {
        return RowcolCodec.decode(input, null, true, false, true);
    }

    public static Document decode(ByteBuffer input, ByteBuffer rowKey, boolean excludeId, boolean decodeTimestamp, boolean preserveDeleteFlags) {
        assert (input.order() == ByteOrder.LITTLE_ENDIAN);
        if (input.position() == input.limit()) {
            return null;
        }
        HashMap<Integer, ByteBuffer> bufferMap = new HashMap<Integer, ByteBuffer>();
        ByteBuffer cachedBuffer = input.duplicate();
        cachedBuffer.mark();
        cachedBuffer.order(ByteOrder.LITTLE_ENDIAN);
        bufferMap.put(0, cachedBuffer);
        DBDocumentImpl doc = new DBDocumentImpl();
        doc.setId(IdCodec.decode(rowKey), excludeId);
        RowcolCodec.decodeInternal(bufferMap, Constants.DEFAULT_FAMILY_MAP, Constants.DEFAULT_NAME_MAP, false, decodeTimestamp, preserveDeleteFlags, doc);
        return doc;
    }

    public static DocumentMutation decodeMutation(ByteBuffer input, boolean needsRead) {
        return MutationImpl.fromSerializedValue(input, needsRead);
    }
}

