/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.impl;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.ByteString;
import com.mapr.db.impl.ConditionDescriptor;
import com.mapr.db.impl.ConditionNode;
import com.mapr.db.impl.Constants;
import com.mapr.db.impl.IdCodec;
import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.db.rowcol.KeyValue;
import com.mapr.db.rowcol.KeyValueBuilder;
import com.mapr.db.rowcol.RowcolCodec;
import com.mapr.db.rowcol.SerializationAction;
import com.mapr.db.rowcol.SerializedFamilyInfo;
import com.mapr.fs.jni.MapRConstants;
import com.mapr.fs.proto.Dbfilters;
import com.mapr.org.apache.hadoop.hbase.util.Bytes;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.ojai.DocumentConstants;
import org.ojai.FieldPath;
import org.ojai.Value;
import org.ojai.annotation.API;
import org.ojai.store.QueryCondition;
import org.ojai.util.Values;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API.Internal
class ConditionLeaf
extends ConditionNode {
    static Logger logger = LoggerFactory.getLogger(ConditionLeaf.class);
    private static final String REGEX_OPTIONAL_CHARS = "?*";
    private static final String REGEX_SPECIAL_CHARS = "^.+*?()[{\\|$";
    final FieldPath field;
    final Dbfilters.CompareOpProto op;
    final Dbfilters.ComparatorModeProto cmpMode;
    final KeyValue value;

    ConditionLeaf(FieldPath path, QueryCondition.Op op, KeyValue initFrom) {
        this(path, (Dbfilters.CompareOpProto)opProtoMap.get((Object)op), initFrom);
    }

    ConditionLeaf(FieldPath field, Dbfilters.CompareOpProto op, KeyValue value) {
        this(field, op, value, Dbfilters.ComparatorModeProto.CMP_VALUE);
    }

    ConditionLeaf(FieldPath field, QueryCondition.Op op, KeyValue value, Dbfilters.ComparatorModeProto cmpMode) {
        this(field, (Dbfilters.CompareOpProto)opProtoMap.get((Object)op), value, cmpMode);
    }

    ConditionLeaf(FieldPath field, Dbfilters.CompareOpProto op, KeyValue value, Dbfilters.ComparatorModeProto cmpMode) {
        this.op = op;
        this.field = field;
        this.value = value;
        this.cmpMode = cmpMode;
        this.checkArgs();
    }

    ConditionLeaf(String filterId, ByteString serializedState) {
        Dbfilters.FilterComparatorProto filterComparator = null;
        try {
            switch (filterId) {
                case "8cbdcd12": {
                    Dbfilters.ConditionFilterProto proto = Dbfilters.ConditionFilterProto.parseFrom((ByteString)serializedState);
                    this.field = FieldPath.parseFrom((String)proto.getFieldPath());
                    filterComparator = proto.getFilterComparator();
                    break;
                }
                case "469dbd04": {
                    this.field = DocumentConstants.ID_FIELD;
                    Dbfilters.ConditionFilterProto proto = Dbfilters.RowFilterProto.parseFrom((ByteString)serializedState);
                    filterComparator = proto.getFilterComparator();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid filter id: " + filterId);
                }
            }
            this.op = filterComparator.getCompareOp();
            if (filterComparator.hasComparator() && filterComparator.getComparator().hasSerializedComparator()) {
                String name = filterComparator.getComparator().getName();
                ByteString state = filterComparator.getComparator().getSerializedComparator();
                switch (name) {
                    case "45a94888": {
                        Dbfilters.BinaryComparatorProto binaryComparator = Dbfilters.BinaryComparatorProto.parseFrom((ByteString)state);
                        ByteBuffer encoded = binaryComparator.getComparable().asReadOnlyByteBuffer();
                        encoded.order(ByteOrder.LITTLE_ENDIAN);
                        HashMap<Integer, ByteBuffer> bufferMap = new HashMap<Integer, ByteBuffer>();
                        bufferMap.put(0, encoded);
                        DBDocumentImpl doc = RowcolCodec.decode(bufferMap, Constants.DEFAULT_FAMILY_MAP, Constants.DEFAULT_NAME_MAP);
                        this.value = (KeyValue)doc.getValue("X");
                        break;
                    }
                    case "e2d7ba40": {
                        Dbfilters.RegexStringComparatorProto regexComparator = Dbfilters.RegexStringComparatorProto.parseFrom((ByteString)state);
                        this.value = KeyValueBuilder.initFrom(regexComparator.getPattern().toStringUtf8());
                        break;
                    }
                    case "05f39865": {
                        ByteString byteString = Dbfilters.BinaryComparatorProto.parseFrom((ByteString)state).getComparable();
                        this.value = (KeyValue)IdCodec.decode(byteString.asReadOnlyByteBuffer());
                        break;
                    }
                    case "2e7025c4": {
                        this.value = KeyValueBuilder.initFrom(Dbfilters.SizeComparatorProto.parseFrom((ByteString)state).getSize());
                        break;
                    }
                    case "8543f5eb": {
                        this.value = null;
                        break;
                    }
                    case "1e95fd6b": {
                        this.value = KeyValueBuilder.initFrom(Dbfilters.TypeComparatorProto.parseFrom((ByteString)state).getType());
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid comparator id: " + name);
                    }
                }
            } else {
                this.value = null;
            }
            this.cmpMode = filterComparator.hasComparatorMode() ? filterComparator.getComparatorMode() : null;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to decode message", e);
        }
        this.checkArgs();
    }

    @Override
    protected ConditionLeaf clone() {
        ConditionLeaf newLeaf = (ConditionLeaf)super.clone();
        return newLeaf;
    }

    Dbfilters.CompareOpProto getOp() {
        return this.op;
    }

    FieldPath getField() {
        return this.field;
    }

    @Override
    boolean checkAndPrune() {
        return this.isOnId() && this.cmpMode == Dbfilters.ComparatorModeProto.CMP_VALUE && this.op != Dbfilters.CompareOpProto.NOT_EQUAL && opProtoMap.containsValue((Object)this.op) && this.value != null;
    }

    @Override
    void addProjections(Set<FieldPath> proj) {
        proj.add(this.field);
    }

    @Override
    StringBuilder expressionBuilder(StringBuilder sb) {
        return this.treeBuilder(sb, 0);
    }

    @Override
    StringBuilder treeBuilder(StringBuilder sb, int level) {
        return sb.append('(').append(this.getFieldStr(sb)).append(' ').append(this.getOpStr(sb)).append(' ').append(this.getValueStr(sb)).append(')');
    }

    private String getFieldStr(StringBuilder sb) {
        switch (this.cmpMode) {
            case CMP_PATTERN: 
            case CMP_VALUE: {
                sb.append(this.field.asPathString());
                break;
            }
            case CMP_TYPE: {
                sb.append("TYPE_OF(").append(this.field.asPathString()).append(')');
                break;
            }
            case CMP_SIZE: {
                sb.append("SIZE_OF(").append(this.field.asPathString()).append(')');
                break;
            }
            default: {
                throw new UnsupportedOperationException(this.cmpMode + " is currently not supported.");
            }
        }
        return "";
    }

    private String getValueStr(StringBuilder sb) {
        switch (this.cmpMode) {
            case CMP_PATTERN: 
            case CMP_VALUE: 
            case CMP_SIZE: {
                sb.append(this.value != null ? Values.asJsonString((Value)this.value) : null);
                break;
            }
            case CMP_TYPE: {
                sb.append(Value.Type.valueOf((int)this.value.getInt()));
                break;
            }
            default: {
                throw new UnsupportedOperationException(this.cmpMode + " is currently not supported.");
            }
        }
        return "";
    }

    private String getOpStr(StringBuilder sb) {
        switch (this.cmpMode) {
            case CMP_VALUE: 
            case CMP_TYPE: 
            case CMP_SIZE: {
                sb.append((String)opSymbolMap.get(this.op));
                break;
            }
            case CMP_PATTERN: {
                sb.append(this.op == Dbfilters.CompareOpProto.EQUAL ? "MATCHES" : "NOT_MATCHES");
                break;
            }
            default: {
                throw new UnsupportedOperationException(this.cmpMode + " is currently not supported.");
            }
        }
        return "";
    }

    @Override
    StringBuilder jsonBuilder(StringBuilder sb) {
        return sb.append('{').append('\"').append(this.field.asPathString()).append('\"').append(':').append(' ').append('{').append('\"').append(((String)opJsonOpMap.get(this.op)).toLowerCase()).append('\"').append(':').append(' ').append('}').append('}');
    }

    @Override
    ConditionDescriptor getDescriptor(BiMap<FieldPath, Integer> pathIdMap) {
        if (this.isOnId()) {
            return this.toRowKeyFilter(pathIdMap);
        }
        return this.toConditionFilter(pathIdMap);
    }

    boolean isOnId() {
        return this.field.getRootSegment().isLastPath() && "_id".equals(this.field.getRootSegment().getNameSegment().getName());
    }

    private void checkArgs() {
        if (this.cmpMode == null) {
            throw new IllegalArgumentException("ComparatorModeProto can not be null.");
        }
        if (this.op == null) {
            throw new IllegalArgumentException("CompareOpProto can not be null.");
        }
        if (this.field == null) {
            throw new IllegalArgumentException("FieldPath can not be null.");
        }
        if (this.isOnId() && (this.cmpMode == Dbfilters.ComparatorModeProto.CMP_VALUE || this.cmpMode == Dbfilters.ComparatorModeProto.CMP_PATTERN) && this.value != null && !IdCodec.isSupportedType(this.value.getType())) {
            throw new IllegalArgumentException(String.format("A %s value can not be used for '_id' field.", this.value.getType()));
        }
        if (this.cmpMode == Dbfilters.ComparatorModeProto.CMP_PATTERN) {
            Pattern.compile(this.value.getString());
        }
    }

    private ConditionDescriptor toRowKeyFilter(BiMap<FieldPath, Integer> pathIdMap) {
        Dbfilters.RowFilterProto rowFilter = Dbfilters.RowFilterProto.newBuilder().setFilterComparator(this.getComparator(true)).build();
        Dbfilters.FilterMsg filterMsg = Dbfilters.FilterMsg.newBuilder().setId("469dbd04").setSerializedState(rowFilter.toByteString()).build();
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (Map.Entry pathIdEntry : pathIdMap.inverse().entrySet()) {
            mapBuilder.put(pathIdEntry.getKey(), (Object)ImmutableSet.of(pathIdEntry.getValue()));
        }
        return new ConditionDescriptor(filterMsg, (Map<Integer, ? extends Set<FieldPath>>)mapBuilder.build());
    }

    private ConditionDescriptor toConditionFilter(BiMap<FieldPath, Integer> pathIdMap) {
        FieldPath fieldPath = this.field;
        Integer familyId = (Integer)pathIdMap.get((Object)FieldPath.EMPTY);
        if (familyId == null) {
            throw new IllegalStateException("Unable to find family id for the default column family.");
        }
        FieldPath lastParent = null;
        for (Map.Entry kv : pathIdMap.entrySet()) {
            FieldPath progeny;
            FieldPath familyPath = (FieldPath)kv.getKey();
            if (familyPath.equals((Object)FieldPath.EMPTY) || (progeny = this.field.cloneAfterAncestor(familyPath)) == null || lastParent != null && !lastParent.isAtOrAbove(familyPath)) continue;
            lastParent = familyPath;
            fieldPath = progeny.equals((Object)FieldPath.EMPTY) ? Constants.DUMMY_FIELDPATH_V : progeny.cloneWithNewParent("v");
            familyId = (Integer)kv.getValue();
        }
        Dbfilters.ConditionFilterProto conditionFilter = Dbfilters.ConditionFilterProto.newBuilder().setFieldPath(fieldPath.asPathString(false)).setFamilyId(familyId.intValue()).setFilterComparator(this.getComparator(false)).build();
        Dbfilters.FilterMsg filterMsg = Dbfilters.FilterMsg.newBuilder().setId("8cbdcd12").setSerializedState(conditionFilter.toByteString()).build();
        return new ConditionDescriptor(filterMsg, (Map<Integer, ? extends Set<FieldPath>>)ImmutableMap.of((Object)familyId, (Object)ImmutableSet.of((Object)fieldPath)));
    }

    private Dbfilters.FilterComparatorProto getComparator(boolean onRowKey) {
        Dbfilters.FilterComparatorProto.Builder filterComparator = Dbfilters.FilterComparatorProto.newBuilder().setComparatorMode(this.cmpMode).setCompareOp(this.op);
        filterComparator.setComparator(this.toComparator(onRowKey));
        return filterComparator.build();
    }

    private Dbfilters.ComparatorProto toComparator(boolean onId) {
        Dbfilters.ComparatorProto.Builder builder = Dbfilters.ComparatorProto.newBuilder();
        switch (this.cmpMode) {
            case CMP_VALUE: {
                return this.buildValueComparator(builder, onId);
            }
            case CMP_TYPE: {
                return this.buildTypeComparator(builder, onId);
            }
            case CMP_PATTERN: {
                return this.buildPatternComparator(builder, onId);
            }
            case CMP_SIZE: {
                return this.buildSizeComparator(builder, onId);
            }
        }
        throw new UnsupportedOperationException(this.cmpMode + " is currently not supported.");
    }

    private Dbfilters.ComparatorProto buildSizeComparator(Dbfilters.ComparatorProto.Builder builder, boolean onId) {
        ByteString state = Dbfilters.SizeComparatorProto.newBuilder().setSize(this.value.getInt()).setOnIdField(onId).build().toByteString();
        return builder.setName("2e7025c4").setSerializedComparator(state).build();
    }

    private Dbfilters.ComparatorProto buildPatternComparator(Dbfilters.ComparatorProto.Builder builder, boolean onId) {
        ByteString pattern = ByteString.copyFrom((byte[])Bytes.toBytes((String)this.value.getString()));
        ByteString state = Dbfilters.RegexStringComparatorProto.newBuilder().setPattern(pattern).setIsUTF8(true).setOnIdField(onId).build().toByteString();
        return builder.setName("e2d7ba40").setSerializedComparator(state).build();
    }

    private Dbfilters.ComparatorProto buildTypeComparator(Dbfilters.ComparatorProto.Builder builder, boolean onId) {
        ByteString state = Dbfilters.TypeComparatorProto.newBuilder().setType(this.value.getInt()).setOnIdField(onId).build().toByteString();
        return builder.setName("1e95fd6b").setSerializedComparator(state).build();
    }

    private Dbfilters.ComparatorProto buildValueComparator(Dbfilters.ComparatorProto.Builder builder, boolean onId) {
        String name = null;
        ByteString state = null;
        if (this.value == null) {
            name = "8543f5eb";
            state = Dbfilters.NullComparatorProto.newBuilder().build().toByteString();
        } else {
            ByteString comparable = null;
            if (onId) {
                name = "05f39865";
                comparable = ByteString.copyFrom((ByteBuffer)IdCodec.encode(this.value));
            } else if (this.value != null) {
                name = "45a94888";
                DBDocumentImpl rec = new DBDocumentImpl();
                rec.set("X", this.value);
                SerializedFamilyInfo[] famInfo = RowcolCodec.encode(rec, Constants.DEFAULT_FAMILY_MAP);
                assert (famInfo.length == 1);
                assert (famInfo[0].getAction() == SerializationAction.SET);
                comparable = ByteString.copyFrom((ByteBuffer)famInfo[0].getByteBuffer());
            }
            state = Dbfilters.BinaryComparatorProto.newBuilder().setComparable(comparable).setOnIdField(onId).build().toByteString();
        }
        return builder.setName(name).setSerializedComparator(state).build();
    }

    @Override
    List<ConditionNode.RowkeyRange> getRowkeyRanges() {
        if (!this.isOnId() || this.value == null || this.cmpMode != Dbfilters.ComparatorModeProto.CMP_VALUE && this.cmpMode != Dbfilters.ComparatorModeProto.CMP_PATTERN) {
            return FULL_TABLE_RANGE;
        }
        byte[] fieldValue = IdCodec.encodeAsBytes(this.value);
        byte[] startRow = MapRConstants.EMPTY_BYTE_ARRAY;
        byte[] stopRow = MapRConstants.EMPTY_BYTE_ARRAY;
        switch (this.op) {
            case GREATER_OR_EQUAL: {
                startRow = fieldValue;
                break;
            }
            case GREATER: {
                startRow = Arrays.copyOf(fieldValue, fieldValue.length + 1);
                break;
            }
            case LESS_OR_EQUAL: {
                stopRow = Arrays.copyOf(fieldValue, fieldValue.length + 1);
                break;
            }
            case LESS: {
                stopRow = fieldValue;
                break;
            }
            case EQUAL: {
                if (this.cmpMode == Dbfilters.ComparatorModeProto.CMP_PATTERN) {
                    String prefix;
                    boolean lastEscaped = false;
                    boolean inRegexQuote = false;
                    StringBuilder prefixSB = new StringBuilder();
                    String regexString = this.value.getString();
                    if (regexString.charAt(0) == '^') {
                        regexString = regexString.substring(1);
                    }
                    for (int i = 0; i < regexString.length(); ++i) {
                        char ch = regexString.charAt(i);
                        if (inRegexQuote) {
                            prefixSB.append(ch);
                        }
                        if (lastEscaped) {
                            lastEscaped = false;
                            if (ch == 'Q') {
                                inRegexQuote = true;
                                continue;
                            }
                            if (ch == 'E') {
                                if (inRegexQuote) {
                                    prefixSB.setLength(prefixSB.length() - 2);
                                }
                                inRegexQuote = false;
                                continue;
                            }
                            if (REGEX_SPECIAL_CHARS.indexOf(ch) == -1) break;
                            prefixSB.append(ch);
                            continue;
                        }
                        if (ch == '\\') {
                            lastEscaped = true;
                            continue;
                        }
                        if (inRegexQuote) continue;
                        if (REGEX_OPTIONAL_CHARS.indexOf(ch) != -1) {
                            if (prefixSB.length() <= 0) break;
                            prefixSB.setLength(prefixSB.length() - 1);
                            break;
                        }
                        if (REGEX_SPECIAL_CHARS.indexOf(ch) != -1) break;
                        prefixSB.append(ch);
                    }
                    if (prefixSB.length() <= 0 || (stopRow = Bytes.unsignedCopyAndIncrement((byte[])(startRow = Bytes.getBytes((ByteBuffer)IdCodec.encode(prefix = prefixSB.toString()))))).length <= startRow.length) break;
                    stopRow = MapRConstants.EMPTY_BYTE_ARRAY;
                    break;
                }
                stopRow = fieldValue;
                startRow = fieldValue;
            }
        }
        if (startRow != MapRConstants.EMPTY_BYTE_ARRAY || stopRow != MapRConstants.EMPTY_BYTE_ARRAY) {
            return ImmutableList.of((Object)new ConditionNode.RowkeyRange(startRow, stopRow));
        }
        return FULL_TABLE_RANGE;
    }
}

