/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tests.admin;

import com.mapr.db.FamilyDescriptor;
import com.mapr.db.MapRDB;
import com.mapr.db.TableDescriptor;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.SimpleTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.FieldPath;

@Category(value={SimpleTest.class})
public class TestAdminDescriptors
extends BaseTest {
    private static final FieldPath FP_ABC = FieldPath.parseFrom((String)"a.b.c");
    private static final String PATH_TO_A_TABLE = "/path/to/a/table";

    @Test
    public void test_TableDescriptor() {
        TableDescriptor desc = MapRDB.newTableDescriptor((String)PATH_TO_A_TABLE);
        Assert.assertEquals((Object)PATH_TO_A_TABLE, (Object)desc.getPath().toString());
        Assert.assertTrue((boolean)desc.getFamilies().isEmpty());
        TableDescriptor descClone = desc.clone();
        Assert.assertEquals((Object)desc, (Object)descClone);
        Assert.assertNotSame((Object)desc, (Object)descClone);
        Assert.assertEquals((Object)PATH_TO_A_TABLE, (Object)descClone.getPath().toString());
        Assert.assertTrue((boolean)descClone.getFamilies().isEmpty());
    }

    @Test
    public void test_FamilyDescriptor() {
        FamilyDescriptor desc = MapRDB.newFamilyDescriptor((String)"f", (FieldPath)FP_ABC);
        Assert.assertEquals((Object)"f", (Object)desc.getName());
        Assert.assertEquals((Object)FP_ABC, (Object)desc.getJsonFieldPath());
        FamilyDescriptor descClone = desc.clone();
        Assert.assertEquals((Object)desc, (Object)descClone);
        Assert.assertNotSame((Object)desc, (Object)descClone);
    }
}

