/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.impl;

import com.mapr.db.TabletInfo;
import com.mapr.db.impl.ConditionImpl;
import com.mapr.db.impl.ConditionNode;
import com.mapr.fs.jni.MapRConstants;
import com.mapr.org.apache.hadoop.hbase.util.Bytes;
import java.util.Arrays;
import org.ojai.annotation.API;
import org.ojai.store.QueryCondition;

@API.Internal
public class TabletInfoImpl
implements TabletInfo,
Comparable<TabletInfoImpl> {
    private final ConditionImpl condition;
    private final String[] locations;
    private final long estimatedSize;
    private final long estimatedNumRows;
    private final ConditionNode.RowkeyRange rowKeyRange;

    public TabletInfoImpl(ConditionImpl condition, String[] locations, long estimatedSize, long estimatedNumRows) {
        this.condition = condition;
        this.locations = locations;
        this.estimatedSize = estimatedSize;
        this.estimatedNumRows = estimatedNumRows;
        this.rowKeyRange = condition.getRowkeyRanges().get(0);
    }

    @Override
    public QueryCondition getCondition() {
        return this.condition;
    }

    @Override
    public String[] getLocations() {
        return this.locations;
    }

    @Override
    public long getEstimatedSize() {
        return this.estimatedSize;
    }

    @Override
    public long getEstimatedNumRows() {
        return this.estimatedNumRows;
    }

    public byte[] getStartRow() {
        return this.rowKeyRange.startRow;
    }

    public byte[] getStopRow() {
        return this.rowKeyRange.stopRow;
    }

    @API.Internal
    public ConditionNode.RowkeyRange getRowKeyRange() {
        return this.rowKeyRange;
    }

    public boolean containsRow(byte[] row) {
        return Bytes.compareTo((byte[])row, (byte[])this.rowKeyRange.startRow) >= 0 && (Bytes.compareTo((byte[])row, (byte[])this.rowKeyRange.stopRow) < 0 || Bytes.equals((byte[])this.rowKeyRange.stopRow, (byte[])MapRConstants.EMPTY_BYTE_ARRAY));
    }

    public String toString() {
        return "TabletInfoImpl [condition=" + this.condition.getRowkeyRanges() + ", locations=" + Arrays.toString(this.locations) + ", estimatedSize=" + this.estimatedSize + ", estimatedNumRows=" + this.estimatedNumRows + "]";
    }

    @Override
    public int compareTo(TabletInfoImpl o) {
        if (o == null) {
            return 1;
        }
        int result = Bytes.compareTo((byte[])this.rowKeyRange.startRow, (byte[])o.rowKeyRange.startRow);
        if (result != 0) {
            return result;
        }
        result = Bytes.compareTo((byte[])this.rowKeyRange.stopRow, (byte[])o.rowKeyRange.stopRow);
        if (result != 0) {
            if (this.rowKeyRange.startRow.length != 0 && this.rowKeyRange.stopRow.length == 0) {
                return 1;
            }
            if (o.rowKeyRange.startRow.length != 0 && o.rowKeyRange.stopRow.length == 0) {
                return -1;
            }
            return result;
        }
        return 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.rowKeyRange == null ? 0 : this.rowKeyRange.hashCode());
        result = 31 * result + Arrays.hashCode(this.locations);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TabletInfoImpl other = (TabletInfoImpl)obj;
        if (this.rowKeyRange == null ? other.rowKeyRange != null : !this.rowKeyRange.equals(other.rowKeyRange)) {
            return false;
        }
        return Arrays.equals(this.locations, other.locations);
    }
}

