/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.rowcol;

import com.mapr.db.DBDocument;
import com.mapr.db.Mutation;
import com.mapr.db.impl.Constants;
import com.mapr.db.impl.IdCodec;
import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.db.rowcol.KeyValueBuilder;
import com.mapr.db.rowcol.MutationImpl;
import com.mapr.db.rowcol.SerializationContext;
import com.mapr.db.rowcol.SerializedFamilyInfo;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import org.ojai.Document;
import org.ojai.FieldPath;

public class RowcolCodec {
    public static DBDocumentImpl getDBDocument(Document r) {
        if (r instanceof DBDocumentImpl) {
            return (DBDocumentImpl)r;
        }
        return (DBDocumentImpl)KeyValueBuilder.initFrom(r);
    }

    public static SerializedFamilyInfo[] encode(Document document, Map<FieldPath, Integer> jsonPathMap, boolean isBulkLoad, boolean useCached) {
        DBDocumentImpl rec = RowcolCodec.getDBDocument(document);
        if (useCached && rec.cachedBuffer != null) {
            SerializationContext ctx = new SerializationContext();
            return ctx.getSerializedBuffers(rec.cachedBuffer.jsonPathMap, rec.cachedBuffer.map);
        }
        if (rec.getNeedDOMStruct()) {
            rec.getDOMFromCachedBuffer();
        }
        SerializationContext ctx = new SerializationContext();
        ctx.setFullRecordOp(true);
        ctx.setStoreRowTS(isBulkLoad);
        ctx.serializeFamilies(rec, jsonPathMap);
        return ctx.getSerializedBuffers();
    }

    public static SerializedFamilyInfo[] encode(Document document, Map<FieldPath, Integer> jsonPathMap) {
        return RowcolCodec.encode(document, jsonPathMap, false, false);
    }

    public static ByteBuffer encode(Document document) {
        SerializedFamilyInfo[] familyInfo = RowcolCodec.encode(document, Constants.DEFAULT_FAMILY_MAP, false, false);
        assert (familyInfo.length == 1);
        return familyInfo[0].getByteBuffer();
    }

    public static void decodeInternal(Map<Integer, ByteBuffer> map, Map<FieldPath, Integer> jsonPathMap, Map<Integer, String> idToCFNameMap, boolean insertionOrder, boolean decodeTimestamp, DBDocumentImpl outDoc) {
        SerializationContext ctx = new SerializationContext();
        if (decodeTimestamp) {
            ctx.setDecodeTimestamp(decodeTimestamp);
        }
        ctx.decode(map, jsonPathMap, idToCFNameMap, insertionOrder, outDoc);
    }

    public static DBDocumentImpl decode(Map<Integer, ByteBuffer> map, Map<FieldPath, Integer> jsonPathMap, Map<Integer, String> idToCFNameMap) {
        DBDocumentImpl doc = new DBDocumentImpl();
        RowcolCodec.decodeInternal(map, jsonPathMap, idToCFNameMap, false, false, doc);
        return doc;
    }

    public static DBDocumentImpl decode(Map<Integer, ByteBuffer> map, Map<FieldPath, Integer> jsonPathMap, Map<Integer, String> idToCFNameMap, ByteBuffer rowKey, boolean excludeId, boolean cacheEncoded, boolean insertionOrder, boolean decodeTimestamp) {
        if (!cacheEncoded) {
            DBDocumentImpl doc = new DBDocumentImpl();
            doc.setId(IdCodec.decode(rowKey), excludeId);
            RowcolCodec.decodeInternal(map, jsonPathMap, idToCFNameMap, insertionOrder, decodeTimestamp, doc);
            return doc;
        }
        DBDocumentImpl r = new DBDocumentImpl();
        r.setId(IdCodec.decode(rowKey), excludeId);
        r.setSerializedJson(map, jsonPathMap, idToCFNameMap, IdCodec.decode(rowKey), excludeId, insertionOrder, decodeTimestamp);
        return r;
    }

    public static DBDocument decode(ByteBuffer input) {
        return RowcolCodec.decode(input, null, true, false);
    }

    public static DBDocument decode(ByteBuffer input, ByteBuffer rowKey, boolean excludeId, boolean decodeTimestamp) {
        assert (input.order() == ByteOrder.LITTLE_ENDIAN);
        if (input.position() == input.limit()) {
            return null;
        }
        HashMap<Integer, ByteBuffer> bufferMap = new HashMap<Integer, ByteBuffer>();
        ByteBuffer cachedBuffer = input.duplicate();
        cachedBuffer.mark();
        cachedBuffer.order(ByteOrder.LITTLE_ENDIAN);
        bufferMap.put(0, cachedBuffer);
        DBDocumentImpl doc = new DBDocumentImpl();
        doc.setId(IdCodec.decode(rowKey), excludeId);
        RowcolCodec.decodeInternal(bufferMap, Constants.DEFAULT_FAMILY_MAP, Constants.DEFAULT_NAME_MAP, false, decodeTimestamp, doc);
        return doc;
    }

    public static Mutation decodeMutation(ByteBuffer input, boolean needsRead) {
        return MutationImpl.fromSerializedValue(input, needsRead);
    }
}

