/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.rowcol;

import com.mapr.db.Mutation;
import com.mapr.db.impl.Constants;
import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.db.rowcol.InsertContext;
import com.mapr.db.rowcol.KeyValue;
import com.mapr.db.rowcol.KeyValueBuilder;
import com.mapr.db.rowcol.MutationHelper;
import com.mapr.db.rowcol.RowcolCodec;
import com.mapr.db.rowcol.SerializationContext;
import com.mapr.db.rowcol.SerializedFamilyInfo;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import org.ojai.Document;
import org.ojai.FieldPath;
import org.ojai.Value;
import org.ojai.annotation.API;
import org.ojai.types.Interval;

@API.Internal
public class MutationImpl
implements Mutation {
    private DBDocumentImpl record = new DBDocumentImpl();
    private boolean needsReadOnServer = false;
    private transient boolean buildDone = false;

    @API.Internal
    public MutationImpl() {
    }

    private void checkForUpdate() {
        if (this.buildDone) {
            throw new IllegalStateException("Mutation can't be updated after build");
        }
    }

    private void checkForId(FieldPath path) {
        if ("_id".equals(path.getRootSegment().getNameSegment().getName())) {
            throw new UnsupportedOperationException("Mutation can't be used to change _id");
        }
    }

    private MutationImpl setCommon(FieldPath path, KeyValue value) {
        this.checkForUpdate();
        this.checkForId(path);
        MutationHelper.mutationCommon(InsertContext.OpType.SET, this.record, path, value);
        this.needsReadOnServer = true;
        return this;
    }

    private MutationImpl setOrReplaceCommon(FieldPath path, KeyValue value) {
        this.checkForUpdate();
        boolean containsArray = MutationHelper.mutationCommon(InsertContext.OpType.SET_OR_REPLACE, this.record, path, value);
        if (containsArray) {
            this.needsReadOnServer = true;
        }
        return this;
    }

    private Mutation appendCommon(FieldPath path, KeyValue value) {
        this.checkForUpdate();
        MutationHelper.mutationCommon(InsertContext.OpType.APPEND, this.record, path, value);
        this.needsReadOnServer = true;
        return this;
    }

    private Mutation mergeCommon(FieldPath path, KeyValue value) {
        this.checkForUpdate();
        MutationHelper.mutationCommon(InsertContext.OpType.MERGE, this.record, path, value);
        this.needsReadOnServer = true;
        return this;
    }

    private MutationImpl incrementCommon(FieldPath path, KeyValue value) {
        this.checkForUpdate();
        MutationHelper.mutationCommon(InsertContext.OpType.INCREMENT, this.record, path, value);
        this.needsReadOnServer = true;
        return this;
    }

    @Override
    public Mutation empty() {
        this.record.empty();
        this.needsReadOnServer = false;
        this.buildDone = false;
        return this;
    }

    @Override
    public Mutation setNull(String path) {
        return this.setNull(FieldPath.parseFrom((String)path));
    }

    @Override
    public Mutation setNull(FieldPath path) {
        return this.setCommon(path, KeyValueBuilder.initFromObject(null));
    }

    @Override
    public Mutation set(String path, Value v) {
        return this.set(FieldPath.parseFrom((String)path), v);
    }

    @Override
    public Mutation set(FieldPath path, Value v) {
        return this.setCommon(path, KeyValueBuilder.initFrom(v));
    }

    @Override
    public Mutation set(String path, boolean b) {
        return this.set(FieldPath.parseFrom((String)path), b);
    }

    @Override
    public Mutation set(FieldPath path, boolean b) {
        return this.setCommon(path, KeyValueBuilder.initFrom(b));
    }

    @Override
    public Mutation set(String path, short s) {
        return this.set(FieldPath.parseFrom((String)path), s);
    }

    @Override
    public Mutation set(FieldPath path, short s) {
        return this.setCommon(path, KeyValueBuilder.initFrom(s));
    }

    @Override
    public Mutation set(String path, byte b) {
        return this.set(FieldPath.parseFrom((String)path), b);
    }

    @Override
    public Mutation set(FieldPath path, byte b) {
        return this.setCommon(path, KeyValueBuilder.initFrom(b));
    }

    @Override
    public Mutation set(String path, int i) {
        return this.set(FieldPath.parseFrom((String)path), i);
    }

    @Override
    public Mutation set(FieldPath path, int i) {
        return this.setCommon(path, KeyValueBuilder.initFrom(i));
    }

    @Override
    public Mutation set(String path, long l) {
        return this.set(FieldPath.parseFrom((String)path), l);
    }

    @Override
    public Mutation set(FieldPath path, long l) {
        return this.setCommon(path, KeyValueBuilder.initFrom(l));
    }

    @Override
    public Mutation set(String path, float f) {
        return this.set(FieldPath.parseFrom((String)path), f);
    }

    @Override
    public Mutation set(FieldPath path, float f) {
        return this.setCommon(path, KeyValueBuilder.initFrom(f));
    }

    @Override
    public Mutation set(String path, double d) {
        return this.set(FieldPath.parseFrom((String)path), d);
    }

    @Override
    public Mutation set(FieldPath path, double d) {
        return this.setCommon(path, KeyValueBuilder.initFrom(d));
    }

    @Override
    public MutationImpl set(String path, String value) {
        return this.set(FieldPath.parseFrom((String)path), value);
    }

    @Override
    public MutationImpl set(FieldPath path, String value) {
        return this.setCommon(path, KeyValueBuilder.initFrom(value));
    }

    @Override
    public Mutation set(String path, BigDecimal bd) {
        return this.set(FieldPath.parseFrom((String)path), bd);
    }

    @Override
    public Mutation set(FieldPath path, BigDecimal bd) {
        return this.setCommon(path, KeyValueBuilder.initFrom(bd));
    }

    @Override
    public Mutation set(String path, Time t) {
        return this.set(FieldPath.parseFrom((String)path), t);
    }

    @Override
    public Mutation set(FieldPath path, Time t) {
        return this.setCommon(path, KeyValueBuilder.initFrom(t));
    }

    @Override
    public Mutation set(String path, Timestamp t) {
        return this.set(FieldPath.parseFrom((String)path), t);
    }

    @Override
    public Mutation set(FieldPath path, Timestamp t) {
        return this.setCommon(path, KeyValueBuilder.initFrom(t));
    }

    @Override
    public Mutation set(String path, Date d) {
        return this.set(FieldPath.parseFrom((String)path), d);
    }

    @Override
    public Mutation set(FieldPath path, Date d) {
        return this.setCommon(path, KeyValueBuilder.initFrom(d));
    }

    @Override
    public Mutation set(String path, List<? extends Object> value) {
        return this.set(FieldPath.parseFrom((String)path), value);
    }

    @Override
    public Mutation set(FieldPath path, List<? extends Object> value) {
        return this.setCommon(path, KeyValueBuilder.initFrom(value));
    }

    @Override
    public Mutation set(String path, Interval intv) {
        return this.set(FieldPath.parseFrom((String)path), intv);
    }

    @Override
    public Mutation set(FieldPath path, Interval intv) {
        return this.setCommon(path, KeyValueBuilder.initFrom(intv));
    }

    @Override
    public Mutation set(String path, ByteBuffer bb) {
        return this.set(FieldPath.parseFrom((String)path), bb);
    }

    @Override
    public Mutation set(FieldPath path, ByteBuffer bb) {
        return this.setCommon(path, KeyValueBuilder.initFrom(bb));
    }

    @Override
    public Mutation set(String path, Map<String, ? extends Object> value) {
        return this.set(FieldPath.parseFrom((String)path), value);
    }

    @Override
    public Mutation set(FieldPath path, Map<String, ? extends Object> value) {
        return this.setCommon(path, KeyValueBuilder.initFrom(value));
    }

    @Override
    public Mutation set(String path, Document value) {
        return this.set(FieldPath.parseFrom((String)path), value);
    }

    @Override
    public Mutation set(FieldPath path, Document value) {
        return this.setCommon(path, KeyValueBuilder.initFrom(value));
    }

    @Override
    public Mutation setOrReplace(String path, Value v) {
        return this.setOrReplace(FieldPath.parseFrom((String)path), v);
    }

    @Override
    public Mutation setOrReplace(FieldPath path, Value v) {
        return this.setOrReplaceCommon(path, KeyValueBuilder.initFromObject(v));
    }

    @Override
    public Mutation setOrReplaceNull(String path) {
        return this.setOrReplaceNull(FieldPath.parseFrom((String)path));
    }

    @Override
    public Mutation setOrReplaceNull(FieldPath path) {
        return this.setOrReplaceCommon(path, KeyValueBuilder.initFromObject(null));
    }

    @Override
    public Mutation setOrReplace(String path, boolean b) {
        return this.setOrReplace(FieldPath.parseFrom((String)path), b);
    }

    @Override
    public Mutation setOrReplace(FieldPath path, boolean b) {
        return this.setOrReplaceCommon(path, KeyValueBuilder.initFrom(b));
    }

    @Override
    public Mutation setOrReplace(String path, short s) {
        return this.setOrReplace(FieldPath.parseFrom((String)path), s);
    }

    @Override
    public Mutation setOrReplace(FieldPath path, short s) {
        return this.setOrReplaceCommon(path, KeyValueBuilder.initFrom(s));
    }

    @Override
    public Mutation setOrReplace(String path, byte b) {
        return this.setOrReplace(FieldPath.parseFrom((String)path), b);
    }

    @Override
    public Mutation setOrReplace(FieldPath path, byte b) {
        return this.setOrReplaceCommon(path, KeyValueBuilder.initFrom(b));
    }

    @Override
    public Mutation setOrReplace(String path, int i) {
        return this.setOrReplace(FieldPath.parseFrom((String)path), i);
    }

    @Override
    public Mutation setOrReplace(FieldPath path, int i) {
        return this.setOrReplaceCommon(path, KeyValueBuilder.initFrom(i));
    }

    @Override
    public Mutation setOrReplace(String path, long l) {
        return this.setOrReplace(FieldPath.parseFrom((String)path), l);
    }

    @Override
    public Mutation setOrReplace(FieldPath path, long l) {
        return this.setOrReplaceCommon(path, KeyValueBuilder.initFrom(l));
    }

    @Override
    public Mutation setOrReplace(String path, float f) {
        return this.setOrReplace(FieldPath.parseFrom((String)path), f);
    }

    @Override
    public Mutation setOrReplace(FieldPath path, float f) {
        return this.setOrReplaceCommon(path, KeyValueBuilder.initFrom(f));
    }

    @Override
    public Mutation setOrReplace(String path, double d) {
        return this.setOrReplace(FieldPath.parseFrom((String)path), d);
    }

    @Override
    public Mutation setOrReplace(FieldPath path, double d) {
        return this.setOrReplaceCommon(path, KeyValueBuilder.initFrom(d));
    }

    @Override
    public MutationImpl setOrReplace(String path, String value) {
        return this.setOrReplace(FieldPath.parseFrom((String)path), value);
    }

    @Override
    public MutationImpl setOrReplace(FieldPath path, String value) {
        return this.setOrReplaceCommon(path, KeyValueBuilder.initFrom(value));
    }

    @Override
    public Mutation setOrReplace(String path, BigDecimal bd) {
        return this.setOrReplace(FieldPath.parseFrom((String)path), bd);
    }

    @Override
    public Mutation setOrReplace(FieldPath path, BigDecimal bd) {
        return this.setOrReplaceCommon(path, KeyValueBuilder.initFrom(bd));
    }

    @Override
    public Mutation setOrReplace(String path, Time t) {
        return this.setOrReplace(FieldPath.parseFrom((String)path), t);
    }

    @Override
    public Mutation setOrReplace(FieldPath path, Time t) {
        return this.setOrReplaceCommon(path, KeyValueBuilder.initFrom(t));
    }

    @Override
    public Mutation setOrReplace(String path, Timestamp t) {
        return this.setOrReplace(FieldPath.parseFrom((String)path), t);
    }

    @Override
    public Mutation setOrReplace(FieldPath path, Timestamp t) {
        return this.setOrReplaceCommon(path, KeyValueBuilder.initFrom(t));
    }

    @Override
    public Mutation setOrReplace(String path, Date d) {
        return this.setOrReplace(FieldPath.parseFrom((String)path), d);
    }

    @Override
    public Mutation setOrReplace(FieldPath path, Date d) {
        return this.setOrReplaceCommon(path, KeyValueBuilder.initFrom(d));
    }

    @Override
    public Mutation setOrReplace(String path, List<? extends Object> value) {
        return this.setOrReplace(FieldPath.parseFrom((String)path), value);
    }

    @Override
    public Mutation setOrReplace(FieldPath path, List<? extends Object> value) {
        return this.setOrReplaceCommon(path, KeyValueBuilder.initFrom(value));
    }

    @Override
    public Mutation setOrReplace(String path, Interval intv) {
        return this.setOrReplace(FieldPath.parseFrom((String)path), intv);
    }

    @Override
    public Mutation setOrReplace(FieldPath path, Interval intv) {
        return this.setOrReplaceCommon(path, KeyValueBuilder.initFrom(intv));
    }

    @Override
    public Mutation setOrReplace(String path, ByteBuffer bb) {
        return this.setOrReplace(FieldPath.parseFrom((String)path), bb);
    }

    @Override
    public Mutation setOrReplace(FieldPath path, ByteBuffer bb) {
        return this.setOrReplaceCommon(path, KeyValueBuilder.initFrom(bb));
    }

    @Override
    public Mutation setOrReplace(String path, Map<String, ? extends Object> value) {
        return this.setOrReplace(FieldPath.parseFrom((String)path), value);
    }

    @Override
    public Mutation setOrReplace(FieldPath path, Map<String, ? extends Object> value) {
        return this.setOrReplaceCommon(path, KeyValueBuilder.initFrom(value));
    }

    @Override
    public Mutation setOrReplace(String path, Document value) {
        return this.setOrReplace(FieldPath.parseFrom((String)path), value);
    }

    @Override
    public Mutation setOrReplace(FieldPath path, Document value) {
        return this.setOrReplaceCommon(path, KeyValueBuilder.initFrom(value));
    }

    @Override
    public Mutation append(String path, List<? extends Object> value) {
        return this.append(FieldPath.parseFrom((String)path), value);
    }

    @Override
    public Mutation append(FieldPath path, List<? extends Object> value) {
        KeyValue kv = KeyValueBuilder.initFrom(value);
        this.appendCommon(path, kv);
        return this;
    }

    @Override
    public Mutation append(String path, String value) {
        return this.append(FieldPath.parseFrom((String)path), value);
    }

    @Override
    public Mutation append(FieldPath path, String value) {
        KeyValue kv = KeyValueBuilder.initFrom(value);
        this.appendCommon(path, kv);
        return this;
    }

    @Override
    public Mutation append(String path, byte[] value, int offset, int len) {
        return this.append(FieldPath.parseFrom((String)path), ByteBuffer.wrap(value, offset, len));
    }

    @Override
    public Mutation append(FieldPath path, byte[] value, int offset, int len) {
        return this.append(path, ByteBuffer.wrap(value, offset, len));
    }

    @Override
    public Mutation append(String path, byte[] value) {
        return this.append(FieldPath.parseFrom((String)path), ByteBuffer.wrap(value));
    }

    @Override
    public Mutation append(FieldPath path, byte[] value) {
        return this.append(path, ByteBuffer.wrap(value));
    }

    @Override
    public Mutation append(String path, ByteBuffer value) {
        return this.append(FieldPath.parseFrom((String)path), value);
    }

    @Override
    public Mutation append(FieldPath path, ByteBuffer value) {
        return this.appendCommon(path, KeyValueBuilder.initFrom(value));
    }

    @Override
    public Mutation merge(String path, Document value) {
        return this.merge(FieldPath.parseFrom((String)path), value);
    }

    @Override
    public Mutation merge(FieldPath path, Document value) {
        return this.mergeCommon(path, KeyValueBuilder.initFrom(value));
    }

    @Override
    public Mutation merge(String path, Map<String, Object> value) {
        return this.merge(FieldPath.parseFrom((String)path), value);
    }

    @Override
    public Mutation merge(FieldPath path, Map<String, Object> value) {
        return this.mergeCommon(path, KeyValueBuilder.initFrom(value));
    }

    @Override
    public Mutation increment(FieldPath path, byte inc) {
        return this.incrementCommon(path, KeyValueBuilder.initFrom(inc));
    }

    @Override
    public Mutation increment(String path, byte inc) {
        return this.incrementCommon(FieldPath.parseFrom((String)path), KeyValueBuilder.initFrom(inc));
    }

    @Override
    public Mutation increment(FieldPath path, short inc) {
        return this.incrementCommon(path, KeyValueBuilder.initFrom(inc));
    }

    @Override
    public Mutation increment(String path, short inc) {
        return this.incrementCommon(FieldPath.parseFrom((String)path), KeyValueBuilder.initFrom(inc));
    }

    @Override
    public MutationImpl increment(String path, int inc) {
        return this.incrementCommon(FieldPath.parseFrom((String)path), KeyValueBuilder.initFrom(inc));
    }

    @Override
    public Mutation increment(FieldPath path, int inc) {
        return this.incrementCommon(path, KeyValueBuilder.initFrom(inc));
    }

    @Override
    public Mutation increment(FieldPath path, long inc) {
        return this.incrementCommon(path, KeyValueBuilder.initFrom(inc));
    }

    @Override
    public Mutation increment(String path, long inc) {
        return this.incrementCommon(FieldPath.parseFrom((String)path), KeyValueBuilder.initFrom(inc));
    }

    @Override
    public Mutation increment(String path, float inc) {
        return this.incrementCommon(FieldPath.parseFrom((String)path), KeyValueBuilder.initFrom(inc));
    }

    @Override
    public Mutation increment(FieldPath path, float inc) {
        return this.incrementCommon(path, KeyValueBuilder.initFrom(inc));
    }

    @Override
    public Mutation increment(String path, double inc) {
        return this.incrementCommon(FieldPath.parseFrom((String)path), KeyValueBuilder.initFrom(inc));
    }

    @Override
    public Mutation increment(FieldPath path, double inc) {
        return this.incrementCommon(path, KeyValueBuilder.initFrom(inc));
    }

    @Override
    public Mutation increment(String path, BigDecimal inc) {
        return this.incrementCommon(FieldPath.parseFrom((String)path), KeyValueBuilder.initFrom(inc));
    }

    @Override
    public Mutation increment(FieldPath path, BigDecimal inc) {
        return this.incrementCommon(path, KeyValueBuilder.initFrom(inc));
    }

    @Override
    public Mutation delete(String path) {
        return this.delete(FieldPath.parseFrom((String)path));
    }

    @Override
    public Mutation delete(FieldPath path) {
        this.checkForUpdate();
        this.checkForId(path);
        boolean readNeeded = MutationHelper.mutationCommon(InsertContext.OpType.DELETE, this.record, path, new KeyValue(Value.Type.NULL));
        if (readNeeded) {
            this.needsReadOnServer = true;
        }
        return this;
    }

    @Override
    public MutationImpl build() {
        this.buildDone = true;
        return this;
    }

    @API.Internal
    public boolean needsReadOnServer() {
        return this.needsReadOnServer;
    }

    @API.Internal
    public ByteBuffer rowcolSerialize() {
        SerializedFamilyInfo[] familyInfo = this.rowcolSerialize((Map<FieldPath, Integer>)Constants.DEFAULT_FAMILY_MAP);
        assert (familyInfo.length == 1);
        return familyInfo[0].getByteBuffer();
    }

    @API.Internal
    public SerializedFamilyInfo[] rowcolSerialize(Map<FieldPath, Integer> jsonPathMap, boolean isBulkLoad) {
        SerializationContext ctx = new SerializationContext();
        ctx.setFullRecordOp(false);
        ctx.setStoreRowTS(isBulkLoad);
        ctx.serializeFamilies(this.record, jsonPathMap);
        return ctx.getSerializedBuffers();
    }

    @API.Internal
    public SerializedFamilyInfo[] rowcolSerialize(Map<FieldPath, Integer> jsonPathMap) {
        return this.rowcolSerialize(jsonPathMap, false);
    }

    @API.Internal
    public static MutationImpl fromSerializedValue(ByteBuffer input, boolean needsRead) {
        MutationImpl rm = new MutationImpl();
        rm.needsReadOnServer = needsRead;
        rm.record = (DBDocumentImpl)RowcolCodec.decode(input);
        return rm.build();
    }
}

