/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.rowcol;

import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.db.rowcol.DBList;
import com.mapr.db.rowcol.InsertContext;
import com.mapr.db.rowcol.KeyValue;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import org.ojai.Document;
import org.ojai.Value;
import org.ojai.exceptions.TypeException;
import org.ojai.json.impl.JsonUtils;
import org.ojai.types.Interval;
import org.ojai.util.Fields;

public class KeyValueBuilder {
    public static KeyValue initFromNull() {
        return new KeyValue(Value.Type.NULL);
    }

    public static KeyValue initFrom(boolean value) {
        KeyValue v = new KeyValue(Value.Type.BOOLEAN);
        v.setPrimValue(value ? 1L : 0L);
        return v;
    }

    public static KeyValue initFrom(String value) {
        KeyValue v = new KeyValue(Value.Type.STRING);
        v.setObjValue(value);
        return v;
    }

    public static KeyValue initFrom(byte value) {
        KeyValue v = new KeyValue(Value.Type.BYTE);
        v.setPrimValue(value);
        return v;
    }

    public static KeyValue initFrom(short value) {
        KeyValue v = new KeyValue(Value.Type.SHORT);
        v.setPrimValue(value);
        return v;
    }

    public static KeyValue initFrom(int value) {
        KeyValue v = new KeyValue(Value.Type.INT);
        v.setPrimValue(value);
        return v;
    }

    public static KeyValue initFrom(long value) {
        KeyValue v = new KeyValue(Value.Type.LONG);
        v.setPrimValue(value);
        return v;
    }

    public static KeyValue initFrom(float value) {
        KeyValue v = new KeyValue(Value.Type.FLOAT);
        v.setPrimValue(Float.floatToIntBits(value));
        return v;
    }

    public static KeyValue initFrom(double value) {
        KeyValue v = new KeyValue(Value.Type.DOUBLE);
        v.setPrimValue(Double.doubleToLongBits(value));
        return v;
    }

    public static KeyValue initFrom(Time value) {
        KeyValue v = new KeyValue(Value.Type.TIME);
        v.setPrimValue((int)(value.getTime() % 86400000L));
        return v;
    }

    public static KeyValue initFrom(Date value) {
        KeyValue v = new KeyValue(Value.Type.DATE);
        v.setPrimValue(JsonUtils.dateToNumDays((Date)value));
        return v;
    }

    public static KeyValue initFrom(BigDecimal value) {
        KeyValue v = new KeyValue(Value.Type.DECIMAL);
        v.setObjValue(value);
        return v;
    }

    public static KeyValue initFrom(Timestamp value) {
        KeyValue v = new KeyValue(Value.Type.TIMESTAMP);
        v.setPrimValue(value.getTime());
        return v;
    }

    public static KeyValue initFrom(Interval value) {
        KeyValue v = new KeyValue(Value.Type.INTERVAL);
        v.setPrimValue(value.getTimeInMillis());
        return v;
    }

    public static KeyValue initFrom(ByteBuffer value) {
        KeyValue v = new KeyValue(Value.Type.BINARY);
        v.setObjValue(value.duplicate());
        return v;
    }

    public static KeyValue initFrom(List<? extends Object> list) {
        if (list instanceof DBList) {
            return ((KeyValue)((Object)list)).shallowCopy();
        }
        DBList l = new DBList(InsertContext.OpType.NONE);
        for (Object object : list) {
            KeyValue child = KeyValueBuilder.initFromObject(object);
            child.setOpTypeAndFlags(null, false);
            l.addToDBList(child);
        }
        return l;
    }

    public static KeyValue initFrom(Map<String, ? extends Object> map) {
        if (map instanceof DBDocumentImpl) {
            return ((DBDocumentImpl)map).shallowCopy();
        }
        DBDocumentImpl rec = new DBDocumentImpl();
        for (String k : map.keySet()) {
            KeyValue child = KeyValueBuilder.initFromObject(map.get(k));
            child.setOpTypeAndFlags(null, false);
            rec.set(k, (Value)child);
        }
        return rec;
    }

    public static KeyValue initFrom(Document value) {
        if (value instanceof DBDocumentImpl) {
            return ((DBDocumentImpl)value).shallowCopy();
        }
        DBDocumentImpl r = new DBDocumentImpl();
        for (Map.Entry e : value) {
            KeyValue child = KeyValueBuilder.initFromObject(e.getValue());
            child.setOpTypeAndFlags(null, false);
            r.set(Fields.quoteFieldName((String)((String)e.getKey())), (Value)child);
        }
        return r;
    }

    public static KeyValue initFrom(Value value) {
        if (value instanceof KeyValue) {
            return ((KeyValue)value).shallowCopy();
        }
        return KeyValueBuilder.initFromObject(value.getObject());
    }

    public static KeyValue initFromObject(Object value) {
        if (value instanceof KeyValue) {
            return ((KeyValue)value).shallowCopy();
        }
        if (value == null) {
            return new KeyValue(Value.Type.NULL);
        }
        if (value instanceof Byte) {
            return KeyValueBuilder.initFrom((Byte)value);
        }
        if (value instanceof Boolean) {
            return KeyValueBuilder.initFrom((Boolean)value);
        }
        if (value instanceof String) {
            return KeyValueBuilder.initFrom((String)value);
        }
        if (value instanceof Short) {
            return KeyValueBuilder.initFrom((Short)value);
        }
        if (value instanceof Integer) {
            return KeyValueBuilder.initFrom((Integer)value);
        }
        if (value instanceof Long) {
            return KeyValueBuilder.initFrom((Long)value);
        }
        if (value instanceof Float) {
            return KeyValueBuilder.initFrom(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return KeyValueBuilder.initFrom((Double)value);
        }
        if (value instanceof Time) {
            return KeyValueBuilder.initFrom((Time)value);
        }
        if (value instanceof Date) {
            return KeyValueBuilder.initFrom((Date)value);
        }
        if (value instanceof Timestamp) {
            return KeyValueBuilder.initFrom((Timestamp)value);
        }
        if (value instanceof BigDecimal) {
            return KeyValueBuilder.initFrom((BigDecimal)value);
        }
        if (value instanceof ByteBuffer) {
            return KeyValueBuilder.initFrom((ByteBuffer)value);
        }
        if (value instanceof Interval) {
            return KeyValueBuilder.initFrom((Interval)value);
        }
        if (value instanceof Document) {
            return KeyValueBuilder.initFrom((Document)value);
        }
        if (value instanceof Map) {
            return KeyValueBuilder.initFrom((Map)value);
        }
        if (value instanceof List) {
            return KeyValueBuilder.initFrom((List)value);
        }
        if (value instanceof Value) {
            return KeyValueBuilder.initFrom((Value)value);
        }
        if (value.getClass().isArray()) {
            return KeyValueBuilder.initFromArray(value);
        }
        throw new TypeException("Unsupported object type of class: " + value.getClass());
    }

    public static KeyValue initFromArray(Object value) {
        Class<?> c = value.getClass().getComponentType();
        if (c.isPrimitive()) {
            if (c == Byte.TYPE) {
                byte[] v = (byte[])value;
                return KeyValueBuilder.initFromArray(v);
            }
            if (c == Short.TYPE) {
                short[] v = (short[])value;
                return KeyValueBuilder.initFromArray(v);
            }
            if (c == Integer.TYPE) {
                int[] v = (int[])value;
                return KeyValueBuilder.initFromArray(v);
            }
            if (c == Long.TYPE) {
                long[] v = (long[])value;
                return KeyValueBuilder.initFromArray(v);
            }
            if (c == Float.TYPE) {
                float[] v = (float[])value;
                return KeyValueBuilder.initFromArray(v);
            }
            if (c == Double.TYPE) {
                double[] v = (double[])value;
                return KeyValueBuilder.initFromArray(v);
            }
            if (c == Boolean.TYPE) {
                boolean[] v = (boolean[])value;
                return KeyValueBuilder.initFromArray(v);
            }
            if (c == Character.TYPE) {
                char[] v = (char[])value;
                return KeyValueBuilder.initFromArray(v);
            }
        } else {
            return KeyValueBuilder.initFromArray((Object[])value);
        }
        return null;
    }

    private static KeyValue initFromArray(byte[] values) {
        DBList list = new DBList(InsertContext.OpType.NONE);
        for (int i = 0; i < values.length; ++i) {
            KeyValue child = KeyValueBuilder.initFrom(values[i]);
            child.setOpTypeAndFlags(null, false);
            list.addToDBList(child);
        }
        return list;
    }

    private static KeyValue initFromArray(short[] values) {
        DBList list = new DBList(InsertContext.OpType.NONE);
        for (int i = 0; i < values.length; ++i) {
            KeyValue child = KeyValueBuilder.initFrom(values[i]);
            child.setOpTypeAndFlags(null, false);
            list.addToDBList(child);
        }
        return list;
    }

    private static KeyValue initFromArray(int[] values) {
        DBList list = new DBList(InsertContext.OpType.NONE);
        for (int i = 0; i < values.length; ++i) {
            KeyValue child = KeyValueBuilder.initFrom(values[i]);
            child.setOpTypeAndFlags(null, false);
            list.addToDBList(child);
        }
        return list;
    }

    private static KeyValue initFromArray(long[] values) {
        DBList list = new DBList(InsertContext.OpType.NONE);
        for (int i = 0; i < values.length; ++i) {
            KeyValue child = KeyValueBuilder.initFrom(values[i]);
            child.setOpTypeAndFlags(null, false);
            list.addToDBList(child);
        }
        return list;
    }

    private static KeyValue initFromArray(float[] values) {
        DBList list = new DBList(InsertContext.OpType.NONE);
        for (int i = 0; i < values.length; ++i) {
            KeyValue child = KeyValueBuilder.initFrom(values[i]);
            child.setOpTypeAndFlags(null, false);
            list.addToDBList(child);
        }
        return list;
    }

    private static KeyValue initFromArray(double[] values) {
        DBList list = new DBList(InsertContext.OpType.NONE);
        for (int i = 0; i < values.length; ++i) {
            KeyValue child = KeyValueBuilder.initFrom(values[i]);
            child.setOpTypeAndFlags(null, false);
            list.addToDBList(child);
        }
        return list;
    }

    private static KeyValue initFromArray(boolean[] values) {
        DBList list = new DBList(InsertContext.OpType.NONE);
        for (int i = 0; i < values.length; ++i) {
            KeyValue child = KeyValueBuilder.initFrom(values[i]);
            child.setOpTypeAndFlags(null, false);
            list.addToDBList(child);
        }
        return list;
    }

    private static KeyValue initFromArray(char[] values) {
        DBList list = new DBList(InsertContext.OpType.NONE);
        for (int i = 0; i < values.length; ++i) {
            KeyValue child = KeyValueBuilder.initFrom(values[i]);
            child.setOpTypeAndFlags(null, false);
            list.addToDBList(child);
        }
        return list;
    }

    private static KeyValue initFromArray(Object[] values) {
        DBList list = new DBList(InsertContext.OpType.NONE);
        for (int i = 0; i < values.length; ++i) {
            KeyValue child = KeyValueBuilder.initFromObject(values[i]);
            child.setOpTypeAndFlags(null, false);
            list.addToDBList(child);
        }
        return list;
    }
}

