/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.rowcol;

import com.mapr.db.rowcol.ArrayIndexDescriptor;
import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.db.rowcol.DBList;
import com.mapr.db.rowcol.InsertContext;
import com.mapr.db.rowcol.TimeAndUniq;
import com.mapr.db.rowcol.TimeDescriptor;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.ojai.Document;
import org.ojai.DocumentReader;
import org.ojai.Value;
import org.ojai.exceptions.TypeException;
import org.ojai.json.impl.JsonUtils;
import org.ojai.types.Interval;
import org.ojai.util.Values;

public class KeyValue
implements Value {
    Value.Type type;
    long primValue;
    Object objValue;
    byte timeDescriptor;
    TimeAndUniq[] times;
    TimeAndUniq arrayIndex;
    byte[] arrayIndexUniq;
    String key;
    int orderInMap;
    byte flags;
    protected InsertContext.OpType opType;
    boolean rootOfFamily;
    boolean partOfNonDefaultCF;
    int rootCFid;
    public static final byte IsArrayElementMask = 1;
    public static final byte IsArrayElementShift = 0;
    public static final byte ArrayIndexTypeMask = 2;
    public static final byte ArrayIndexTypeShift = 1;
    public static final byte IsRootMask = 4;
    public static final byte IsRootShift = 2;

    public void setIsArrayElement(boolean v) {
        this.flags = v ? (byte)(this.flags | 1) : (byte)(this.flags & 0xFFFFFFFE);
    }

    public boolean isArrayElement() {
        return (this.flags & 1) >> 0 == 1;
    }

    public void setArrayIndexType(ArrayIndexDescriptor.ArrayIndexType type) {
        this.flags = (byte)(this.flags | type.ordinal() << 1);
    }

    public ArrayIndexDescriptor.ArrayIndexType getArrayIndexType() {
        return ArrayIndexDescriptor.ArrayIndexType.values()[(this.flags & 2) >> 1];
    }

    public void setIsRoot() {
        this.flags = (byte)(this.flags | 4);
    }

    public boolean isRoot() {
        return (this.flags & 4) >> 2 == 1;
    }

    public KeyValue() {
        this.opType = InsertContext.OpType.NONE;
    }

    public KeyValue(Value.Type type) {
        this.type = type;
        this.opType = InsertContext.OpType.NONE;
    }

    void setPrimValue(long primValue) {
        this.primValue = primValue;
    }

    long getPrimValue() {
        return this.primValue;
    }

    void setObjValue(Object objValue) {
        this.objValue = objValue;
    }

    private void checkType(Value.Type t) throws TypeException {
        if (this.type != t) {
            throw new TypeException("Value is of type " + this.type + ", but it is accessed as type " + t);
        }
    }

    public Value.Type getType() {
        return this.type;
    }

    public String getKey() {
        return this.key;
    }

    public byte getByte() {
        this.checkType(Value.Type.BYTE);
        return (byte)(this.primValue & 0xFFL);
    }

    public short getShort() {
        this.checkType(Value.Type.SHORT);
        return (short)(this.primValue & 0xFFFFL);
    }

    public int getInt() {
        this.checkType(Value.Type.INT);
        return (int)(this.primValue & 0xFFFFFFFFL);
    }

    public long getLong() {
        this.checkType(Value.Type.LONG);
        return this.primValue;
    }

    public float getFloat() {
        this.checkType(Value.Type.FLOAT);
        return Float.intBitsToFloat((int)(this.primValue & 0xFFFFFFFFL));
    }

    public double getDouble() {
        this.checkType(Value.Type.DOUBLE);
        return Double.longBitsToDouble(this.primValue);
    }

    public boolean getBoolean() {
        this.checkType(Value.Type.BOOLEAN);
        return this.primValue != 0L;
    }

    public Timestamp getTimestamp() {
        this.checkType(Value.Type.TIMESTAMP);
        if (this.objValue == null) {
            Timestamp t = new Timestamp(this.primValue);
            this.objValue = t;
        }
        return (Timestamp)this.objValue;
    }

    public long getTimestampAsLong() {
        this.checkType(Value.Type.TIMESTAMP);
        return this.primValue;
    }

    public String getString() {
        this.checkType(Value.Type.STRING);
        return (String)this.objValue;
    }

    public BigDecimal getDecimal() {
        this.checkType(Value.Type.DECIMAL);
        return (BigDecimal)this.objValue;
    }

    public Date getDate() {
        this.checkType(Value.Type.DATE);
        if (this.objValue == null) {
            this.objValue = JsonUtils.numDaysToDate((long)this.primValue);
        }
        return (Date)this.objValue;
    }

    public int getDateAsInt() {
        return (int)this.primValue;
    }

    public Time getTime() {
        this.checkType(Value.Type.TIME);
        if (this.objValue == null) {
            Time t = new Time(this.primValue % 86400000L);
            this.objValue = t;
        }
        return (Time)this.objValue;
    }

    public int getTimeAsInt() {
        return (int)this.primValue;
    }

    public Interval getInterval() {
        this.checkType(Value.Type.INTERVAL);
        if (this.objValue == null) {
            Interval t = new Interval(this.primValue);
            this.objValue = t;
        }
        return (Interval)this.objValue;
    }

    public long getIntervalAsLong() {
        return this.primValue;
    }

    public Map<String, Object> getMap() {
        this.checkType(Value.Type.MAP);
        return (DBDocumentImpl)this;
    }

    public Document getRecord() {
        this.checkType(Value.Type.MAP);
        return (DBDocumentImpl)this;
    }

    public List<Object> getList() {
        this.checkType(Value.Type.ARRAY);
        return (DBList)this;
    }

    ByteBuffer getBinaryInternal() {
        this.checkType(Value.Type.BINARY);
        return (ByteBuffer)this.objValue;
    }

    public ByteBuffer getBinary() {
        this.checkType(Value.Type.BINARY);
        return ((ByteBuffer)this.objValue).duplicate();
    }

    public Object getObject() {
        switch (this.type) {
            case BOOLEAN: {
                return new Boolean(this.getBoolean());
            }
            case BYTE: {
                return new Byte(this.getByte());
            }
            case SHORT: {
                return new Short(this.getShort());
            }
            case INT: {
                return new Integer(this.getInt());
            }
            case LONG: {
                return new Long(this.getLong());
            }
            case FLOAT: {
                return new Float(this.getFloat());
            }
            case DOUBLE: {
                return new Double(this.getDouble());
            }
            case TIME: {
                return this.getTime();
            }
            case TIMESTAMP: {
                return this.getTimestamp();
            }
            case DATE: {
                return this.getDate();
            }
            case INTERVAL: {
                return this.getInterval();
            }
            case BINARY: {
                return this.getBinary();
            }
            case DECIMAL: 
            case STRING: 
            case NULL: {
                return this.objValue;
            }
            case MAP: 
            case ARRAY: {
                return this;
            }
        }
        throw new TypeException("Invalid type " + this.type);
    }

    public DocumentReader getStream() {
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof KeyValue) {
            KeyValue value = (KeyValue)obj;
            if (this.type != value.getType()) {
                return false;
            }
            switch (this.type) {
                case BOOLEAN: 
                case BYTE: 
                case SHORT: 
                case INT: 
                case LONG: 
                case FLOAT: 
                case DOUBLE: 
                case TIME: 
                case TIMESTAMP: 
                case DATE: 
                case INTERVAL: {
                    return this.primValue == value.primValue;
                }
                case NULL: {
                    return this.objValue == null && value.objValue == null;
                }
                case BINARY: 
                case DECIMAL: 
                case STRING: 
                case MAP: 
                case ARRAY: {
                    return this.objValue.equals(value.objValue);
                }
            }
        }
        if (obj instanceof String) {
            return this.objValue.equals(obj);
        }
        if (obj instanceof Byte) {
            return obj.equals(this.getByte());
        }
        if (obj instanceof Short) {
            return obj.equals(this.getShort());
        }
        if (obj instanceof Boolean) {
            return obj.equals(this.getBoolean());
        }
        if (obj instanceof Float) {
            return obj.equals(Float.valueOf(this.getFloat()));
        }
        if (obj instanceof Integer) {
            return obj.equals(this.getInt());
        }
        if (obj instanceof BigDecimal) {
            return obj.equals(this.getDecimal());
        }
        if (obj instanceof Double) {
            return obj.equals(this.getDouble());
        }
        if (obj instanceof Date) {
            long dateAsLong = ((Date)obj).getTime() / 86400000L;
            return dateAsLong == this.primValue;
        }
        if (obj instanceof Time) {
            long timeAsLong = ((Time)obj).getTime() % 86400000L;
            return timeAsLong == this.primValue;
        }
        if (obj instanceof Timestamp) {
            long timestampAsLong = ((Timestamp)obj).getTime();
            return this.getTimestampAsLong() == timestampAsLong;
        }
        if (obj instanceof Interval) {
            return obj.equals(this.getInterval());
        }
        if (obj instanceof ByteBuffer) {
            return obj.equals(this.getBinary());
        }
        if (obj instanceof Map) {
            return obj.equals(this.getMap());
        }
        if (obj instanceof List) {
            return obj.equals(this.getList());
        }
        return false;
    }

    public KeyValue shallowCopy() {
        if (this.type == Value.Type.MAP) {
            DBDocumentImpl rec = (DBDocumentImpl)this;
            return rec.shallowCopy();
        }
        if (this.type == Value.Type.ARRAY) {
            DBList list = (DBList)this;
            return list.shallowCopy();
        }
        KeyValue newKeyValue = new KeyValue(this.type);
        newKeyValue.objValue = this.objValue;
        newKeyValue.primValue = this.primValue;
        newKeyValue.orderInMap = this.orderInMap;
        newKeyValue.rootCFid = this.rootCFid;
        newKeyValue.partOfNonDefaultCF = this.partOfNonDefaultCF;
        return newKeyValue;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setArrayIndex(ArrayIndexDescriptor.ArrayIndexType type, int index) {
        this.setIsArrayElement(true);
        this.setArrayIndexType(type);
        this.setOrderOfField(index);
    }

    public void toString(StringBuilder buf) {
        if (!this.isArrayElement() && this.key != null) {
            buf.append(" key:" + this.key + " keylen:" + this.key.length());
        }
        buf.append(" td:" + this.timeDescriptor);
        buf.append(" orderoffield:" + this.orderInMap);
        buf.append(" type:" + this.type);
        buf.append(" optype: " + (Object)((Object)this.opType));
        buf.append(" value:");
        this.valueToString(buf);
    }

    public void valueToString(StringBuilder buf) {
        switch (this.type) {
            case BINARY: {
                ByteBuffer b = this.getBinary();
                buf.append("binary size: " + (b.limit() - b.position()));
                break;
            }
            case NULL: {
                buf.append("null");
                break;
            }
            case STRING: {
                buf.append('\"').append(this.getObject().toString()).append('\"');
                break;
            }
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case TIME: 
            case TIMESTAMP: 
            case DATE: 
            case DECIMAL: {
                buf.append(this.getObject().toString());
                break;
            }
            case INTERVAL: {
                buf.append(this.getIntervalAsLong());
                break;
            }
            case MAP: {
                DBDocumentImpl r = (DBDocumentImpl)this;
                buf.append("Type: " + this.type);
                buf.append(", value:");
                if (r.idValue != null) {
                    r.idValue.toString(buf);
                }
                for (KeyValue kv : r.map.values()) {
                    buf.append("\n");
                    kv.toString(buf);
                }
                break;
            }
            case ARRAY: {
                DBList r = (DBList)this;
                buf.append("timedescriptor:" + this.timeDescriptor);
                for (KeyValue kv : r.list) {
                    if (kv != null) {
                        buf.append("\n");
                        kv.toString(buf);
                        continue;
                    }
                    buf.append("NULL_ARRAY_VALUE");
                }
                break;
            }
        }
    }

    public String toString() {
        return Values.asJsonString((Value)this);
    }

    public void setRootFlags(InsertContext ctx) {
        TimeDescriptor.setUpdateTimeValid(this);
        switch (ctx.getOpType()) {
            case NONE: {
                TimeDescriptor.setCreateTimeValid(this);
                TimeDescriptor.setDeleteTimeValid(this);
                break;
            }
            case MERGE: 
            case SET: 
            case SET_OR_REPLACE: 
            case APPEND: 
            case INCREMENT: {
                TimeDescriptor.setCreateTimeValid(this);
            }
        }
    }

    public void setOpTypeAndFlags(InsertContext ctx, boolean isLastElement) {
        InsertContext.OpType t = ctx != null ? ctx.getOpType() : InsertContext.OpType.NONE;
        if (isLastElement) {
            this.opType = t;
        }
        TimeDescriptor.reset(this);
        switch (t) {
            case NONE: {
                TimeDescriptor.setCreateTimeValid(this);
                TimeDescriptor.setUpdateTimeValid(this);
                break;
            }
            case SET: 
            case SET_OR_REPLACE: {
                TimeDescriptor.setCreateTimeValid(this);
                TimeDescriptor.setUpdateTimeValid(this);
                if (!isLastElement) break;
                TimeDescriptor.setDeleteTimeValid(this);
                break;
            }
            case MERGE: 
            case APPEND: 
            case INCREMENT: {
                TimeDescriptor.setCreateTimeValid(this);
                TimeDescriptor.setUpdateTimeValid(this);
                break;
            }
            case DELETE: {
                TimeDescriptor.setUpdateTimeValid(this);
                if (!isLastElement) break;
                this.opType = InsertContext.OpType.DELETE;
                TimeDescriptor.setDeleteTimeValid(this);
            }
        }
    }

    public InsertContext.OpType getOpType() {
        return this.opType;
    }

    public byte getTimeDescriptor() {
        return this.timeDescriptor;
    }

    public void restoreKVOrder(Map<Integer, String> idToCFNameMap) {
        if (this.type == Value.Type.MAP) {
            DBDocumentImpl rec = (DBDocumentImpl)this;
            rec.restoreOrder(idToCFNameMap);
        }
        if (this.type == Value.Type.ARRAY) {
            DBList arr = (DBList)this;
            arr.restoreArrayOrder(idToCFNameMap);
        }
    }

    public void setOrderOfField(int i) {
        this.orderInMap = i;
    }

    public int getOrderOfField() {
        return this.orderInMap;
    }

    public boolean isContainerType() {
        return this.type == Value.Type.ARRAY || this.type == Value.Type.MAP;
    }

    public void setRootOfColumnFamily(boolean b) {
        this.rootOfFamily = b;
    }

    public boolean isRootOfColumnFamily() {
        return this.rootOfFamily;
    }

    public void setPartOfNonDefaultColumnFamily(boolean b) {
        this.partOfNonDefaultCF = b;
    }

    public boolean isPartOfNonDefaultColumnFamily() {
        return this.partOfNonDefaultCF;
    }

    public void setCFRootId(int id) {
        this.rootCFid = id;
    }

    public int getCFRootId() {
        return this.rootCFid;
    }

    public void setRecursiveNonDefaultColumnFamily(boolean b, int cfId) {
        this.setPartOfNonDefaultColumnFamily(b);
        this.setCFRootId(cfId);
        if (this.type == Value.Type.MAP) {
            DBDocumentImpl rec = (DBDocumentImpl)this;
            rec.setRecursiveNonDefaultColumnFamily(b, cfId);
        }
        if (this.type == Value.Type.ARRAY) {
            DBList arr = (DBList)this;
            for (KeyValue kv : arr.list) {
                if (kv == null || kv.type != Value.Type.MAP) continue;
                DBDocumentImpl rec = (DBDocumentImpl)kv;
                rec.setRecursiveNonDefaultColumnFamily(b, cfId);
            }
        }
    }

    public String toStringWithTimestamp() {
        return Values.asJsonString((Value)this);
    }

    public static boolean equals(KeyValue kv1, KeyValue kv2, boolean matchTime, boolean keepOnlyMismatch, TimeAndUniq parentDelTime1, TimeAndUniq parentDelTime2) {
        TimeAndUniq delTime1 = null;
        TimeAndUniq delTime2 = null;
        boolean matched = true;
        if (kv1 == null && kv2 == null) {
            return true;
        }
        if (kv1 == null || kv2 == null) {
            return false;
        }
        if (kv1 instanceof DBDocumentImpl) {
            DBDocumentImpl doc1 = (DBDocumentImpl)kv1;
            DBDocumentImpl doc2 = (DBDocumentImpl)kv2;
            doc1.setMapOnDemand();
            doc2.setMapOnDemand();
        }
        assert (kv1.isRoot() == kv2.isRoot());
        if (matchTime) {
            for (int i = 0; i < 2; ++i) {
                TimeAndUniq t1 = kv1.times[i];
                TimeAndUniq t2 = kv2.times[i];
                if (TimeAndUniq.equals(t1, t2)) continue;
                matched = false;
            }
            delTime1 = kv1.times[2];
            delTime2 = kv2.times[2];
            if (parentDelTime1 != null && TimeAndUniq.cmp(parentDelTime1, delTime1) >= 0) {
                delTime1 = parentDelTime1;
            }
            if (parentDelTime2 != null && TimeAndUniq.cmp(parentDelTime2, delTime2) >= 0) {
                delTime2 = parentDelTime2;
            }
            if (!TimeAndUniq.equals(delTime1, delTime2)) {
                matched = false;
            }
        }
        if (kv1.type != kv2.type) {
            return false;
        }
        assert (kv1.isArrayElement() == kv2.isArrayElement());
        Value.Type type = kv1.type;
        if (type == Value.Type.MAP) {
            LinkedHashMap<String, KeyValue> map1 = ((DBDocumentImpl)kv1).map;
            LinkedHashMap<String, KeyValue> map2 = ((DBDocumentImpl)kv2).map;
            KeyValue child1 = null;
            KeyValue child2 = null;
            Iterator iter1 = map1.entrySet().iterator();
            Iterator iter2 = map2.entrySet().iterator();
            while (iter1.hasNext() || iter2.hasNext()) {
                if (child1 == null && iter1.hasNext()) {
                    child1 = (KeyValue)iter1.next().getValue();
                }
                if (child2 == null && iter2.hasNext()) {
                    child2 = (KeyValue)iter2.next().getValue();
                }
                assert (child1 != null || child2 != null);
                if (child1 == null || child2 == null) {
                    return false;
                }
                int cmp = child1.key.compareTo(child2.key);
                if (cmp == 0) {
                    boolean childMatched = KeyValue.equals(child1, child2, matchTime, keepOnlyMismatch, delTime1, delTime2);
                    if (childMatched && keepOnlyMismatch) {
                        iter1.remove();
                        iter2.remove();
                    }
                    if (!childMatched) {
                        matched = false;
                    }
                    child2 = null;
                    child1 = null;
                    continue;
                }
                if (cmp < 0) {
                    matched = false;
                    child1 = null;
                    continue;
                }
                matched = false;
                child2 = null;
            }
            return matched;
        }
        if (type == Value.Type.ARRAY) {
            List<KeyValue> list1 = ((DBList)kv1).list;
            List<KeyValue> list2 = ((DBList)kv2).list;
            KeyValue child1 = null;
            KeyValue child2 = null;
            Iterator<KeyValue> iter1 = list1.iterator();
            Iterator<KeyValue> iter2 = list2.iterator();
            while (iter1.hasNext() || iter2.hasNext()) {
                if (child1 == null && iter1.hasNext()) {
                    child1 = iter1.next();
                }
                if (child2 == null && iter2.hasNext()) {
                    child2 = iter2.next();
                }
                assert (child1 != null || child2 != null);
                if (child1 == null || child2 == null) {
                    return false;
                }
                TimeAndUniq index1 = child1.arrayIndex;
                byte[] index1Uniq = child1.arrayIndexUniq;
                TimeAndUniq index2 = child2.arrayIndex;
                byte[] index2Uniq = child2.arrayIndexUniq;
                int cmp = ArrayIndexDescriptor.compareIndexTimeAndUniq(index1, index1Uniq, index2, index2Uniq);
                if (cmp == 0) {
                    boolean childMatched = KeyValue.equals(child1, child2, matchTime, keepOnlyMismatch, delTime1, delTime2);
                    if (childMatched && keepOnlyMismatch) {
                        iter1.remove();
                        iter2.remove();
                    }
                    if (!childMatched) {
                        matched = false;
                    }
                    child2 = null;
                    child1 = null;
                    continue;
                }
                if (cmp < 0) {
                    matched = false;
                    child1 = null;
                    continue;
                }
                matched = false;
                child2 = null;
            }
            return matched;
        }
        return kv1.equals(kv2);
    }
}

