/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.ojai;

import com.mapr.db.ControlInfo;
import com.mapr.db.ojai.DBDocumentReaderBase;
import com.mapr.db.rowcol.BigDecimalSizeDescriptor;
import com.mapr.db.rowcol.ControlInfoImpl;
import com.mapr.db.rowcol.KeyValue;
import com.mapr.db.rowcol.KeyValueDeserializeHelper;
import com.mapr.db.rowcol.SerializationContext;
import com.mapr.db.util.ObjectTypeBuilder;
import com.mapr.org.apache.hadoop.hbase.util.Bytes;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;
import java.util.Stack;
import org.ojai.DocumentReader;
import org.ojai.FieldPath;
import org.ojai.Value;
import org.ojai.annotation.API;
import org.ojai.exceptions.TypeException;
import org.ojai.types.Interval;
import org.ojai.util.Types;

@API.Internal
public class DBDocumentReader
implements DBDocumentReaderBase {
    private Map<Integer, ByteBuffer> dataMap;
    private Map<FieldPath, Integer> jsonPathMap;
    private KeyValue idValue;
    private boolean excludeId;
    private boolean idNameProcessed = false;
    private ByteBuffer rowBuf;
    protected long currentLongValue = 0L;
    protected Object currentObjValue = null;
    private int decimalScale;
    private int decimalPrecision;
    private byte[] decimalUnscaledValue;
    protected DocumentReader.EventType currentEventType;
    private DocumentReader.EventType nextEventType;
    private DocumentReader.EventType processedEventType = null;
    private int mapLevel;
    private Stack<Boolean> isMapOrArrayContext;
    private Boolean mapContext;
    private Boolean arrayContext;
    private SerializationContext context;
    private int[] keyValueSize;

    public DBDocumentReader(Map<Integer, ByteBuffer> map, Map<FieldPath, Integer> pathMap, KeyValue idValue, boolean exclude) throws IOException {
        this.dataMap = map;
        this.jsonPathMap = pathMap;
        this.idValue = idValue;
        this.excludeId = exclude;
        this.context = new SerializationContext();
        if (this.dataMap != null) {
            ByteBuffer row = this.dataMap.entrySet().iterator().next().getValue();
            this.rowBuf = row.duplicate();
            this.rowBuf.order(row.order());
            if (this.rowBuf.order() != ByteOrder.LITTLE_ENDIAN) {
                throw new IOException("Byte order of serialized buffer must be little endian.");
            }
            this.context.setNewRecord(true);
            this.mapLevel = 1;
            this.isMapOrArrayContext = new Stack();
            this.isMapOrArrayContext.push(new Boolean(true));
            this.mapContext = new Boolean(true);
            this.arrayContext = new Boolean(false);
        } else {
            this.rowBuf = null;
        }
        this.currentEventType = DocumentReader.EventType.START_MAP;
        this.nextEventType = null;
        this.decimalPrecision = 0;
        this.decimalScale = 0;
        this.decimalUnscaledValue = null;
    }

    private DocumentReader.EventType getEventType(Value.Type t) {
        switch (t) {
            case MAP: {
                return DocumentReader.EventType.START_MAP;
            }
            case ARRAY: {
                return DocumentReader.EventType.START_ARRAY;
            }
        }
        return Types.getEventTypeForType((Value.Type)t);
    }

    private void getNextToken() {
        if (!this.rowBuf.hasRemaining()) {
            if (this.isMapOrArrayContext.isEmpty()) {
                return;
            }
            throw new IllegalStateException("Can not parse serialized document.");
        }
        KeyValueDeserializeHelper.deserializeWithoutKeyValue(this.context, this.rowBuf);
        Value.Type t = this.context.getType();
        if (t == null) {
            Boolean currentContext = this.isMapOrArrayContext.pop();
            if (currentContext.booleanValue()) {
                this.currentEventType = DocumentReader.EventType.END_MAP;
                if (!this.isMapOrArrayContext.isEmpty()) {
                    this.context.setIsArrayElement(this.isMapOrArrayContext.peek() == false);
                }
                --this.mapLevel;
            } else {
                this.currentEventType = DocumentReader.EventType.END_ARRAY;
                if (!this.isMapOrArrayContext.isEmpty()) {
                    this.context.setIsArrayElement(this.isMapOrArrayContext.peek() == false);
                }
            }
            return;
        }
        this.keyValueSize = this.context.getKeyValueSize();
        if (this.isMapOrArrayContext.peek().booleanValue()) {
            this.currentEventType = DocumentReader.EventType.FIELD_NAME;
            this.nextEventType = this.getEventType(t);
        } else {
            this.currentEventType = this.getEventType(t);
        }
        if (t == Value.Type.MAP) {
            this.context.setIsArrayElement(false);
            ++this.mapLevel;
            this.isMapOrArrayContext.push(this.mapContext);
        }
        if (t == Value.Type.ARRAY) {
            this.context.setIsArrayElement(true);
            this.isMapOrArrayContext.push(this.arrayContext);
        }
    }

    private void cacheBigDecimalComponents() {
        byte sizeDesc = this.rowBuf.get();
        int unscaledValueSize = BigDecimalSizeDescriptor.getBigDecimalUnscaledValueSize(sizeDesc, this.rowBuf);
        this.decimalPrecision = BigDecimalSizeDescriptor.getBigDecimalPrecision(sizeDesc, this.rowBuf);
        this.decimalScale = BigDecimalSizeDescriptor.getBigDecimalScale(sizeDesc, this.rowBuf);
        this.decimalUnscaledValue = BigDecimalSizeDescriptor.getBigDecimalUnscaledValue(unscaledValueSize, this.rowBuf);
    }

    private void cacheCurrentValue(DocumentReader.EventType eventType) {
        this.processedEventType = eventType;
        switch (eventType) {
            case BOOLEAN: {
                this.currentLongValue = this.keyValueSize[1];
                break;
            }
            case STRING: {
                this.currentObjValue = Bytes.toString((ByteBuffer)this.rowBuf, (int)this.keyValueSize[1]);
                break;
            }
            case FIELD_NAME: {
                this.currentObjValue = Bytes.toString((ByteBuffer)this.rowBuf, (int)this.keyValueSize[0]);
                break;
            }
            case BYTE: {
                this.currentLongValue = this.rowBuf.get();
                break;
            }
            case SHORT: {
                this.currentLongValue = this.rowBuf.getShort();
                break;
            }
            case FLOAT: 
            case INT: {
                this.currentLongValue = this.rowBuf.getInt();
                break;
            }
            case DOUBLE: 
            case LONG: {
                this.currentLongValue = this.rowBuf.getLong();
                break;
            }
            case DECIMAL: {
                this.cacheBigDecimalComponents();
                this.currentObjValue = null;
                break;
            }
            case DATE: 
            case TIME: 
            case TIMESTAMP: 
            case INTERVAL: {
                this.currentLongValue = KeyValueDeserializeHelper.deserializeVarLong(this.keyValueSize[1], this.rowBuf);
                break;
            }
            case BINARY: {
                byte[] bytes = new byte[this.keyValueSize[1]];
                this.rowBuf.get(bytes);
                ByteBuffer b = ByteBuffer.wrap(bytes);
                this.currentObjValue = b;
                break;
            }
        }
    }

    public DocumentReader.EventType next() {
        if (!this.excludeId) {
            DocumentReader.EventType et;
            if (!this.idNameProcessed) {
                this.processedEventType = et = DocumentReader.EventType.FIELD_NAME;
                this.currentObjValue = "_id";
                this.idNameProcessed = true;
            } else {
                this.processedEventType = et = Types.getEventTypeForType((Value.Type)this.idValue.getType());
                this.currentObjValue = this.idValue.getObject();
                this.excludeId = true;
            }
            return et;
        }
        if (this.rowBuf == null) {
            return null;
        }
        if (this.currentEventType == null) {
            if (this.nextEventType != null) {
                this.currentEventType = this.nextEventType;
                this.nextEventType = null;
            } else {
                this.getNextToken();
            }
        }
        DocumentReader.EventType et = this.currentEventType;
        this.currentEventType = null;
        if (et != null) {
            this.cacheCurrentValue(et);
        }
        return et;
    }

    private void checkEventType(DocumentReader.EventType eventType) throws TypeException {
        if (this.processedEventType != eventType) {
            throw new TypeException("Event type mismatch");
        }
    }

    public String getFieldName() {
        this.checkEventType(DocumentReader.EventType.FIELD_NAME);
        return (String)this.currentObjValue;
    }

    public byte getByte() {
        this.checkEventType(DocumentReader.EventType.BYTE);
        return (byte)this.currentLongValue;
    }

    public short getShort() {
        this.checkEventType(DocumentReader.EventType.SHORT);
        return (short)this.currentLongValue;
    }

    public int getInt() {
        this.checkEventType(DocumentReader.EventType.INT);
        return (int)this.currentLongValue;
    }

    public long getLong() {
        this.checkEventType(DocumentReader.EventType.LONG);
        return this.currentLongValue;
    }

    public float getFloat() {
        this.checkEventType(DocumentReader.EventType.FLOAT);
        return Float.intBitsToFloat((int)(this.currentLongValue & 0xFFFFFFFFL));
    }

    public double getDouble() {
        this.checkEventType(DocumentReader.EventType.DOUBLE);
        return Double.longBitsToDouble(this.currentLongValue);
    }

    public BigDecimal getDecimal() {
        this.checkEventType(DocumentReader.EventType.DECIMAL);
        if (this.currentObjValue == null) {
            this.currentObjValue = new BigDecimal(new BigInteger(this.decimalUnscaledValue), this.decimalScale, new MathContext(this.decimalPrecision));
        }
        return (BigDecimal)this.currentObjValue;
    }

    public int getDecimalPrecision() {
        this.checkEventType(DocumentReader.EventType.DECIMAL);
        return this.decimalPrecision;
    }

    public int getDecimalScale() {
        this.checkEventType(DocumentReader.EventType.DECIMAL);
        return this.decimalScale;
    }

    public int getDecimalValueAsInt() {
        BigDecimal decimal = this.getDecimal();
        if (decimal != null) {
            return decimal.intValueExact();
        }
        return 0;
    }

    public long getDecimalValueAsLong() {
        BigDecimal decimal = this.getDecimal();
        if (decimal != null) {
            return decimal.longValueExact();
        }
        return 0L;
    }

    public ByteBuffer getDecimalValueAsBytes() {
        BigDecimal decimal = this.getDecimal();
        if (decimal != null) {
            BigInteger decimalInteger = decimal.unscaledValue();
            byte[] bytearray = decimalInteger.toByteArray();
            return ByteBuffer.wrap(bytearray);
        }
        return null;
    }

    public boolean getBoolean() {
        this.checkEventType(DocumentReader.EventType.BOOLEAN);
        return this.currentLongValue != 0L;
    }

    public String getString() {
        this.checkEventType(DocumentReader.EventType.STRING);
        return (String)this.currentObjValue;
    }

    public long getTimestampLong() {
        this.checkEventType(DocumentReader.EventType.TIMESTAMP);
        return ((Timestamp)this.currentObjValue).getTime();
    }

    public Timestamp getTimestamp() {
        this.checkEventType(DocumentReader.EventType.TIMESTAMP);
        return new Timestamp(this.currentLongValue);
    }

    public int getDateInt() {
        this.checkEventType(DocumentReader.EventType.DATE);
        return (int)(((Date)this.currentObjValue).getTime() / 86400000L);
    }

    public Date getDate() {
        this.checkEventType(DocumentReader.EventType.DATE);
        return ObjectTypeBuilder.getDate(this.currentLongValue);
    }

    public int getTimeInt() {
        this.checkEventType(DocumentReader.EventType.TIME);
        return (int)(((Time)this.currentObjValue).getTime() % 86400000L);
    }

    public Time getTime() {
        this.checkEventType(DocumentReader.EventType.TIME);
        return ObjectTypeBuilder.getTime(this.currentLongValue);
    }

    public Interval getInterval() {
        this.checkEventType(DocumentReader.EventType.INTERVAL);
        return new Interval(this.currentLongValue);
    }

    public int getIntervalDays() {
        this.checkEventType(DocumentReader.EventType.INTERVAL);
        return (int)(this.currentLongValue / 86400000L);
    }

    public long getIntervalMillis() {
        this.checkEventType(DocumentReader.EventType.INTERVAL);
        return this.currentLongValue;
    }

    public ByteBuffer getBinary() {
        this.checkEventType(DocumentReader.EventType.BINARY);
        return (ByteBuffer)this.currentObjValue;
    }

    @Override
    public ControlInfo getControlInfo() {
        if (this.processedEventType == DocumentReader.EventType.END_MAP || this.processedEventType == DocumentReader.EventType.END_ARRAY) {
            throw new UnsupportedOperationException("Can not return timeDescriptor for eventType END_MAP or END_ARRAY");
        }
        return new ControlInfoImpl(this.context.getTimeDescriptor());
    }
}

