/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.ojai;

import com.mapr.db.DBDocument;
import com.mapr.db.MapRDB;
import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.db.rowcol.DBList;
import com.mapr.db.rowcol.InsertContext;
import com.mapr.db.rowcol.KeyValue;
import com.mapr.db.rowcol.KeyValueBuilder;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;
import java.util.Stack;
import org.ojai.Document;
import org.ojai.DocumentBuilder;
import org.ojai.Value;
import org.ojai.types.Interval;
import org.ojai.util.Decimals;

public class DBDocumentBuilder
implements DocumentBuilder {
    private DBDocumentImpl dbRecord = new DBDocumentImpl();
    private DBList curList;
    private boolean isClosed;
    Stack<WriterStage> allRecords;
    private WriterContext currentContext;

    public DBDocumentBuilder() {
        InsertContext ctx = new InsertContext();
        this.dbRecord.setRootFlags(ctx);
        this.curList = null;
        this.allRecords = new Stack();
        this.isClosed = false;
        this.currentContext = WriterContext.NONE;
    }

    public boolean inMap() {
        return this.currentContext == WriterContext.MAPCONTEXT;
    }

    public DBDocumentBuilder put(String field, String value) {
        this.checkContext(WriterContext.MAPCONTEXT);
        this.dbRecord.insertKeyValue(field, KeyValueBuilder.initFrom(value), this.allRecords.size() == 1);
        return this;
    }

    public DBDocumentBuilder put(String field, int value) {
        this.checkContext(WriterContext.MAPCONTEXT);
        this.dbRecord.insertKeyValue(field, KeyValueBuilder.initFrom(value), this.allRecords.size() == 1);
        return this;
    }

    public DBDocumentBuilder put(String field, Date value) {
        this.checkContext(WriterContext.MAPCONTEXT);
        this.dbRecord.insertKeyValue(field, KeyValueBuilder.initFrom(value), this.allRecords.size() == 1);
        return this;
    }

    public DBDocumentBuilder put(String field, boolean value) {
        this.checkContext(WriterContext.MAPCONTEXT);
        this.dbRecord.insertKeyValue(field, KeyValueBuilder.initFrom(value), this.allRecords.size() == 1);
        return this;
    }

    public DBDocumentBuilder put(String field, byte value) {
        this.checkContext(WriterContext.MAPCONTEXT);
        this.dbRecord.insertKeyValue(field, KeyValueBuilder.initFrom(value), this.allRecords.size() == 1);
        return this;
    }

    public DBDocumentBuilder put(String field, short value) {
        this.checkContext(WriterContext.MAPCONTEXT);
        this.dbRecord.insertKeyValue(field, KeyValueBuilder.initFrom(value), this.allRecords.size() == 1);
        return this;
    }

    public DBDocumentBuilder put(String field, long value) {
        this.checkContext(WriterContext.MAPCONTEXT);
        this.dbRecord.insertKeyValue(field, KeyValueBuilder.initFrom(value), this.allRecords.size() == 1);
        return this;
    }

    public DBDocumentBuilder put(String field, float value) {
        this.checkContext(WriterContext.MAPCONTEXT);
        this.dbRecord.insertKeyValue(field, KeyValueBuilder.initFrom(value), this.allRecords.size() == 1);
        return this;
    }

    public DBDocumentBuilder put(String field, double value) {
        this.checkContext(WriterContext.MAPCONTEXT);
        this.dbRecord.insertKeyValue(field, KeyValueBuilder.initFrom(value), this.allRecords.size() == 1);
        return this;
    }

    public DBDocumentBuilder put(String field, BigDecimal value) {
        this.checkContext(WriterContext.MAPCONTEXT);
        this.dbRecord.insertKeyValue(field, KeyValueBuilder.initFrom(value), this.allRecords.size() == 1);
        return this;
    }

    public DBDocumentBuilder put(String field, byte[] value) {
        this.checkContext(WriterContext.MAPCONTEXT);
        this.dbRecord.insertKeyValue(field, KeyValueBuilder.initFromArray((Object)value), this.allRecords.size() == 1);
        return this;
    }

    public DBDocumentBuilder put(String field, byte[] value, int off, int len) {
        this.checkContext(WriterContext.MAPCONTEXT);
        this.dbRecord.insertKeyValue(field, KeyValueBuilder.initFrom(ByteBuffer.wrap(value, off, len)), this.allRecords.size() == 1);
        return this;
    }

    public DBDocumentBuilder put(String field, ByteBuffer value) {
        this.checkContext(WriterContext.MAPCONTEXT);
        this.dbRecord.insertKeyValue(field, KeyValueBuilder.initFrom(value), this.allRecords.size() == 1);
        return this;
    }

    public DBDocumentBuilder put(String field, Interval value) {
        this.checkContext(WriterContext.MAPCONTEXT);
        this.dbRecord.insertKeyValue(field, KeyValueBuilder.initFrom(value), this.allRecords.size() == 1);
        return this;
    }

    public DBDocumentBuilder putNewMap(String field) {
        this.checkContext(WriterContext.MAPCONTEXT);
        DBDocumentImpl newRecord = (DBDocumentImpl)MapRDB.newDocument();
        this.dbRecord.insertKeyValue(field, newRecord, this.allRecords.size() == 1);
        this.dbRecord = newRecord;
        this.currentContext = WriterContext.MAPCONTEXT;
        this.allRecords.push(new WriterStage(this.currentContext, null, newRecord));
        return this;
    }

    public DBDocumentBuilder putNewArray(String field) {
        this.checkContext(WriterContext.MAPCONTEXT);
        this.curList = new DBList(InsertContext.OpType.NONE);
        this.currentContext = WriterContext.ARRAYCONTEXT;
        this.allRecords.push(new WriterStage(this.currentContext, field, this.curList));
        return this;
    }

    public DBDocumentBuilder putNull(String field) {
        this.checkContext(WriterContext.MAPCONTEXT);
        this.dbRecord.insertKeyValue(field, new KeyValue(Value.Type.NULL), this.allRecords.size() == 1);
        return this;
    }

    public DBDocumentBuilder put(String field, Value value) {
        this.checkContext(WriterContext.MAPCONTEXT);
        this.dbRecord.insertKeyValue(field, KeyValueBuilder.initFrom(value), this.allRecords.size() == 1);
        return this;
    }

    public DBDocumentBuilder put(String field, Document value) {
        this.checkContext(WriterContext.MAPCONTEXT);
        this.dbRecord.insertKeyValue(field, KeyValueBuilder.initFrom(value), this.allRecords.size() == 1);
        return this;
    }

    public DBDocumentBuilder putDecimal(String field, int unscaledValue, int scale) {
        this.checkContext(WriterContext.MAPCONTEXT);
        return this.put(field, Decimals.convertIntToDecimal((int)unscaledValue, (int)scale));
    }

    public DBDocumentBuilder putDecimal(String field, long unscaledValue, int scale) {
        this.checkContext(WriterContext.MAPCONTEXT);
        return this.put(field, Decimals.convertLongToDecimal((long)unscaledValue, (int)scale));
    }

    public DBDocumentBuilder putDecimal(String field, long decimalValue) {
        this.checkContext(WriterContext.MAPCONTEXT);
        return this.put(field, new BigDecimal(decimalValue));
    }

    public DBDocumentBuilder putDecimal(String field, double decimalValue) {
        this.checkContext(WriterContext.MAPCONTEXT);
        return this.put(field, new BigDecimal(decimalValue));
    }

    public DBDocumentBuilder addDecimal(long decimalValue) {
        return this.add(new BigDecimal(decimalValue));
    }

    public DBDocumentBuilder addDecimal(double decimalValue) {
        return this.add(new BigDecimal(decimalValue));
    }

    public DBDocumentBuilder putDecimal(String field, byte[] unscaledValue, int scale) {
        return this.put(field, Decimals.convertByteToBigDecimal((byte[])unscaledValue, (int)scale));
    }

    public DBDocumentBuilder put(String field, Time value) {
        this.checkContext(WriterContext.MAPCONTEXT);
        this.dbRecord.insertKeyValue(field, KeyValueBuilder.initFrom(value), this.allRecords.size() == 1);
        return this;
    }

    public DBDocumentBuilder put(String field, Timestamp value) {
        this.checkContext(WriterContext.MAPCONTEXT);
        this.dbRecord.insertKeyValue(field, KeyValueBuilder.initFrom(value), this.allRecords.size() == 1);
        return this;
    }

    public DBDocumentBuilder putDate(String field, int days) {
        this.checkContext(WriterContext.MAPCONTEXT);
        this.dbRecord.insertKeyValue(field, KeyValueBuilder.initFrom(new Date((long)days * 86400000L)), this.allRecords.size() == 1);
        return this;
    }

    public DBDocumentBuilder putTime(String field, int millis) {
        if ((long)millis > 86400000L) {
            throw new IllegalArgumentException("Long value exceeds " + Long.toString(86400000L) + " " + Long.toString(millis));
        }
        return this.put(field, new Time(millis));
    }

    public DBDocumentBuilder putTimestamp(String field, long timeMillis) {
        return this.put(field, new Timestamp(timeMillis));
    }

    public DBDocumentBuilder putInterval(String field, long durationInMs) {
        this.checkContext(WriterContext.MAPCONTEXT);
        this.dbRecord.insertKeyValue(field, KeyValueBuilder.initFrom(new Interval(durationInMs)), this.allRecords.size() == 1);
        return this;
    }

    public DBDocumentBuilder putInterval(String field, int months, int days, int milliseconds) {
        this.checkContext(WriterContext.MAPCONTEXT);
        long total_milliseconds = (long)milliseconds + ((long)days + (long)months * 30L) * 86400000L;
        this.dbRecord.insertKeyValue(field, KeyValueBuilder.initFrom(new Interval(total_milliseconds)), this.allRecords.size() == 1);
        return this;
    }

    private void checkContext(WriterContext context) {
        if (this.isClosed) {
            throw new IllegalStateException("Writer is closed for put and add");
        }
        if (this.currentContext != context) {
            throw new IllegalStateException("Mismatch in writeContext");
        }
    }

    private void addElementToList(KeyValue child) {
        child.setOpTypeAndFlags(null, false);
        this.curList.addToDBListWithFlags(child);
    }

    public DBDocumentBuilder add(boolean value) {
        this.checkContext(WriterContext.ARRAYCONTEXT);
        this.addElementToList(KeyValueBuilder.initFrom(value));
        return this;
    }

    public DBDocumentBuilder add(String value) {
        this.checkContext(WriterContext.ARRAYCONTEXT);
        this.addElementToList(KeyValueBuilder.initFrom(value));
        return this;
    }

    public DBDocumentBuilder add(byte value) {
        this.checkContext(WriterContext.ARRAYCONTEXT);
        this.addElementToList(KeyValueBuilder.initFrom(value));
        return this;
    }

    public DBDocumentBuilder add(short value) {
        this.checkContext(WriterContext.ARRAYCONTEXT);
        this.addElementToList(KeyValueBuilder.initFrom(value));
        return this;
    }

    public DBDocumentBuilder add(int value) {
        this.checkContext(WriterContext.ARRAYCONTEXT);
        this.addElementToList(KeyValueBuilder.initFrom(value));
        return this;
    }

    public DBDocumentBuilder add(long value) {
        this.checkContext(WriterContext.ARRAYCONTEXT);
        this.addElementToList(KeyValueBuilder.initFrom(value));
        return this;
    }

    public DBDocumentBuilder add(float value) {
        this.checkContext(WriterContext.ARRAYCONTEXT);
        this.addElementToList(KeyValueBuilder.initFrom(value));
        return this;
    }

    public DBDocumentBuilder add(double value) {
        this.checkContext(WriterContext.ARRAYCONTEXT);
        this.addElementToList(KeyValueBuilder.initFrom(value));
        return this;
    }

    public DBDocumentBuilder add(BigDecimal value) {
        this.checkContext(WriterContext.ARRAYCONTEXT);
        this.addElementToList(KeyValueBuilder.initFrom(value));
        return this;
    }

    public DBDocumentBuilder add(Time value) {
        this.checkContext(WriterContext.ARRAYCONTEXT);
        this.addElementToList(KeyValueBuilder.initFrom(value));
        return this;
    }

    public DBDocumentBuilder add(Date value) {
        this.checkContext(WriterContext.ARRAYCONTEXT);
        this.addElementToList(KeyValueBuilder.initFrom(value));
        return this;
    }

    public DBDocumentBuilder add(Timestamp value) {
        this.checkContext(WriterContext.ARRAYCONTEXT);
        this.addElementToList(KeyValueBuilder.initFrom(value));
        return this;
    }

    public DBDocumentBuilder add(Interval value) {
        this.checkContext(WriterContext.ARRAYCONTEXT);
        this.addElementToList(KeyValueBuilder.initFrom(value));
        return this;
    }

    public DBDocumentBuilder add(byte[] value) {
        this.checkContext(WriterContext.ARRAYCONTEXT);
        this.addElementToList(KeyValueBuilder.initFrom(ByteBuffer.wrap(value)));
        return this;
    }

    public DBDocumentBuilder add(byte[] value, int off, int len) {
        this.checkContext(WriterContext.ARRAYCONTEXT);
        this.addElementToList(KeyValueBuilder.initFrom(ByteBuffer.wrap(value, off, len)));
        return this;
    }

    public DBDocumentBuilder add(ByteBuffer value) {
        this.checkContext(WriterContext.ARRAYCONTEXT);
        this.addElementToList(KeyValueBuilder.initFrom(value));
        return this;
    }

    public DBDocumentBuilder addNull() {
        this.checkContext(WriterContext.ARRAYCONTEXT);
        this.addElementToList(KeyValueBuilder.initFromNull());
        return this;
    }

    public DBDocumentBuilder add(Value value) {
        this.checkContext(WriterContext.ARRAYCONTEXT);
        this.addElementToList(KeyValueBuilder.initFrom(value));
        return this;
    }

    public DBDocumentBuilder add(Document value) {
        this.checkContext(WriterContext.ARRAYCONTEXT);
        this.addElementToList(KeyValueBuilder.initFrom(value));
        return this;
    }

    public DBDocumentBuilder addNewArray() {
        this.checkContext(WriterContext.ARRAYCONTEXT);
        this.curList = new DBList(InsertContext.OpType.NONE);
        this.allRecords.push(new WriterStage(WriterContext.ARRAYCONTEXT, null, this.curList));
        return this;
    }

    public DBDocumentBuilder addNewMap() {
        if (this.currentContext == WriterContext.MAPCONTEXT) {
            throw new IllegalStateException("Context mismatch : addNewMap() can not be called at " + this.currentContext.name());
        }
        if (this.currentContext != WriterContext.NONE) {
            this.dbRecord = new DBDocumentImpl();
            InsertContext ctx = new InsertContext();
            this.dbRecord.setRootFlags(ctx);
        }
        this.currentContext = WriterContext.MAPCONTEXT;
        this.allRecords.push(new WriterStage(this.currentContext, null, this.dbRecord));
        return this;
    }

    public DBDocumentBuilder addDecimal(int unscaledValue, int scale) {
        return this.add(Decimals.convertIntToDecimal((int)unscaledValue, (int)scale));
    }

    public DBDocumentBuilder addDecimal(long unscaledValue, int scale) {
        return this.add(Decimals.convertLongToDecimal((long)unscaledValue, (int)scale));
    }

    public DBDocumentBuilder addDecimal(byte[] unscaledValue, int scale) {
        return this.add(Decimals.convertByteToBigDecimal((byte[])unscaledValue, (int)scale));
    }

    public DBDocumentBuilder addDate(int days) {
        return this.add(new Date((long)days * 86400000L));
    }

    public DBDocumentBuilder addTime(int millis) {
        if ((long)millis > 86400000L) {
            throw new IllegalArgumentException("Long value exceeds " + Long.toString(86400000L) + " " + Long.toString(millis));
        }
        return this.add(new Time(millis));
    }

    public DBDocumentBuilder addTimestamp(long timeMillis) {
        return this.add(new Timestamp(timeMillis));
    }

    public DBDocumentBuilder addInterval(long durationInMs) {
        return this.add(new Interval(durationInMs));
    }

    public DBDocumentBuilder endArray() {
        this.checkContext(WriterContext.ARRAYCONTEXT);
        if (this.curList == null) {
            throw new IllegalStateException("The array was not started");
        }
        WriterStage nextStage = this.allRecords.pop();
        WriterStage stage = this.allRecords.peek();
        this.currentContext = stage.context;
        if (stage.context == WriterContext.ARRAYCONTEXT) {
            DBList l = this.curList;
            this.curList = (DBList)stage.getKeyValue();
            this.curList.addToDBListWithFlags(l);
        } else {
            this.dbRecord = (DBDocumentImpl)stage.getKeyValue();
            this.dbRecord.insertKeyValue(nextStage.getFieldName(), this.curList, this.allRecords.size() == 1);
        }
        return this;
    }

    public DBDocumentBuilder endMap() {
        if (this.isClosed) {
            throw new IllegalStateException("The record has already been built.");
        }
        this.checkContext(WriterContext.MAPCONTEXT);
        this.allRecords.pop();
        if (!this.allRecords.empty()) {
            WriterStage lastStage = this.allRecords.peek();
            this.currentContext = lastStage.context;
            if (this.currentContext == WriterContext.MAPCONTEXT) {
                this.dbRecord = (DBDocumentImpl)lastStage.getKeyValue();
            } else {
                this.curList = (DBList)lastStage.getKeyValue();
                this.curList.addToDBListWithFlags(this.dbRecord);
            }
        } else {
            this.isClosed = true;
        }
        return this;
    }

    public DBDocument getDocument() {
        if (!this.isClosed) {
            throw new IllegalStateException("Record is not written completely");
        }
        return this.dbRecord;
    }

    public DBDocumentBuilder put(String field, Map<String, Object> value) {
        return this.put(field, KeyValueBuilder.initFrom(value));
    }

    private class WriterStage {
        WriterContext context;
        String fieldName;
        Object kv;

        WriterStage(WriterContext c, String field, Object v) {
            this.context = c;
            this.fieldName = field;
            this.kv = v;
        }

        Object getKeyValue() {
            return this.kv;
        }

        String getFieldName() {
            return this.fieldName;
        }
    }

    private static enum WriterContext {
        MAPCONTEXT,
        ARRAYCONTEXT,
        NONE;

    }
}

