/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.impl;

import com.google.common.collect.BiMap;
import com.google.common.collect.EnumBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.mapr.db.Condition;
import com.mapr.db.impl.ConditionDescriptor;
import com.mapr.fs.jni.MapRConstants;
import com.mapr.fs.proto.Dbfilters;
import com.mapr.org.apache.hadoop.hbase.util.Bytes;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ojai.FieldPath;
import org.ojai.annotation.API;

@API.Internal
public abstract class ConditionNode
implements Cloneable {
    static final String HASH_OF_CONDITION_FILTER = "8cbdcd12";
    static final String HASH_OF_ROW_FILTER = "469dbd04";
    static final String HASH_OF_FILTER_LIST = "a42ebf64";
    static final String HASH_OF_BINARY_COMPARATOR = "05f39865";
    static final String HASH_OF_JSON_COMPARATOR = "45a94888";
    static final String HASH_OF_REGEX_COMPARATOR = "e2d7ba40";
    static final String DUMMY_FIELD_X = "X";
    static final Set<Integer> EMPTY_FIELD_IDS = ImmutableSet.of();
    static final Set<FieldPath> EMPTY_FIELD_PATHS = ImmutableSet.of();
    static final char DOLLAR_CHAR = '$';
    static final char COLON_CHAR = ':';
    static final char QUOTE_CHAR = '\"';
    static final char COMMA_CHAR = ',';
    static final char SPACE_CHAR = ' ';
    static final char NEWLINE_CHAR = '\n';
    static final char OPEN_BRACKET = '[';
    static final char CLOSE_BRACKET = ']';
    static final char OPEN_PARAN = '(';
    static final char CLOSE_PARAN = ')';
    static final char OPEN_MAP = '{';
    static final char CLOSE_MAP = '}';
    static final BiMap<Condition.Op, Dbfilters.ConditionOpProto> opProtoMap = EnumBiMap.create(Condition.Op.class, Dbfilters.ConditionOpProto.class);
    static final Map<Dbfilters.ConditionOpProto, String> opSymbolMap;
    static final Map<Dbfilters.ConditionOpProto, String> opJsonOpMap;
    static final List<RowkeyRange> FULL_TABLE_RANGE;

    boolean isLeaf() {
        return true;
    }

    StringBuilder treeBuilder(StringBuilder sb) {
        return this.treeBuilder(ConditionNode.indent(sb, 2), 2);
    }

    abstract ConditionDescriptor getDescriptor(BiMap<FieldPath, Integer> var1);

    abstract StringBuilder expressionBuilder(StringBuilder var1);

    abstract StringBuilder treeBuilder(StringBuilder var1, int var2);

    abstract StringBuilder jsonBuilder(StringBuilder var1);

    abstract List<RowkeyRange> getRowkeyRanges();

    abstract void addProjections(Set<FieldPath> var1);

    protected ConditionNode clone() {
        try {
            return (ConditionNode)super.clone();
        }
        catch (CloneNotSupportedException e) {
            assert (false) : "Clone failed!!!";
            return null;
        }
    }

    abstract boolean checkAndPrune();

    boolean isEmpty() {
        return false;
    }

    static StringBuilder indent(StringBuilder sb, int indent) {
        for (int i = 0; i < indent; ++i) {
            sb.append(' ');
        }
        return sb;
    }

    static {
        opProtoMap.put((Object)Condition.Op.LESS, (Object)Dbfilters.ConditionOpProto.CND_LT);
        opProtoMap.put((Object)Condition.Op.LESS_OR_EQUAL, (Object)Dbfilters.ConditionOpProto.CND_LE);
        opProtoMap.put((Object)Condition.Op.EQUAL, (Object)Dbfilters.ConditionOpProto.CND_EQ);
        opProtoMap.put((Object)Condition.Op.NOT_EQUAL, (Object)Dbfilters.ConditionOpProto.CND_NE);
        opProtoMap.put((Object)Condition.Op.GREATER_OR_EQUAL, (Object)Dbfilters.ConditionOpProto.CND_GE);
        opProtoMap.put((Object)Condition.Op.GREATER, (Object)Dbfilters.ConditionOpProto.CND_GT);
        assert (opProtoMap.size() == Condition.Op.values().length) : "Map is missing some of the Condition.Op elements";
        opSymbolMap = Maps.newEnumMap(Dbfilters.ConditionOpProto.class);
        opSymbolMap.put(Dbfilters.ConditionOpProto.CND_UNKNOWN, "!ERR!");
        opSymbolMap.put(Dbfilters.ConditionOpProto.CND_LT, "<");
        opSymbolMap.put(Dbfilters.ConditionOpProto.CND_LE, "<=");
        opSymbolMap.put(Dbfilters.ConditionOpProto.CND_EQ, "=");
        opSymbolMap.put(Dbfilters.ConditionOpProto.CND_NE, "!=");
        opSymbolMap.put(Dbfilters.ConditionOpProto.CND_GE, ">=");
        opSymbolMap.put(Dbfilters.ConditionOpProto.CND_GT, ">");
        opSymbolMap.put(Dbfilters.ConditionOpProto.CND_IN, "IN");
        opSymbolMap.put(Dbfilters.ConditionOpProto.CND_NOT_IN, "NOT_IN");
        opSymbolMap.put(Dbfilters.ConditionOpProto.CND_LIKE, "LIKE");
        opSymbolMap.put(Dbfilters.ConditionOpProto.CND_NOT_LIKE, "NOT_LIKE");
        opSymbolMap.put(Dbfilters.ConditionOpProto.CND_TYPE_OF, "TYPE_OF");
        opSymbolMap.put(Dbfilters.ConditionOpProto.CND_NOT_TYPE_OF, "NOT_TYPE_OF");
        assert (opSymbolMap.size() == Dbfilters.ConditionOpProto.values().length) : "Map is missing some of the ConditionOpProto elements";
        opJsonOpMap = Maps.newEnumMap(Dbfilters.ConditionOpProto.class);
        opJsonOpMap.put(Dbfilters.ConditionOpProto.CND_UNKNOWN, "!ERR!");
        opJsonOpMap.put(Dbfilters.ConditionOpProto.CND_LT, "$lt");
        opJsonOpMap.put(Dbfilters.ConditionOpProto.CND_LE, "$le");
        opJsonOpMap.put(Dbfilters.ConditionOpProto.CND_EQ, "$eq");
        opJsonOpMap.put(Dbfilters.ConditionOpProto.CND_NE, "$ne");
        opJsonOpMap.put(Dbfilters.ConditionOpProto.CND_GE, "$ge");
        opJsonOpMap.put(Dbfilters.ConditionOpProto.CND_GT, "$gt");
        opJsonOpMap.put(Dbfilters.ConditionOpProto.CND_IN, "$in");
        opJsonOpMap.put(Dbfilters.ConditionOpProto.CND_NOT_IN, "$nin");
        opJsonOpMap.put(Dbfilters.ConditionOpProto.CND_LIKE, "$like");
        opJsonOpMap.put(Dbfilters.ConditionOpProto.CND_NOT_LIKE, "$notlike");
        opJsonOpMap.put(Dbfilters.ConditionOpProto.CND_TYPE_OF, "$typeof");
        opJsonOpMap.put(Dbfilters.ConditionOpProto.CND_NOT_TYPE_OF, "$nottypeof");
        assert (opJsonOpMap.size() == Dbfilters.ConditionOpProto.values().length) : "Map is missing some of the ConditionOpProto elements";
        FULL_TABLE_RANGE = ImmutableList.of((Object)new RowkeyRange(MapRConstants.EMPTY_BYTE_ARRAY, MapRConstants.EMPTY_BYTE_ARRAY));
    }

    public static class RowkeyRange {
        protected final byte[] startRow;
        protected final byte[] stopRow;

        public RowkeyRange(byte[] startRow, byte[] stopRow) {
            this.startRow = startRow;
            this.stopRow = stopRow;
        }

        public byte[] getStartRow() {
            return this.startRow == null ? MapRConstants.EMPTY_BYTE_ARRAY : this.startRow;
        }

        public byte[] getStopRow() {
            return this.stopRow == null ? MapRConstants.EMPTY_BYTE_ARRAY : this.stopRow;
        }

        public String toString() {
            return "RowkeyRange [startRow=" + Bytes.toStringBinary((byte[])this.startRow) + ", stopRow=" + Bytes.toStringBinary((byte[])this.stopRow) + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.startRow);
            result = 31 * result + Arrays.hashCode(this.stopRow);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RowkeyRange other = (RowkeyRange)obj;
            if (!Arrays.equals(this.startRow, other.startRow)) {
                return false;
            }
            return Arrays.equals(this.stopRow, other.stopRow);
        }
    }
}

