/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.impl;

import com.mapr.fs.proto.Dbfilters;
import java.nio.ByteBuffer;
import java.util.Set;
import org.ojai.FieldPath;
import org.ojai.annotation.API;

@API.Internal
public class ConditionDescriptor {
    Dbfilters.FilterMsg filterMsg;
    ByteBuffer serialized;
    Set<Integer> familyIDs;
    Set<FieldPath> fieldPaths;

    ConditionDescriptor(ByteBuffer serializedCondition) {
        this.serialized = serializedCondition;
    }

    ConditionDescriptor(Dbfilters.FilterMsg filterMsg, Set<Integer> familyIDs, Set<FieldPath> fieldPaths) {
        this.filterMsg = filterMsg;
        this.familyIDs = familyIDs;
        this.fieldPaths = fieldPaths;
    }

    public Dbfilters.FilterMsg getFilterMsg() {
        return this.filterMsg;
    }

    public ByteBuffer getSerialized() {
        if (this.serialized == null && this.filterMsg != null) {
            this.serialized = this.filterMsg.toByteString().asReadOnlyByteBuffer();
        }
        return this.serialized;
    }

    public Set<Integer> getFamilyIDs() {
        return this.familyIDs;
    }

    public Set<FieldPath> getFieldPaths() {
        return this.fieldPaths;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.familyIDs == null ? 0 : this.familyIDs.hashCode());
        result = 31 * result + (this.fieldPaths == null ? 0 : this.fieldPaths.hashCode());
        result = 31 * result + (this.serialized == null ? 0 : this.serialized.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConditionDescriptor other = (ConditionDescriptor)obj;
        if (this.familyIDs == null ? other.familyIDs != null : !this.familyIDs.equals(other.familyIDs)) {
            return false;
        }
        if (this.fieldPaths == null ? other.fieldPaths != null : !this.fieldPaths.equals(other.fieldPaths)) {
            return false;
        }
        return !(this.serialized == null ? other.serialized != null : !this.serialized.equals(other.serialized));
    }
}

