/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db;

import com.mapr.db.Condition;
import com.mapr.db.DBDocument;
import com.mapr.db.Mutation;
import com.mapr.db.OpListener;
import com.mapr.db.TableDescriptor;
import com.mapr.db.TabletInfo;
import com.mapr.db.exceptions.DBException;
import com.mapr.db.exceptions.MultiOpException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import org.apache.hadoop.fs.Path;
import org.ojai.Document;
import org.ojai.DocumentStream;
import org.ojai.FieldPath;
import org.ojai.Value;
import org.ojai.annotation.API;

@API.Public
public interface Table
extends AutoCloseable {
    public String getName();

    public Path getPath();

    public TableDescriptor getTableDescriptor();

    public Table setOption(TableOption var1, boolean var2);

    public Value getOption(TableOption var1);

    public void flush() throws DBException;

    public DBDocument findById(String var1) throws DBException;

    public DBDocument findById(ByteBuffer var1) throws DBException;

    public DBDocument findById(Value var1) throws DBException;

    public DBDocument findById(String var1, String ... var2) throws DBException;

    public DBDocument findById(String var1, FieldPath ... var2) throws DBException;

    public DBDocument findById(ByteBuffer var1, String ... var2) throws DBException;

    public DBDocument findById(ByteBuffer var1, FieldPath ... var2) throws DBException;

    public DBDocument findById(String var1, Condition var2) throws DBException;

    public DBDocument findById(ByteBuffer var1, Condition var2) throws DBException;

    public DBDocument findById(String var1, Condition var2, String ... var3) throws DBException;

    public DBDocument findById(String var1, Condition var2, FieldPath ... var3) throws DBException;

    public DBDocument findById(ByteBuffer var1, Condition var2, String ... var3) throws DBException;

    public DBDocument findById(ByteBuffer var1, Condition var2, FieldPath ... var3) throws DBException;

    public void findById(OpListener var1, String var2);

    public void findById(OpListener var1, ByteBuffer var2);

    public void findById(OpListener var1, String var2, String ... var3);

    public void findById(OpListener var1, String var2, FieldPath ... var3);

    public void findById(OpListener var1, ByteBuffer var2, String ... var3);

    public void findById(OpListener var1, ByteBuffer var2, FieldPath ... var3);

    public void findById(OpListener var1, String var2, Condition var3);

    public void findById(OpListener var1, ByteBuffer var2, Condition var3);

    public void findById(OpListener var1, String var2, Condition var3, String ... var4);

    public void findById(OpListener var1, String var2, Condition var3, FieldPath ... var4);

    public void findById(OpListener var1, ByteBuffer var2, Condition var3, String ... var4);

    public void findById(OpListener var1, ByteBuffer var2, Condition var3, FieldPath ... var4);

    public DocumentStream<DBDocument> find() throws DBException;

    public DocumentStream<DBDocument> find(String ... var1) throws DBException;

    public DocumentStream<DBDocument> find(FieldPath ... var1) throws DBException;

    public DocumentStream<DBDocument> find(Condition var1) throws DBException;

    public DocumentStream<DBDocument> find(Condition var1, String ... var2) throws DBException;

    public DocumentStream<DBDocument> find(Condition var1, FieldPath ... var2) throws DBException;

    public void insertOrReplace(Document var1) throws DBException;

    public void insertOrReplace(String var1, Document var2) throws DBException;

    public void insertOrReplace(ByteBuffer var1, Document var2) throws DBException;

    public void insertOrReplace(Document var1, FieldPath var2) throws DBException;

    public void insertOrReplace(Document var1, String var2) throws DBException;

    public void insertOrReplace(DocumentStream<? extends Document> var1) throws MultiOpException;

    public void insertOrReplace(DocumentStream<? extends Document> var1, FieldPath var2) throws MultiOpException;

    public void insertOrReplace(DocumentStream<? extends Document> var1, String var2) throws MultiOpException;

    public void update(String var1, Mutation var2) throws DBException;

    public void update(ByteBuffer var1, Mutation var2) throws DBException;

    public void delete(String var1) throws DBException;

    public void delete(ByteBuffer var1) throws DBException;

    public void delete(Document var1) throws DBException;

    public void delete(Document var1, FieldPath var2) throws DBException;

    public void delete(Document var1, String var2) throws DBException;

    public void delete(DocumentStream<? extends Document> var1) throws MultiOpException;

    public void delete(DocumentStream<? extends Document> var1, FieldPath var2) throws MultiOpException;

    public void delete(DocumentStream<? extends Document> var1, String var2) throws MultiOpException;

    public void insert(String var1, Document var2) throws DBException;

    public void insert(ByteBuffer var1, Document var2) throws DBException;

    public void insert(Document var1) throws DBException;

    public void insert(Document var1, FieldPath var2) throws DBException;

    public void insert(Document var1, String var2) throws DBException;

    public void insert(DocumentStream<? extends Document> var1) throws MultiOpException;

    public void insert(DocumentStream<? extends Document> var1, FieldPath var2) throws MultiOpException;

    public void insert(DocumentStream<? extends Document> var1, String var2) throws MultiOpException;

    public void replace(String var1, Document var2) throws DBException;

    public void replace(ByteBuffer var1, Document var2) throws DBException;

    public void replace(Document var1) throws DBException;

    public void replace(Document var1, FieldPath var2) throws DBException;

    public void replace(Document var1, String var2) throws DBException;

    public void replace(DocumentStream<? extends Document> var1) throws MultiOpException;

    public void replace(DocumentStream<? extends Document> var1, FieldPath var2) throws MultiOpException;

    public void replace(DocumentStream<? extends Document> var1, String var2) throws MultiOpException;

    public void increment(String var1, String var2, byte var3) throws DBException;

    public void increment(ByteBuffer var1, String var2, byte var3) throws DBException;

    public void increment(String var1, String var2, short var3) throws DBException;

    public void increment(ByteBuffer var1, String var2, short var3) throws DBException;

    public void increment(String var1, String var2, int var3) throws DBException;

    public void increment(ByteBuffer var1, String var2, int var3) throws DBException;

    public void increment(String var1, String var2, long var3) throws DBException;

    public void increment(ByteBuffer var1, String var2, long var3) throws DBException;

    public void increment(String var1, String var2, float var3) throws DBException;

    public void increment(ByteBuffer var1, String var2, float var3) throws DBException;

    public void increment(String var1, String var2, double var3) throws DBException;

    public void increment(ByteBuffer var1, String var2, double var3) throws DBException;

    public void increment(String var1, String var2, BigDecimal var3) throws DBException;

    public void increment(ByteBuffer var1, String var2, BigDecimal var3) throws DBException;

    public boolean checkAndMutate(String var1, Condition var2, Mutation var3) throws DBException;

    public boolean checkAndMutate(ByteBuffer var1, Condition var2, Mutation var3) throws DBException;

    public boolean checkAndDelete(String var1, Condition var2) throws DBException;

    public boolean checkAndDelete(ByteBuffer var1, Condition var2) throws DBException;

    public boolean checkAndReplace(String var1, Condition var2, Document var3) throws DBException;

    public boolean checkAndReplace(ByteBuffer var1, Condition var2, Document var3) throws DBException;

    public TabletInfo getTabletInfo(String var1) throws DBException;

    public TabletInfo getTabletInfo(ByteBuffer var1) throws DBException;

    public TabletInfo[] getTabletInfos() throws DBException;

    public TabletInfo[] getTabletInfos(Condition var1) throws DBException;

    @Override
    public void close() throws DBException;

    public static enum TableOption {
        EXCLUDEID,
        BUFFERWRITE,
        KEEPINSERTIONORDER;

    }
}

