/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tests.tableops;

import com.mapr.db.DBDocument;
import com.mapr.db.MapRDB;
import com.mapr.db.Mutation;
import com.mapr.db.Table;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.StressTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={StressTest.class})
public class TestCompaction
extends BaseTest {
    private static final Logger _logger = LoggerFactory.getLogger(TestCompaction.class);
    private static final String TABLE_NAME = "/tmp/testtable-TTLTest";

    @Test
    public void testCompaction() throws Exception {
        try {
            DBTests.admin().deleteTable(TABLE_NAME);
        }
        catch (Exception e) {
            // empty catch block
        }
        Table myTab = DBTests.admin().createTable(MapRDB.newTableDescriptor((String)TABLE_NAME));
        for (int iter = 0; iter < 10; ++iter) {
            for (int i = 0; i < 100; ++i) {
                Mutation m = MapRDB.newMutation();
                m.setOrReplace("field" + iter, "value" + iter);
                myTab.update("key" + i, m);
            }
            Thread.sleep(15000L);
        }
        for (int i = 0; i < 100; ++i) {
            DBDocument d = myTab.findById("key" + i);
            _logger.trace("record is {}", (Object)d);
            for (int iter = 0; iter < 10; ++iter) {
                Assert.assertEquals((Object)("value" + iter), (Object)d.getString("field" + iter));
            }
        }
        DBTests.deleteTables(TABLE_NAME);
    }

    @Test
    public void testCompactionWithMultiCF() throws Exception {
        try {
            DBTests.admin().deleteTable(TABLE_NAME);
        }
        catch (Exception e) {
            // empty catch block
        }
        Table myTab = DBTests.admin().createTable(MapRDB.newTableDescriptor((String)TABLE_NAME).addFamily(MapRDB.newDefaultFamilyDescriptor()).addFamily(MapRDB.newFamilyDescriptor((String)"CF1", (String)"a")).addFamily(MapRDB.newFamilyDescriptor((String)"CF2", (String)"b")).addFamily(MapRDB.newFamilyDescriptor((String)"CF3", (String)"c")).addFamily(MapRDB.newFamilyDescriptor((String)"CF4", (String)"d")).addFamily(MapRDB.newFamilyDescriptor((String)"CF5", (String)"e")).addFamily(MapRDB.newFamilyDescriptor((String)"CF6", (String)"f")));
        for (int iter = 0; iter < 10; ++iter) {
            for (int i = 0; i < 100; ++i) {
                Mutation m = MapRDB.newMutation();
                m.setOrReplace("c.field" + iter, "c.value" + iter);
                m.setOrReplace("e.field" + iter, "e.value" + iter);
                myTab.update("key" + i, m);
            }
            Thread.sleep(15000L);
        }
        for (int i = 0; i < 100; ++i) {
            DBDocument d = myTab.findById("key" + i);
            _logger.trace("record is {}", (Object)d);
            for (int iter = 0; iter < 10; ++iter) {
                Assert.assertEquals((Object)("c.value" + iter), (Object)d.getString("c.field" + iter));
                Assert.assertEquals((Object)("e.value" + iter), (Object)d.getString("e.field" + iter));
            }
        }
        DBTests.deleteTables(TABLE_NAME);
    }

    @Test
    public void testFullCompactionWithSingleCF() throws Exception {
        int i;
        try {
            DBTests.admin().deleteTable(TABLE_NAME);
        }
        catch (Exception e) {
            // empty catch block
        }
        Table myTab = DBTests.admin().createTable(MapRDB.newTableDescriptor((String)TABLE_NAME));
        String value5K = null;
        StringBuilder b = new StringBuilder();
        for (i = 0; i < 5120; ++i) {
            b.append("a");
        }
        value5K = b.toString();
        for (int iter = 0; iter < 7; ++iter) {
            for (int i2 = 0; i2 < 100; ++i2) {
                Mutation m = MapRDB.newMutation();
                m.setOrReplace("c.field" + iter, value5K + iter);
                m.setOrReplace("e.field" + iter, value5K + iter);
                myTab.update("key" + i2, m);
            }
            Thread.sleep(15000L);
        }
        for (i = 0; i < 100; ++i) {
            DBDocument d = myTab.findById("key" + i);
            _logger.trace("record is {}", (Object)d);
            for (int iter = 0; iter < 7; ++iter) {
                Assert.assertEquals((Object)(value5K + iter), (Object)d.getString("c.field" + iter));
                Assert.assertEquals((Object)(value5K + iter), (Object)d.getString("e.field" + iter));
            }
        }
        DBTests.deleteTables(TABLE_NAME);
    }

    @Test
    public void testFullCompactionWithMultiCF() throws Exception {
        int i;
        try {
            DBTests.admin().deleteTable(TABLE_NAME);
        }
        catch (Exception e) {
            // empty catch block
        }
        Table myTab = DBTests.admin().createTable(MapRDB.newTableDescriptor((String)TABLE_NAME).addFamily(MapRDB.newDefaultFamilyDescriptor()).addFamily(MapRDB.newFamilyDescriptor((String)"CF1", (String)"a")).addFamily(MapRDB.newFamilyDescriptor((String)"CF2", (String)"b")).addFamily(MapRDB.newFamilyDescriptor((String)"CF3", (String)"c")).addFamily(MapRDB.newFamilyDescriptor((String)"CF4", (String)"d")).addFamily(MapRDB.newFamilyDescriptor((String)"CF5", (String)"e")).addFamily(MapRDB.newFamilyDescriptor((String)"CF6", (String)"f")));
        String value5K = null;
        StringBuilder b = new StringBuilder();
        for (i = 0; i < 5120; ++i) {
            b.append("a");
        }
        value5K = b.toString();
        for (int iter = 0; iter < 7; ++iter) {
            for (int i2 = 0; i2 < 100; ++i2) {
                Mutation m = MapRDB.newMutation();
                m.setOrReplace("c.field" + iter, value5K + iter);
                m.setOrReplace("e.field" + iter, value5K + iter);
                myTab.update("key" + i2, m);
            }
            Thread.sleep(15000L);
        }
        for (i = 0; i < 100; ++i) {
            DBDocument d = myTab.findById("key" + i);
            _logger.trace("record is {}", (Object)d);
            for (int iter = 0; iter < 7; ++iter) {
                Assert.assertEquals((Object)(value5K + iter), (Object)d.getString("c.field" + iter));
                Assert.assertEquals((Object)(value5K + iter), (Object)d.getString("e.field" + iter));
            }
        }
        DBTests.deleteTables(TABLE_NAME);
    }
}

