/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tests.ojai;

import com.mapr.db.ControlInfo;
import com.mapr.db.ojai.DBDocumentReaderBase;
import com.mapr.db.rowcol.DBDocumentImpl;
import java.io.IOException;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.ojai.DocumentReader;

public class TestDBDOMDocumentReader {
    DBDocumentImpl record = new DBDocumentImpl();

    @Before
    public void setUp() {
        this.record.set("map.num1", (byte)127);
        this.record.set("map.name.first", "John");
        this.record.set("map.name.last", "Doe");
        this.record.set("map.address.street.no", 350);
        this.record.set("map.address.street.name", "Front St");
        this.record.set("map.address.zip", 95134L);
        ArrayList<Object> values = new ArrayList<Object>();
        values.add("Field1");
        values.add(new Short(500));
        values.add(new Double(5555.5555));
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("key1", 100);
        m.put("key2", "xyz");
        values.add(m);
        ArrayList<Constable> l = new ArrayList<Constable>();
        l.add(Double.valueOf(123.4567));
        l.add(Boolean.valueOf(true));
        values.add(l);
        this.record.set("map.list", values);
    }

    @Test
    public void testDOMRecordReader() throws IOException {
        DocumentReader.EventType et;
        boolean isArray = false;
        DocumentReader r = this.record.asReader();
        int numtokens = 0;
        String fieldName = null;
        while ((et = r.next()) != null) {
            if (et == DocumentReader.EventType.FIELD_NAME) {
                fieldName = r.getFieldName();
            }
            if (isArray && et == DocumentReader.EventType.SHORT) {
                Assert.assertEquals((Object)"list", (Object)fieldName);
                Assert.assertEquals((long)500L, (long)r.getShort());
            }
            if (et == DocumentReader.EventType.BYTE) {
                Assert.assertEquals((Object)"num1", (Object)fieldName);
                Assert.assertEquals((long)127L, (long)r.getByte());
            }
            if (et == DocumentReader.EventType.INT && !isArray) {
                Assert.assertEquals((Object)"no", (Object)fieldName);
                Assert.assertEquals((long)350L, (long)r.getInt());
            }
            if (et == DocumentReader.EventType.LONG && !isArray) {
                Assert.assertEquals((Object)"zip", (Object)fieldName);
                Assert.assertEquals((long)95134L, (long)r.getLong());
            }
            if (et == DocumentReader.EventType.START_ARRAY) {
                isArray = true;
            }
            if (et == DocumentReader.EventType.END_ARRAY) {
                isArray = false;
            }
            ++numtokens;
        }
    }

    @Test
    public void testDOMReader() {
        DocumentReader.EventType et;
        DocumentReader reader = this.record.asReader("map.list");
        while ((et = reader.next()) != null) {
            if (et != DocumentReader.EventType.BOOLEAN) continue;
            Assert.assertEquals((Object)true, (Object)reader.getBoolean());
        }
    }

    @Test
    public void testScalarTypeReader() {
        DocumentReader.EventType et;
        DocumentReader reader = this.record.asReader("map.num1");
        while ((et = reader.next()) != null) {
            Assert.assertEquals((Object)DocumentReader.EventType.BYTE, (Object)et);
            Assert.assertEquals((long)127L, (long)reader.getByte());
        }
    }

    public void iterateOverBaseReader(DBDocumentReaderBase reader) {
        DocumentReader.EventType et = null;
        String fieldName = null;
        while ((et = reader.next()) != null) {
            if (et == DocumentReader.EventType.FIELD_NAME) {
                fieldName = reader.getFieldName();
            } else if (et == DocumentReader.EventType.LONG) {
                Assert.assertEquals((Object)fieldName, (Object)"zip");
                Assert.assertEquals((long)95134L, (long)reader.getLong());
            } else if (et == DocumentReader.EventType.INT && fieldName.equals("key1")) {
                Assert.assertEquals((long)100L, (long)reader.getInt());
            }
            if (et == DocumentReader.EventType.END_MAP || et == DocumentReader.EventType.END_ARRAY) continue;
            ControlInfo ctlInfo = reader.getControlInfo();
        }
    }

    @Test
    public void testDOMReaderWithBaseInterface() {
        DBDocumentReaderBase reader = (DBDocumentReaderBase)this.record.asReader();
        this.iterateOverBaseReader(reader);
    }
}

