/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.shell.commands;

import com.mapr.db.shell.commands.ShellCommands;
import java.io.IOException;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;

@Component
public class SessionCommnds
extends ShellCommands {
    protected SessionCommnds() throws IOException {
    }

    @CliAvailabilityIndicator(value={"debug"})
    public boolean available() {
        return true;
    }

    @CliAvailabilityIndicator(value={"mode"})
    public boolean modeAvailable() {
        return false;
    }

    @CliCommand(value={"debug"}, help="Sets the debug mode.")
    public String debug(@CliOption(key={""}, help="Set the debug mode to on/off") String mode) throws IOException {
        if (mode != null) {
            this.session_.setDebug("on".equalsIgnoreCase(mode));
        }
        return "Debug mode is " + (this.session_.isDebug() ? "on." : "off.");
    }

    @CliCommand(value={"mode"}, help="Sets the mode.")
    public String mode(@CliOption(key={""}, help="Set/show the active mode (global|files|tables|stream) of the session.") String mode) throws IOException {
        if (mode != null) {
            this.session_.setMode(mode);
        }
        return "Session mode is set to " + (Object)((Object)this.session_.getMode()) + ".";
    }

    @CliCommand(value={"jsonoptions"}, help="Sets the Json output options.")
    public String jsonoption(@CliOption(key={"pretty"}, help="Sets/clears the pretty printing mode.", specifiedDefaultValue="true") Boolean pretty, @CliOption(key={"withtags", "withTags"}, help="Enables/disables printing with extended tags.", specifiedDefaultValue="true") Boolean withTags) throws IOException {
        if (pretty != null) {
            this.session_.getJsonOptions().setPretty(pretty.booleanValue());
        }
        if (withTags != null) {
            this.session_.getJsonOptions().setWithTags(withTags.booleanValue());
        }
        return String.valueOf(this.session_.getJsonOptions());
    }
}

