/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.mapreduce;

import com.mapr.db.rowcol.MutationImpl;
import com.mapr.db.rowcol.RowcolCodec;
import com.mapr.db.util.ByteBufs;
import com.mapr.org.apache.hadoop.hbase.util.Bytes;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.Serialization;
import org.apache.hadoop.io.serializer.Serializer;
import org.ojai.store.DocumentMutation;

public class MutationSerialization
extends Configured
implements Serialization<DocumentMutation> {
    public boolean accept(Class<?> arg0) {
        return MutationImpl.class.isAssignableFrom(arg0);
    }

    public Deserializer<DocumentMutation> getDeserializer(Class<DocumentMutation> arg0) {
        return new RecordMutationDeserializer();
    }

    public Serializer<DocumentMutation> getSerializer(Class<DocumentMutation> arg0) {
        return new RecordMutationSerializer();
    }

    private static class RecordMutationSerializer
    implements Serializer<DocumentMutation> {
        OutputStream out;

        private RecordMutationSerializer() {
        }

        public void close() throws IOException {
            this.out.close();
        }

        public void open(OutputStream out) throws IOException {
            this.out = out;
        }

        public void serialize(DocumentMutation m) throws IOException {
            int remaining;
            MutationImpl rmi = (MutationImpl)m;
            ByteBuffer outBuffer = rmi.rowcolSerialize();
            this.out.write(Bytes.toBytes((int)outBuffer.remaining()));
            this.out.write(rmi.needsReadOnServer() ? 1 : 0);
            int maxRead = 128;
            byte[] buffer = new byte[128];
            while ((remaining = Math.min(outBuffer.remaining(), 128)) > 0) {
                outBuffer.get(buffer, 0, remaining);
                this.out.write(buffer, 0, remaining);
            }
        }
    }

    private static class RecordMutationDeserializer
    implements Deserializer<DocumentMutation> {
        DataInputStream dataInputStream;

        private RecordMutationDeserializer() {
        }

        public void close() throws IOException {
            this.dataInputStream.close();
        }

        public DocumentMutation deserialize(DocumentMutation arg0) throws IOException {
            int lenSize = 4;
            byte[] recSize = new byte[4];
            this.dataInputStream.read(recSize, 0, 4);
            int recordSize = Bytes.toInt((byte[])recSize);
            if (recordSize < 0) {
                throw new IllegalArgumentException("Invalid record size " + recordSize);
            }
            boolean flagValue = this.dataInputStream.readByte() == 1;
            byte[] serializedRec = new byte[recordSize];
            this.dataInputStream.read(serializedRec, 0, recordSize);
            ByteBuffer buffer = ByteBufs.wrap((byte[])serializedRec);
            return RowcolCodec.decodeMutation((ByteBuffer)buffer, (boolean)flagValue);
        }

        public void open(InputStream in) throws IOException {
            this.dataInputStream = new DataInputStream(in);
        }
    }
}

