/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.mapreduce.test;

import com.mapr.db.Admin;
import com.mapr.db.MapRDB;
import com.mapr.db.Table;
import com.mapr.db.TableDescriptor;
import com.mapr.db.mapreduce.BulkLoadRecordWriter;
import com.mapr.db.rowcol.KeyValueBuilder;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.ClusterTest;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.ojai.Value;
import org.ojai.store.DocumentMutation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ClusterTest.class})
public class TestBulkLoadRecordWriter
extends BaseTest {
    private static final String TEST_BULKLOAD_JSON_TABLE = "/tmp/test_bulkload_json";
    private static final Logger _logger = LoggerFactory.getLogger(TestBulkLoadRecordWriter.class);
    private static final String TABLE_NAME = "testtable-TestBulkLoadRecordWriter";
    private static Table table;
    private static Admin admin;
    private static final Path tablePath;
    private static final int THR_SLEEP_INT = 5000;

    @Before
    public void setupTestBulkLoadRecordWriter() throws Exception {
        try {
            table = DBTests.createOrReplaceTable((String)TABLE_NAME);
            table.setOption(Table.TableOption.BUFFERWRITE, false);
            table.setOption(Table.TableOption.EXCLUDEID, true);
            admin = MapRDB.newAdmin();
        }
        catch (Exception e) {
            _logger.info("Failed to create a new table '{}'.", (Object)tablePath);
            throw e;
        }
    }

    @After
    public void cleanupTestBulkLoadRecordWriter() throws Exception {
        if (table != null) {
            table.close();
            DBTests.admin().deleteTable(tablePath);
        }
    }

    private void createBulkLoadTable(boolean fullBulkLoad) throws IOException, Exception {
        TableDescriptor desc = MapRDB.newTableDescriptor((String)TEST_BULKLOAD_JSON_TABLE).setBulkLoad(fullBulkLoad);
        desc.addFamily(MapRDB.newDefaultFamilyDescriptor());
        desc.addFamily(MapRDB.newFamilyDescriptor((String)"cf1", (String)"defaultchild4.family1"));
        desc.addFamily(MapRDB.newFamilyDescriptor((String)"cf2", (String)"defaultchild4.family2"));
        desc.addFamily(MapRDB.newFamilyDescriptor((String)"cf3", (String)"Family1"));
        desc.addFamily(MapRDB.newFamilyDescriptor((String)"cf4", (String)"Family1.child4.family1"));
        desc.addFamily(MapRDB.newFamilyDescriptor((String)"cf5", (String)"Family1.child4.family2"));
        admin.deleteTable(TEST_BULKLOAD_JSON_TABLE);
        _logger.info("Creating table /tmp/test_bulkload_json with bulkload = " + fullBulkLoad);
        admin.createTable(desc);
    }

    private void deleteBulkLoadTable() {
        admin.deleteTable(TEST_BULKLOAD_JSON_TABLE);
    }

    private void clearBulkLoadTableFlag() throws IOException, Exception {
        TableDescriptor desc = admin.getTableDescriptor(TEST_BULKLOAD_JSON_TABLE);
        desc.setBulkLoad(false);
        admin.alterTable(desc);
    }

    @Test
    public void testBulkLoadRecordDeleteIncremental() throws IOException, Exception {
        this.createBulkLoadTable(false);
        this.testBulkLoadRecordDeleteCommon();
        this.deleteBulkLoadTable();
    }

    @Test
    public void testBulkLoadRecordDeleteFull() throws IOException, Exception {
        this.createBulkLoadTable(true);
        this.testBulkLoadRecordDeleteCommon();
        this.deleteBulkLoadTable();
    }

    private void testBulkLoadRecordDeleteCommon() throws IOException, Exception {
        assert (table != null);
        Path tabPath = new Path(TEST_BULKLOAD_JSON_TABLE);
        try {
            table = MapRDB.getTable((Path)tabPath);
            table.setOption(Table.TableOption.BUFFERWRITE, false);
            table.setOption(Table.TableOption.EXCLUDEID, true);
        }
        catch (Exception e) {
            _logger.info("Failed to get table. Create table '{}'.", (Object)tabPath);
            throw e;
        }
        Configuration conf = new Configuration();
        BulkLoadRecordWriter bulkLoadWriter = new BulkLoadRecordWriter(conf, tabPath);
        String rowStr = new String("r1");
        Document rec = MapRDB.newDocument();
        rec.set("defaultchild1", 10).set("defaultchild2", true).set("defaultchild3", "Value").set("defaultchild4.child1", "child1").set("defaultchild4.child2", "child2").set("defaultchild4.family1", "family1").set("defaultchild4.family2", 25000).set("Family1.child1", 10).set("Family1.child2", true).set("Family1.child3", "Value").set("Family1.child4.child1", "child1").set("Family1.child4.child2", "child2").set("Family1.child4.family2.child2", 50000);
        bulkLoadWriter.write((Value)KeyValueBuilder.initFrom((String)rowStr), rec);
        bulkLoadWriter.close(null);
        this.clearBulkLoadTableFlag();
        Document readRec = table.findById(rowStr);
        Assert.assertNotNull((Object)readRec);
        Assert.assertEquals((long)10L, (long)readRec.getInt("defaultchild1"));
        Assert.assertEquals((Object)true, (Object)readRec.getBoolean("defaultchild2"));
        Assert.assertEquals((Object)"Value", (Object)readRec.getString("defaultchild3"));
        Assert.assertEquals((Object)"child1", (Object)readRec.getString("defaultchild4.child1"));
        Assert.assertEquals((Object)"child2", (Object)readRec.getString("defaultchild4.child2"));
        Assert.assertEquals((Object)"family1", (Object)readRec.getString("defaultchild4.family1"));
        Assert.assertEquals((long)25000L, (long)readRec.getInt("defaultchild4.family2"));
        Assert.assertNull((Object)readRec.getValue("defaultchild4.family2.child1"));
        Assert.assertNull((Object)readRec.getValue("defaultchild4.family2.child2"));
        Assert.assertNull((Object)readRec.getValue("Family1.child4.family2.child1"));
    }

    @Test
    public void testFullBulkLoadRecordWriter() throws IOException, Exception {
        int i;
        String tabName = "/tmp/test_bulkload_full";
        Path tabPath = new Path(tabName);
        TableDescriptor desc = MapRDB.newTableDescriptor((String)tabName).setBulkLoad(true);
        desc.addFamily(MapRDB.newDefaultFamilyDescriptor());
        _logger.info("Creating table: " + tabName);
        admin.deleteTable(tabName);
        admin.createTable(tabName);
        try {
            _logger.info("Getting table: " + tabPath.toString());
            table = MapRDB.getTable((Path)tabPath);
            table.setOption(Table.TableOption.BUFFERWRITE, false);
            table.setOption(Table.TableOption.EXCLUDEID, true);
        }
        catch (Exception e) {
            _logger.info("Failed to get table. Create table '{}'.", (Object)tabPath);
            throw e;
        }
        assert (table != null);
        Configuration conf = new Configuration();
        BulkLoadRecordWriter bulkLoadWriter = new BulkLoadRecordWriter(conf, tabPath);
        Document rec = MapRDB.newDocument();
        rec.set("person.address.home.street", "525 E Maude Ave").set("person.address.home.city", "Sunnyvale").set("person.address.office.street", "San Jose").set("person.address.office.zip", "95134");
        String row1Str = "r1";
        bulkLoadWriter.write((Value)KeyValueBuilder.initFrom((String)row1Str), rec);
        rec = MapRDB.newDocument();
        rec.set("person.address.office.street", "350 Holger Way").set("person.address.office.city", "San Jose").set("person.address.office.zip", 95134);
        String row2Str = "r2";
        bulkLoadWriter.write((Value)KeyValueBuilder.initFrom((String)row2Str), rec);
        bulkLoadWriter.write(null, (Document)null);
        DocumentMutation mutation = MapRDB.newMutation();
        mutation.delete("person.address.office.street").setOrReplace("person.address.home.city", "San Jose");
        String row3Str = "r3";
        ByteBuffer rowBytes3 = ByteBuffer.wrap(row3Str.getBytes());
        bulkLoadWriter.write((Value)KeyValueBuilder.initFrom((String)row3Str), mutation);
        bulkLoadWriter.write(null, (DocumentMutation)null);
        Object rowBytes = null;
        int j = 4000;
        for (i = 4; i < 999; ++i) {
            String rowStr = new String("r" + Long.toString(j++));
            bulkLoadWriter.write((Value)KeyValueBuilder.initFrom((String)rowStr), rec);
        }
        bulkLoadWriter.close(null);
        desc.setBulkLoad(false);
        admin.alterTable(desc);
        Document readRec1 = table.findById(row1Str);
        Assert.assertEquals((Object)"525 E Maude Ave", (Object)readRec1.getString("person.address.home.street"));
        Assert.assertEquals((Object)"Sunnyvale", (Object)readRec1.getString("person.address.home.city"));
        Document readRec2 = table.findById(row2Str);
        Assert.assertEquals((Object)"350 Holger Way", (Object)readRec2.getString("person.address.office.street"));
        Assert.assertEquals((Object)"San Jose", (Object)readRec2.getString("person.address.office.city"));
        Assert.assertEquals((long)95134L, (long)readRec2.getInt("person.address.office.zip"));
        Document readRec3 = table.findById(row3Str);
        Assert.assertEquals((Object)"San Jose", (Object)readRec3.getString("person.address.home.city"));
        Assert.assertNull((Object)readRec3.getString("person.address.office.street"));
        j = 4000;
        Document readRec = null;
        for (i = 4; i < 999; ++i) {
            String rowStr = new String("r" + Long.toString(j++));
            readRec = table.findById(rowStr);
            Assert.assertEquals((Object)"350 Holger Way", (Object)readRec.getString("person.address.office.street"));
            Assert.assertEquals((Object)"San Jose", (Object)readRec.getString("person.address.office.city"));
            Assert.assertEquals((long)95134L, (long)readRec.getInt("person.address.office.zip"));
        }
        admin.deleteTable(tabName);
    }

    @Test
    public void testIncrementalBulkLoadRecordWriter() throws IOException, Exception {
        int i;
        assert (table != null);
        Configuration conf = new Configuration();
        BulkLoadRecordWriter bulkLoadWriter = new BulkLoadRecordWriter(conf, tablePath);
        Document rec = MapRDB.newDocument();
        rec.set("person.address.home.street", "525 E Maude Ave").set("person.address.home.city", "Sunnyvale").set("person.address.office.street", "San Jose").set("person.address.office.zip", "95134");
        String row1Str = "r1";
        bulkLoadWriter.write((Value)KeyValueBuilder.initFrom((String)row1Str), rec);
        rec = MapRDB.newDocument();
        rec.set("person.address.office.street", "350 Holger Way").set("person.address.office.city", "San Jose").set("person.address.office.zip", 95134);
        String row2Str = new String("r2");
        bulkLoadWriter.write((Value)KeyValueBuilder.initFrom((String)row2Str), rec);
        bulkLoadWriter.write(null, (Document)null);
        bulkLoadWriter.close(null);
        Document readRec1 = table.findById(row1Str);
        Document readRec2 = table.findById(row2Str);
        Assert.assertEquals((Object)"525 E Maude Ave", (Object)readRec1.getString("person.address.home.street"));
        Assert.assertEquals((Object)"Sunnyvale", (Object)readRec1.getString("person.address.home.city"));
        Assert.assertEquals((Object)"350 Holger Way", (Object)readRec2.getString("person.address.office.street"));
        Assert.assertEquals((Object)"San Jose", (Object)readRec2.getString("person.address.office.city"));
        Assert.assertEquals((long)95134L, (long)readRec2.getInt("person.address.office.zip"));
        bulkLoadWriter = new BulkLoadRecordWriter(conf, tablePath);
        DocumentMutation mutation = MapRDB.newMutation();
        mutation.delete("person.address.office.street").setOrReplace("person.address.home.city", "San Jose");
        bulkLoadWriter.write((Value)KeyValueBuilder.initFrom((String)row2Str), mutation);
        bulkLoadWriter.write(null, (DocumentMutation)null);
        bulkLoadWriter.close(null);
        readRec1 = table.findById(row2Str);
        Assert.assertEquals((Object)"San Jose", (Object)readRec1.getString("person.address.home.city"));
        Assert.assertNull((Object)readRec1.getString("person.address.office.street"));
        bulkLoadWriter = new BulkLoadRecordWriter(conf, tablePath);
        Object rowBytes = null;
        int j = 4000;
        for (i = 4; i < 999; ++i) {
            row2Str = new String("r" + Long.toString(j++));
            bulkLoadWriter.write((Value)KeyValueBuilder.initFrom((String)row2Str), rec);
        }
        bulkLoadWriter.close(null);
        j = 4000;
        Document readRec = null;
        for (i = 4; i < 999; ++i) {
            row2Str = new String("r" + Long.toString(j++));
            readRec = table.findById(row2Str);
            Assert.assertEquals((Object)"350 Holger Way", (Object)readRec.getString("person.address.office.street"));
            Assert.assertEquals((Object)"San Jose", (Object)readRec.getString("person.address.office.city"));
            Assert.assertEquals((long)95134L, (long)readRec.getInt("person.address.office.zip"));
        }
    }

    @Test
    public void testBulkLoadMultiCFFull() throws IOException, Exception {
        this.createBulkLoadTable(true);
        this.testBulkLoadMultiCFCommon();
        this.deleteBulkLoadTable();
    }

    @Test
    public void testBulkLoadMultiCFIncremental() throws IOException, Exception {
        this.createBulkLoadTable(false);
        this.testBulkLoadMultiCFCommon();
        this.deleteBulkLoadTable();
    }

    private void testBulkLoadMultiCFCommon() throws IOException, Exception {
        Path tabPath = new Path(TEST_BULKLOAD_JSON_TABLE);
        try {
            table = MapRDB.getTable((Path)tabPath);
            table.setOption(Table.TableOption.BUFFERWRITE, false);
            table.setOption(Table.TableOption.EXCLUDEID, true);
        }
        catch (Exception e) {
            _logger.info("Failed to get table. Create table '{}'.", (Object)tabPath);
            throw e;
        }
        Document rec = MapRDB.newDocument();
        rec.set("defaultchild1", 10).set("defaultchild2", true).set("defaultchild3", "Value").set("defaultchild4.child1", "child1").set("defaultchild4.child2", "child2").set("defaultchild4.family1", "family1").set("defaultchild4.family2.child1", false).set("defaultchild4.family2.child2", 50000).set("Family1.child1", 10).set("Family1.child2", true).set("Family1.child3", "Value").set("Family1.child4.child1", "child1").set("Family1.child4.child2", "child2").set("Family1.child4.family1", "family1").set("Family1.child4.family2.child1", false).set("Family1.child4.family2.child2", 50000);
        assert (table != null);
        Configuration conf = new Configuration();
        BulkLoadRecordWriter bulkLoadWriter = new BulkLoadRecordWriter(conf, tabPath);
        String rowStr = new String("r1");
        bulkLoadWriter.write((Value)KeyValueBuilder.initFrom((String)rowStr), rec);
        bulkLoadWriter.close(null);
        this.clearBulkLoadTableFlag();
        Document readRec = table.findById(rowStr);
        Assert.assertNotNull((Object)readRec);
        Assert.assertEquals((long)10L, (long)readRec.getInt("defaultchild1"));
        Assert.assertEquals((Object)true, (Object)readRec.getBoolean("defaultchild2"));
        Assert.assertEquals((Object)"Value", (Object)readRec.getString("defaultchild3"));
        Assert.assertEquals((Object)"child1", (Object)readRec.getString("defaultchild4.child1"));
        Assert.assertEquals((Object)"child2", (Object)readRec.getString("defaultchild4.child2"));
        Assert.assertEquals((Object)"family1", (Object)readRec.getString("defaultchild4.family1"));
        Assert.assertEquals((Object)Value.Type.MAP, (Object)readRec.getValue("defaultchild4.family2").getType());
        Assert.assertEquals((Object)false, (Object)readRec.getBoolean("defaultchild4.family2.child1"));
        Assert.assertEquals((long)50000L, (long)readRec.getInt("defaultchild4.family2.child2"));
    }

    static {
        tablePath = DBTests.getTablePath((String)TABLE_NAME);
    }
}

