/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.mapreduce;

import com.mapr.db.MapRDB;
import com.mapr.db.TabletInfo;
import com.mapr.db.impl.ConditionImpl;
import com.mapr.db.impl.ConditionNode;
import com.mapr.db.impl.IdCodec;
import com.mapr.db.mapreduce.DocumentSerialization;
import com.mapr.db.mapreduce.TableInputFormat;
import com.mapr.db.mapreduce.TableOutputFormat;
import com.mapr.db.mapreduce.TotalOrderPartitioner;
import com.mapr.db.mapreduce.ValueSerialization;
import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.db.rowcol.IdValueComparator;
import com.mapr.db.rowcol.KeyValue;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.mapreduce.Job;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapRDBMapReduceUtil {
    final Logger LOG = LoggerFactory.getLogger(MapRDBMapReduceUtil.class);

    public static void configureTableInputFormat(Job job, String srcTable) throws IOException {
        Configuration conf = job.getConfiguration();
        conf.setStrings("io.serializations", new String[]{conf.get("io.serializations"), ValueSerialization.class.getName(), DocumentSerialization.class.getName()});
        if (srcTable != null) {
            conf.set("maprdb.mapreduce.inputtable", srcTable);
        }
        job.setInputFormatClass(TableInputFormat.class);
    }

    public static void configureTableOutputFormat(Job job, String destTable) {
        Configuration conf = job.getConfiguration();
        if (destTable != null) {
            conf.set("maprdb.mapred.outputtable", destTable);
        }
        job.setOutputFormatClass(TableOutputFormat.class);
        job.setSpeculativeExecution(false);
    }

    public static void setMapOutputKeyValueClass(Job job) {
        job.setMapOutputKeyClass(KeyValue.class);
        job.setSortComparatorClass(IdValueComparator.class);
        job.setMapOutputValueClass(DBDocumentImpl.class);
    }

    public static void setOutputKeyValueClass(Job job) {
        job.setOutputKeyClass(KeyValue.class);
        job.setSortComparatorClass(IdValueComparator.class);
        job.setOutputValueClass(DBDocumentImpl.class);
    }

    public static int configurePartitioner(Job job, String destPath) throws IOException {
        String uuid = UUID.randomUUID().toString();
        job.setPartitionerClass(TotalOrderPartitioner.class);
        Configuration config = job.getConfiguration();
        Path partitionFile = new Path(config.get("hadoop.tmp.dir"), "partitions_" + uuid);
        TotalOrderPartitioner.setPartitionFile(config, partitionFile);
        List<ByteBuffer> partitionSplitPoints = MapRDBMapReduceUtil.getPartitionSplitPoints(destPath);
        MapRDBMapReduceUtil.writePartitions(job, partitionFile, partitionSplitPoints);
        job.addCacheFile(partitionFile.toUri());
        return partitionSplitPoints.size();
    }

    private static List<ByteBuffer> getPartitionSplitPoints(String tabName) throws IOException {
        TabletInfo[] tabletInfo = MapRDB.getTable((String)tabName).getTabletInfos();
        assert (tabletInfo.length >= 1);
        ArrayList<ByteBuffer> startKeys = new ArrayList<ByteBuffer>();
        for (TabletInfo ti : tabletInfo) {
            List range = ((ConditionImpl)ti.getCondition()).getRowkeyRanges();
            startKeys.add(ByteBuffer.wrap(((ConditionNode.RowkeyRange)range.get(0)).getStartRow()));
        }
        return startKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writePartitions(Job job, Path partitionsPath, List<ByteBuffer> startKeys) throws IOException, IllegalArgumentException {
        Configuration conf = job.getConfiguration();
        if (startKeys.isEmpty()) {
            throw new IllegalArgumentException("No regions passed");
        }
        TreeSet<ByteBuffer> sorted = new TreeSet<ByteBuffer>(startKeys);
        ByteBuffer first = sorted.first();
        if (first.limit() != 0) {
            throw new IllegalArgumentException("First region of table should have empty start key. Instead has: " + first.toString());
        }
        sorted.remove(first);
        FileSystem fs = partitionsPath.getFileSystem(conf);
        try (SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)partitionsPath, (Class)job.getMapOutputKeyClass(), NullWritable.class);){
            for (ByteBuffer startKey : sorted) {
                writer.append((Object)IdCodec.decode((ByteBuffer)startKey), (Object)NullWritable.get());
            }
        }
    }
}

