/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.mapreduce.tools.impl;

import com.mapr.db.Condition;
import com.mapr.db.DBDocument;
import com.mapr.db.MapRDB;
import com.mapr.db.impl.MapRDBTableImpl;
import com.mapr.db.rowcol.DBDocumentImpl;
import java.io.IOException;
import java.util.Iterator;
import org.ojai.DocumentStream;

public class DocScanner {
    DocumentStream<DBDocument> s;
    Iterator<DBDocument> iter;
    DBDocumentImpl lastDocument;
    MapRDBTableImpl table;
    boolean preserveTimestamp = true;
    boolean decodeTimestamp = false;
    boolean getDeletes = true;

    public DocScanner(String tablePath, Condition c, String[] fields, boolean excludedEmbeddedFamily) throws IOException {
        this.table = (MapRDBTableImpl)MapRDB.getTable((String)tablePath);
        this.table.setPrivateOption(MapRDBTableImpl.TablePrivateOption.PRESERVE_TIMESTAMP, this.preserveTimestamp);
        this.table.setPrivateOption(MapRDBTableImpl.TablePrivateOption.GET_DELETES, this.getDeletes);
        this.table.setPrivateOption(MapRDBTableImpl.TablePrivateOption.DECODE_TIMESTAMP, this.decodeTimestamp);
        this.table.setPrivateOption(MapRDBTableImpl.TablePrivateOption.EXCLUDE_EMBEDDEDFAMILY, excludedEmbeddedFamily);
        this.s = fields != null ? this.table.find(c, fields) : this.table.find(c);
        this.iter = this.s.iterator();
    }

    public DBDocumentImpl getNext() {
        if (this.lastDocument != null) {
            return this.lastDocument;
        }
        if (this.iter.hasNext()) {
            return (DBDocumentImpl)this.iter.next();
        }
        return null;
    }

    public DBDocumentImpl peekNext() {
        if (this.lastDocument != null) {
            return this.lastDocument;
        }
        if (this.iter.hasNext()) {
            this.lastDocument = (DBDocumentImpl)this.iter.next();
        }
        return this.lastDocument;
    }

    public void consume() {
        this.lastDocument = null;
    }

    public void close() throws IOException {
        this.table.close();
    }
}

