/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.mapreduce.tools;

import com.google.common.io.BaseEncoding;
import com.mapr.db.Admin;
import com.mapr.db.Condition;
import com.mapr.db.DBConstants;
import com.mapr.db.MapRDB;
import com.mapr.db.impl.ConditionImpl;
import com.mapr.db.impl.TableDescriptorImpl;
import com.mapr.fs.proto.Marlinserver;
import java.nio.ByteBuffer;
import org.apache.hadoop.conf.Configuration;

public class MapReduceUtilMethods {
    public static void setStartStopRow(Configuration conf) {
        String startRow = conf.get("maprdb.mapreduce.getall.startrow");
        String endRow = conf.get("maprdb.mapreduce.getall.stoprow");
        if (startRow == null && endRow == null) {
            return;
        }
        ConditionImpl cond = ((ConditionImpl)MapRDB.newCondition()).and().is(DBConstants.ROWKEY_FIELD, Condition.Op.GREATER_OR_EQUAL, startRow).is(DBConstants.ROWKEY_FIELD, Condition.Op.LESS_OR_EQUAL, endRow).close().build();
        ByteBuffer serializedCond = cond.getDescriptor().getSerialized();
        byte[] condArray = new byte[serializedCond.remaining()];
        serializedCond.get(condArray);
        String conditionString = BaseEncoding.base64().encode(condArray);
        conf.set("maprdb.mapreduce.condition", conditionString);
    }

    public static String[] getStreamDefaultCFsForRepl() {
        Marlinserver.MarlinInternalDefaults def = Marlinserver.MarlinInternalDefaults.getDefaultInstance();
        String[] fields = new String[]{def.getCfTopicMeta(), def.getCfMessages().equals("default") ? new String("") : def.getCfMessages(), def.getCfCursors()};
        return fields;
    }

    public static String processColumnSpec(String columnSpec, String tabPath) {
        String[] fields = null;
        Admin admin = MapRDB.newAdmin();
        TableDescriptorImpl desc = (TableDescriptorImpl)admin.getTableDescriptor(tabPath);
        if (columnSpec != null) {
            fields = columnSpec.split(",");
        } else if (desc.isStream()) {
            fields = MapReduceUtilMethods.getStreamDefaultCFsForRepl();
        }
        if (fields != null) {
            int numFields = fields.length;
            StringBuilder cols = new StringBuilder();
            for (int i = 0; i < numFields; ++i) {
                cols.append(fields[i]);
                if (i >= numFields - 1) continue;
                cols.append(",");
            }
            return cols.toString();
        }
        return null;
    }
}

