/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.mapreduce.tools;

import com.mapr.db.mapreduce.tools.impl.FormatResultNonMR;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormatResult
extends Configured
implements Tool {
    private static final Logger LOG = LoggerFactory.getLogger(FormatResult.class);
    static boolean mapreduce = false;
    static int numThreads = 16;
    static Path inDir;
    static Path outDir;
    static boolean exitOnFirstDiff;

    public int run(String[] args) throws Exception {
        Configuration conf = this.getConf();
        FileSystem fs = FileSystem.get((Configuration)conf);
        if (!fs.exists(inDir)) {
            System.err.println("Input dir " + inDir + " doesn't exist");
            System.exit(-1);
        }
        if (!fs.isDirectory(inDir)) {
            System.err.println("Input path " + inDir + " is not a directory");
            System.exit(-1);
        }
        if (fs.exists(outDir)) {
            System.err.println("Output dir " + outDir + " already exist");
            System.exit(-1);
        }
        FormatResultNonMR d = new FormatResultNonMR(conf, inDir, outDir, numThreads);
        return d.runWithoutMapReduce();
    }

    private static void parseArgs(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-h")) {
                FormatResult.Usage(null);
                continue;
            }
            if (args[i].equalsIgnoreCase("-indir")) {
                inDir = new Path(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-outdir")) {
                outDir = new Path(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-numthreads")) {
                numThreads = Integer.parseInt(args[++i]);
                continue;
            }
            FormatResult.Usage(null);
        }
        if (inDir == null) {
            FormatResult.Usage("Missing -indir");
        }
        if (outDir == null) {
            FormatResult.Usage("Missing -outdir");
        }
        if (mapreduce && numThreads != 0) {
            FormatResult.Usage("-numthreads can't be specified when -mapreduce is true");
        }
    }

    public static void Usage(String errorMsg) {
        if (errorMsg != null && errorMsg.length() > 0) {
            System.err.println("ERROR: " + errorMsg);
        }
        System.err.println("Usage: FormatResult \n-indir <dir path containing files with doucments>\n-outdir <dir path where files with decoded documents will be created>\n[-numthreads <numThreads> (default:16)]\n");
        System.exit(1);
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = new Configuration();
        FormatResult.parseArgs(args);
        int ret = 0;
        try {
            ret = ToolRunner.run((Configuration)conf, (Tool)new FormatResult(), (String[])args);
        }
        catch (Exception e) {
            ret = 1;
            e.printStackTrace();
        }
        System.exit(ret);
    }
}

