/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.mapreduce.tools;

import com.mapr.db.Condition;
import com.mapr.db.DBDocument;
import com.mapr.db.MapRDB;
import com.mapr.db.Table;
import com.mapr.db.TabletInfo;
import com.mapr.db.impl.IdCodec;
import com.mapr.db.impl.MapRDBTableImpl;
import com.mapr.db.mapreduce.ByteBufWritableComparable;
import com.mapr.db.mapreduce.DBDocumentSerialization;
import com.mapr.db.mapreduce.TableInputFormat;
import com.mapr.db.mapreduce.TableMapReduceUtil;
import com.mapr.db.mapreduce.tools.MapReduceUtilMethods;
import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.db.rowcol.SequenceFileRowColCodec;
import com.mapr.fs.MapRFileSystem;
import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileAlreadyExistsException;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.ojai.Document;
import org.ojai.DocumentStream;
import org.ojai.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Export
extends Configured
implements Tool {
    private static final Logger LOG = LoggerFactory.getLogger(Export.class);
    private static final String NAME = "export";
    private static boolean mapreduce = false;
    private static String tableName = null;
    private static String destPath = null;
    private static boolean preserveTimestamps = true;
    private static int numThreads = 16;
    private static String columnSpec = null;
    private static boolean isSuccess = false;
    private static String fileNamePrefix = "part";

    private static Job createSubmittableJob(Configuration conf, String[] otherArgs) throws IOException {
        String tableName = otherArgs[0];
        String outputPath = otherArgs[1];
        conf.set("maprdb.mapreduce.inputtable", tableName);
        conf.setBoolean("maprdb.table.impl.preserve_timestamps", preserveTimestamps);
        Path path = new Path(outputPath);
        Job job = new Job(conf, "export_" + tableName);
        job.setJarByClass(Export.class);
        Configuration config = job.getConfiguration();
        config.setStrings("io.serializations", new String[]{conf.get("io.serializations"), DBDocumentSerialization.class.getName()});
        job.setMapperClass(Exporter.class);
        job.setInputFormatClass(TableInputFormat.class);
        MapReduceUtilMethods.setStartStopRow(config);
        job.setMapOutputKeyClass(LongWritable.class);
        job.setMapOutputValueClass(DBDocumentImpl.class);
        job.setNumReduceTasks(0);
        job.setOutputFormatClass(SequenceFileOutputFormat.class);
        job.setOutputKeyClass(ByteBufWritableComparable.class);
        job.setOutputValueClass(DBDocumentImpl.class);
        FileOutputFormat.setOutputPath((Job)job, (Path)path);
        return job;
    }

    private void usage(String errorMsg) {
        if (errorMsg != null && errorMsg.length() > 0) {
            System.err.println("ERROR: " + errorMsg);
        }
        System.err.println("Usage: Export [-D <property=value>]* <tablename> <outputdir>");
    }

    private void ParseArgs(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-src")) {
                tableName = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-dst")) {
                destPath = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-mapreduce")) {
                mapreduce = Boolean.valueOf(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-columns")) {
                columnSpec = args[++i];
                continue;
            }
            System.err.println("Invalid argument: " + args[i]);
            this.Usage(null);
        }
        mapreduce = false;
        if (tableName == null || destPath == null) {
            this.Usage("missing -src or -dst.");
        }
    }

    private void Usage(String errorMsg) {
        if (errorMsg != null && errorMsg.length() > 0) {
            System.err.println("ERROR: " + errorMsg);
        }
        System.err.println("Usage: export [options] -src <Input table name> -dst <dest directory>\n[-columns : the set of paths for projection.]");
        System.exit(1);
    }

    public static void main(String[] args) throws Exception {
        int ret = 0;
        try {
            ret = ToolRunner.run((Configuration)new Configuration(), (Tool)new Export(), (String[])args);
        }
        catch (Exception e) {
            ret = 1;
            e.printStackTrace();
        }
        System.exit(ret);
    }

    private int run_NonMR(String[] args) throws Exception {
        Path dirPath = new Path(destPath);
        Configuration config = this.getConf();
        if (dirPath.getFileSystem(config).exists(dirPath)) {
            throw new FileAlreadyExistsException("Output directory " + dirPath + " already exists");
        }
        dirPath = dirPath.getFileSystem(config).makeQualified(dirPath);
        config.setBoolean("maprdb.table.impl.preserve_timestamps", preserveTimestamps);
        Table srcTable = MapRDB.getTable((String)tableName);
        TabletInfo[] tabletInfos = srcTable.getTabletInfos();
        int numSplits = tabletInfos.length;
        long ts = System.currentTimeMillis();
        ExecutorService executor = Executors.newFixedThreadPool(numThreads);
        for (int i = 0; i < numSplits; ++i) {
            executor.execute(new ExporterThread(i, tabletInfos[i], config));
        }
        executor.shutdown();
        while (!executor.isTerminated()) {
        }
        if (!isSuccess) {
            return 1;
        }
        Export.doCleanup();
        return 0;
    }

    private static void doCleanup() {
    }

    public int run(String[] args) throws Exception {
        Configuration conf = this.getConf();
        String[] otherArgs = new GenericOptionsParser(conf, args).getRemainingArgs();
        this.ParseArgs(otherArgs);
        if (otherArgs.length < 2) {
            this.usage("Wrong number of arguments: " + otherArgs.length);
            System.exit(-1);
        }
        if (!mapreduce) {
            this.run_NonMR(otherArgs);
            return 0;
        }
        Job job = Export.createSubmittableJob(conf, otherArgs);
        int retval = job.waitForCompletion(true) ? 0 : 1;
        return retval;
    }

    public static class Exporter
    extends Mapper<ByteBufWritableComparable, Document, ByteBufWritableComparable, Document> {
        public void map(ByteBufWritableComparable key, Document value, Mapper.Context context) throws IOException, InterruptedException {
            DBDocument rec = (DBDocument)value;
            context.write((Object)key, (Object)rec);
        }
    }

    class ExporterThread
    implements Runnable {
        protected TabletInfo tabletInfo;
        protected int myid;
        protected Configuration config;

        ExporterThread(int id, TabletInfo t, Configuration config) {
            this.tabletInfo = t;
            this.myid = id;
            this.config = config;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Condition c = this.tabletInfo.getCondition();
            MapRDBTableImpl srcTable = null;
            try {
                srcTable = new MapRDBTableImpl(new Path(tableName), this.config);
                DocumentStream rs = null;
                rs = columnSpec != null ? srcTable.find(c, TableMapReduceUtil.getFieldPaths(columnSpec)) : srcTable.find(c);
                Iterator iterator = rs.iterator();
                if (!destPath.endsWith("/")) {
                    destPath = destPath + "/";
                }
                Path outputPath = new Path(destPath + fileNamePrefix + Integer.toString(this.myid));
                FileSystem fs = MapRFileSystem.get((Configuration)this.config);
                SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)this.config, (Path)outputPath, ByteBufWritableComparable.class, ByteBufWritableComparable.class);
                ByteBufWritableComparable key = null;
                ByteBufWritableComparable value = null;
                while (iterator.hasNext()) {
                    DBDocument doc = (DBDocument)iterator.next();
                    key = new ByteBufWritableComparable(IdCodec.encode((Value)doc.getId()));
                    value = new ByteBufWritableComparable(SequenceFileRowColCodec.encode((Document)doc));
                    writer.append((Writable)key, (Writable)value);
                }
                writer.close();
            }
            catch (Exception e) {
                LOG.error("export encountered an exception: " + e.getMessage());
                e.printStackTrace();
            }
            finally {
                try {
                    if (srcTable != null) {
                        srcTable.close();
                    }
                }
                catch (Exception e) {
                    LOG.error("export encountered an exception: " + e.getMessage());
                    e.printStackTrace();
                }
            }
            isSuccess = true;
        }
    }
}

