/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.mapreduce.tools;

import com.mapr.db.Admin;
import com.mapr.db.FamilyDescriptor;
import com.mapr.db.MapRDB;
import com.mapr.db.impl.MapRDBTableImpl;
import com.mapr.db.impl.TableDescriptorImpl;
import com.mapr.db.mapreduce.tools.DiffTables;
import com.mapr.fs.proto.Dbserver;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class DiffTablesMeta
extends Configured
implements Tool {
    public static final String NAME = "DiffTablesMeta";
    public static final int METATYPE_NONE = 0;
    public static final int METATYPE_CFS = 1;
    public static final int METATYPE_ACES = 2;
    public static final int METATYPE_ATTRS = 4;
    public static final int METATYPE_ALL = 7;
    public static final int SAME_METADATA_RET = 0;
    public static final int DIFFERENT_METADATA_RET = 1;
    public static final int COMMAND_LINE_ERROR_RET = 2;
    public static final int SKIP_META_TEST = 3;
    private static String srcPath = null;
    private static String dstPath = null;
    private static MapRDBTableImpl srcTable = null;
    private static MapRDBTableImpl dstTable = null;
    private static TableDescriptorImpl srcDesc = null;
    private static TableDescriptorImpl dstDesc = null;
    static int metaTypeMask = 0;
    static boolean cmpmeta = true;
    static Configuration config = null;
    private boolean callFromDiffTables = true;

    public DiffTablesMeta(boolean callFromDiffTables) {
        this.callFromDiffTables = callFromDiffTables;
    }

    public static boolean compareTableMeta(String src, String dst, int metaTypeMask) throws Exception {
        Admin maprAdmin = MapRDB.newAdmin();
        ArrayList<String> mismatchErrors = new ArrayList<String>();
        if (!maprAdmin.tableExists(srcPath)) {
            throw new IOException("Table " + srcPath + " does not exist.");
        }
        try {
            srcTable = (MapRDBTableImpl)MapRDB.getTable((String)srcPath);
            srcDesc = (TableDescriptorImpl)srcTable.getTableDescriptor();
        }
        catch (Exception e) {
            new IOException("Failed to read table " + srcTable + " due to exception: " + e.getMessage());
        }
        if (!maprAdmin.tableExists(dstPath)) {
            throw new IOException("Table " + dstPath + " does not exist.");
        }
        try {
            dstTable = (MapRDBTableImpl)MapRDB.getTable((String)dstPath);
            dstDesc = (TableDescriptorImpl)dstTable.getTableDescriptor();
        }
        catch (Exception e) {
            throw new IOException("Failed to read table " + dstTable + " due to exception: " + e.getMessage());
        }
        if (srcDesc.isStream() != dstDesc.isStream()) {
            mismatchErrors.add("Table: types are different: " + srcDesc.getPath() + " is" + (srcDesc.isStream() ? " a Stream, " : " a JSON Table, " + dstDesc.getPath() + " is" + (dstDesc.isStream() ? " a Stream." : " a JSON Table.")));
        }
        if ((metaTypeMask & 1) > 0) {
            List srcFams = srcDesc.getFamilies();
            List dstFams = dstDesc.getFamilies();
            if (srcFams.size() != dstFams.size()) {
                mismatchErrors.add("Column family: Counts are different: " + srcDesc.getPath() + " has " + srcFams.size() + " Column Families, " + dstDesc.getPath() + " has " + dstFams.size() + " Column Families.");
            }
            ListIterator srcIter = srcFams.listIterator();
            while (srcIter.hasNext()) {
                boolean foundMatch = false;
                FamilyDescriptor srcFam = (FamilyDescriptor)srcIter.next();
                ListIterator dstIter = dstFams.listIterator();
                while (dstIter.hasNext()) {
                    FamilyDescriptor dstFam = (FamilyDescriptor)dstIter.next();
                    if (!srcFam.getName().equals(dstFam.getName())) continue;
                    foundMatch = true;
                    if (!srcFam.equals(dstFam)) {
                        mismatchErrors.add("Column Family: " + srcFam.getName() + " has different properties " + " in " + srcDesc.getPath() + " and " + dstDesc.getPath());
                    }
                    srcIter.remove();
                    dstIter.remove();
                }
                if (foundMatch) continue;
                mismatchErrors.add("Column Family: " + srcFam.getName() + " with Json Path " + srcFam.getJsonFieldPath() + " not found in " + dstDesc.getPath() + ".");
            }
            if (!dstFams.isEmpty()) {
                for (FamilyDescriptor f : dstFams) {
                    mismatchErrors.add("Column Family:" + f.getName() + " with Json Path " + f.getJsonFieldPath() + " not found in " + srcDesc.getPath() + ".");
                }
            }
        }
        if ((metaTypeMask & 2) > 0) {
            Dbserver.TableAces.Builder srcAces = srcDesc.getTableAces();
            Dbserver.TableAces.Builder dstAces = dstDesc.getTableAces();
            if (srcAces.getAcesCount() != dstAces.getAcesCount()) {
                mismatchErrors.add("Table Aces: Number of aces are different. " + srcTable.getName() + " has " + srcAces.getAcesCount() + " while " + dstTable.getName() + " has " + dstAces.getAcesCount() + " aces.");
            }
            ArrayList srcAceList = new ArrayList(srcAces.getAcesList());
            ArrayList dstAceList = new ArrayList(dstAces.getAcesList());
            for (Dbserver.AccessControlExpression srcAce : srcAceList) {
                boolean found = false;
                Iterator dstAceItr = dstAceList.iterator();
                while (dstAceItr.hasNext()) {
                    Dbserver.AccessControlExpression dstAce = (Dbserver.AccessControlExpression)dstAceItr.next();
                    if (srcAce.getAccessType() == dstAce.getAccessType()) {
                        found = true;
                        if (!srcAce.getBooleanExpression().equals((Object)dstAce.getBooleanExpression())) {
                            mismatchErrors.add("Table Aces: Boolean expressions are different for access type " + srcAce.getAccessType() + ". " + srcTable.getName() + " has " + srcAce.getBooleanExpression().toStringUtf8() + " while " + dstTable.getName() + " has " + dstAce.getBooleanExpression().toStringUtf8() + ".");
                        }
                        dstAceItr.remove();
                    }
                    if (found) continue;
                    mismatchErrors.add("Table Aces: ACE of access type " + srcAce.getAccessType() + " not found in " + dstTable.getName() + ".");
                }
            }
            if (!dstAceList.isEmpty()) {
                for (Dbserver.AccessControlExpression dstAce : dstAceList) {
                    mismatchErrors.add("Table aces: ACE of access type " + dstAce.getAccessType() + " not found in " + srcTable.getName() + ".");
                }
            }
        }
        if (mismatchErrors.size() > 0) {
            System.out.println("DiffTablesMeta Output:");
            for (String errMsg : mismatchErrors) {
                System.out.println(errMsg);
            }
            return false;
        }
        return true;
    }

    private boolean ParseArgs(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-h") || args[i].startsWith("--h")) {
                this.printUsage();
                return false;
            }
            if (args[i].equalsIgnoreCase("-src")) {
                srcPath = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-dst")) {
                dstPath = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-columns")) {
                metaTypeMask |= 1;
                continue;
            }
            if (args[i].equalsIgnoreCase("-Aces")) {
                metaTypeMask |= 2;
                continue;
            }
            if (args[i].equalsIgnoreCase("-cmpmeta")) {
                String cmpmetaString;
                if ((cmpmetaString = args[++i]).equalsIgnoreCase("false")) {
                    cmpmeta = false;
                    continue;
                }
                if (!cmpmetaString.equalsIgnoreCase("true")) continue;
                cmpmeta = true;
                continue;
            }
            if (this.callFromDiffTables) continue;
            this.printUsage();
        }
        if (srcPath == null || dstPath == null) {
            this.printUsage();
        }
        return true;
    }

    private void printUsage() {
        if (this.callFromDiffTables) {
            DiffTables.Usage(null);
        }
        System.err.println("Usage: DiffTablesMeta -src tableA -dst tableB [options].\nOptions:  [-cmpmeta] <true|false> by default it's true\n  [-columns] compare column families\n  [-Aces] compare Aces\nBy default checks all of them.\n");
        System.exit(1);
    }

    public int run(String[] args) throws Exception {
        this.ParseArgs(args);
        if (!cmpmeta) {
            return 3;
        }
        return DiffTablesMeta.compareTableMeta(srcPath, dstPath, metaTypeMask == 0 ? 7 : metaTypeMask) ? 0 : 1;
    }

    public static void main(String[] args) throws Exception {
        int ret = 0;
        try {
            ret = ToolRunner.run((Configuration)new Configuration(), (Tool)new DiffTablesMeta(false), (String[])args);
            if (ret == 2) {
                System.out.println("Please check command line again and use correct format.");
            } else if (ret == 0) {
                System.out.println("DiffTablesMeta completed. Metadata of the two tables is same.");
            } else if (ret == 1) {
                System.err.println("ERROR: Metadata is different.");
            }
        }
        catch (Exception e) {
            ret = 1;
            e.printStackTrace();
        }
        System.exit(ret);
    }
}

