/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.mapreduce.tools;

import com.mapr.db.Admin;
import com.mapr.db.MapRDB;
import com.mapr.db.impl.TableDescriptorImpl;
import com.mapr.db.mapreduce.tools.DiffTablesMeta;
import com.mapr.db.mapreduce.tools.MapReduceUtilMethods;
import com.mapr.db.mapreduce.tools.impl.DiffTableNonMR;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiffTables
extends Configured
implements Tool {
    private static final Logger LOG = LoggerFactory.getLogger(DiffTables.class);
    public static final String NAME = "difftables";
    static String table1Path;
    static String table2Path;
    static String columnSpec;
    static boolean mapreduce;
    static int numThreads;
    static String outDir;
    static boolean exitOnFirstDiff;
    static boolean cmpMeta;
    static boolean excludedEmbeddedFamily;
    static final String table1PathConf = "table1Pathconf";
    static final String table2PathConf = "table2Pathconf";
    static final String outDirConf = "outdirconf";
    static final String columnSpecConf = "columnspeccconf";
    static final String exitOnFirstDiffConf = "exitonfirstdiffconf";

    public static String getOpsForTableName(String table) {
        return "OpsForTable_" + table;
    }

    public int run(String[] args) throws Exception {
        DiffTables.parseArgs(args);
        int ret = 0;
        ret = this.compareMeta(args);
        if (ret != 0) {
            return ret;
        }
        Configuration conf = this.getConf();
        DiffTables.parseArgs(args);
        this.setupConfParmas(conf);
        String[] fields = null;
        if (columnSpec != null) {
            fields = columnSpec.split(",");
        }
        DiffTableNonMR d = new DiffTableNonMR(conf, table1Path, table2Path, fields, numThreads, exitOnFirstDiff, excludedEmbeddedFamily, outDir);
        return d.runWithoutMapReduce();
    }

    private int compareMeta(String[] args) throws Exception {
        int ret = ToolRunner.run((Configuration)this.getConf(), (Tool)new DiffTablesMeta(true), (String[])args);
        if (ret == 1) {
            System.out.println("ERROR: Metadata is different.");
            System.out.println("To skip metadata comparison, use the option -cmpmeta false.");
            System.exit(ret);
        } else if (ret == 3) {
            System.out.println("Skip Metadata test.");
        } else if (ret == 0) {
            System.out.println("DiffTablesMeta completed. Metadata of the two tables is same.");
        }
        return ret;
    }

    private void setupConfParmas(Configuration conf) {
        conf.set(table1PathConf, table1Path);
        conf.set(table2PathConf, table2Path);
        conf.set(outDirConf, outDir);
        if (columnSpec != null) {
            conf.set(columnSpecConf, columnSpec);
        }
        conf.setBoolean(exitOnFirstDiffConf, exitOnFirstDiff);
    }

    private static void parseArgs(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-h")) {
                DiffTables.Usage(null);
                continue;
            }
            if (args[i].equalsIgnoreCase("-src")) {
                table1Path = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-dst")) {
                table2Path = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-columns")) {
                columnSpec = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-exclude_embedded_families")) {
                excludedEmbeddedFamily = Boolean.valueOf(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-mapreduce")) {
                mapreduce = Boolean.valueOf(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-numthreads")) {
                numThreads = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-outdir")) {
                outDir = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-first_exit")) {
                exitOnFirstDiff = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-cmpmeta")) {
                cmpMeta = true;
                ++i;
                continue;
            }
            DiffTables.Usage(null);
        }
        if (table1Path == null || table2Path == null) {
            DiffTables.Usage("missing -src or -dst table path.");
        }
        if (table1Path.equals(table2Path)) {
            System.out.println("Source table " + table1Path + " and destination table " + table2Path + " refers to the same table");
            System.exit(-1);
        }
        if (outDir == null) {
            DiffTables.Usage("Missing -outdir");
        }
        if (mapreduce && numThreads != 0) {
            DiffTables.Usage("-numthreads can't be specified when -mapreduce is true");
        }
        columnSpec = MapReduceUtilMethods.processColumnSpec(columnSpec, table1Path);
        LOG.info("Comparing {} column families from {} to {}.", new Object[]{columnSpec != null ? columnSpec : "all", table1Path, table2Path});
        Admin admin = MapRDB.newAdmin();
        TableDescriptorImpl desc = (TableDescriptorImpl)admin.getTableDescriptor(table1Path);
        if (desc.isStream()) {
            excludedEmbeddedFamily = true;
        }
    }

    public static void Usage(String errorMsg) {
        if (errorMsg != null && errorMsg.length() > 0) {
            System.err.println("ERROR: " + errorMsg);
        }
        System.err.println("Usage: hadoop com.mapr.db.mapreduce.tools.DiffTables \n-src <source table path>\n-dst <destination table path>\n-outdir <output directory>\n[-first_exit] Exit when first difference is found.\n[-columns <comma separated list of field paths> ]\n[-exclude_embedded_families <true|false>] (default: false)\n  Don't include the  other column families with path embedded in specified columns\n[-mapreduce] <true|false> (default: true)]\n[-numthreads <numThreads> (default:16, valid only when -mapreduce is false)]\n[-cmpmeta <true|false> (default: true)]\n");
        System.exit(1);
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = new Configuration();
        int ret = 0;
        try {
            ret = ToolRunner.run((Configuration)conf, (Tool)new DiffTables(), (String[])args);
        }
        catch (Exception e) {
            ret = 1;
            e.printStackTrace();
        }
        System.exit(ret);
    }

    static {
        mapreduce = false;
        numThreads = 16;
    }
}

