/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.mapreduce;

import com.mapr.db.Table;
import com.mapr.db.mapreduce.ByteBufWritableComparable;
import java.io.IOException;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.ojai.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableRecordWriter
extends RecordWriter<ByteBufWritableComparable, Document> {
    static final Logger LOG = LoggerFactory.getLogger(TableRecordWriter.class);
    private Table jTable;
    public static final String OUTPUT_TABLE = "maprdb.mapreduce.outputtable";

    public TableRecordWriter(Table table) {
        this.jTable = table;
    }

    public void close(TaskAttemptContext context) throws IOException {
        this.jTable.flush();
    }

    public void write(ByteBufWritableComparable key, Document value) throws IOException {
        if (key == null) {
            this.jTable.insertOrReplace(value);
        } else {
            this.jTable.insertOrReplace(key.toString(), value);
        }
    }
}

