/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.mapreduce;

import com.mapr.db.Condition;
import com.mapr.db.impl.ConditionImpl;
import com.mapr.db.mapreduce.DBDocumentSerialization;
import com.mapr.db.mapreduce.TableInputFormat;
import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.db.util.ByteBufs;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.ojai.Document;
import org.ojai.Value;
import org.ojai.util.Fields;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableMapReduceUtil {
    final Logger LOG = LoggerFactory.getLogger(TableMapReduceUtil.class);

    public static void initMapperJob(Class<? extends Mapper> mapper, Job job, Condition cond) throws IOException {
        Configuration conf = job.getConfiguration();
        conf.setStrings("io.serializations", new String[]{conf.get("io.serializations"), DBDocumentSerialization.class.getName()});
        String conditionString = new String(((ConditionImpl)cond).getDescriptor().getSerialized().array(), "UTF-8");
        conf.set("maprdb.mapreduce.condition", conditionString);
        if (mapper != null) {
            job.setMapperClass(mapper);
        }
        job.setInputFormatClass(TableInputFormat.class);
        job.setMapOutputKeyClass(LongWritable.class);
        job.setMapOutputValueClass(DBDocumentImpl.class);
    }

    public static void initReducerJob(Class<? extends Reducer> reducer, Job job) {
        Configuration conf = job.getConfiguration();
        if (reducer != null) {
            job.setReducerClass(reducer);
        }
        conf.setStrings("io.serializations", new String[]{conf.get("io.serializations"), DBDocumentSerialization.class.getName()});
        job.setOutputValueClass(DBDocumentImpl.class);
    }

    public static ByteBuffer getRowKey(Document record, String field) {
        Value value = record.getValue(field);
        if (value.getType() == Value.Type.BINARY) {
            return value.getBinary();
        }
        if (value.getType() == Value.Type.STRING) {
            try {
                return ByteBufs.wrap((byte[])value.getString().getBytes("UTF-8"));
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public static String[] getFieldPaths(String fieldPaths) {
        String[] tokens = fieldPaths.split(",");
        ArrayList<String> pathList = new ArrayList<String>();
        int length = tokens.length;
        String currentToken = null;
        for (int count = 0; count < length; ++count) {
            if (currentToken != null) {
                currentToken = currentToken + "," + tokens[count];
                if (!tokens[count].endsWith(String.valueOf(Fields.SEGMENT_QUOTE_CHAR))) continue;
                pathList.add(currentToken);
                currentToken = null;
                continue;
            }
            if (tokens[count].charAt(0) != Fields.SEGMENT_QUOTE_CHAR) {
                pathList.add(tokens[count]);
                continue;
            }
            currentToken = tokens[count];
        }
        String[] paths = new String[pathList.size()];
        paths = pathList.toArray(paths);
        return paths;
    }
}

