/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.mapreduce.test;

import com.mapr.db.mapreduce.TableMapReduceUtil;
import org.junit.Assert;
import org.junit.Test;

public class TestUtilMethods {
    @Test
    public void testGetFieldPaths() {
        String paths = "a.b.c,map";
        String[] parsedPaths = TableMapReduceUtil.getFieldPaths((String)paths);
        Assert.assertEquals((Object)"a.b.c", (Object)parsedPaths[0]);
        Assert.assertEquals((Object)"map", (Object)parsedPaths[1]);
    }

    @Test
    public void testGetFieldPathsWithQuote() {
        String paths = "`a,k,.c`,@p#,a.x";
        String[] parsedPaths = TableMapReduceUtil.getFieldPaths((String)paths);
        Assert.assertEquals((Object)"`a,k,.c`", (Object)parsedPaths[0]);
        Assert.assertEquals((Object)"@p#", (Object)parsedPaths[1]);
    }

    @Test
    public void testGetFieldPathsWithSingleEntry() {
        String paths = "map.b";
        String[] parsedPaths = TableMapReduceUtil.getFieldPaths((String)paths);
        Assert.assertEquals((Object)"map.b", (Object)parsedPaths[0]);
    }

    @Test
    public void testGetFieldPathsWithQ() {
        String paths = "`a.k,.c`,`b,,y`,a.x";
        String[] parsedPaths = TableMapReduceUtil.getFieldPaths((String)paths);
        Assert.assertEquals((Object)"`a.k,.c`", (Object)parsedPaths[0]);
        Assert.assertEquals((Object)"`b,,y`", (Object)parsedPaths[1]);
    }
}

