/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.mapreduce.test;

import com.mapr.db.DBDocument;
import com.mapr.db.MapRDB;
import com.mapr.db.Mutation;
import com.mapr.db.mapreduce.MutationSerialization;
import com.mapr.db.rowcol.InsertContext;
import com.mapr.db.rowcol.KeyValue;
import com.mapr.db.rowcol.MutationImpl;
import com.mapr.db.rowcol.RowcolCodec;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.Serializer;
import org.junit.Assert;
import org.junit.Test;

public class TestMutationSerialization {
    @Test
    public void testRecordMutationSerialization() throws Exception {
        MutationSerialization serde = new MutationSerialization();
        MutationImpl mutation = (MutationImpl)MapRDB.newMutation();
        mutation.set("a.b", 10).set("a.d", "Anurag").set("Address.zip", 94086).set("Address.Street", "Washington Avenue").set("Field1", 1000.0).build();
        Assert.assertEquals((Object)true, (Object)mutation.needsReadOnServer());
        MutationImpl rm2 = (MutationImpl)MapRDB.newMutation();
        rm2.setOrReplace("a.name", "Santanu").setOrReplace("a.zip", 11011).setOrReplace("a.f", 100.0).build();
        Assert.assertEquals((Object)false, (Object)rm2.needsReadOnServer());
        Serializer se = serde.getSerializer(Mutation.class);
        DataOutputStream out = new DataOutputStream(new FileOutputStream("test.txt"));
        se.open((OutputStream)out);
        se.serialize((Object)mutation);
        se.serialize((Object)rm2);
        se.close();
        out.close();
        DataInputStream in = new DataInputStream(new FileInputStream("test.txt"));
        Deserializer de = serde.getDeserializer(Mutation.class);
        de.open((InputStream)in);
        MutationImpl newrec = null;
        newrec = (MutationImpl)de.deserialize(newrec);
        Assert.assertEquals((Object)true, (Object)newrec.needsReadOnServer());
        ByteBuffer b = newrec.rowcolSerialize();
        DBDocument recImpl = RowcolCodec.decode((ByteBuffer)b);
        KeyValue kv = (KeyValue)recImpl.getValue("a.b");
        Assert.assertEquals((Object)InsertContext.OpType.SET, (Object)kv.getOpType());
        Assert.assertEquals((long)10L, (long)kv.getInt());
        newrec = (MutationImpl)de.deserialize((Object)newrec);
        b = newrec.rowcolSerialize();
        recImpl = RowcolCodec.decode((ByteBuffer)b);
        kv = (KeyValue)recImpl.getValue("a.zip");
        Assert.assertEquals((Object)InsertContext.OpType.SET_OR_REPLACE, (Object)kv.getOpType());
        Assert.assertEquals((long)11011L, (long)kv.getInt());
        de.close();
        in.close();
    }
}

