/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.mapreduce.test;

import com.mapr.db.Table;
import com.mapr.db.impl.MapRDBTableImpl;
import com.mapr.db.mapreduce.tools.DiffTables;
import com.mapr.db.mapreduce.tools.Export;
import com.mapr.db.mapreduce.tools.Import;
import com.mapr.db.mapreduce.tools.ImportJSON;
import com.mapr.db.tests.tableops.TestMapRDBWithCluster;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.IntegrationTest;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={IntegrationTest.class})
public class TestImportUtility
extends BaseTest {
    private static final Logger _logger = LoggerFactory.getLogger(TestImportUtility.class);
    private static final String jsonFilePath = "/tmp/jsonpath/jsonfile";
    private static final String jsonPath = "/tmp/jsonpath";
    private static final String srcTableName = "/srctab1";
    private static final String destTableName = "/desttab1";
    private static final String exportPath = "/tmp/export1";
    private static final String DIFF_TABLE_OUT_DIR = "/tmp/difftable";

    @BeforeClass
    public static void startupBeforeClass() throws IOException {
    }

    @AfterClass
    public static void cleanupAfterClass() throws IOException, Exception {
        DBTests.deleteTables((String[])new String[]{srcTableName});
        DBTests.deleteTables((String[])new String[]{destTableName});
    }

    void rmDir(String path) throws IOException, InterruptedException {
        ProcessBuilder proc = new ProcessBuilder("hadoop", "fs", "-rmr", path);
        Process p = proc.start();
        p.waitFor();
    }

    void compareTables(String srcTable, String dstTable, boolean expectedPass) throws Exception {
        String outdir = DIFF_TABLE_OUT_DIR;
        this.rmDir(outdir);
        int ret = ToolRunner.run(null, (Tool)new DiffTables(), (String[])new String[]{"-src", srcTable, "-dst", dstTable, "-outdir", outdir});
        if (expectedPass) {
            Assert.assertEquals((long)0L, (long)ret);
        }
    }

    private void runImportJSON(String destTab, String blkLoad, String textFilePath) throws Exception {
        int ret = ToolRunner.run(null, (Tool)new ImportJSON(), (String[])new String[]{"-src", textFilePath, "-dst", destTab, "-bulkload", blkLoad, "-mapreduce", "false"});
        Assert.assertEquals((long)0L, (long)ret);
    }

    public void runExport(String srcTable) throws Exception {
        int ret = ToolRunner.run(null, (Tool)new Export(), (String[])new String[]{"-src", srcTable, "-dst", exportPath});
        Assert.assertEquals((long)0L, (long)ret);
    }

    private void runImport(String destTable, String blkLoad) throws Exception {
        int ret = ToolRunner.run(null, (Tool)new Import(), (String[])new String[]{"-src", exportPath, "-dst", destTable, "-bulkload", blkLoad, "-mapreduce", "false"});
        Assert.assertEquals((long)0L, (long)ret);
    }

    private void initializeWithData(FileSystem fs, Configuration conf) throws Exception {
        Document d = TestMapRDBWithCluster.getMedRecord();
        if (fs.exists(new Path(jsonPath))) {
            fs.delete(new Path(jsonPath), true);
        }
        FSDataOutputStream os = fs.create(new Path(jsonFilePath), true);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)os, "UTF-8"));
        for (int i = 0; i < 10; ++i) {
            d.set("_id", "k" + i);
            writer.write(d.toString() + "\n");
        }
        writer.close();
    }

    private void runTest(String blkLoadOption, String textFilePath) throws Exception {
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        this.initializeWithData(fs, conf);
        MapRDBTableImpl srcTab = (MapRDBTableImpl)DBTests.createOrReplaceTable((String)srcTableName);
        this.runImportJSON(srcTab.getPath().toString(), blkLoadOption, textFilePath);
        if (fs.exists(new Path(exportPath))) {
            fs.delete(new Path(exportPath), true);
        }
        srcTab.setPrivateOption(MapRDBTableImpl.TablePrivateOption.PRESERVE_TIMESTAMP, true);
        this.runExport(srcTab.getPath().toString());
        _logger.info("Run import");
        Table destTab = DBTests.createOrReplaceTable((String)destTableName);
        this.runImport(destTab.getPath().toString(), blkLoadOption);
        _logger.info("Comparing tables");
        this.compareTables(srcTab.getPath().toString(), destTab.getPath().toString(), true);
    }

    private void runNegativeTests() throws Exception {
        String filePath;
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        if (fs.exists(new Path(filePath = "/tmp/fpath"))) {
            fs.delete(new Path(filePath), true);
        }
        int ret = ToolRunner.run(null, (Tool)new ImportJSON(), (String[])new String[]{"-src", filePath, "-dst", "/tmp/dtab1", "-bulkload", "false", "-mapreduce", "false"});
        Assert.assertEquals((long)1L, (long)ret);
    }

    @Test
    public void testExportImportNonMRWithDiffTable() throws Exception {
        this.runTest("false", jsonPath);
    }

    @Test
    public void testExportImportNonMRWithDiffTableWithBulkLoad() throws Exception {
        this.runTest("true", jsonPath);
    }

    @Test
    public void testExportImportNonMRWithDiffTableAndFile() throws Exception {
        this.runTest("false", jsonFilePath);
    }

    @Test
    public void testUtilitiesWithFailure() throws Exception {
        this.runNegativeTests();
    }
}

