/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.mapreduce.test;

import com.mapr.db.Condition;
import com.mapr.db.DBDocument;
import com.mapr.db.MapRDB;
import com.mapr.db.mapreduce.TableMapReduceUtil;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.apache.hadoop.util.GenericOptionsParser;

public class TestCounter {
    private static final String NAME = "rowcounter";
    public static int count;

    public static Job createSubmittableJob(Configuration conf, String[] otherArgs, Condition cond) throws IOException {
        count = 0;
        String tableName = otherArgs[0];
        conf.set("maprdb.mapreduce.inputtable", tableName);
        Job job = new Job(conf, "rowcounter_" + tableName);
        job.setJarByClass(TestCounter.class);
        job.setOutputFormatClass(NullOutputFormat.class);
        TableMapReduceUtil.initMapperJob(RowCounterMapper.class, (Job)job, (Condition)cond);
        job.setNumReduceTasks(0);
        return job;
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = new Configuration();
        Condition cond = MapRDB.newCondition();
        cond.build();
        String[] otherArgs = new GenericOptionsParser(conf, args).getRemainingArgs();
        Job job = TestCounter.createSubmittableJob(conf, otherArgs, cond);
        if (job == null) {
            System.exit(-1);
        }
        System.exit(job.waitForCompletion(true) ? 0 : 1);
    }

    static class RowCounterMapper
    extends Mapper<LongWritable, DBDocument, LongWritable, DBDocument> {
        RowCounterMapper() {
        }

        public void map(LongWritable row, DBDocument value, Mapper.Context context) throws IOException {
            context.getCounter((Enum)Counters.ROWS).increment(1L);
            System.out.println("count " + Integer.toString(++count));
        }

        public static enum Counters {
            ROWS;

        }
    }
}

