/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.climarlin;

import com.google.common.collect.ImmutableMap;
import com.mapr.cli.DbUpstreamCommands;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.IntegerInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.climarlin.StreamCommands;
import java.io.IOException;
import java.util.Map;
import org.apache.log4j.Logger;

public class StreamUpstreamCommands
extends DbUpstreamCommands {
    private static final Logger LOG = Logger.getLogger(StreamUpstreamCommands.class);
    public static final String COLUMNS_PARAM_NAME = "columns";
    public static final String OUTPUT_PARAM_NAME = "output";
    public static final String START_PARAM_NAME = "start";
    public static final String LIMIT_PARAM_NAME = "limit";
    private static final String PATH_PARAM_NAME = "path";
    private static final String UPSTREAM_PARAM_NAME = "upstream";
    private static final String PAUSED_PARAM_NAME = "paused";
    private static final CLICommand listCommand = new CLICommand("list", "usage: stream upstream list -path <streamPath>", StreamUpstreamCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "stream path", true, null)).put((Object)"columns", (Object)new TextInputParameter("columns", "columns", false, "all").setInvisible(true)).put((Object)"output", (Object)new TextInputParameter("output", "verbose|terse", false, "verbose").setInvisible(true)).put((Object)"start", (Object)new IntegerInputParameter("start", "start", false, Integer.valueOf(0)).setInvisible(true)).put((Object)"limit", (Object)new IntegerInputParameter("limit", "limit", false, Integer.valueOf(Integer.MAX_VALUE)).setInvisible(true)).build(), null).setShortUsage("stream upstream list -path <streamPath>");
    private static final CLICommand addCommand = new CLICommand("add", "usage: stream upstream add -path <streamPath> -upstream <upstreamPath>", StreamUpstreamCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "stream path", true, null)).put((Object)"upstream", (Object)new TextInputParameter("upstream", "upstream stream path", true, null)).build(), null).setShortUsage("stream upstream add -path <streamPath> -upstream <upstreamPath>");
    private static final CLICommand removeCommand = new CLICommand("remove", "usage: stream upstream remove -path <streamPath> -upstream <upstreamPath>", StreamUpstreamCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "stream path", true, null)).put((Object)"upstream", (Object)new TextInputParameter("upstream", "upstream stream path", true, null)).build(), null).setShortUsage("stream upstream remove -path <streamPath> -upstream <upstreamPath>");
    public static final CLICommand upstreamCommands = new CLICommand("upstream", "upstream [add|list|remove]", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{addCommand, listCommand, removeCommand}).setShortUsage("stream upstream [add|list|remove]");

    public StreamUpstreamCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public String entityName() {
        return "stream";
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        if (!super.validateInput()) {
            return output;
        }
        String streamPath = this.getParamTextValue(PATH_PARAM_NAME, 0);
        try {
            if (!StreamCommands.isStream(streamPath)) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Path " + streamPath + " is not a valid stream"));
                return output;
            }
        }
        catch (CLIProcessingException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, e.getMessage()));
            return output;
        }
        catch (IOException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
        String cname = this.cliCommand.getCommandName();
        if (cname.equalsIgnoreCase(addCommand.getCommandName())) {
            this.addUpstream(out);
        } else if (cname.equalsIgnoreCase(listCommand.getCommandName())) {
            this.listUpstream(out);
        } else if (cname.equalsIgnoreCase(removeCommand.getCommandName())) {
            this.removeUpstream(out);
        }
        return output;
    }

    protected void addUpstream(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        super.addUpstream(out);
    }

    protected void listUpstream(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        super.listUpstream(out);
    }

    protected void removeUpstream(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        super.removeUpstream(out);
    }
}

