/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli.common;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.Errno;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.fs.cldb.proto.Accesscontrol;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.cldb.security.ACL;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Security;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AuthManager {
    private static AuthManager s_instance;
    private static final Log LOG;

    public static synchronized AuthManager getInstance() {
        if (s_instance == null) {
            s_instance = new AuthManager();
        }
        return s_instance;
    }

    public boolean canPerformVolumeAction(String clusterName, String volumeName, CLDBProto.VolumeProperties volProps, int volumeActions, Security.CredentialsMsg creds, CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        Accesscontrol.ClientAuthorizationResponse resp = this.sendAuthRequestToCldb(clusterName, creds, volumeActions, volumeName, 0);
        if (resp.getStatus() == 0) {
            if (!resp.getIsAuthorized() && out != null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(1, Errno.toString(1)));
            }
            return resp.getIsAuthorized();
        }
        if (resp.getStatus() != 10009) {
            if (out != null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg()));
            }
            return false;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Authorization Not Supported at CLDB: Reverting to Obtaining ACLs");
        }
        Security.AccessControlList accessControlList = null;
        if (volProps != null) {
            if (volProps.getAcl() == null) {
                if (out != null) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Missing ACLs in VolumeProperties for Volume " + volumeName));
                }
                return false;
            }
            accessControlList = volProps.getAcl();
        } else {
            CLDBProto.SecurityGetAclResponse getAclsResp = this.getAcls(creds, volumeName);
            if (getAclsResp.getStatus() != 0) {
                if (out != null) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(getAclsResp.getStatus(), getAclsResp.getErrorString()));
                }
                return false;
            }
            accessControlList = getAclsResp.getAcl();
        }
        ACL acl = new ACL(accessControlList);
        if (!acl.verifyPermissions(creds, volumeActions)) {
            if (out != null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(1, "Authorization Error: Volume: " + volumeName + " VolumeActions: " + volumeActions));
            }
            return false;
        }
        return true;
    }

    public boolean canPerformVolumeAction(String volumeName, CLDBProto.VolumeProperties volProps, int volumeActions, Security.CredentialsMsg creds, CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        return this.canPerformVolumeAction(CLDBRpcCommonUtils.getInstance().getCurrentClusterName(), volumeName, volProps, volumeActions, creds, out);
    }

    public boolean canPerformClusterActions(String clusterName, int clusterActions, Security.CredentialsMsg creds, CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        CLDBProto.SecurityGetAclResponse getAclsResp;
        Accesscontrol.ClientAuthorizationResponse resp = this.sendAuthRequestToCldb(clusterName, creds, 0, null, clusterActions);
        if (resp.getStatus() == 0) {
            if (!resp.getIsAuthorized() && out != null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(1, Errno.toString(1)));
            }
            return resp.getIsAuthorized();
        }
        if (resp.getStatus() != 10009) {
            if (out != null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg()));
            }
            return false;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Authorization Not Supported at CLDB: Reverting to Obtaining ACLs");
        }
        if ((getAclsResp = this.getAcls(creds, null)).getStatus() != 0) {
            if (out != null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(getAclsResp.getStatus(), getAclsResp.getErrorString()));
            }
            return false;
        }
        ACL acl = new ACL(getAclsResp.getAcl());
        if (!acl.verifyPermissions(creds, clusterActions)) {
            if (out != null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(1, Errno.toString(1)));
            }
            return false;
        }
        return true;
    }

    public boolean canPerformClusterActions(int clusterActions, Security.CredentialsMsg creds, CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        return this.canPerformClusterActions(CLDBRpcCommonUtils.getInstance().getCurrentClusterName(), clusterActions, creds, out);
    }

    private Accesscontrol.ClientAuthorizationResponse sendAuthRequestToCldb(String clusterName, Security.CredentialsMsg creds, int volumeActions, String volumeName, int clusterActions) throws CLIProcessingException {
        Accesscontrol.ClientAuthorizationResponse authResponse;
        byte[] data;
        Accesscontrol.ClientAuthorizationRequest.Builder authRequestBuilder = Accesscontrol.ClientAuthorizationRequest.newBuilder().setCreds(creds).setClusterActions(clusterActions).setVolumeActions(volumeActions);
        if (volumeName != null) {
            authRequestBuilder.setVolumeName(volumeName);
        }
        try {
            data = CLDBRpcCommonUtils.getInstance().sendRequest(clusterName, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ClientAuthorizationProc.getNumber(), (MessageLite)authRequestBuilder.build(), Accesscontrol.ClientAuthorizationResponse.class);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Error Sending RPC Request", (Throwable)e);
        }
        if (data == null) {
            return Accesscontrol.ClientAuthorizationResponse.newBuilder().setStatus(10009).setErrMsg("RPC Rejected by CLDB Server").build();
        }
        try {
            authResponse = Accesscontrol.ClientAuthorizationResponse.parseFrom((byte[])data);
        }
        catch (InvalidProtocolBufferException e) {
            throw new CLIProcessingException("Error Parsing RPC Response", (Throwable)e);
        }
        return authResponse;
    }

    private CLDBProto.SecurityGetAclResponse getAcls(Security.CredentialsMsg creds, String volumeName) throws CLIProcessingException {
        byte[] data;
        CLDBProto.SecurityGetAclRequest.Builder aclRequestBuilder = CLDBProto.SecurityGetAclRequest.newBuilder().setCreds(creds).setObjectType(CLDBProto.SecureObjectType.OBJECT_TYPE_CLUSTER);
        if (volumeName != null) {
            aclRequestBuilder.setName(volumeName).setObjectType(CLDBProto.SecureObjectType.OBJECT_TYPE_VOLUME);
        }
        try {
            data = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.SecurityGetAclProc.getNumber(), (MessageLite)aclRequestBuilder.build(), CLDBProto.SecurityGetAclResponse.class);
        }
        catch (Exception e) {
            throw new CLIProcessingException((Throwable)e);
        }
        if (data == null) {
            return CLDBProto.SecurityGetAclResponse.newBuilder().setStatus(10009).setErrorString("RPC Rejected by CLDB Server").build();
        }
        CLDBProto.SecurityGetAclResponse getAclsResp = null;
        try {
            getAclsResp = CLDBProto.SecurityGetAclResponse.parseFrom((byte[])data);
        }
        catch (InvalidProtocolBufferException e) {
            throw new CLIProcessingException("InvalidProtocolBufferException Exception", (Throwable)e);
        }
        return getAclsResp;
    }

    static {
        LOG = LogFactory.getLog(AuthManager.class);
    }
}

