/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.mapr.cli.JobLogLinkUtils;
import com.mapr.cli.SetupYarnAppLogLinks;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.mapred.DefaultJobHistoryParser;
import org.apache.hadoop.mapred.JobHistory;

public final class SetupJobLogLinks
extends CLIBaseClass
implements CLIInterface {
    private static final String CENTRAL_LOGVIEWDIR_PROP = "mapr.centrallogview.dir";
    private static final PathFilter jobLogFileFilter = new PathFilter(){

        public boolean accept(Path p) {
            String pathName = p.getName();
            return !pathName.endsWith(".xml") && !pathName.endsWith("_metrics");
        }
    };
    private static final Log LOG = LogFactory.getLog(SetupJobLogLinks.class);
    private final Configuration conf = new Configuration();
    private Path jobsDonePath;
    private String localVolumesPath;
    private String centralLogDirName;
    private String centralLogViewDirName;
    private FileSystem maprFS;

    public SetupJobLogLinks(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    private void createLogLinks(String jobNamePattern) throws IOException {
        Path historyLogDir = this.maprFS.makeQualified(this.jobsDonePath);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Parsing history at " + historyLogDir + " for jobid " + jobNamePattern));
        }
        Path jobGlob = new Path(historyLogDir, "[^_]*_[0-9]*_" + jobNamePattern + "*");
        Path[] jobLogs = FileUtil.stat2Paths((FileStatus[])this.maprFS.globStatus(jobGlob, jobLogFileFilter));
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Found " + jobLogs.length + " matches for " + jobGlob));
        }
        for (int i = 0; i < jobLogs.length; ++i) {
            Path jobviewPath;
            String fileName = JobHistory.JobInfo.decodeJobHistoryFileName((String)jobLogs[i].toString());
            String[] jobDetails = fileName.split("_");
            if (jobDetails.length < 5 || !"job".equals(jobDetails[2])) {
                LOG.warn((Object)"Histoty file name matches, but no job id could be parsed.");
                continue;
            }
            String jobId = jobDetails[2] + "_" + jobDetails[3] + "_" + jobDetails[4];
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Procesing " + jobId + " from file: " + jobLogs[i]));
            }
            if (!(jobviewPath = new Path(this.centralLogViewDirName + "/" + jobId)).isAbsolute()) {
                jobviewPath = new Path(this.maprFS.getHomeDirectory(), jobviewPath);
            }
            Path mappersPath = new Path(jobviewPath, "mappers");
            Path reducersPath = new Path(jobviewPath, "reducers");
            Path hostsPath = new Path(jobviewPath, "hosts");
            for (Path p : new Path[]{mappersPath, reducersPath, hostsPath}) {
                this.maprFS.mkdirs(p);
            }
            JobHistory.JobInfo jobInfo = new JobHistory.JobInfo(jobId);
            DefaultJobHistoryParser.parseJobTasks((String)jobLogs[i].toString(), (JobHistory.JobInfo)jobInfo, (FileSystem)this.maprFS);
            Map taskMap = jobInfo.getAllTasks();
            for (JobHistory.Task t : taskMap.values()) {
                Set attempts = t.getTaskAttempts().entrySet();
                for (Map.Entry te : attempts) {
                    String taskAttemptId = (String)te.getKey();
                    JobHistory.TaskAttempt task = (JobHistory.TaskAttempt)te.getValue();
                    String valhost = task.get(JobHistory.Keys.HOSTNAME);
                    if (valhost.isEmpty()) {
                        if (!LOG.isWarnEnabled()) continue;
                        LOG.warn((Object)("Skipping TaskAttempt record " + taskAttemptId + " due to missing key " + JobHistory.Keys.HOSTNAME));
                        continue;
                    }
                    int slashPos = valhost.lastIndexOf(47);
                    String host = valhost.substring(slashPos + 1);
                    Path attemptTargetPath = new Path(this.localVolumesPath + "/" + host + "/" + this.centralLogDirName + "/" + "mapred/userlogs" + "/" + jobId + "/" + taskAttemptId);
                    Path currentHostPath = new Path(hostsPath, host);
                    this.maprFS.mkdirs(currentHostPath);
                    Path hostCentricLinkPath = new Path(currentHostPath, taskAttemptId);
                    JobLogLinkUtils.createSymlinkIfAbsent(this.maprFS, attemptTargetPath, hostCentricLinkPath);
                    Path mapRedLinkPath = null;
                    if (task instanceof JobHistory.MapAttempt) {
                        mapRedLinkPath = new Path(mappersPath, taskAttemptId);
                    } else if (task instanceof JobHistory.ReduceAttempt) {
                        mapRedLinkPath = new Path(reducersPath, taskAttemptId);
                    }
                    if (mapRedLinkPath == null) {
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)("Unknown task type encountered: " + taskAttemptId));
                        continue;
                    }
                    JobLogLinkUtils.createSymlinkIfAbsent(this.maprFS, attemptTargetPath, mapRedLinkPath);
                }
            }
        }
    }

    private void evalConf() throws IOException {
        this.jobsDonePath = new Path(this.conf.get("mapred.job.tracker.history.completed.location", "/var/mapr/cluster/mapred/jobTracker/history/done"));
        this.localVolumesPath = this.conf.get("mapr.localvolumes.path", "/var/mapr/local");
        this.centralLogDirName = this.conf.get("mapr.centrallog.dir", "logs");
        this.centralLogViewDirName = this.conf.get(CENTRAL_LOGVIEWDIR_PROP, "/var/mapr/cluster/mapred/logview");
        this.maprFS = this.jobsDonePath.getFileSystem(this.conf);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        String confFile;
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        String jobidArg = this.getParamTextValue("jobid", 0);
        String jobid = jobidArg == null ? "" : jobidArg.trim();
        String viewDirArg = this.getParamTextValue("todir", 0);
        String viewDir = viewDirArg == null ? "" : viewDirArg.trim();
        String confFileArg = this.isParamPresent("jobconf") ? this.getParamTextValue("jobconf", 0) : null;
        String string = confFile = confFileArg == null ? "" : confFileArg.trim();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Parsed arguments: " + jobid + ", " + viewDir + ", " + confFile));
        }
        if (jobid.isEmpty()) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid job id: <" + jobidArg + ">"));
            return output;
        }
        if (jobid.startsWith("application")) {
            try {
                new SetupYarnAppLogLinks(jobid, viewDirArg).run();
            }
            catch (Exception e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Failed to create job log links." + e.getMessage()));
            }
            return output;
        }
        if (!jobid.startsWith("job")) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Expected job pattern should begin with \"job\"; pattern used : <" + jobidArg + ">"));
            return output;
        }
        if (!confFile.isEmpty()) {
            this.conf.addResource(new Path(confFile));
        }
        if (viewDir.isEmpty()) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid directory name: <" + viewDirArg + ">"));
            return output;
        }
        this.conf.set(CENTRAL_LOGVIEWDIR_PROP, viewDir);
        try {
            this.evalConf();
            this.createLogLinks(jobid);
        }
        catch (IOException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Failed to create job log links." + e.getMessage()));
        }
        return output;
    }
}

