/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.ByteString;
import com.mapr.baseutils.BinaryString;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.cli.DbCommands;
import com.mapr.cli.DbUpstreamCommands;
import com.mapr.cli.ElasticsearchCommands;
import com.mapr.cli.MapRCliUtil;
import com.mapr.cli.common.CopyTableCallable;
import com.mapr.cli.common.FileclientRun;
import com.mapr.cli.common.JobExecutor;
import com.mapr.cli.table.RecentTablesListManager;
import com.mapr.cli.table.RecentTablesListManagers;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.BooleanInputParameter;
import com.mapr.cliframework.base.inputparams.IntegerInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.db.impl.AdminImpl;
import com.mapr.db.impl.MapRDBTableImplHelper;
import com.mapr.fs.AceHelper;
import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.cldb.util.Util;
import com.mapr.fs.gateway.external.GatewaySink;
import com.mapr.fs.hbase.TableUtil;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Dbserver;
import com.mapr.fs.proto.Error;
import com.mapr.fs.proto.Marlinserver;
import com.mapr.fs.tables.MapRAdmin;
import com.mapr.fs.tables.TableProperties;
import com.mapr.streams.impl.admin.MarlinAdmin;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;

public class DbReplicaCommands
extends CLIBaseClass
implements CLIInterface,
AceHelper.DBPermission {
    private static final Logger LOG = Logger.getLogger(DbReplicaCommands.class);
    public static final String COLUMNS_PARAM_NAME = "columns";
    public static final String OUTPUT_PARAM_NAME = "output";
    public static final String START_PARAM_NAME = "start";
    public static final String LIMIT_PARAM_NAME = "limit";
    private static final String PATH_PARAM_NAME = "path";
    private static final String REPLICA_PARAM_NAME = "replica";
    private static final String NEWREPLICA_PARAM_NAME = "newreplica";
    private static final String PAUSED_PARAM_NAME = "paused";
    private static final String THROTTLE_PARAM_NAME = "throttle";
    private static final String ENCRYPTION_PARAM_NAME = "networkencryption";
    private static final String SYNCHRONOUS_PARAM_NAME = "synchronous";
    private static final String COMPRESSION_PARAM_NAME = "networkcompression";
    private static final String MULTI_ARG_SEP = ",";
    private static final String COLUMN_SEP = ":";
    private static final String REFRESH_PARAM_NAME = "refreshnow";
    private static final String WAIT_FOR_COMPLETION_PARAM_NAME = "waitforcompletion";
    private static final String MULTI_MASTER_PARAM_NAME = "multimaster";
    private static final String TICKET_PATH_PARAM_NAME = "ticketpath";
    private static final String MAPRDB_REPLICA_CLASS_NAME = "MapRDB";
    private static final String MAPRSTREAM_REPLICA_CLASS_NAME = "MapRStream";
    private static final CLICommand listCommand = new CLICommand("list", "usage: table replica list -path <tablepath>", DbReplicaCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "table path", true, null)).put((Object)"refreshnow", (Object)new BooleanInputParameter("refreshnow", "refreshnow", false, Boolean.valueOf(false))).put((Object)"columns", (Object)new TextInputParameter("columns", "columns", false, "all").setInvisible(true)).put((Object)"output", (Object)new TextInputParameter("output", "verbose|terse", false, "verbose").setInvisible(true)).put((Object)"start", (Object)new IntegerInputParameter("start", "start", false, Integer.valueOf(0)).setInvisible(true)).put((Object)"limit", (Object)new IntegerInputParameter("limit", "limit", false, Integer.valueOf(Integer.MAX_VALUE)).setInvisible(true)).build(), null).setShortUsage("table replica list -path <tablepath>");
    private static final CLICommand addCommand = new CLICommand("add", "usage: table replica add -path <tablePath> -replica <replicaPath> -columns <cf1[:col1],cf2,..> -paused <true|false> -throttle <true|false> -synchronous <true|false> -networkencryption <true|false> -networkcompression <off|on|lzf|lz4|zlib> ", DbReplicaCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "table path", true, null)).put((Object)"replica", (Object)new TextInputParameter("replica", "replica table path", true, null)).put((Object)"columns", (Object)new TextInputParameter("columns", "comma separated list of <family>[:<column>]", false, null)).put((Object)"paused", (Object)new BooleanInputParameter("paused", "is replication paused", false, Boolean.valueOf(false))).put((Object)"throttle", (Object)new BooleanInputParameter("throttle", "throttle replication ops", false, Boolean.valueOf(false))).put((Object)"networkencryption", (Object)new BooleanInputParameter("networkencryption", "enable on-wire encryption", false, Boolean.valueOf(false))).put((Object)"synchronous", (Object)new BooleanInputParameter("synchronous", "is synchronous replication", false, Boolean.valueOf(false))).put((Object)"networkcompression", (Object)new TextInputParameter("networkcompression", "on-wire compression type: off|on|lzf|lz4|zlib", false, "on")).build(), null).setShortUsage("table replica add -path <tablePath> -replica <replicaPath>");
    private static final CLICommand autoSetupCommand = new CLICommand("autosetup", "usage: table replica autosetup -path <tablePath> -replica <replicaPath> -columns <cf1[:col1],cf2,..>-multimaster <true/false>-waitforcompletion <true/false>-throttle <true|false> -synchronous <true|false> -networkencryption <true|false> -networkcompression <off|on|lzf|lz4|zlib> -ticketpath <path>", DbReplicaCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "table path", true, null)).put((Object)"replica", (Object)new TextInputParameter("replica", "replica table path", true, null)).put((Object)"columns", (Object)new TextInputParameter("columns", "comma separated list of <family>[:<column>]", false, null)).put((Object)"synchronous", (Object)new BooleanInputParameter("synchronous", "is synchronous replication", false, Boolean.valueOf(false))).put((Object)"multimaster", (Object)new BooleanInputParameter("multimaster", "is multi master replication", false, Boolean.valueOf(false))).put((Object)"throttle", (Object)new BooleanInputParameter("throttle", "throttle replication ops", false, Boolean.valueOf(false))).put((Object)"networkencryption", (Object)new BooleanInputParameter("networkencryption", "enable on-wire encryption", false, Boolean.valueOf(false))).put((Object)"networkcompression", (Object)new TextInputParameter("networkcompression", "on-wire compression type: off|on|lzf|lz4|zlib", false, "on")).put((Object)"waitforcompletion", (Object)new BooleanInputParameter("waitforcompletion", "wait for completion", false, Boolean.valueOf(true)).setInvisible(true)).put((Object)"ticketpath", (Object)new TextInputParameter("ticketpath", "ticket path", false, null).setInvisible(true)).build(), null).setShortUsage("table replica autosetup -path <tablePath> -replica <replicaPath>");
    private static final CLICommand editCommand = new CLICommand("edit", "usage: table replica edit -path <tablePath> -replica <replicaPath> -newreplica <newReplicaPath> -columns <cf1[:col1],cf2,..> -paused <true|false> -allowallcfs <true> -throttle <true|false> -synchronous <true|false> -networkencryption <true|false> -networkcompression <off|on|lzf|lz4|zlib> ", DbReplicaCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "table path", true, null)).put((Object)"replica", (Object)new TextInputParameter("replica", "replica table path", true, null)).put((Object)"newreplica", (Object)new TextInputParameter("newreplica", "renamed table path", false, null)).put((Object)"columns", (Object)new TextInputParameter("columns", "comma separated list of <family>[:<column>]", false, null)).put((Object)"throttle", (Object)new BooleanInputParameter("throttle", "throttle replication ops", false, null)).put((Object)"networkencryption", (Object)new BooleanInputParameter("networkencryption", "enable on-wire encryption", false, null)).put((Object)"synchronous", (Object)new BooleanInputParameter("synchronous", "is synchronous replication", false, null)).put((Object)"networkcompression", (Object)new TextInputParameter("networkcompression", "on-wire compression type: off|on|lzf|lz4|zlib", false, null)).build(), null).setShortUsage("table replica edit -path <tablePath> -replica <replicaPath> -newreplica <newReplicaPath> -columns <cf1[:col1],cf2,..> -paused <true|false> -allowallcfs <true> -throttle <true|false>  -synchronous <true|false> -networkencryption <true|false -networkcompression <off|on|lzf|lz4|zlib>");
    private static final CLICommand pauseCommand = new CLICommand("pause", "usage: table replica pause -path <tablePath> -replica <replicaPath>", DbReplicaCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "table path", true, null)).put((Object)"replica", (Object)new TextInputParameter("replica", "replica table path", true, null)).build(), null).setShortUsage("table replica pause -path <tablePath> -replica <replicaPath>");
    private static final CLICommand resumeCommand = new CLICommand("resume", "usage: table replica resume -path <tablePath> -replica <replicaPath>", DbReplicaCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "table path", true, null)).put((Object)"replica", (Object)new TextInputParameter("replica", "replica table path", true, null)).build(), null).setShortUsage("table replica resume -path <tablePath> -replica <replicaPath>");
    private static final CLICommand removeCommand = new CLICommand("remove", "usage: table replica remove -path <tablePath> -replica <replicaPath>", DbReplicaCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "table path", true, null)).put((Object)"replica", (Object)new TextInputParameter("replica", "replica table path", true, null)).build(), null).setShortUsage("table replica remove -path <tablePath> -replica <replicaPath>");
    public static final CLICommand replicaCommands = new CLICommand("replica", "replica [add|edit|list|remove|pause|resume|elasticsearch]", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{addCommand, editCommand, listCommand, removeCommand, pauseCommand, resumeCommand, autoSetupCommand, ElasticsearchCommands.esReplicaCommands}).setShortUsage("table replica [add|edit|list|remove|pause|resume|elasticsearch]");

    public DbReplicaCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        if (!super.validateInput()) {
            return output;
        }
        String cname = this.cliCommand.getCommandName();
        if (cname.equalsIgnoreCase(addCommand.getCommandName())) {
            this.addReplica(out);
        } else if (cname.equalsIgnoreCase(editCommand.getCommandName())) {
            this.editReplica(out);
        } else if (cname.equalsIgnoreCase(listCommand.getCommandName())) {
            this.listReplica(out);
        } else if (cname.equalsIgnoreCase(removeCommand.getCommandName())) {
            this.removeReplica(out);
        } else if (cname.equalsIgnoreCase(pauseCommand.getCommandName())) {
            this.pauseOrResumeReplica(out, true);
        } else if (cname.equalsIgnoreCase(resumeCommand.getCommandName())) {
            this.pauseOrResumeReplica(out, false);
        } else if (cname.equalsIgnoreCase(autoSetupCommand.getCommandName())) {
            this.autoSetup(out);
        }
        return output;
    }

    private String bytesToString(ByteString bstr) {
        return BinaryString.toStringBinary(bstr.toByteArray());
    }

    private ByteString stringToByteString(String raws) {
        byte[] bArr = BinaryString.toBytesBinary(raws);
        return ByteString.copyFrom((byte[])bArr);
    }

    public static Common.FileCompressionType getCompressionType(String cs) {
        if (cs.equalsIgnoreCase("off")) {
            return Common.FileCompressionType.FCT_OFF;
        }
        if (cs.equalsIgnoreCase("lz4") || cs.equalsIgnoreCase("on")) {
            return Common.FileCompressionType.FCT_LZ4;
        }
        if (cs.equalsIgnoreCase("lzf")) {
            return Common.FileCompressionType.FCT_LZF;
        }
        if (cs.equalsIgnoreCase("zlib")) {
            return Common.FileCompressionType.FCT_ZLIB;
        }
        return null;
    }

    public static String getCompressionName(Common.FileCompressionType ct) {
        if (ct == Common.FileCompressionType.FCT_OFF) {
            return "off";
        }
        if (ct == Common.FileCompressionType.FCT_LZ4) {
            return "lz4";
        }
        if (ct == Common.FileCompressionType.FCT_ZLIB) {
            return "zlib";
        }
        if (ct == Common.FileCompressionType.FCT_LZF || ct == Common.FileCompressionType.FCT_OLDLZF) {
            return "lzf";
        }
        return "unknown";
    }

    public String entityName() {
        return "table";
    }

    private void createJSONTableForCopy(String replicaPath, String srcPath, List<String> cfList, boolean isMarlinStream, boolean isBulkload) throws Exception {
        if (!isMarlinStream) {
            AdminImpl.createTableForCopy((String)replicaPath, (String)srcPath, cfList, (boolean)isBulkload);
        } else {
            MarlinAdmin.createStreamForCopy((String)replicaPath, (String)srcPath);
        }
    }

    private String getStreamDefaultJsonPathsForRepl(String streamDefaultCF) {
        if (streamDefaultCF == null || streamDefaultCF.isEmpty()) {
            return null;
        }
        StringBuilder defJP = new StringBuilder();
        String[] defCFs = streamDefaultCF.split(MULTI_ARG_SEP);
        int len = defCFs.length;
        for (int i = 0; i < len; ++i) {
            if (defCFs[i].equals("default")) {
                defCFs[i] = new String("");
            }
            defJP.append(defCFs[i]);
            if (i >= len - 1) continue;
            defJP.append(MULTI_ARG_SEP);
        }
        return defJP.toString();
    }

    protected void autoSetup(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        final String tablePath = DbCommands.getTransformedPath(this.getParamTextValue(PATH_PARAM_NAME, 0), this.getUserLoginId());
        final String replicaFullPath = DbCommands.getTransformedPath(this.getParamTextValue(REPLICA_PARAM_NAME, 0), this.getUserLoginId());
        final String colList = this.isParamPresent(COLUMNS_PARAM_NAME) ? this.getParamTextValue(COLUMNS_PARAM_NAME, 0) : null;
        final boolean isMultiMaster = this.isParamPresent(MULTI_MASTER_PARAM_NAME) ? this.getParamBooleanValue(MULTI_MASTER_PARAM_NAME, 0) : false;
        final boolean waitForCompletion = this.isParamPresent(WAIT_FOR_COMPLETION_PARAM_NAME) ? this.getParamBooleanValue(WAIT_FOR_COMPLETION_PARAM_NAME, 0) : false;
        final boolean isSync = this.isParamPresent(SYNCHRONOUS_PARAM_NAME) ? this.getParamBooleanValue(SYNCHRONOUS_PARAM_NAME, 0) : false;
        final String ticketPath = this.isParamPresent(TICKET_PATH_PARAM_NAME) ? this.getParamTextValue(TICKET_PATH_PARAM_NAME, 0) : null;
        final DbReplicaCommands dbPerm = this;
        final Dbserver.TableReplicaDesc.Builder replBuilder = Dbserver.TableReplicaDesc.newBuilder();
        try {
            new FileclientRun(this.getUserLoginId()){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void runAsProxyUser() throws IOException, CLIProcessingException {
                    Common.FileCompressionType ctype;
                    MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
                    boolean isReplicaTypeTable = !DbReplicaCommands.isExternalDestination(mfs, replicaFullPath);
                    int maxVersions = isReplicaTypeTable ? Integer.MAX_VALUE : 1;
                    String rCName = null;
                    Path path = new Path(tablePath);
                    if (!mfs.isTable(path)) {
                        throw new CLIProcessingException("Table not found. Path: " + tablePath);
                    }
                    TableProperties props = mfs.getTableProperties(path);
                    boolean isJson = props.getAttr().getJson();
                    boolean isMarlinStream = props.getAttr().getIsMarlinTable();
                    if (isJson && !isMarlinStream) {
                        throw new CLIProcessingException("Table replication autosetup not supported for table " + path.toString() + " of type 'json'.");
                    }
                    replBuilder.setIsPaused(true);
                    if (DbReplicaCommands.this.isParamPresent(DbReplicaCommands.THROTTLE_PARAM_NAME)) {
                        replBuilder.setThrottle(DbReplicaCommands.this.getParamBooleanValue(DbReplicaCommands.THROTTLE_PARAM_NAME, 0));
                    }
                    if (DbReplicaCommands.this.isParamPresent(DbReplicaCommands.ENCRYPTION_PARAM_NAME)) {
                        replBuilder.setEncryptonwire(DbReplicaCommands.this.getParamBooleanValue(DbReplicaCommands.ENCRYPTION_PARAM_NAME, 0));
                    }
                    if (DbReplicaCommands.this.isParamPresent(DbReplicaCommands.COMPRESSION_PARAM_NAME)) {
                        ctype = DbReplicaCommands.getCompressionType(DbReplicaCommands.this.getParamTextValue(DbReplicaCommands.COMPRESSION_PARAM_NAME, 0));
                        if (ctype == null) {
                            throw new CLIProcessingException("Invalid input values. The entered value for compression is not a supported type.");
                        }
                        replBuilder.setCompressonwire(ctype);
                    } else if (props.getAttr().getIsMarlinTable()) {
                        ctype = DbReplicaCommands.this.getStreamCompression(mfs, path);
                        replBuilder.setCompressonwire(ctype);
                    }
                    if (isSync) {
                        if (!isReplicaTypeTable) {
                            throw new CLIProcessingException("Can setup synchronous replication only when the replica is a MapRDB table.");
                        }
                        replBuilder.setSynchronous(DbReplicaCommands.this.getParamBooleanValue(DbReplicaCommands.SYNCHRONOUS_PARAM_NAME, 0));
                    }
                    if (isMultiMaster && !isReplicaTypeTable) {
                        throw new CLIProcessingException("Can setup multi-master replication only when the replica is a MapRDB table.");
                    }
                    if (isReplicaTypeTable) {
                        if (mfs.isTable(new Path(replicaFullPath))) {
                            LOG.info((Object)("Destination table: " + replicaFullPath + " exists already. Replication cannot be setup in auto mode"));
                            throw new CLIProcessingException("Destination table: " + replicaFullPath + " exists already. Replication cannot be setup in auto mode");
                        }
                        LOG.info((Object)("Creating the destination table: " + replicaFullPath + " as user: " + DbReplicaCommands.this.getUserLoginId()));
                        boolean isBulkLoad = true;
                        if (!isJson) {
                            List cfList = TableUtil.getColumnFamiliesList((String)colList);
                            if (props.getAttr().getIsMarlinTable()) {
                                isBulkLoad = false;
                            }
                            DbCommands.createTable(replicaFullPath, false, isBulkLoad, null, false, false, null, DbReplicaCommands.this.getUserLoginId(), tablePath, dbPerm, 15, cfList, -1, isJson, false);
                        } else {
                            List cfList = MapRDBTableImplHelper.getColumnFamiliesList((String)colList);
                            try {
                                DbReplicaCommands.this.createJSONTableForCopy(replicaFullPath, tablePath, cfList, isMarlinStream, isBulkLoad);
                            }
                            catch (Exception e) {
                                throw new CLIProcessingException("Failed to create replica " + replicaFullPath + " due to an exception: " + e.getMessage());
                            }
                        }
                        LOG.info((Object)"Finished creating destination table");
                    } else {
                        replBuilder.setExternal(true);
                        rCName = DbReplicaCommands.verifyExternalDstSanity(mfs, replicaFullPath);
                    }
                    String clist = colList;
                    if (clist == null && isMarlinStream) {
                        clist = DbReplicaCommands.getStreamDefaultCFsForRepl();
                    }
                    DbReplicaCommands.setupReplication(dbPerm, replBuilder, tablePath, replicaFullPath, clist, DbReplicaCommands.this.getUserLoginId(), mfs, rCName);
                    if (isReplicaTypeTable) {
                        LOG.info((Object)"Creating upstream");
                        DbUpstreamCommands.addUpStream(replicaFullPath, tablePath, DbReplicaCommands.this.getUserLoginId());
                        LOG.info((Object)"Finished creating upstream");
                    }
                    if (!isReplicaTypeTable && isMultiMaster) {
                        throw new CLIProcessingException("Can setup multi-master replication only when the replica is a MapRDB table.");
                    }
                    DbReplicaCommands.copyTable(tablePath, replicaFullPath, maxVersions, DbReplicaCommands.this.getStreamDefaultJsonPathsForRepl(clist), DbReplicaCommands.this.getUserLoginId(), waitForCompletion, ticketPath, isMultiMaster, dbPerm, replBuilder);
                }
            };
        }
        catch (CLIProcessingException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, e.getMessage()));
        }
        catch (IOException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10002, e.getMessage()));
        }
    }

    public static String verifyExternalDstSanity(MapRFileSystem mfs, String replicaFullPathStr) throws CLIProcessingException, IOException {
        String className = null;
        try {
            className = GatewaySink.verifyDstSanity((String)replicaFullPathStr);
        }
        catch (Exception e) {
            throw new CLIProcessingException(e.getMessage());
        }
        return className;
    }

    public static void setupMultiMaster(AceHelper.DBPermission dbPerm, Dbserver.TableReplicaDesc.Builder replBuilder, String tablePath, String replicaFullPath, String colList, String user) throws IOException, CLIProcessingException {
        MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
        TableProperties rtableProp = mfs.getTableProperties(new Path(tablePath));
        if (rtableProp.getUuid() == null || rtableProp.getUuid().length == 0) {
            throw new IOException("replica table does not have a uuid");
        }
        replBuilder.setTableUuid(ByteString.copyFrom((byte[])rtableProp.getUuid()));
        replBuilder.setIsPaused(false);
        DbReplicaCommands.setupReplication(dbPerm, replBuilder, replicaFullPath, tablePath, null, user, mfs, null);
        LOG.info((Object)"Creating upstream for source table in multi-master replication");
        DbUpstreamCommands.addUpStream(tablePath, replicaFullPath, user);
        LOG.info((Object)"Finished creating upstream for source table in multi-master replication");
    }

    public static String verifyExternalDstSanity(String dstTable) throws CLIProcessingException, IOException {
        return DbReplicaCommands.verifyExternalDstSanity(MapRCliUtil.getMapRFileSystem(), dstTable);
    }

    public static boolean isExternalDestination(MapRFileSystem mfs, String dstTable) throws IOException {
        Path replicaPath = new Path(dstTable);
        return mfs.isFile(replicaPath) && !mfs.isTable(replicaPath);
    }

    public static boolean isExternalDestination(String dstTable) throws IOException, CLIProcessingException {
        return DbReplicaCommands.isExternalDestination(MapRCliUtil.getMapRFileSystem(), dstTable);
    }

    protected void addReplica(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        final String tablePath = DbCommands.getTransformedPath(this.getParamTextValue(PATH_PARAM_NAME, 0), this.getUserLoginId());
        final String replicaFullPath = DbCommands.getTransformedPath(this.getParamTextValue(REPLICA_PARAM_NAME, 0), this.getUserLoginId());
        final String colList = this.isParamPresent(COLUMNS_PARAM_NAME) ? this.getParamTextValue(COLUMNS_PARAM_NAME, 0) : null;
        final boolean isSync = this.isParamPresent(SYNCHRONOUS_PARAM_NAME) ? this.getParamBooleanValue(SYNCHRONOUS_PARAM_NAME, 0) : false;
        boolean validatePeer = true;
        final Dbserver.TableReplicaDesc.Builder replBuilder = Dbserver.TableReplicaDesc.newBuilder();
        final DbReplicaCommands dbPerm = this;
        try {
            new FileclientRun(this.getUserLoginId()){

                @Override
                public void runAsProxyUser() throws IOException, CLIProcessingException {
                    Common.FileCompressionType ctype;
                    MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
                    boolean isReplicaTypeTable = !DbReplicaCommands.isExternalDestination(mfs, replicaFullPath);
                    Path path = new Path(tablePath);
                    String rCName = null;
                    if (!mfs.isTable(path)) {
                        throw new CLIProcessingException("Table not found. Path: " + tablePath);
                    }
                    TableProperties props = mfs.getTableProperties(path);
                    boolean isJson = props.getAttr().getJson();
                    boolean isMarlinStream = props.getAttr().getIsMarlinTable();
                    if (isJson && !isMarlinStream) {
                        throw new CLIProcessingException("Table replica add not supported for table " + path.toString() + " of type 'json'.");
                    }
                    if (isReplicaTypeTable) {
                        Path rpath = new Path(replicaFullPath);
                        if (!mfs.isTable(rpath)) {
                            throw new CLIProcessingException("Replica table does not exist. Path: " + replicaFullPath);
                        }
                        TableProperties rprops = mfs.getTableProperties(rpath);
                        if (props.getAttr().getIsMarlinTable() != rprops.getAttr().getIsMarlinTable()) {
                            String msg = tablePath + " is " + (props.getAttr().getIsMarlinTable() ? "" : " not ") + "a stream, but replica " + replicaFullPath + " is " + (rprops.getAttr().getIsMarlinTable() ? "" : "not ") + "a stream";
                            throw new CLIProcessingException(msg);
                        }
                        if (props.getAttr().getJson() != rprops.getAttr().getJson()) {
                            String msg = tablePath + " is " + (props.getAttr().getJson() ? "" : " not ") + "a json table, but replica " + replicaFullPath + " is " + (rprops.getAttr().getJson() ? "" : "not ") + "a json table";
                            throw new CLIProcessingException(msg);
                        }
                    }
                    if (DbReplicaCommands.this.isParamPresent(DbReplicaCommands.PAUSED_PARAM_NAME)) {
                        replBuilder.setIsPaused(DbReplicaCommands.this.getParamBooleanValue(DbReplicaCommands.PAUSED_PARAM_NAME, 0));
                    }
                    if (DbReplicaCommands.this.isParamPresent(DbReplicaCommands.THROTTLE_PARAM_NAME)) {
                        replBuilder.setThrottle(DbReplicaCommands.this.getParamBooleanValue(DbReplicaCommands.THROTTLE_PARAM_NAME, 0));
                    }
                    if (DbReplicaCommands.this.isParamPresent(DbReplicaCommands.ENCRYPTION_PARAM_NAME)) {
                        replBuilder.setEncryptonwire(DbReplicaCommands.this.getParamBooleanValue(DbReplicaCommands.ENCRYPTION_PARAM_NAME, 0));
                    }
                    if (DbReplicaCommands.this.isParamPresent(DbReplicaCommands.COMPRESSION_PARAM_NAME)) {
                        ctype = DbReplicaCommands.getCompressionType(DbReplicaCommands.this.getParamTextValue(DbReplicaCommands.COMPRESSION_PARAM_NAME, 0));
                        if (ctype == null) {
                            throw new CLIProcessingException("Invalid input values. The entered value for compression is not a supported type.");
                        }
                        replBuilder.setCompressonwire(ctype);
                    } else if (props.getAttr().getIsMarlinTable()) {
                        ctype = DbReplicaCommands.this.getStreamCompression(mfs, path);
                        replBuilder.setCompressonwire(ctype);
                    }
                    if (isSync) {
                        if (isReplicaTypeTable) {
                            replBuilder.setSynchronous(DbReplicaCommands.this.getParamBooleanValue(DbReplicaCommands.SYNCHRONOUS_PARAM_NAME, 0));
                        } else {
                            throw new CLIProcessingException("Can use synchronous replication only when the replica is a MapRDB table.");
                        }
                    }
                    if (!isReplicaTypeTable) {
                        rCName = DbReplicaCommands.verifyExternalDstSanity(mfs, replicaFullPath);
                        replBuilder.setExternal(true);
                    }
                    String clist = colList;
                    if (colList == null && isMarlinStream) {
                        clist = DbReplicaCommands.getStreamDefaultCFsForRepl();
                    }
                    DbReplicaCommands.setupReplication(dbPerm, replBuilder, tablePath, replicaFullPath, clist, DbReplicaCommands.this.getUserLoginId(), mfs, rCName);
                }
            };
        }
        catch (CLIProcessingException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, e.getMessage()));
        }
        catch (IOException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
    }

    public static void parseColList(String colList, Map<Integer, SortedSet<String>> familyMap, String tablePath, String user) throws CLIProcessingException {
        List<Dbserver.ColumnFamilyAttr> familyAttrs;
        if (colList == null || familyMap == null) {
            return;
        }
        try {
            familyAttrs = DbReplicaCommands.getAllFamilies(tablePath, user);
        }
        catch (IOException e) {
            throw new CLIProcessingException(e.getMessage());
        }
        for (String entry : colList.split(MULTI_ARG_SEP)) {
            String[] names = entry.split(COLUMN_SEP, 2);
            int famId = DbReplicaCommands.familyNameToId(familyAttrs, names[0]);
            SortedSet<String> cols = familyMap.get(famId);
            if (famId == 0) {
                throw new CLIProcessingException("count not get familyId for columnFamily " + names[0]);
            }
            if (cols == null) {
                cols = new TreeSet<String>();
                familyMap.put(famId, cols);
            }
            if (names.length <= 1 || names[1].length() <= 0) continue;
            cols.add(names[1]);
        }
    }

    public static void addCfQualifiers(Map<Integer, SortedSet<String>> familyMap, Dbserver.TableReplicaDesc.Builder replBuilder) {
        for (Map.Entry<Integer, SortedSet<String>> entry : familyMap.entrySet()) {
            Dbserver.Qualifier.Builder qualBuilder = Dbserver.Qualifier.newBuilder();
            qualBuilder.setFamily(entry.getKey().intValue());
            for (String colName : entry.getValue()) {
                qualBuilder.addQualifiers(ByteString.copyFrom((byte[])colName.getBytes()));
            }
            replBuilder.addQualifiers(qualBuilder.build());
        }
    }

    private static String getStreamDefaultCFsForRepl() {
        Marlinserver.MarlinInternalDefaults mdef = Marlinserver.MarlinInternalDefaults.getDefaultInstance();
        return mdef.getCfTopicMeta() + MULTI_ARG_SEP + mdef.getCfMessages() + MULTI_ARG_SEP + mdef.getCfCursors();
    }

    private Common.FileCompressionType getStreamCompression(MapRFileSystem mfs, Path stream) throws IOException {
        MapRAdmin madmin = new MapRAdmin(mfs);
        Marlinserver.MarlinInternalDefaults mdef = Marlinserver.MarlinInternalDefaults.getDefaultInstance();
        Dbserver.ColumnFamilyAttr cfAttr = madmin.getColumnFamily(stream, mdef.getCfMessages(), false);
        return cfAttr.getSchFamily().getCompression();
    }

    public static void setupReplication(AceHelper.DBPermission dbPerm, Dbserver.TableReplicaDesc.Builder replBuilder, String tablePath, String replicaFullPath, String clist, String user, MapRFileSystem mfs, String replicaClassName) throws CLIProcessingException, IOException {
        RecentTablesListManager manager = RecentTablesListManagers.getRecentTablesListManagerForUser(user);
        try {
            boolean isReplicaTypeTable;
            TableProperties tableProp = mfs.getTableProperties(new Path(tablePath));
            if (tableProp.getUuid() == null || tableProp.getUuid().length == 0) {
                throw new IOException("Table " + tablePath + " does not have a uuid." + " Set replperm and retry operation");
            }
            boolean bl = isReplicaTypeTable = !DbReplicaCommands.isExternalDestination(mfs, replicaFullPath);
            if (isReplicaTypeTable) {
                TableProperties replicaTableProp = mfs.getTableProperties(new Path(replicaFullPath));
                if (replicaTableProp.getUuid() == null || replicaTableProp.getUuid().length == 0) {
                    throw new IOException("Replica table " + replicaFullPath + " does not have a uuid." + " Set replperm and retry operation");
                }
                replBuilder.setTableUuid(ByteString.copyFrom((byte[])replicaTableProp.getUuid()));
            }
            if (tableProp.getAttr().getBulkLoad()) {
                throw new CLIProcessingException("source cannot be in bulkload mode. Path: " + tablePath);
            }
            String colList = clist;
            if (colList != null && colList.length() > 0) {
                TreeMap<Integer, SortedSet<String>> familyMap = new TreeMap<Integer, SortedSet<String>>();
                DbReplicaCommands.parseColList(colList, familyMap, tablePath, user);
                if (familyMap.isEmpty()) {
                    throw new CLIProcessingException("empty list invalid for param columns");
                }
                DbReplicaCommands.addCfQualifiers(familyMap, replBuilder);
            }
            if (replicaClassName == null) {
                if (tableProp.getAttr().getIsMarlinTable()) {
                    replBuilder.setReplicaClassName(MAPRSTREAM_REPLICA_CLASS_NAME);
                } else {
                    replBuilder.setReplicaClassName(MAPRDB_REPLICA_CLASS_NAME);
                }
            } else {
                replBuilder.setReplicaClassName(replicaClassName);
            }
            Path rpath = new Path(replicaFullPath);
            String clusterName = mfs.getClusterName(rpath.toUri());
            replBuilder.setClusterName(clusterName);
            String replicaPath = mfs.getNameStr(replicaFullPath);
            replBuilder.setTablePath(replicaPath);
            if (!(replBuilder.hasExternal() && replBuilder.getExternal() || mfs.isTable(rpath))) {
                throw new CLIProcessingException("Replica should be a table. Path: " + replicaPath);
            }
            if (clusterName.equals(mfs.getClusterNameUnchecked(tablePath)) && replicaPath.equals(mfs.getNameStr(tablePath))) {
                throw new CLIProcessingException("source and replica tables cannot be same");
            }
            Dbserver.TableReplicaDesc replDesc = replBuilder.build();
            mfs.addTableReplica(new Path(tablePath), replDesc);
            manager.moveToTop(tablePath);
        }
        catch (Exception e) {
            manager.deleteIfNotExist(tablePath, mfs);
            throw new CLIProcessingException(e.getMessage());
        }
    }

    public static void copyTable(String tablePath, String replicaFullPath, int maxVersions, String colList, String user, boolean waitForCompletion, String ticketPath, boolean isMultiMaster, AceHelper.DBPermission dbPerm, Dbserver.TableReplicaDesc.Builder replBuilder) throws CLIProcessingException {
        ExecutorService execService = JobExecutor.getExecutorService();
        CopyTableCallable copyTableTask = new CopyTableCallable(tablePath, replicaFullPath, user, maxVersions, colList, ticketPath, isMultiMaster, dbPerm, replBuilder);
        LOG.info((Object)("Calling copy table for tables: " + tablePath + MULTI_ARG_SEP + replicaFullPath + " by user: " + user));
        Future<Integer> status = execService.submit(copyTableTask);
        if (waitForCompletion) {
            try {
                if (status.get() == null) {
                    throw new CLIProcessingException("Copy Table failed for tables: " + tablePath + MULTI_ARG_SEP + replicaFullPath);
                }
            }
            catch (Exception e) {
                throw new CLIProcessingException(e.getMessage());
            }
        }
    }

    private boolean isExternalReplicaClass(String className) {
        return !className.equals(MAPRDB_REPLICA_CLASS_NAME) && !className.equals(MAPRSTREAM_REPLICA_CLASS_NAME);
    }

    protected void listReplica(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        final boolean refreshNow = this.isParamPresent(REFRESH_PARAM_NAME) ? this.getParamBooleanValue(REFRESH_PARAM_NAME, 0) : false;
        final String tablePath = DbCommands.getTransformedPath(this.getParamTextValue(PATH_PARAM_NAME, 0), this.getUserLoginId());
        final RecentTablesListManager manager = RecentTablesListManagers.getRecentTablesListManagerForUser(this.getUserLoginId());
        final ArrayList rlist = new ArrayList();
        try {
            new FileclientRun(this.getUserLoginId()){

                @Override
                public void runAsProxyUser() throws IOException, CLIProcessingException {
                    MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
                    try {
                        if (!mfs.isTable(new Path(tablePath))) {
                            throw new CLIProcessingException("Table not found. Path: " + tablePath);
                        }
                        Dbserver.TableReplicaListResponse resp = mfs.listTableReplicas(new Path(tablePath), true, refreshNow);
                        rlist.add(resp);
                        manager.moveToTop(tablePath);
                    }
                    catch (IOException e) {
                        manager.deleteIfNotExist(tablePath, mfs);
                        throw new CLIProcessingException(e.getMessage());
                    }
                }
            };
            Dbserver.TableReplicaListResponse listResp = (Dbserver.TableReplicaListResponse)rlist.get(0);
            List<Dbserver.ColumnFamilyAttr> familyAttrs = DbReplicaCommands.getAllFamilies(tablePath, this.getUserLoginId());
            for (Dbserver.TableReplicaDesc rd : listResp.getReplicasList()) {
                boolean isExternal = this.isExternalReplicaClass(rd.getReplicaClassName());
                CommandOutput.OutputHierarchy.OutputNode replNode = new CommandOutput.OutputHierarchy.OutputNode();
                replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("cluster", (Object)rd.getClusterName()));
                if (!isExternal) {
                    replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.entityName(), (Object)rd.getTablePath()));
                    replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("type", (Object)rd.getReplicaClassName()));
                } else {
                    replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.entityName(), (Object)GatewaySink.getDestinationName((String)rd.getTablePath())));
                    replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("type", (Object)GatewaySink.getDestinationType((String)rd.getTablePath())));
                }
                replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("realTablePath", (Object)rd.getTablePath()));
                replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(PAUSED_PARAM_NAME, (Object)rd.getIsPaused()));
                replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(THROTTLE_PARAM_NAME, (Object)rd.getThrottle()));
                replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("idx", rd.getIdx()));
                replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(ENCRYPTION_PARAM_NAME, (Object)rd.getEncryptonwire()));
                replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(SYNCHRONOUS_PARAM_NAME, (Object)rd.getSynchronous()));
                replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(COMPRESSION_PARAM_NAME, (Object)DbReplicaCommands.getCompressionName(rd.getCompressonwire())));
                if (this.entityName().equals("table") && rd.getQualifiersCount() > 0) {
                    String famList = "";
                    int idx = 0;
                    for (Dbserver.Qualifier qual : rd.getQualifiersList()) {
                        String famName = DbReplicaCommands.familyIdToName(familyAttrs, qual.getFamily());
                        if (famName == null) {
                            LOG.error((Object)("failed to get family name for id " + qual.getFamily()));
                        }
                        if (qual.getQualifiersCount() > 0) {
                            for (ByteString bstr : qual.getQualifiersList()) {
                                famList = idx == 0 ? famName + COLUMN_SEP + bstr.toStringUtf8() : famList + MULTI_ARG_SEP + famName + COLUMN_SEP + bstr.toStringUtf8();
                                ++idx;
                            }
                            continue;
                        }
                        if (idx == 0) {
                            famList = famName;
                            ++idx;
                            continue;
                        }
                        famList = famList + MULTI_ARG_SEP + famName;
                        ++idx;
                    }
                    replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("Columns", (Object)famList));
                }
                String replicaTablePath = DbReplicaCommands.getTransformedTablePath(rd.getClusterName(), rd.getTablePath());
                if (JobExecutor.getStatus(tablePath + "_" + replicaTablePath) != null) {
                    replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("copytablestatus", (Object)JobExecutor.getStatus(tablePath + "_" + replicaTablePath)));
                }
                long minPendingTS = 0L;
                long maxPendingTS = 0L;
                long bytesPending = 0L;
                long putsPending = 0L;
                int bucketsPending = 0;
                int asyncBuckets = 0;
                ArrayList<Error.ExtendedError> elist = null;
                for (Dbserver.TableReplicaStatus rs : listResp.getReplicaStatusList()) {
                    if (rd.getIdx() != rs.getReplicaIdx()) continue;
                    minPendingTS = rs.getMinPendingTS();
                    maxPendingTS = rs.getMaxPendingTS();
                    bytesPending = rs.getBytesPending();
                    putsPending = rs.getPutsPending();
                    bucketsPending = rs.getBucketsPending();
                    asyncBuckets = rs.getAsyncBuckets();
                    for (Error.ExtendedError ee : rs.getEerrorsList()) {
                        if (elist == null) {
                            elist = new ArrayList<Error.ExtendedError>();
                        }
                        elist.add(ee);
                    }
                }
                replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("isUptodate", (Object)(bucketsPending == 0 && !rd.getIsPaused() ? 1 : 0)));
                replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("minPendingTS", minPendingTS));
                replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("maxPendingTS", maxPendingTS));
                replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("bytesPending", bytesPending));
                if (this.entityName().equals("table")) {
                    replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("putsPending", putsPending));
                }
                replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("bucketsPending", bucketsPending));
                byte[] uuid = rd.getTableUuid().toByteArray();
                replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("uuid", (Object)BinaryString.toUUIDString(uuid)));
                if (rd.getSynchronous()) {
                    replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("numAsyncBuckets", asyncBuckets));
                    replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("switchedToAsync", (Object)(asyncBuckets != 0 ? 1 : 0)));
                }
                if (elist != null) {
                    for (Error.ExtendedError ee : elist) {
                        CommandOutput.OutputHierarchy.OutputNode errNodes = new CommandOutput.OutputHierarchy.OutputNode("errors");
                        replNode.addChild(errNodes);
                        if (ee.hasEcode()) {
                            errNodes.addChild(new CommandOutput.OutputHierarchy.OutputNode("Code", (Object)ee.getEcode().name()));
                        }
                        if (ee.hasEhost()) {
                            errNodes.addChild(new CommandOutput.OutputHierarchy.OutputNode("Host", (Object)Util.intToIp((int)ee.getEhost())));
                        }
                        if (!ee.hasEmsg()) continue;
                        errNodes.addChild(new CommandOutput.OutputHierarchy.OutputNode("Msg", (Object)ee.getEmsg()));
                    }
                }
                out.addNode(replNode);
            }
        }
        catch (CLIProcessingException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
        catch (IOException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
    }

    public static String getTransformedTablePath(String clusterName, String tableName) {
        if (!clusterName.equals(CLDBRpcCommonUtils.getInstance().getCurrentClusterName())) {
            return "/mapr/" + clusterName + tableName;
        }
        return tableName;
    }

    protected void editReplica(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        final String tablePath = DbCommands.getTransformedPath(this.getParamTextValue(PATH_PARAM_NAME, 0), this.getUserLoginId());
        final String replicaFullPath = DbCommands.getTransformedPath(this.getParamTextValue(REPLICA_PARAM_NAME, 0), this.getUserLoginId());
        final Dbserver.TableReplicaDesc.Builder replBuilder = Dbserver.TableReplicaDesc.newBuilder();
        final int replDescSerializedSize = replBuilder.build().getSerializedSize();
        final boolean isSync = this.isParamPresent(SYNCHRONOUS_PARAM_NAME) ? this.getParamBooleanValue(SYNCHRONOUS_PARAM_NAME, 0) : false;
        try {
            new FileclientRun(this.getUserLoginId()){

                @Override
                public void runAsProxyUser() throws IOException, CLIProcessingException {
                    boolean allowAllCfs;
                    boolean isReplicaTypeTable;
                    MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
                    String replicaClusterName = mfs.getClusterNameUnchecked(replicaFullPath);
                    String replicaPath = mfs.getNameStr(replicaFullPath);
                    boolean bl = isReplicaTypeTable = !DbReplicaCommands.isExternalDestination(mfs, replicaFullPath);
                    if (DbReplicaCommands.this.isParamPresent(DbReplicaCommands.NEWREPLICA_PARAM_NAME)) {
                        Dbserver.TableReplicaDesc rd = DbReplicaCommands.this.getReplica(tablePath, replicaClusterName, replicaPath);
                        if (rd == null) {
                            throw new IOException("Replica not found");
                        }
                        if (rd.hasExternal() && rd.getExternal()) {
                            throw new CLIProcessingException("Can not rename an external replica");
                        }
                        String newReplicaFullPath = DbCommands.getTransformedPath(DbReplicaCommands.this.getParamTextValue(DbReplicaCommands.NEWREPLICA_PARAM_NAME, 0), DbReplicaCommands.this.getUserLoginId());
                        Path newRpath = new Path(newReplicaFullPath);
                        String newReplicaClusterName = mfs.getClusterName(newRpath.toUri());
                        replBuilder.setClusterName(newReplicaClusterName);
                        String newReplicaPath = mfs.getNameStr(newReplicaFullPath);
                        replBuilder.setTablePath(newReplicaPath);
                        if (!mfs.isTable(new Path(tablePath))) {
                            throw new CLIProcessingException("Table not found. Path: " + tablePath);
                        }
                        if (!mfs.isTable(newRpath)) {
                            throw new CLIProcessingException("New Replica not found. Path: " + newReplicaPath);
                        }
                        if (newReplicaClusterName.equals(mfs.getClusterNameUnchecked(tablePath)) && newReplicaPath.equals(mfs.getNameStr(tablePath))) {
                            throw new CLIProcessingException("source and replica tables cannot be same");
                        }
                        TableProperties rtableProp = mfs.getTableProperties(newRpath);
                        if (rtableProp.getUuid() == null || rtableProp.getUuid().length == 0) {
                            throw new IOException("replica table does not have a uuid");
                        }
                        replBuilder.setTableUuid(ByteString.copyFrom((byte[])rtableProp.getUuid()));
                    }
                    if (DbReplicaCommands.this.isParamPresent(DbReplicaCommands.COMPRESSION_PARAM_NAME)) {
                        boolean updateCompression = false;
                        String compressionStr = DbReplicaCommands.this.getParamTextValue(DbReplicaCommands.COMPRESSION_PARAM_NAME, 0);
                        if (compressionStr.equals("on")) {
                            Dbserver.TableReplicaDesc rd = DbReplicaCommands.this.getReplica(tablePath, replicaClusterName, replicaPath);
                            if (rd == null) {
                                throw new IOException("Replica not found");
                            }
                            if (!rd.hasCompressonwire() || rd.getCompressonwire() == Common.FileCompressionType.FCT_OFF) {
                                updateCompression = true;
                            }
                        } else {
                            updateCompression = true;
                        }
                        if (updateCompression) {
                            Common.FileCompressionType ctype = DbReplicaCommands.getCompressionType(compressionStr);
                            if (ctype == null) {
                                throw new CLIProcessingException("Invalid input values. The entered value for compression is not a supported type.");
                            }
                            replBuilder.setCompressonwire(ctype);
                        }
                    }
                    boolean bl2 = DbReplicaCommands.this.isParamPresent(DbReplicaCommands.COLUMNS_PARAM_NAME) ? DbReplicaCommands.this.getParamTextValue(DbReplicaCommands.COLUMNS_PARAM_NAME, 0).trim().length() == 0 : (allowAllCfs = false);
                    if (!allowAllCfs && DbReplicaCommands.this.isParamPresent(DbReplicaCommands.COLUMNS_PARAM_NAME)) {
                        String colList = DbReplicaCommands.this.getParamTextValue(DbReplicaCommands.COLUMNS_PARAM_NAME, 0);
                        TreeMap<Integer, SortedSet<String>> familyMap = new TreeMap<Integer, SortedSet<String>>();
                        String user = DbReplicaCommands.this.getUserLoginId();
                        String tablePath2 = DbCommands.getTransformedPath(DbReplicaCommands.this.getParamTextValue(DbReplicaCommands.PATH_PARAM_NAME, 0), user);
                        DbReplicaCommands.parseColList(colList, familyMap, tablePath2, user);
                        DbReplicaCommands.addCfQualifiers(familyMap, replBuilder);
                    }
                    if (DbReplicaCommands.this.isParamPresent(DbReplicaCommands.THROTTLE_PARAM_NAME)) {
                        replBuilder.setThrottle(DbReplicaCommands.this.getParamBooleanValue(DbReplicaCommands.THROTTLE_PARAM_NAME, 0));
                    }
                    if (DbReplicaCommands.this.isParamPresent(DbReplicaCommands.ENCRYPTION_PARAM_NAME)) {
                        replBuilder.setEncryptonwire(DbReplicaCommands.this.getParamBooleanValue(DbReplicaCommands.ENCRYPTION_PARAM_NAME, 0));
                    }
                    if (DbReplicaCommands.this.isParamPresent(DbReplicaCommands.SYNCHRONOUS_PARAM_NAME)) {
                        if (isSync && !isReplicaTypeTable) {
                            throw new CLIProcessingException("Can setup synchronous replication only when the replica is a MapRDB table.");
                        }
                        replBuilder.setSynchronous(isSync);
                    }
                    if (replDescSerializedSize == replBuilder.build().getSerializedSize() && !allowAllCfs) {
                        return;
                    }
                    RecentTablesListManager manager = RecentTablesListManagers.getRecentTablesListManagerForUser(DbReplicaCommands.this.getUserLoginId());
                    try {
                        if (!mfs.isTable(new Path(tablePath))) {
                            throw new CLIProcessingException("Table not found. Path: " + tablePath);
                        }
                        Dbserver.TableReplicaDesc replDesc = replBuilder.build();
                        mfs.editTableReplica(new Path(tablePath), replicaClusterName, replicaPath, allowAllCfs, replDesc);
                        manager.moveToTop(tablePath);
                    }
                    catch (IOException e) {
                        manager.deleteIfNotExist(tablePath, mfs);
                        throw new CLIProcessingException(e.getMessage());
                    }
                }
            };
        }
        catch (CLIProcessingException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, e.getMessage()));
            return;
        }
        catch (IOException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
            return;
        }
    }

    protected void removeReplica(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        final String tablePath = DbCommands.getTransformedPath(this.getParamTextValue(PATH_PARAM_NAME, 0), this.getUserLoginId());
        final String replicaFullPath = DbCommands.getTransformedPath(this.getParamTextValue(REPLICA_PARAM_NAME, 0), this.getUserLoginId());
        final Dbserver.TableReplicaDesc.Builder replBuilder = Dbserver.TableReplicaDesc.newBuilder();
        final RecentTablesListManager manager = RecentTablesListManagers.getRecentTablesListManagerForUser(this.getUserLoginId());
        try {
            new FileclientRun(this.getUserLoginId()){

                @Override
                public void runAsProxyUser() throws IOException, CLIProcessingException {
                    MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
                    try {
                        Path rpath = new Path(replicaFullPath);
                        String clusterName = mfs.getClusterNameUnchecked(replicaFullPath);
                        replBuilder.setClusterName(clusterName);
                        String replicaPath = mfs.getNameStr(replicaFullPath);
                        replBuilder.setTablePath(replicaPath);
                        Dbserver.TableReplicaDesc replDesc = replBuilder.build();
                        if (!mfs.isTable(new Path(tablePath))) {
                            throw new CLIProcessingException("Table not found. Path: " + tablePath);
                        }
                        mfs.removeTableReplica(new Path(tablePath), replDesc);
                        manager.moveToTop(tablePath);
                    }
                    catch (IOException e) {
                        manager.deleteIfNotExist(tablePath, mfs);
                        throw new CLIProcessingException(e.getMessage());
                    }
                }
            };
        }
        catch (CLIProcessingException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
        catch (IOException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
    }

    public static void pauseOrResumeReplication(final String tablePath, final String replicaFullPath, boolean isPaused, String loginId) throws IOException, CLIProcessingException {
        final Dbserver.TableReplicaDesc.Builder replBuilder = Dbserver.TableReplicaDesc.newBuilder();
        replBuilder.setIsPaused(isPaused);
        final RecentTablesListManager manager = RecentTablesListManagers.getRecentTablesListManagerForUser(loginId);
        try {
            new FileclientRun(loginId){

                @Override
                public void runAsProxyUser() throws IOException, CLIProcessingException {
                    MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
                    try {
                        Path rpath = new Path(replicaFullPath);
                        String replicaClusterName = mfs.getClusterNameUnchecked(replicaFullPath);
                        String replicaPath = mfs.getNameStr(replicaFullPath);
                        if (!mfs.isTable(new Path(tablePath))) {
                            throw new CLIProcessingException("Table not found. Path: " + tablePath);
                        }
                        Dbserver.TableReplicaDesc replDesc = replBuilder.build();
                        mfs.editTableReplica(new Path(tablePath), replicaClusterName, replicaPath, false, replDesc);
                    }
                    catch (IOException e) {
                        manager.deleteIfNotExist(tablePath, mfs);
                        throw new CLIProcessingException(e.getMessage());
                    }
                }
            };
        }
        catch (Exception e) {
            throw new CLIProcessingException(e.getMessage());
        }
    }

    protected void pauseOrResumeReplica(CommandOutput.OutputHierarchy out, boolean isPaused) throws CLIProcessingException {
        String tablePath = DbCommands.getTransformedPath(this.getParamTextValue(PATH_PARAM_NAME, 0), this.getUserLoginId());
        String replicaFullPath = DbCommands.getTransformedPath(this.getParamTextValue(REPLICA_PARAM_NAME, 0), this.getUserLoginId());
        try {
            DbReplicaCommands.pauseOrResumeReplication(tablePath, replicaFullPath, isPaused, this.getUserLoginId());
        }
        catch (CLIProcessingException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
        catch (IOException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
    }

    private Dbserver.TableReplicaDesc getReplica(final String tablePath, String replClusterName, String replTablePath) throws IOException, CLIProcessingException {
        final RecentTablesListManager manager = RecentTablesListManagers.getRecentTablesListManagerForUser(this.getUserLoginId());
        final ArrayList rlist = new ArrayList();
        try {
            new FileclientRun(this.getUserLoginId()){

                @Override
                public void runAsProxyUser() throws IOException, CLIProcessingException {
                    MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
                    try {
                        if (!mfs.isTable(new Path(tablePath))) {
                            throw new CLIProcessingException("Table not found. Path: " + tablePath);
                        }
                        Dbserver.TableReplicaListResponse resp = mfs.listTableReplicas(new Path(tablePath), false, false);
                        rlist.add(resp);
                        manager.moveToTop(tablePath);
                    }
                    catch (IOException e) {
                        manager.deleteIfNotExist(tablePath, mfs);
                        throw new CLIProcessingException(e.getMessage());
                    }
                }
            };
            Dbserver.TableReplicaListResponse listResp = (Dbserver.TableReplicaListResponse)rlist.get(0);
            for (Dbserver.TableReplicaDesc rd : listResp.getReplicasList()) {
                if (!replClusterName.equals(rd.getClusterName()) || !replTablePath.equals(rd.getTablePath())) continue;
                return rd;
            }
            return null;
        }
        catch (CLIProcessingException e) {
            throw new CLIProcessingException(e.getMessage());
        }
        catch (IOException e) {
            throw new IOException(e.getMessage());
        }
    }

    public static List<Dbserver.ColumnFamilyAttr> getAllFamilies(String tablePath, String user) throws IOException, CLIProcessingException {
        final String tablePathFinal = tablePath;
        final ArrayList<Dbserver.ColumnFamilyAttr> cfListFinal = new ArrayList<Dbserver.ColumnFamilyAttr>();
        new FileclientRun(user){

            @Override
            public void runAsProxyUser() throws CLIProcessingException, IOException {
                MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
                List colList = mfs.listColumnFamily(new Path(tablePathFinal), false);
                cfListFinal.addAll(colList);
            }
        };
        return cfListFinal;
    }

    private static int familyNameToId(List<Dbserver.ColumnFamilyAttr> cfAttrList, String familyName) {
        for (Dbserver.ColumnFamilyAttr cf : cfAttrList) {
            if (!cf.getSchFamily().getName().equals(familyName)) continue;
            return cf.getSchFamily().getId();
        }
        return 0;
    }

    public static String familyIdToName(List<Dbserver.ColumnFamilyAttr> cfAttrList, int familyId) {
        for (Dbserver.ColumnFamilyAttr cf : cfAttrList) {
            if (cf.getSchFamily().getId() != familyId) continue;
            return cf.getSchFamily().getName();
        }
        return null;
    }

    public String getCliParam(String key) throws IOException {
        String ret = null;
        try {
            if (this.isParamPresent(key)) {
                ret = this.getParamTextValue(key, 0);
            }
        }
        catch (CLIProcessingException e) {
            throw new IOException(e);
        }
        return ret;
    }
}

