/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.Errno;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.cli.DbCommands;
import com.mapr.cli.MapRCliUtil;
import com.mapr.cli.table.RecentTablesListManager;
import com.mapr.cli.table.RecentTablesListManagers;
import com.mapr.cli.table.TabletStats;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.IntegerInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.db.impl.IdCodec;
import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.cldb.util.Util;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Dbserver;
import com.mapr.org.apache.hadoop.hbase.util.Bytes;
import com.mapr.security.MaprSecurityException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;
import org.ojai.Value;

public class DbRegionCommands
extends CLIBaseClass
implements CLIInterface {
    private static final Logger LOG = Logger.getLogger(DbRegionCommands.class);
    private static final String PATH_PARAM_NAME = "path";
    private static final String FID_PARAM_NAME = "fid";
    private static final String CTYPE_PARAM_NAME = "type";
    private static final String CTYPE_PARAM_DESC = "default|postsplit|sync|partitionSplit";
    private static final String NTHREADS_PARAM_NAME = "nthreads";
    public static final String COLUMNS_PARAM_NAME = "columns";
    public static final String OUTPUT_PARAM_NAME = "output";
    public static final String START_PARAM_NAME = "start";
    public static final String LIMIT_PARAM_NAME = "limit";
    public static final int NUM_REGION_INFOS_PER_RPC = 25;
    private static final CLICommand splitCommand = new CLICommand("split", "usage: table region split -path <tablepath> -fid <fid>", DbRegionCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "table path", true, null)).put((Object)"fid", (Object)new TextInputParameter("fid", "fid", true, null)).build(), null).setShortUsage("table region split -path <tablepath> -fid <fid>");
    private static final CLICommand packCommand = new CLICommand("pack", "usage: table region pack -path <tablepath> -fid <fid>", DbRegionCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "table path", true, null)).put((Object)"fid", (Object)new TextInputParameter("fid", "fid|all", true, null)).put((Object)"type", (Object)new TextInputParameter("type", "default|postsplit|sync|partitionSplit", false, null).setInvisible(true)).put((Object)"nthreads", (Object)new IntegerInputParameter("nthreads", "nthreads", false, Integer.valueOf(16))).build(), null).setShortUsage("table region pack -path <tablepath> -fid <fid>");
    private static final CLICommand listCommand = new CLICommand("list", "usage: table region list -path <tablepath>", DbRegionCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "table path", true, null)).put((Object)"columns", (Object)new TextInputParameter("columns", "columns", false, "all").setInvisible(true)).put((Object)"output", (Object)new TextInputParameter("output", "verbose|terse", false, "verbose").setInvisible(true)).put((Object)"start", (Object)new IntegerInputParameter("start", "start", false, Integer.valueOf(0))).put((Object)"limit", (Object)new IntegerInputParameter("limit", "limit", false, Integer.valueOf(Integer.MAX_VALUE))).build(), null).setShortUsage("table region list -path <tablepath>");
    private static final CLICommand mergeCommand = new CLICommand("merge", "usage: table region merge -path <tablepath> -fid <fid>", DbRegionCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "table path", true, null)).put((Object)"fid", (Object)new TextInputParameter("fid", "fid", true, null)).build(), null).setShortUsage("table region -path <tablepath> merge -fid <fid>");
    public static final CLICommand regionCommands = new CLICommand("region", "region [split|pack|merge|list]", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{splitCommand, packCommand, mergeCommand, listCommand}).setShortUsage("table region [split|pack|merge|list]");
    private static final Map<String, String> verboseToTerseMap = new ImmutableMap.Builder().put((Object)"startkey", (Object)"sk").put((Object)"endkey", (Object)"ek").put((Object)"size", (Object)"s").put((Object)"numrows", (Object)"nr").put((Object)"numberofrowswithdelete", (Object)"nrd").put((Object)"primarynode", (Object)"pn").put((Object)"secondarynodes", (Object)"sn").put((Object)"lastheartbeat", (Object)"lhb").put((Object)"physicalsize", (Object)"ps").put((Object)"logicalsize", (Object)"ls").put((Object)"numberofrows", (Object)"nr").put((Object)"fid", (Object)"fid").put((Object)"copypendingsize", (Object)"cps").put((Object)"numberofspills", (Object)"nsp").put((Object)"numberofsegments", (Object)"nsg").build();

    public DbRegionCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        if (!super.validateInput()) {
            return output;
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase(splitCommand.getCommandName())) {
            this.splitRegion(out);
        } else if (this.cliCommand.getCommandName().equalsIgnoreCase(packCommand.getCommandName())) {
            this.packRegion(out);
        } else if (this.cliCommand.getCommandName().equalsIgnoreCase(mergeCommand.getCommandName())) {
            this.mergeRegion(out);
        } else if (this.cliCommand.getCommandName().equalsIgnoreCase(listCommand.getCommandName())) {
            this.listRegions(out);
        }
        return output;
    }

    private void splitRegion(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        String tablePath = DbCommands.getTransformedPath(this.getParamTextValue(PATH_PARAM_NAME, 0), this.getUserLoginId());
        String fidstr = this.getParamTextValue(FID_PARAM_NAME, 0);
        MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
        RecentTablesListManager manager = RecentTablesListManagers.getRecentTablesListManagerForUser(this.getUserLoginId());
        try {
            mfs.splitTableRegion(new Path(tablePath), fidstr, false);
            manager.moveToTop(tablePath);
        }
        catch (IOException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
            manager.deleteIfNotExist(tablePath, mfs);
        }
    }

    private static CommandOutput.OutputHierarchy.OutputError invokePackRegionOnTabletFid(String tablePath, String fidstr, int ctype) throws CLIProcessingException {
        MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
        try {
            mfs.packTableRegion(new Path(tablePath), fidstr, ctype);
        }
        catch (IOException e) {
            return new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage());
        }
        return new CommandOutput.OutputHierarchy.OutputError(0, null);
    }

    private static List<Dbserver.TabletDesc> getAllTabletDescriptors(String tablePath, String username, CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        int start = 0;
        int limit = Integer.MAX_VALUE;
        TabletStats tabletStats = new TabletStats(tablePath, username);
        List<Dbserver.TabletDesc> tablets = tabletStats.getTablets(out, start, limit);
        return tablets;
    }

    public static CommandOutput.OutputHierarchy.OutputError packAllRegionsOfTable(final String tablePath, final int ctype, int nthreads, String username) throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        List<Dbserver.TabletDesc> tablets = DbRegionCommands.getAllTabletDescriptors(tablePath, username, out);
        if (tablets == null) {
            if (out.getOutputErrors() != null && out.getOutputErrors().size() > 1) {
                return (CommandOutput.OutputHierarchy.OutputError)out.getOutputErrors().get(0);
            }
            return new CommandOutput.OutputHierarchy.OutputError(10003, "Error fetching regions for " + tablePath);
        }
        ExecutorService executor = Executors.newFixedThreadPool(nthreads);
        ArrayList<Future<CommandOutput.OutputHierarchy.OutputError>> fObj = new ArrayList<Future<CommandOutput.OutputHierarchy.OutputError>>();
        for (Dbserver.TabletDesc tablet : tablets) {
            final String fid = MapRCliUtil.getFidAsString(tablet.getFid());
            Callable<CommandOutput.OutputHierarchy.OutputError> packCommand = new Callable<CommandOutput.OutputHierarchy.OutputError>(){

                @Override
                public CommandOutput.OutputHierarchy.OutputError call() throws CLIProcessingException {
                    CommandOutput.OutputHierarchy.OutputError retval = null;
                    retval = DbRegionCommands.invokePackRegionOnTabletFid(tablePath, fid, ctype);
                    return retval;
                }
            };
            Future<CommandOutput.OutputHierarchy.OutputError> fRet = executor.submit(packCommand);
            fObj.add(fRet);
        }
        int fObjSize = fObj.size();
        ArrayList<CommandOutput.OutputHierarchy.OutputError> errorCodes = new ArrayList<CommandOutput.OutputHierarchy.OutputError>();
        try {
            for (int i = 0; i < fObjSize; ++i) {
                CommandOutput.OutputHierarchy.OutputError retval = (CommandOutput.OutputHierarchy.OutputError)((Future)fObj.get(i)).get();
                if (retval.getErrorCode() == 0) continue;
                errorCodes.add(retval);
            }
        }
        catch (Exception e) {
            return new CommandOutput.OutputHierarchy.OutputError(10003, " wait for threadpool to finish failed " + e.getMessage());
        }
        executor.shutdown();
        if (errorCodes.isEmpty()) {
            return null;
        }
        return (CommandOutput.OutputHierarchy.OutputError)errorCodes.get(0);
    }

    private void packRegion(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        String tablePath = DbCommands.getTransformedPath(this.getParamTextValue(PATH_PARAM_NAME, 0), this.getUserLoginId());
        String fidstr = null;
        fidstr = this.getParamTextValue(FID_PARAM_NAME, 0);
        int ctype = Dbserver.ForcedCompactionType.ForcedCompactionDefault.getNumber();
        if (this.isParamPresent(CTYPE_PARAM_NAME)) {
            String ctypeStr = this.getParamTextValue(CTYPE_PARAM_NAME, 0);
            if (ctypeStr.equalsIgnoreCase("default")) {
                ctype = Dbserver.ForcedCompactionType.ForcedCompactionDefault.getNumber();
            } else if (ctypeStr.equalsIgnoreCase("postSplit")) {
                ctype = Dbserver.ForcedCompactionType.ForcedCompactionPostSplit.getNumber();
            } else if (ctypeStr.equalsIgnoreCase("sync")) {
                ctype = Dbserver.ForcedCompactionType.ForcedCompactionSync.getNumber();
            } else if (ctypeStr.equalsIgnoreCase("partitionSplit")) {
                ctype = Dbserver.ForcedCompactionType.ForcedCompactionPartitionSplit.getNumber();
            } else if (ctypeStr.equalsIgnoreCase("ttl")) {
                ctype = Dbserver.ForcedCompactionType.ForcedCompactionTTL.getNumber();
            } else {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "unknown type " + ctypeStr));
                return;
            }
        }
        RecentTablesListManager manager = RecentTablesListManagers.getRecentTablesListManagerForUser(this.getUserLoginId());
        manager.moveToTop(tablePath);
        CommandOutput.OutputHierarchy.OutputError err = null;
        if (fidstr.equals("all")) {
            int nthreads = this.getParamIntValue(NTHREADS_PARAM_NAME, 0);
            err = DbRegionCommands.packAllRegionsOfTable(tablePath, ctype, nthreads, this.getUserLoginId());
        } else {
            err = DbRegionCommands.invokePackRegionOnTabletFid(tablePath, fidstr, ctype);
        }
        if (err != null && err.getErrorCode() != 0) {
            MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
            manager.deleteIfNotExist(tablePath, mfs);
            out.addError(err);
        }
    }

    private boolean showColumn(Set<String> columns, String verboseName) {
        if (columns == null) {
            return false;
        }
        String terseName = verboseToTerseMap.get(verboseName);
        return columns.contains("all") || columns.contains("verboseName") || columns.contains(terseName);
    }

    private void listRegions(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        String path = DbCommands.getTransformedPath(this.getParamTextValue(PATH_PARAM_NAME, 0), this.getUserLoginId());
        int start = this.getParamIntValue(START_PARAM_NAME, 0);
        int limit = this.getParamIntValue(LIMIT_PARAM_NAME, 0);
        MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
        RecentTablesListManager manager = RecentTablesListManagers.getRecentTablesListManagerForUser(this.getUserLoginId());
        TabletStats tabletStats = new TabletStats(path, this.getUserLoginId());
        List<Dbserver.TabletDesc> tablets = tabletStats.getTablets(out, start, limit);
        if (tablets == null) {
            return;
        }
        boolean isJson = this.isJsonTable(path);
        String columnsString = this.getParamTextValue(COLUMNS_PARAM_NAME, 0);
        HashSet<String> columns = null;
        if (columnsString != null) {
            columns = new HashSet<String>(Arrays.asList(columnsString.split(",")));
        }
        Map<Integer, CLDBProto.TabletInfo> cidMap = this.getTabletsInfo(out, tablets);
        for (Dbserver.TabletDesc tablet : tablets) {
            CLDBProto.TabletInfo tabletInfo = cidMap.get(tablet.getFid().getCid());
            String primaryNode = ((Common.IPAddress)tabletInfo.getMaster().getIpsList().get(0)).getHostname();
            String secondaryNodes = this.getSecondaryNodes(tabletInfo);
            byte[] startKey = tablet.getStartKey().toByteArray();
            byte[] endKey = tablet.getEndKey().toByteArray();
            String startKeyStr = "-INFINITY";
            String endKeyStr = "INFINITY";
            if (startKey.length != 0) {
                String string = startKeyStr = isJson ? IdCodec.asString((Value)IdCodec.decode((byte[])startKey)) : Bytes.toStringBinary((byte[])startKey);
            }
            if (endKey.length != 0) {
                endKeyStr = isJson ? IdCodec.asString((Value)IdCodec.decode((byte[])endKey)) : Bytes.toStringBinary((byte[])endKey);
            }
            CommandOutput.OutputHierarchy.OutputNode tabletNode = new CommandOutput.OutputHierarchy.OutputNode();
            if (this.showColumn(columns, "primarynode")) {
                tabletNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName("primarynode"), (Object)primaryNode));
            }
            if (this.showColumn(columns, "secondarynodes")) {
                tabletNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName("secondarynodes"), (Object)secondaryNodes));
            }
            if (this.showColumn(columns, "startkey")) {
                tabletNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName("startkey"), (Object)startKeyStr));
            }
            if (this.showColumn(columns, "endkey")) {
                tabletNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName("endkey"), (Object)endKeyStr));
            }
            if (this.showColumn(columns, "lastheartbeat")) {
                tabletNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName("lastheartbeat"), tabletInfo.getMastersLastHBSec()));
            }
            if (this.showColumn(columns, FID_PARAM_NAME)) {
                tabletNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName(FID_PARAM_NAME), (Object)MapRCliUtil.getFidAsString(tablet.getFid())));
            }
            try {
                Dbserver.TabletStatResponse tsr = tabletStats.getTabletStatResponse(tablet);
                if (tsr != null && tsr.hasUsage()) {
                    Dbserver.SpaceUsage su = tsr.getUsage();
                    long blockSize = 8192L;
                    if (this.showColumn(columns, "logicalsize")) {
                        tabletNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName("logicalsize"), su.getNumLogicalBlocks() * blockSize));
                    }
                    if (this.showColumn(columns, "physicalsize")) {
                        tabletNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName("physicalsize"), su.getNumPhysicalBlocks() * blockSize));
                    }
                    if (this.showColumn(columns, "copypendingsize") && su.hasNumRemoteBlocks()) {
                        tabletNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName("copypendingsize"), su.getNumRemoteBlocks() * blockSize));
                    }
                    if (this.showColumn(columns, "numberofrows")) {
                        tabletNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName("numberofrows"), su.getNumRows()));
                    }
                    if (this.showColumn(columns, "numberofrowswithdelete") && su.hasNumRowsWithDelete()) {
                        tabletNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName("numberofrowswithdelete"), su.getNumRowsWithDelete()));
                    }
                    if (this.showColumn(columns, "numberofspills") && su.hasNumSpills()) {
                        tabletNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName("numberofspills"), su.getNumSpills()));
                    }
                    if (this.showColumn(columns, "numberofsegments") && su.hasNumSegments()) {
                        tabletNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName("numberofsegments"), su.getNumSegments()));
                    }
                }
            }
            catch (Exception e) {
                LOG.error((Object)("Error fetching tablet stats for fid: " + MapRCliUtil.getFidAsString(tablet.getFid())), (Throwable)e);
            }
            out.addNode(tabletNode);
        }
        manager.moveToTop(path);
    }

    private boolean isJsonTable(String path) throws CLIProcessingException {
        try {
            return MapRCliUtil.getMapRFileSystem().getTableProperties(new Path(path)).getAttr().getJson();
        }
        catch (IOException | IllegalArgumentException e) {
            throw new CLIProcessingException((Throwable)e);
        }
    }

    private Map<Integer, CLDBProto.TabletInfo> getTabletsInfo(CommandOutput.OutputHierarchy out, List<Dbserver.TabletDesc> tablets) throws CLIProcessingException {
        CLDBProto.TabletInfoRequest.Builder tabletInfoReqBuilder;
        HashSet cidSet = Sets.newHashSet();
        for (Dbserver.TabletDesc tablet : tablets) {
            cidSet.add(tablet.getFid().getCid());
        }
        HashMap cidToTabletInfoMap = Maps.newHashMap();
        int from = 0;
        int to = 25;
        ArrayList cidList = Lists.newArrayList((Iterable)cidSet);
        while (to < cidList.size()) {
            tabletInfoReqBuilder = CLDBProto.TabletInfoRequest.newBuilder().setCreds(this.getUserCredentials());
            tabletInfoReqBuilder.addAllContainerId(cidList.subList(from, to));
            this.fetchTabletsInfoFromCLDB(tabletInfoReqBuilder, out, cidToTabletInfoMap);
            if (!out.getOutputErrors().isEmpty()) {
                return cidToTabletInfoMap;
            }
            from = to;
            to = from + 25;
        }
        tabletInfoReqBuilder = CLDBProto.TabletInfoRequest.newBuilder().setCreds(this.getUserCredentials());
        tabletInfoReqBuilder.addAllContainerId(cidList.subList(from, cidList.size()));
        this.fetchTabletsInfoFromCLDB(tabletInfoReqBuilder, out, cidToTabletInfoMap);
        return cidToTabletInfoMap;
    }

    private void fetchTabletsInfoFromCLDB(CLDBProto.TabletInfoRequest.Builder request, CommandOutput.OutputHierarchy out, Map<Integer, CLDBProto.TabletInfo> results) throws CLIProcessingException {
        try {
            String cluster = MapRCliUtil.extractClusterNameFromFullyQualifiedPath(this.getParamTextValue(PATH_PARAM_NAME, 0));
            byte[] replyData = cluster != null ? CLDBRpcCommonUtils.getInstance().sendRequest(cluster, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.TabletInfoProc.getNumber(), (MessageLite)request.build(), CLDBProto.TabletInfoResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.TabletInfoProc.getNumber(), (MessageLite)request.build(), CLDBProto.TabletInfoResponse.class);
            if (replyData == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Could not retrieve the list of regions. Reason: Could not connect to the CLDB service"));
                return;
            }
            CLDBProto.TabletInfoResponse resp = CLDBProto.TabletInfoResponse.parseFrom((byte[])replyData);
            if (resp.getStatus() != 0) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "Could not retrieve the list of regions. Reason: Region lookup failed. Error: " + Errno.toString(resp.getStatus())));
                return;
            }
            List tabletsInfoList = resp.getTabletsList();
            if (tabletsInfoList.isEmpty()) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "Could not retrieve the list of regions. Reason: Region info response did not contain regions information in it."));
                return;
            }
            for (CLDBProto.TabletInfo tabletInfo : tabletsInfoList) {
                results.put(tabletInfo.getContainerId(), tabletInfo);
            }
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("InvalidProtocolBufferException Exception", (Throwable)e);
        }
    }

    private String getSecondaryNodes(CLDBProto.TabletInfo tablet) {
        StringBuilder secondaryNodesBuilder = new StringBuilder();
        boolean first = true;
        for (Common.Server secondaryServers : tablet.getReplicasList()) {
            if (Util.compareIPAddress((Common.IPAddress)tablet.getMaster().getIps(0), (Common.IPAddress)secondaryServers.getIps(0))) continue;
            if (!first) {
                secondaryNodesBuilder.append(", ");
            }
            secondaryNodesBuilder.append(secondaryServers.getHostname());
            String host = null;
            if (secondaryServers.hasHostname()) {
                host = secondaryServers.getHostname();
            }
            if (host == null || host.isEmpty()) {
                host = secondaryServers.getIps(0).getHostname();
            }
            secondaryNodesBuilder.append(host);
            first = false;
        }
        return secondaryNodesBuilder.toString();
    }

    private String getOutputFieldName(String verboseName) throws CLIProcessingException {
        return "terse".equals(this.getParamTextValue(OUTPUT_PARAM_NAME, 0)) ? verboseToTerseMap.get(verboseName) : verboseName;
    }

    private void mergeRegion(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        String tablePath = DbCommands.getTransformedPath(this.getParamTextValue(PATH_PARAM_NAME, 0), this.getUserLoginId());
        String fidstr = this.getParamTextValue(FID_PARAM_NAME, 0);
        MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
        RecentTablesListManager manager = RecentTablesListManagers.getRecentTablesListManagerForUser(this.getUserLoginId());
        try {
            mfs.mergeTableRegion(new Path(tablePath), fidstr);
            manager.moveToTop(tablePath);
        }
        catch (IOException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
            manager.deleteIfNotExist(tablePath, mfs);
        }
    }
}

