/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3native;

import amazon.emr.metrics.MetricsSaver;
import com.amazonaws.AmazonClientException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.InstanceProfileCredentialsProvider;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.ObjectMetadata;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.UnknownHostException;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.BufferedFSInputStream;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.common.Abortable;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.s3.S3Credentials;
import org.apache.hadoop.fs.s3.S3Exception;
import org.apache.hadoop.fs.s3native.FileMetadata;
import org.apache.hadoop.fs.s3native.FileStatusCache;
import org.apache.hadoop.fs.s3native.Jets3tNativeFileSystemStore;
import org.apache.hadoop.fs.s3native.MultipartUploadOutputStream;
import org.apache.hadoop.fs.s3native.NativeFileSystemStore;
import org.apache.hadoop.fs.s3native.PartialListing;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.io.retry.RetryProxy;
import org.apache.hadoop.util.Progressable;

public class NativeS3FileSystem
extends FileSystem {
    public static final Log LOG = LogFactory.getLog(NativeS3FileSystem.class);
    protected static final String FOLDER_SUFFIX = "_$folder$";
    static final String PATH_DELIMITER = "/";
    private static final int S3_MAX_LISTING_LENGTH = 1000;
    private static final int S3_MIN_PART_SIZE = 0x500000;
    private static ThreadPoolExecutor threadPool = NativeS3FileSystem.createThreadPoolExecutor();
    private AmazonS3 s3;
    private static ThreadLocal<FileStatusCache> prefetchedFileStatus = new ThreadLocal<FileStatusCache>(){

        @Override
        protected FileStatusCache initialValue() {
            LOG.info((Object)"Creating prefetchedFileStatus initial object");
            return new FileStatusCache();
        }
    };
    private static ThreadLocal<FileStatusCache> cachedFileStatus = new ThreadLocal<FileStatusCache>(){

        @Override
        protected FileStatusCache initialValue() {
            LOG.info((Object)"Creating cachedFileStatus initial object");
            return new FileStatusCache();
        }
    };
    private static ThreadLocal<Boolean> useCache = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private static ThreadLocal<Boolean> usePrefetch = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private URI uri;
    private NativeFileSystemStore store;
    private Path workingDir;

    private static ThreadPoolExecutor createThreadPoolExecutor() {
        ThreadFactory daemonThreadFactory = new ThreadFactory(){
            private int threadCount = 1;

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r);
                thread.setName("s3-transfer-manager-worker-" + this.threadCount++);
                thread.setDaemon(true);
                return thread;
            }
        };
        return (ThreadPoolExecutor)Executors.newFixedThreadPool(10, daemonThreadFactory);
    }

    private static String[] getTempDirs(Configuration conf) {
        String[] backupDirs = conf.get("fs.s3.buffer.dir").split(",");
        ArrayList<String> tempDirs = new ArrayList<String>(backupDirs.length);
        File result = null;
        for (int directoryIndex = 0; directoryIndex < backupDirs.length; ++directoryIndex) {
            File dir = new File(backupDirs[directoryIndex]);
            dir.mkdirs();
            try {
                result = File.createTempFile("output-", ".tmp", dir);
                if (result != null) {
                    tempDirs.add(backupDirs[directoryIndex]);
                }
                result.delete();
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return tempDirs.toArray(new String[0]);
    }

    public BlockLocation[] getFileBlockLocations(FileStatus file, long start, long len) throws IOException {
        if (file == null) {
            return null;
        }
        if (start < 0L || len < 0L) {
            throw new IllegalArgumentException("Invalid start or len parameter");
        }
        if (file.getLen() < start) {
            return new BlockLocation[0];
        }
        String[] name = new String[]{"localhost:50010"};
        String[] host = new String[]{"localhost"};
        long length = file.getLen();
        long blockSize = this.getDefaultBlockSize();
        ArrayList<BlockLocation> locations = new ArrayList<BlockLocation>((int)(length / blockSize + 1L));
        long i = 0L;
        while (length > 0L) {
            long block_length;
            if ((length -= (block_length = Math.min(blockSize, length))) < blockSize) {
                block_length += length;
                length = 0L;
            }
            locations.add(new BlockLocation(name, host, blockSize * i, block_length));
            LOG.debug((Object)("Adding block at " + blockSize * i + " with length " + block_length));
            ++i;
        }
        return locations.toArray(new BlockLocation[0]);
    }

    public NativeS3FileSystem() {
    }

    public NativeS3FileSystem(NativeFileSystemStore store) {
        this.store = store;
    }

    public void initialize(URI uri, Configuration conf) throws IOException {
        super.initialize(uri, conf);
        if (this.s3 == null) {
            ClientConfiguration configuration = new ClientConfiguration();
            configuration.setMaxErrorRetry(10);
            boolean enableSSL = conf.getBoolean("fs.s3n.ssl.enabled", true);
            if (enableSSL) {
                configuration.setProtocol(Protocol.HTTPS);
            } else {
                configuration.setProtocol(Protocol.HTTP);
            }
            S3Credentials s3Credentials = null;
            try {
                s3Credentials = new S3Credentials();
                s3Credentials.initialize(uri, conf);
            }
            catch (IllegalArgumentException ex) {
                s3Credentials = null;
            }
            if (s3Credentials != null) {
                BasicAWSCredentials credentials = new BasicAWSCredentials(s3Credentials.getAccessKey(), s3Credentials.getSecretAccessKey());
                this.s3 = new AmazonS3Client((AWSCredentials)credentials, configuration);
            } else {
                InstanceProfileCredentialsProvider provider = new InstanceProfileCredentialsProvider();
                this.s3 = new AmazonS3Client((AWSCredentialsProvider)provider, configuration);
                LOG.info((Object)"Created AmazonS3 with InstanceProfileCredentialsProvider");
            }
            this.s3.setEndpoint(conf.get("fs.s3n.endpoint", "s3.amazonaws.com"));
        }
        if (this.store == null) {
            this.store = NativeS3FileSystem.createDefaultStore(this.s3, conf);
        }
        this.store.initialize(uri, conf);
        this.setConf(conf);
        this.uri = URI.create(uri.getScheme() + "://" + uri.getAuthority());
        this.workingDir = new Path("/user", System.getProperty("user.name")).makeQualified((FileSystem)this);
    }

    private static NativeFileSystemStore createDefaultStore(AmazonS3 s3, Configuration conf) {
        Jets3tNativeFileSystemStore store = new Jets3tNativeFileSystemStore();
        store.setS3(s3);
        RetryPolicy defaultPolicy = RetryPolicies.retryUpToMaximumCountWithFixedSleep((int)2, (long)1L, (TimeUnit)TimeUnit.SECONDS);
        RetryWrappedExceptions wrappedPolicy = new RetryWrappedExceptions(4, 10);
        wrappedPolicy.addClass(UnknownHostException.class);
        wrappedPolicy.addClass(SSLException.class);
        wrappedPolicy.addClass(SSLPeerUnverifiedException.class);
        RetryPolicy basePolicy = RetryPolicies.retryUpToMaximumCountWithFixedSleep((int)conf.getInt("fs.s3.maxRetries", 4), (long)conf.getLong("fs.s3.sleepTimeSeconds", 10L), (TimeUnit)TimeUnit.SECONDS);
        HashMap<Class<AmazonClientException>, RetryPolicy> explicitPolicyMap = new HashMap<Class<AmazonClientException>, RetryPolicy>();
        explicitPolicyMap.put(IOException.class, basePolicy);
        explicitPolicyMap.put(S3Exception.class, basePolicy);
        explicitPolicyMap.put(AmazonClientException.class, wrappedPolicy);
        RetryPolicy methodPolicy = RetryPolicies.retryByException((RetryPolicy)defaultPolicy, explicitPolicyMap);
        return (NativeFileSystemStore)RetryProxy.create(NativeFileSystemStore.class, (Object)store, (RetryPolicy)methodPolicy);
    }

    private static String pathToKey(Path path) {
        if (path.toUri().getScheme() != null && "".equals(path.toUri().getPath())) {
            return "";
        }
        if (!path.isAbsolute()) {
            throw new IllegalArgumentException("Path must be absolute: " + path);
        }
        String ret = path.toUri().getPath().substring(1);
        if (ret.endsWith(PATH_DELIMITER) && ret.indexOf(PATH_DELIMITER) != ret.length() - 1) {
            ret = ret.substring(0, ret.length() - 1);
        }
        return ret;
    }

    private static Path keyToPath(String key) {
        return new Path(PATH_DELIMITER + key);
    }

    private Path makeAbsolute(Path path) {
        if (path.isAbsolute()) {
            return path;
        }
        return new Path(this.workingDir, path);
    }

    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        throw new IOException("Not supported");
    }

    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        OutputStream outputStream;
        if (this.exists(f) && !overwrite) {
            throw new IOException("File already exists:" + f);
        }
        LOG.info((Object)("Creating new file '" + f + "' in S3"));
        Path absolutePath = this.makeAbsolute(f);
        String key = NativeS3FileSystem.pathToKey(absolutePath);
        boolean useMultipart = this.getConf().getBoolean("fs.s3n.multipart.uploads.enabled", true);
        if (useMultipart) {
            String[] dirs = NativeS3FileSystem.getTempDirs(this.getConf());
            File[] fileDirs = new File[dirs.length];
            for (int i = 0; i < dirs.length; ++i) {
                fileDirs[i] = new File(dirs[i]);
            }
            long partSize = this.getConf().getLong("fs.s3n.multipart.uploads.split.size", 0x8000000L);
            if (partSize < 0x500000L) {
                LOG.warn((Object)("The value of fs.s3n.multipart.uploads.split.size is " + partSize + " bytes which is less than the 5 MB minimum." + " Setting to 5 MB."));
                partSize = 0x500000L;
            }
            ObjectMetadata metadata = new ObjectMetadata();
            metadata.setContentType("binary/octet-stream");
            String bucket = this.uri.getAuthority();
            if (f.toUri().getHost() != null) {
                bucket = f.toUri().getHost();
            }
            outputStream = new MultipartUploadOutputStream(this.s3, this.store, threadPool, progress, bucket, key, metadata, partSize, fileDirs);
        } else {
            outputStream = new NativeS3FsOutputStream(this.getConf(), this.store, key, progress, bufferSize);
        }
        return new FSDataOutputStream(outputStream, this.statistics);
    }

    @Deprecated
    public boolean delete(Path path) throws IOException {
        return this.delete(path, true);
    }

    public boolean delete(Path f, boolean recurse) throws IOException {
        FileStatus status;
        try {
            status = this.getFileStatus(f);
        }
        catch (FileNotFoundException e) {
            LOG.info((Object)("Delete called for '" + f + "' but file does not exist, so returning false"));
            return false;
        }
        Path absolutePath = this.makeAbsolute(f);
        String key = NativeS3FileSystem.pathToKey(absolutePath);
        if (status.isDir()) {
            PartialListing listing;
            if (!recurse && this.listStatus(f).length > 0) {
                throw new IOException("Can not delete " + f + " at is a not empty directory and recurse option is false");
            }
            this.createParent(f);
            LOG.info((Object)("Deleting directory '" + f + "'"));
            String priorLastKey = null;
            do {
                listing = this.store.list(key, 1000, priorLastKey, true);
                for (FileMetadata file : listing.getFiles()) {
                    this.store.delete(file.getKey());
                }
            } while ((priorLastKey = listing.getPriorLastKey()) != null);
            try {
                this.store.delete(key + FOLDER_SUFFIX);
            }
            catch (FileNotFoundException e) {}
        } else {
            LOG.info((Object)("Deleting file '" + f + "'"));
            this.createParent(f);
            this.store.delete(key);
        }
        return true;
    }

    public FileStatus getFileStatus(Path f) throws IOException {
        FileStatus keyStatus;
        Path absolutePath = this.makeAbsolute(f);
        String key = NativeS3FileSystem.pathToKey(absolutePath);
        if (key.length() == 0) {
            return this.newDirectory(absolutePath);
        }
        if (this.isCacheOrPrefetchEnabled() && (keyStatus = this.getKeyFromCache(absolutePath)) != null) {
            LOG.debug((Object)("Serving get key " + key + " from cache"));
            return keyStatus;
        }
        LOG.debug((Object)("getFileStatus retrieving metadata for key '" + key + "'"));
        FileMetadata meta = this.store.retrieveMetadata(key);
        if (meta != null) {
            LOG.debug((Object)("getFileStatus returning 'file' for key '" + key + "'"));
            return this.newFile(meta, absolutePath);
        }
        if (this.store.retrieveMetadata(key + FOLDER_SUFFIX) != null) {
            LOG.debug((Object)("getFileStatus returning 'directory' for key '" + key + "' as '" + key + FOLDER_SUFFIX + "' exists"));
            return this.newDirectory(absolutePath);
        }
        LOG.debug((Object)("getFileStatus listing key '" + key + "'"));
        PartialListing listing = this.store.list(key, 1);
        if (listing.getFiles().length > 0 || listing.getCommonPrefixes().length > 0) {
            LOG.debug((Object)("getFileStatus returning 'directory' for key '" + key + "' as it has contents"));
            return this.newDirectory(absolutePath);
        }
        LOG.debug((Object)("getFileStatus could not find key '" + key + "'"));
        throw new FileNotFoundException("No such file or directory '" + absolutePath + "'");
    }

    private FileStatus getKeyFromCache(Path absolutePath) throws IOException {
        FileStatus result;
        String key = NativeS3FileSystem.pathToKey(absolutePath);
        if (usePrefetch.get().booleanValue() && prefetchedFileStatus.get().isCached(key) && (result = prefetchedFileStatus.get().getFileStatus(key, this)) != null) {
            return result;
        }
        if (useCache.get().booleanValue()) {
            this.verifyCache(key);
            return cachedFileStatus.get().getFileStatus(key, this);
        }
        return null;
    }

    private void verifyCache(String key) throws IOException {
        if (!cachedFileStatus.get().isCached(key)) {
            this.cache(key);
        }
    }

    public URI getUri() {
        return this.uri;
    }

    public FileStatus[] listStatus(Path f) throws IOException {
        PartialListing listing;
        FileMetadata meta;
        List<FileStatus> keyStatus;
        Path absolutePath = this.makeAbsolute(f);
        String key = NativeS3FileSystem.pathToKey(absolutePath);
        if (this.isCacheOrPrefetchEnabled() && (keyStatus = this.listFromCache(absolutePath)) != null) {
            LOG.debug((Object)("Serving list key " + key + " from cache"));
            return keyStatus.toArray(new FileStatus[keyStatus.size()]);
        }
        LOG.debug((Object)("Lising keys for : " + key));
        if (key.length() > 0 && (meta = this.store.retrieveMetadata(key)) != null) {
            return new FileStatus[]{this.newFile(meta, absolutePath)};
        }
        URI pathUri = absolutePath.toUri();
        TreeSet<FileStatus> status = new TreeSet<FileStatus>();
        String priorLastKey = null;
        do {
            String relativePath;
            Path subpath;
            listing = this.store.list(key, 1000, priorLastKey, false);
            for (FileMetadata fileMetadata : listing.getFiles()) {
                subpath = NativeS3FileSystem.keyToPath(fileMetadata.getKey());
                relativePath = pathUri.relativize(subpath.toUri()).getPath();
                if (fileMetadata.getKey().equals(key + PATH_DELIMITER)) continue;
                if (relativePath.endsWith(FOLDER_SUFFIX)) {
                    status.add(this.newDirectory(new Path(absolutePath, relativePath.substring(0, relativePath.indexOf(FOLDER_SUFFIX)))));
                    continue;
                }
                status.add(this.newFile(fileMetadata, subpath));
            }
            for (String commonPrefix : listing.getCommonPrefixes()) {
                subpath = NativeS3FileSystem.keyToPath(commonPrefix);
                relativePath = pathUri.relativize(subpath.toUri()).getPath();
                status.add(this.newDirectory(new Path(absolutePath, relativePath)));
            }
        } while ((priorLastKey = listing.getPriorLastKey()) != null);
        if (status.isEmpty() && key.length() > 0 && this.store.retrieveMetadata(key + FOLDER_SUFFIX) == null && this.store.retrieveMetadata(key + PATH_DELIMITER) == null) {
            return null;
        }
        return status.toArray(new FileStatus[status.size()]);
    }

    private List<FileStatus> listFromCache(Path absolutePath) throws IOException {
        List<FileStatus> result;
        String key = NativeS3FileSystem.pathToKey(absolutePath);
        if (usePrefetch.get().booleanValue() && prefetchedFileStatus.get().isCached(key) && (result = prefetchedFileStatus.get().listStatus(key)) != null) {
            return result;
        }
        if (useCache.get().booleanValue()) {
            this.verifyCache(key);
            return cachedFileStatus.get().listStatus(key);
        }
        return null;
    }

    public TreeMap<String, FileStatus> fetchKeysFromStore(String prefix, String priorLastKey, Integer maxKeys) throws IOException {
        FileMetadata meta;
        TreeMap<String, FileStatus> prefetchMap = new TreeMap<String, FileStatus>();
        int numListedKeys = 0;
        if (priorLastKey != null && !priorLastKey.isEmpty() && (meta = this.store.retrieveMetadata(priorLastKey)) != null) {
            prefetchMap.put(priorLastKey, this.newFile(meta, NativeS3FileSystem.keyToPath(meta.getKey())));
            ++numListedKeys;
        }
        int numKeysToList = this.getNumKeysToList(maxKeys, numListedKeys);
        String previousKey = null;
        while (numKeysToList > 0) {
            PartialListing listing = this.store.list(prefix, numKeysToList, priorLastKey, true);
            for (FileMetadata fileMetadata : listing.getFiles()) {
                String relativeKey;
                Path subpath = NativeS3FileSystem.keyToPath(fileMetadata.getKey());
                String currentKey = fileMetadata.getKey();
                this.checkClosedFolders(previousKey, currentKey, prefetchMap);
                previousKey = currentKey;
                if (currentKey.endsWith(FOLDER_SUFFIX)) {
                    relativeKey = currentKey.substring(0, currentKey.indexOf(FOLDER_SUFFIX));
                    this.insertDirectory(relativeKey, prefetchMap);
                    continue;
                }
                if (currentKey.endsWith(PATH_DELIMITER)) {
                    relativeKey = currentKey.substring(0, currentKey.length() - 1);
                    this.insertDirectory(relativeKey, prefetchMap);
                    continue;
                }
                prefetchMap.put(currentKey, this.newFile(fileMetadata, subpath));
            }
            priorLastKey = listing.getPriorLastKey();
            if (priorLastKey == null) break;
            numKeysToList = this.getNumKeysToList(maxKeys, numListedKeys += numKeysToList);
        }
        return prefetchMap;
    }

    private void insertDirectory(String key, TreeMap<String, FileStatus> prefetchMap) {
        if (prefetchMap.isEmpty() || prefetchMap.firstKey().compareTo(key) < 0) {
            prefetchMap.put(key, this.newDirectory(NativeS3FileSystem.keyToPath(key).makeQualified((FileSystem)this)));
        }
    }

    private void checkClosedFolders(String previousKey, String currentKey, TreeMap<String, FileStatus> prefetchMap) {
        if (previousKey == null || !previousKey.contains(PATH_DELIMITER)) {
            return;
        }
        String[] previousFolders = previousKey.split(PATH_DELIMITER);
        String[] newFolders = currentKey.split(PATH_DELIMITER);
        String currentPath = "";
        boolean differ = false;
        for (int i = 0; i < previousFolders.length - 1; ++i) {
            currentPath = currentPath + previousFolders[i];
            if (differ || newFolders.length <= i || !previousFolders[i].equals(newFolders[i])) {
                differ = true;
                this.insertDirectory(currentPath, prefetchMap);
            }
            currentPath = currentPath + PATH_DELIMITER;
        }
    }

    private void cache(String key) throws IOException {
        LOG.info((Object)("Caching key: " + key));
        cachedFileStatus.get().buildCache(this.fetchKeysFromStore("", key, 1000), key);
    }

    public synchronized void prefetch(Path f, String marker, Integer maxKeys) throws IOException {
        Path absolutePath = this.makeAbsolute(f);
        String key = NativeS3FileSystem.pathToKey(absolutePath);
        prefetchedFileStatus.get().buildCache(this.fetchKeysFromStore(key, marker, maxKeys), key);
        usePrefetch.set(true);
    }

    public synchronized void clearPrefetch() {
        prefetchedFileStatus.get().clearCache();
        usePrefetch.set(false);
    }

    public static synchronized void enableCache() {
        LOG.debug((Object)"Enabling cache for contiguous s3 objects");
        useCache.set(true);
    }

    public static synchronized void disableCache() {
        LOG.debug((Object)"Disabling cache");
        useCache.set(false);
        cachedFileStatus.get().clearCache();
    }

    public static void clearCache() {
        cachedFileStatus.get().clearCache();
    }

    public static synchronized boolean isCacheEnabled() {
        return useCache.get();
    }

    private boolean isCacheOrPrefetchEnabled() {
        return useCache.get() != false || usePrefetch.get() != false;
    }

    public synchronized boolean isPrefetchEnabled() {
        return usePrefetch.get();
    }

    private int getNumKeysToList(Integer maxKeys, int numListed) {
        if (maxKeys != null) {
            int remaining = maxKeys - numListed;
            if (remaining > 1000) {
                return 1000;
            }
            return remaining > 0 ? remaining : 0;
        }
        return 1000;
    }

    private FileStatus newFile(FileMetadata meta, Path path) {
        return new FileStatus(meta.getLength(), false, 1, this.getDefaultBlockSize(), meta.getLastModified(), path.makeQualified((FileSystem)this));
    }

    FileStatus newDirectory(Path path) {
        return new FileStatus(0L, true, 1, 0L, 0L, path.makeQualified((FileSystem)this));
    }

    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        Path absolutePath = this.makeAbsolute(f);
        ArrayList<Path> paths = new ArrayList<Path>();
        do {
            paths.add(0, absolutePath);
        } while ((absolutePath = absolutePath.getParent()) != null);
        boolean result = true;
        for (Path path : paths) {
            result &= this.mkdir(path);
        }
        return result;
    }

    private boolean mkdir(Path f) throws IOException {
        try {
            FileStatus fileStatus = this.getFileStatus(f);
            if (!fileStatus.isDir()) {
                throw new IOException(String.format("Can't make directory for path '%s' since it is a file.", f));
            }
        }
        catch (FileNotFoundException e) {
            LOG.info((Object)("Making dir '" + f + "' in S3"));
            String key = NativeS3FileSystem.pathToKey(f) + FOLDER_SUFFIX;
            this.store.storeEmptyFile(key);
        }
        return true;
    }

    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        FileStatus fs = this.getFileStatus(f);
        if (fs.isDir()) {
            throw new IOException("'" + f + "' is a directory");
        }
        LOG.info((Object)("Opening '" + f + "' for reading"));
        Path absolutePath = this.makeAbsolute(f);
        String key = NativeS3FileSystem.pathToKey(absolutePath);
        NativeFileSystemStore.InputStreamPair streamPair = this.store.retrievePair(key);
        FSDataInputStream output = new FSDataInputStream((InputStream)new BufferedFSInputStream((FSInputStream)new NativeS3FsInputStream(streamPair), bufferSize));
        return output;
    }

    private void createParent(Path path) throws IOException {
        String key;
        Path parent = path.getParent();
        if (parent != null && (key = NativeS3FileSystem.pathToKey(this.makeAbsolute(parent))).length() > 0) {
            this.store.storeEmptyFile(key + FOLDER_SUFFIX);
        }
    }

    public boolean rename(Path src, Path dst) throws IOException {
        boolean srcIsFile;
        String dstKey;
        String srcKey = NativeS3FileSystem.pathToKey(this.makeAbsolute(src));
        if (srcKey.length() == 0) {
            return false;
        }
        String debugPreamble = "Renaming '" + src + "' to '" + dst + "' - ";
        try {
            boolean dstIsFile;
            boolean bl = dstIsFile = !this.getFileStatus(dst).isDir();
            if (dstIsFile) {
                LOG.debug((Object)(debugPreamble + "returning false as dst is an already existing file"));
                return false;
            }
            LOG.debug((Object)(debugPreamble + "using dst as output directory"));
            dstKey = NativeS3FileSystem.pathToKey(this.makeAbsolute(new Path(dst, src.getName())));
        }
        catch (FileNotFoundException e) {
            LOG.debug((Object)(debugPreamble + "using dst as output destination"));
            dstKey = NativeS3FileSystem.pathToKey(this.makeAbsolute(dst));
            try {
                if (!this.getFileStatus(dst.getParent()).isDir()) {
                    LOG.debug((Object)(debugPreamble + "returning false as dst parent exists and is a file"));
                    return false;
                }
            }
            catch (FileNotFoundException ex) {
                LOG.debug((Object)(debugPreamble + "returning false as dst parent does not exist"));
                return false;
            }
        }
        try {
            srcIsFile = !this.getFileStatus(src).isDir();
        }
        catch (FileNotFoundException e) {
            LOG.debug((Object)(debugPreamble + "returning false as src does not exist"));
            return false;
        }
        if (srcIsFile) {
            LOG.debug((Object)(debugPreamble + "src is file, so doing copy then delete in S3"));
            this.store.copy(srcKey, dstKey);
            this.store.delete(srcKey);
        } else {
            PartialListing listing;
            LOG.debug((Object)(debugPreamble + "src is directory, so copying contents"));
            this.store.storeEmptyFile(dstKey + FOLDER_SUFFIX);
            ArrayList<String> keysToDelete = new ArrayList<String>();
            String priorLastKey = null;
            do {
                listing = this.store.list(srcKey, 1000, priorLastKey, true);
                for (FileMetadata file : listing.getFiles()) {
                    keysToDelete.add(file.getKey());
                    this.store.copy(file.getKey(), dstKey + file.getKey().substring(srcKey.length()));
                }
            } while ((priorLastKey = listing.getPriorLastKey()) != null);
            LOG.debug((Object)(debugPreamble + "all files in src copied, now removing src files"));
            for (String key : keysToDelete) {
                this.store.delete(key);
            }
            try {
                this.store.delete(srcKey + FOLDER_SUFFIX);
            }
            catch (FileNotFoundException e) {
                // empty catch block
            }
            LOG.debug((Object)(debugPreamble + "done"));
        }
        return true;
    }

    public long getDefaultBlockSize() {
        return this.getConf().getLong("fs.s3n.block.size", 0x4000000L);
    }

    public void setWorkingDirectory(Path newDir) {
        this.workingDir = newDir;
    }

    public Path getWorkingDirectory() {
        return this.workingDir;
    }

    static class RetryWrappedExceptions
    implements RetryPolicy {
        int maxRetries;
        int retrySeconds;
        ArrayList<Class> klasses = new ArrayList();

        private RetryWrappedExceptions(int maxRetries, int retrySeconds) {
            this.maxRetries = maxRetries;
            this.retrySeconds = retrySeconds;
        }

        public void addClass(Class klass) {
            this.klasses.add(klass);
        }

        public boolean shouldRetry(Exception e, int retries) throws Exception {
            if (this.isMatchingException(e)) {
                if (retries < this.maxRetries) {
                    LOG.info((Object)("retry " + e.getClass() + " " + retries));
                    Thread.sleep(this.retrySeconds * 1000 / this.maxRetries);
                    return true;
                }
                LOG.info((Object)("exhausted retry " + e.getClass() + " " + retries));
                return false;
            }
            if (retries < 2) {
                LOG.info((Object)("retry un-registered " + e.getClass() + " " + retries));
                Thread.sleep(1000L);
                return true;
            }
            LOG.info((Object)("exhausted retry un-registered " + e.getClass()));
            return false;
        }

        private boolean isMatchingException(Throwable e) {
            int depth = 0;
            while (e != null) {
                if (++depth > 20) {
                    return false;
                }
                if (this.klasses.contains(e.getClass())) {
                    return true;
                }
                e = e.getCause();
            }
            return false;
        }
    }

    private class NativeS3FsOutputStream
    extends OutputStream
    implements Abortable {
        private Configuration conf;
        private NativeFileSystemStore store;
        private String key;
        private File backupFile;
        private OutputStream backupStream;
        private MessageDigest digest;
        private boolean closed = false;
        private boolean aborted = false;
        private Progressable progress = null;
        private Random random = new Random();

        public NativeS3FsOutputStream(Configuration conf, NativeFileSystemStore store, String key, Progressable progress, int bufferSize) throws IOException {
            this.conf = conf;
            this.store = store;
            this.key = key;
            this.backupFile = this.newBackupFile();
            this.progress = progress;
            LOG.info((Object)("OutputStream for key '" + key + "' writing to tempfile '" + this.backupFile + "'"));
            try {
                this.digest = MessageDigest.getInstance("MD5");
                this.backupStream = new BufferedOutputStream(new DigestOutputStream(new FileOutputStream(this.backupFile), this.digest));
            }
            catch (NoSuchAlgorithmException e) {
                LOG.warn((Object)"Cannot load MD5 digest algorithm,skipping message integrity check.", (Throwable)e);
                this.backupStream = new BufferedOutputStream(new FileOutputStream(this.backupFile));
            }
        }

        private File newBackupFile() throws IOException {
            String[] backupDirs = NativeS3FileSystem.getTempDirs(this.conf);
            int directoryIndex = this.random.nextInt(backupDirs.length);
            File dir = new File(backupDirs[directoryIndex]);
            File result = null;
            try {
                result = File.createTempFile("output-", ".tmp", dir);
            }
            catch (Exception e) {
                throw new IOException("Cannot create S3 buffer directory: " + dir, e);
            }
            if (result == null) {
                throw new IOException("Cannot create S3 buffer directory: " + dir);
            }
            result.deleteOnExit();
            return result;
        }

        @Override
        public void flush() throws IOException {
            this.backupStream.flush();
        }

        @Override
        public synchronized void close() throws IOException {
            if (this.closed) {
                return;
            }
            try {
                this.backupStream.close();
                if (this.aborted) {
                    LOG.info((Object)("Outputstream for key '" + this.key + "' was aborted, not performing upload."));
                } else {
                    LOG.info((Object)("Outputstream for key '" + this.key + "' is being closed. Beginning upload."));
                    byte[] md5Hash = this.digest == null ? null : this.digest.digest();
                    this.store.storeFile(this.key, this.backupFile, md5Hash, this.progress);
                }
            }
            catch (IOException e) {
                LOG.info((Object)("Outputstream for key '" + this.key + "' failed, marking stream as aborted."));
                this.aborted = true;
                throw e;
            }
            catch (RuntimeException e) {
                LOG.info((Object)("Outputstream for key '" + this.key + "' failed, marking stream as aborted."));
                this.aborted = true;
                throw e;
            }
            finally {
                if (!this.backupFile.delete()) {
                    LOG.warn((Object)("Could not delete temporary s3n file: " + this.backupFile));
                }
                super.close();
                this.closed = true;
            }
            LOG.info((Object)("OutputStream for key '" + this.key + "': upload complete"));
        }

        @Override
        public synchronized void abort() throws IOException {
            this.aborted = true;
            this.close();
        }

        @Override
        public void write(int b) throws IOException {
            this.backupStream.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.backupStream.write(b, off, len);
        }
    }

    private class NativeS3FsInputStream
    extends FSInputStream {
        private NativeFileSystemStore.InputStreamPair pair;
        private long pos = 0L;

        public NativeS3FsInputStream(NativeFileSystemStore.InputStreamPair pair) throws IOException {
            this.pair = pair;
        }

        public synchronized int read() throws IOException {
            int result = -1;
            try {
                result = this.pair.in.read();
            }
            catch (IOException e) {
                LOG.info((Object)("Received IOException while reading '" + this.pair.key + "', attempting to reopen."));
                this.seek(this.pos);
                result = this.pair.in.read();
            }
            if (result == -1) {
                if (this.pair.contentLength != -1L && this.pos != this.pair.contentLength) {
                    int numRetries;
                    LOG.info((Object)("Unexpected end of stream in read() while reading from stream pos=" + this.pos + ", contentLength=" + this.pair.contentLength));
                    LOG.info((Object)("result=" + result + " and numRetries=" + numRetries));
                    for (numRetries = 5; result <= 0 && numRetries > 0; --numRetries) {
                        LOG.info((Object)("Retry reading from stream " + this.pos + ", contentLength=" + this.pair.contentLength));
                        this.seek(this.pos);
                        result = this.pair.in.read();
                    }
                    if (result <= 0) {
                        LOG.error((Object)"Unable to recover reading from stream");
                        throw new IOException("Unexpected end of stream pos=" + this.pos + " contentLength= " + this.pair.contentLength);
                    }
                }
            }
            if (result > 0) {
                this.advance(result);
            }
            return result;
        }

        private void advance(int amount) {
            this.pos += (long)amount;
            if (NativeS3FileSystem.this.statistics != null) {
                NativeS3FileSystem.this.statistics.incrementBytesRead((long)amount);
            }
        }

        public synchronized int read(byte[] b, int off, int len) throws IOException {
            MetricsSaver.StopWatch stopWatch = new MetricsSaver.StopWatch();
            int numRetries = 5;
            int result = -1;
            for (int attemp = 0; attemp < 5; ++attemp) {
                try {
                    stopWatch.reset();
                    if (attemp > 0) {
                        this.seek(this.pos);
                    }
                    if ((result = this.pair.in.read(b, off, len)) > 0) {
                        this.advance(result);
                        break;
                    }
                    if (this.pair.contentLength == -1L || this.pos == this.pair.contentLength) break;
                    LOG.info((Object)("Unexpected end of stream while reading from stream pos=" + this.pos + "," + "contentLength=" + this.pair.contentLength));
                    MetricsSaver.addValueWithError((String)"S3ReadDelay", (long)stopWatch.elapsedTime(), (String)"UnexpectedEndOfStream");
                }
                catch (IOException e) {
                    MetricsSaver.addValueWithError((String)"S3ReadDelay", (long)stopWatch.elapsedTime(), (String)"IOException");
                    if (attemp >= 2) {
                        throw e;
                    }
                    LOG.info((Object)("Received IOException while reading '" + this.pair.key + "', attempting to reopen."), (Throwable)e);
                }
                if (attemp < 4) continue;
                LOG.error((Object)"Unable to recover reading from stream");
                throw new IOException("Unexpected end of stream pos=" + this.pos + " contentLength= " + this.pair.contentLength);
            }
            MetricsSaver.addValue((String)"S3ReadDelay", (long)stopWatch.elapsedTime());
            if (result > 0) {
                MetricsSaver.addValue((String)"S3ReadBytes", (long)result);
            }
            return result;
        }

        public void close() throws IOException {
            if (this.pair.in != null) {
                this.closeInputStream();
            }
        }

        private void closeInputStream() {
            try {
                this.pair.in.abort();
            }
            catch (Exception e) {
                LOG.warn((Object)"Exception closing input stream. ", (Throwable)e);
            }
        }

        public synchronized void seek(long pos) throws IOException {
            this.closeInputStream();
            this.pair.in = null;
            LOG.info((Object)("Stream for key '" + this.pair.key + "' seeking to position '" + pos + "'"));
            this.pair = NativeS3FileSystem.this.store.retrievePair(this.pair.key, pos);
            this.pos = pos;
        }

        public synchronized long getPos() throws IOException {
            return this.pos;
        }

        public boolean seekToNewSource(long targetPos) throws IOException {
            return false;
        }
    }
}

