/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3native;

import amazon.emr.metrics.MetricsSaver;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.model.UploadPartResult;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.common.Abortable;
import org.apache.hadoop.fs.s3native.NativeFileSystemStore;
import org.apache.hadoop.fs.s3native.ProgressableResettableBufferedFileInputStream;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.io.retry.RetryProxy;
import org.apache.hadoop.util.Progressable;

public class MultipartUploadOutputStream
extends OutputStream
implements Abortable {
    public static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.fs.s3native.MultipartUploadOutputStream");
    final AmazonS3 s3;
    final ThreadPoolExecutor threadPool;
    final Progressable progressable;
    final List<Future<PartETag>> futures;
    final File[] tempDirs;
    final String bucket;
    final String key;
    final long partSize;
    int partCount = 0;
    long currentPartSize = 0L;
    File currentFile;
    DigestOutputStream currentOutput;
    final String partFilePrefix;
    boolean multipartUploadInitiated;
    ObjectMetadata metadata;
    String uploadId;
    boolean closed = false;
    boolean closing = false;
    long totalLength = 0L;
    private NativeFileSystemStore store;

    public MultipartUploadOutputStream(AmazonS3 s3, NativeFileSystemStore store, ThreadPoolExecutor threadPool, Progressable progressable, String bucketName, String key, ObjectMetadata metadata, long partSize, File ... tempDirs) {
        RetryPolicy basePolicy = RetryPolicies.retryUpToMaximumCountWithFixedSleep((int)4, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        HashMap<Class<Exception>, RetryPolicy> exceptionToPolicyMap = new HashMap<Class<Exception>, RetryPolicy>();
        exceptionToPolicyMap.put(Exception.class, basePolicy);
        RetryPolicy methodPolicy = RetryPolicies.retryByException((RetryPolicy)RetryPolicies.TRY_ONCE_THEN_FAIL, exceptionToPolicyMap);
        HashMap<String, RetryPolicy> methodNameToPolicyMap = new HashMap<String, RetryPolicy>();
        methodNameToPolicyMap.put("completeMultipartUpload", methodPolicy);
        this.s3 = (AmazonS3)RetryProxy.create(AmazonS3.class, (Object)s3, methodNameToPolicyMap);
        this.multipartUploadInitiated = false;
        this.metadata = metadata;
        this.partFilePrefix = UUID.randomUUID().toString();
        this.store = store;
        this.threadPool = threadPool;
        this.progressable = progressable;
        this.futures = new ArrayList<Future<PartETag>>();
        this.tempDirs = tempDirs;
        this.bucket = bucketName;
        this.key = key;
        this.partSize = partSize;
        this.openNewPart();
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        long capacityLeft = this.capacityLeft();
        int offset = off;
        int length = len;
        while (capacityLeft < (long)length) {
            int capacityLeftInt = (int)capacityLeft;
            this.currentOutput.write(b, offset, capacityLeftInt);
            this.closeAndSchedulePart();
            offset += capacityLeftInt;
            length -= capacityLeftInt;
            capacityLeft = this.capacityLeft();
        }
        this.currentOutput.write(b, offset, length);
        this.currentPartSize += (long)length;
        this.totalLength += (long)length;
        MetricsSaver.addValue((String)"S3WriteBytes", (long)len);
    }

    @Override
    public void write(int b) throws IOException {
        if (this.capacityLeft() < 1L) {
            this.closeAndSchedulePart();
        }
        this.currentOutput.write(b);
        ++this.currentPartSize;
    }

    @Override
    public void flush() {
    }

    private void uploadSinglePart() throws IOException {
        InputStream in = null;
        MetricsSaver.StopWatch stopWatch = new MetricsSaver.StopWatch();
        try {
            this.currentOutput.close();
            byte[] md5Hash = this.currentOutput.getMessageDigest().digest();
            this.store.storeFile(this.key, this.currentFile, md5Hash, this.progressable);
        }
        catch (Exception e) {
            MetricsSaver.addValueWithError((String)"S3WriteDelay", (long)stopWatch.elapsedTime(), (Exception)e);
            throw new IOException("exception in uploadSinglePart", e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                this.currentFile.delete();
            }
            catch (IOException e) {}
        }
    }

    private void uploadMultiParts() throws IOException {
        try {
            this.closeAndSchedulePart();
            while (true) {
                boolean allDone = true;
                for (Future<PartETag> future : this.futures) {
                    if (future.isDone()) continue;
                    allDone = false;
                    break;
                }
                if (this.progressable != null) {
                    this.progressable.progress();
                }
                if (allDone) break;
                Thread.sleep(1000L);
            }
            ArrayList<PartETag> etags = new ArrayList<PartETag>();
            for (Future<PartETag> future : this.futures) {
                etags.add(future.get());
            }
            LOG.debug((Object)("Complete multipart upload " + this.uploadId + " with bucket '" + this.bucket + "' key '" + this.key + "' and etags '" + etags + "'"));
            this.s3.completeMultipartUpload(new CompleteMultipartUploadRequest(this.bucket, this.key, this.uploadId, etags));
            LOG.info((Object)("completed multipart upload of " + this.futures.size() + " parts " + this.totalLength + " bytes"));
        }
        catch (Exception e) {
            LOG.info((Object)"completeMultipartUpload error ", (Throwable)e);
            this.abort();
            throw new IOException("Error closing multipart upload", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            if (this.closed) {
                return;
            }
            this.closing = true;
            if (this.partCount <= 1) {
                this.uploadSinglePart();
            } else {
                this.uploadMultiParts();
            }
        }
        finally {
            this.closed = true;
        }
    }

    @Override
    public void abort() {
        if (this.multipartUploadInitiated) {
            for (Future<PartETag> future : this.futures) {
                future.cancel(true);
            }
            this.s3.abortMultipartUpload(new AbortMultipartUploadRequest(this.bucket, this.key, this.uploadId));
        }
    }

    private long capacityLeft() {
        return this.partSize - this.currentPartSize;
    }

    private File getPartFile(int partIndex) {
        String name = String.format("%s-%04d", this.partFilePrefix, partIndex);
        return new File(this.tempDirs[this.partCount % this.tempDirs.length], name);
    }

    private void openNewPart() {
        try {
            this.currentPartSize = 0L;
            this.currentFile = this.getPartFile(this.partCount++);
            this.currentOutput = new DigestOutputStream(new BufferedOutputStream(new FileOutputStream(this.currentFile)), MessageDigest.getInstance("MD5"));
        }
        catch (IOException e) {
            throw new RuntimeException("Error creating temporary output stream.", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Error creating DigestOutputStream", e);
        }
    }

    private void closeAndSchedulePart() throws IOException {
        if (!this.multipartUploadInitiated) {
            InitiateMultipartUploadResult result = this.s3.initiateMultipartUpload(new InitiateMultipartUploadRequest(this.bucket, this.key).withObjectMetadata(this.metadata));
            this.uploadId = result.getUploadId();
            this.multipartUploadInitiated = true;
        }
        this.currentOutput.close();
        this.futures.add(this.threadPool.submit(new MultipartUploadCallable(this.partCount, this.currentFile, this.currentOutput.getMessageDigest().digest())));
        if (!this.closing) {
            this.openNewPart();
        }
    }

    private class MultipartUploadCallable
    implements Callable<PartETag> {
        private final int partNumber;
        private final File partFile;
        private final String md5sum;
        private final String md5hex;

        public MultipartUploadCallable(int partNumber, File partFile, byte[] md5) {
            this.partNumber = partNumber;
            this.partFile = partFile;
            this.md5sum = Base64.encodeBase64String((byte[])md5);
            this.md5hex = new String(Hex.encodeHex((byte[])md5));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public PartETag call() throws Exception {
            UploadPartResult result;
            ProgressableResettableBufferedFileInputStream is = new ProgressableResettableBufferedFileInputStream(this.partFile, MultipartUploadOutputStream.this.progressable);
            UploadPartRequest request = new UploadPartRequest().withBucketName(MultipartUploadOutputStream.this.bucket).withKey(MultipartUploadOutputStream.this.key).withUploadId(MultipartUploadOutputStream.this.uploadId).withInputStream((InputStream)is).withPartNumber(this.partNumber).withPartSize(this.partFile.length()).withMD5Digest(this.md5sum);
            MetricsSaver.StopWatch stopWatch = new MetricsSaver.StopWatch();
            try {
                LOG.info((Object)("uploadPart " + this.partFile.getPath() + " " + this.partFile.length() + " bytes md5: " + this.md5sum + " md5hex: " + this.md5hex));
                result = MultipartUploadOutputStream.this.s3.uploadPart(request);
                MetricsSaver.addValue((String)"S3WriteDelay", (long)stopWatch.elapsedTime());
            }
            catch (Exception e) {
                LOG.info((Object)("uploadPart error " + e));
                MetricsSaver.addValueWithError((String)"S3WriteDelay", (long)stopWatch.elapsedTime(), (String)e.getClass().toString());
                throw e;
            }
            finally {
                try {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                }
                finally {
                    this.partFile.delete();
                }
            }
            return result.getPartETag();
        }
    }
}

