/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.maven;

import com.google.common.collect.ImmutableList;
import com.google.protobuf.maven.AbstractProtocMojo;
import com.google.protobuf.maven.Protoc;
import java.io.File;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="testCompile", defaultPhase=LifecyclePhase.GENERATE_TEST_SOURCES, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public final class ProtocTestCompileMojo
extends AbstractProtocMojo {
    @Parameter(required=true, defaultValue="${basedir}/src/test/proto")
    private File protoTestSourceRoot;
    @Parameter(required=true, defaultValue="${project.build.directory}/generated-test-sources/protobuf/java")
    private File outputDirectory;
    @Parameter(required=true, defaultValue="${project.build.directory}/generated-test-resources/protobuf/descriptor-sets")
    private File descriptorSetOutputDirectory;

    @Override
    protected void addProtocBuilderParameters(Protoc.Builder protocBuilder) {
        super.addProtocBuilderParameters(protocBuilder);
        protocBuilder.setJavaOutputDirectory(this.getOutputDirectory());
        File buildOutputDirectory = new File(this.project.getBuild().getOutputDirectory());
        if (buildOutputDirectory.exists()) {
            protocBuilder.addProtoPathElement(buildOutputDirectory);
        }
    }

    @Override
    protected void attachFiles() {
        this.project.addTestCompileSourceRoot(this.outputDirectory.getAbsolutePath());
        this.projectHelper.addTestResource(this.project, this.protoTestSourceRoot.getAbsolutePath(), (List)ImmutableList.of((Object)"**/*.proto"), (List)ImmutableList.of());
        this.buildContext.refresh(this.outputDirectory);
    }

    @Override
    protected List<Artifact> getDependencyArtifacts() {
        List testArtifacts = this.project.getTestArtifacts();
        return testArtifacts;
    }

    @Override
    protected File getOutputDirectory() {
        return this.outputDirectory;
    }

    @Override
    protected File getDescriptorSetOutputDirectory() {
        return this.descriptorSetOutputDirectory;
    }

    @Override
    protected File getProtoSourceRoot() {
        return this.protoTestSourceRoot;
    }
}

