/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.maven;

import com.google.protobuf.maven.ProtocPlugin;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.Os;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtocPluginAssembler {
    private final ProtocPlugin pluginDefinition;
    private final Artifact rootResolutionArtifact;
    private final ArtifactFactory artifactFactory;
    private final ArtifactResolver artifactResolver;
    private final ArtifactMetadataSource artifactMetadataSource;
    private final ArtifactRepository localRepository;
    private final List<ArtifactRepository> remoteRepositories;
    private final File pluginDirectory;
    private final List<File> resolvedJars = new ArrayList<File>();
    private final File pluginExecutableFile;
    private final Log log;

    public ProtocPluginAssembler(ProtocPlugin pluginDefinition, Artifact rootResolutionArtifact, ArtifactFactory artifactFactory, ArtifactResolver artifactResolver, ArtifactMetadataSource artifactMetadataSource, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories, File pluginDirectory, Log log) {
        this.pluginDefinition = pluginDefinition;
        this.rootResolutionArtifact = rootResolutionArtifact;
        this.artifactFactory = artifactFactory;
        this.artifactResolver = artifactResolver;
        this.artifactMetadataSource = artifactMetadataSource;
        this.localRepository = localRepository;
        this.remoteRepositories = remoteRepositories;
        this.pluginDirectory = pluginDirectory;
        this.pluginExecutableFile = pluginDefinition.getPluginExecutableFile(pluginDirectory);
        this.log = log;
    }

    public void execute() throws MojoExecutionException {
        this.pluginDefinition.validate(this.log);
        if (this.log.isDebugEnabled()) {
            this.log.debug((CharSequence)("plugin definition: " + this.pluginDefinition));
        }
        this.resolvePluginDependencies();
        if (Os.isFamily((String)"windows")) {
            this.buildWindowsPlugin();
            this.copyWinRun4JExecutable();
        } else {
            this.buildUnixPlugin();
            this.pluginExecutableFile.setExecutable(true);
        }
    }

    private void buildWindowsPlugin() throws MojoExecutionException {
        this.createPluginDirectory();
        File javaHome = new File(this.pluginDefinition.getJavaHome());
        File jvmLocation = ProtocPluginAssembler.findJvmLocation(javaHome, "jre/bin/server/jvm.dll", "bin/server/jvm.dll", "jre/bin/client/jvm.dll", "bin/client/jvm.dll");
        File winRun4JIniFile = new File(this.pluginDirectory, this.pluginDefinition.getPluginName() + ".ini");
        if (this.log.isDebugEnabled()) {
            this.log.debug((CharSequence)("javaHome=" + javaHome.getAbsolutePath()));
            this.log.debug((CharSequence)("jvmLocation=" + (jvmLocation != null ? jvmLocation.getAbsolutePath() : "(none)")));
            this.log.debug((CharSequence)("winRun4JIniFile=" + winRun4JIniFile.getAbsolutePath()));
            this.log.debug((CharSequence)("winJvmDataModel=" + this.pluginDefinition.getWinJvmDataModel()));
        }
        PrintWriter out = null;
        try {
            out = new PrintWriter(new FileWriter(winRun4JIniFile));
            if (jvmLocation != null) {
                out.println("vm.location=" + jvmLocation.getAbsolutePath());
            }
            int index = 1;
            for (File resolvedJar : this.resolvedJars) {
                out.println("classpath." + index + "=" + resolvedJar.getAbsolutePath());
                ++index;
            }
            out.println("main.class=" + this.pluginDefinition.getMainClass());
            index = 1;
            for (String arg : this.pluginDefinition.getArgs()) {
                out.println("arg." + index + "=" + arg);
                ++index;
            }
            index = 1;
            for (String jvmArg : this.pluginDefinition.getJvmArgs()) {
                out.println("vmarg." + index + "=" + jvmArg);
                ++index;
            }
            out.println("vm.version.min=1.6");
            out.println("log.level=none");
            out.println("[ErrorMessages]");
            out.println("show.popup=false");
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not write WinRun4J ini file: " + winRun4JIniFile.getAbsolutePath(), (Exception)e);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    private static File findJvmLocation(File javaHome, String ... paths) {
        for (String path : paths) {
            File jvmLocation = new File(javaHome, path);
            if (!jvmLocation.isFile()) continue;
            return jvmLocation;
        }
        return null;
    }

    private void copyWinRun4JExecutable() throws MojoExecutionException {
        String executablePath = this.getWinrun4jExecutablePath();
        URL url = Thread.currentThread().getContextClassLoader().getResource(executablePath);
        if (url == null) {
            throw new MojoExecutionException("Could not locate WinRun4J executable at path: " + executablePath);
        }
        try {
            FileUtils.copyURLToFile((URL)url, (File)this.pluginExecutableFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not copy WinRun4J executable to: " + this.pluginExecutableFile.getAbsolutePath(), (Exception)e);
        }
    }

    private void buildUnixPlugin() throws MojoExecutionException {
        this.createPluginDirectory();
        File javaLocation = new File(this.pluginDefinition.getJavaHome(), "bin/java");
        if (this.log.isDebugEnabled()) {
            this.log.debug((CharSequence)("javaLocation=" + javaLocation.getAbsolutePath()));
        }
        PrintWriter out = null;
        try {
            out = new PrintWriter(new FileWriter(this.pluginExecutableFile));
            out.println("#!/bin/sh");
            out.println();
            out.print("CP=");
            for (int i = 0; i < this.resolvedJars.size(); ++i) {
                if (i > 0) {
                    out.print(":");
                }
                out.print("\"" + this.resolvedJars.get(i).getAbsolutePath() + "\"");
            }
            out.println();
            out.print("ARGS=\"");
            for (String arg : this.pluginDefinition.getArgs()) {
                out.print(arg + " ");
            }
            out.println("\"");
            out.print("JVMARGS=\"");
            for (String jvmArg : this.pluginDefinition.getJvmArgs()) {
                out.print(jvmArg + " ");
            }
            out.println("\"");
            out.println();
            out.println("\"" + javaLocation.getAbsolutePath() + "\" $JVMARGS -cp $CP " + this.pluginDefinition.getMainClass() + " $ARGS");
            out.println();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not write plugin script file: " + this.pluginExecutableFile, (Exception)e);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    private void createPluginDirectory() throws MojoExecutionException {
        this.pluginDirectory.mkdirs();
        if (!this.pluginDirectory.isDirectory()) {
            throw new MojoExecutionException("Could not create protoc plugin directory: " + this.pluginDirectory.getAbsolutePath());
        }
    }

    private void resolvePluginDependencies() throws MojoExecutionException {
        VersionRange versionSpec;
        try {
            versionSpec = VersionRange.createFromVersionSpec((String)this.pluginDefinition.getVersion());
        }
        catch (InvalidVersionSpecificationException e) {
            throw new MojoExecutionException("Invalid plugin version specification", (Exception)((Object)e));
        }
        Artifact protocPluginArtifact = this.artifactFactory.createDependencyArtifact(this.pluginDefinition.getGroupId(), this.pluginDefinition.getArtifactId(), versionSpec, "jar", this.pluginDefinition.getClassifier(), "runtime");
        try {
            ArtifactResolutionResult artifactResolutionResult = this.artifactResolver.resolveTransitively(Collections.singleton(protocPluginArtifact), this.rootResolutionArtifact, this.localRepository, this.remoteRepositories, this.artifactMetadataSource, null);
            Set artifacts = artifactResolutionResult.getArtifacts();
            if (artifacts == null || artifacts.isEmpty()) {
                throw new MojoExecutionException("Unable to resolve plugin artifact");
            }
            for (Artifact artifact : artifacts) {
                this.resolvedJars.add(artifact.getFile());
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((CharSequence)("Resolved jars: " + this.resolvedJars));
            }
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private String getWinrun4jExecutablePath() {
        return "winrun4j/WinRun4J" + this.pluginDefinition.getWinJvmDataModel() + ".exe";
    }
}

