/*
 * Decompiled with CFR 0.152.
 */
package org.hbase.async;

import com.google.common.base.Charsets;
import com.google.protobuf.ByteString;
import com.mapr.fs.proto.Dbfilters;
import java.nio.charset.Charset;
import org.hbase.async.Bytes;
import org.hbase.async.FilterComparator;
import org.hbase.async.ScanFilter;
import org.hbase.async.generated.ComparatorPB;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.util.CharsetUtil;

public final class RegexStringComparator
extends FilterComparator {
    private static final byte[] NAME = Bytes.UTF8("org.apache.hadoop.hbase.filter.RegexStringComparator");
    private final String expr;
    private final Charset charset;
    public static final int kRegexStringComparator = -489178560;

    public RegexStringComparator(String expr) {
        this(expr, Charsets.UTF_8);
    }

    public RegexStringComparator(String expr, Charset charset) {
        this.expr = expr;
        this.charset = charset;
    }

    public String expression() {
        return this.expr;
    }

    public Charset charset() {
        return this.charset;
    }

    @Override
    byte[] name() {
        return NAME;
    }

    @Override
    ComparatorPB.Comparator toProtobuf() {
        ByteString byte_string = ComparatorPB.RegexStringComparator.newBuilder().setPattern(this.expr).setPatternFlags(32).setCharset(this.charset.name()).build().toByteString();
        return super.toProtobuf(byte_string);
    }

    @Override
    void serializeOld(ChannelBuffer buf) {
        super.serializeOld(buf);
        buf.writeByte(0);
        buf.writeByte((int)((byte)NAME.length));
        buf.writeBytes(NAME);
        byte[] expr_bytes = Bytes.UTF8(this.expr);
        buf.writeShort(expr_bytes.length);
        buf.writeBytes(expr_bytes);
        byte[] charset_bytes = Bytes.UTF8(this.charset.name());
        buf.writeShort(charset_bytes.length);
        buf.writeBytes(charset_bytes);
    }

    @Override
    int predictSerializedSize() {
        return super.predictSerializedSize() + 1 + 1 + NAME.length + 2 + Bytes.UTF8(this.expr).length + 2 + Bytes.UTF8(this.charset.name()).length;
    }

    public String toString() {
        return String.format("%s(%s, %s)", this.getClass().getSimpleName(), this.expr, this.charset.name());
    }

    @Override
    protected ByteString getState() {
        return Dbfilters.RegexStringComparatorProto.newBuilder().setPattern(ByteString.copyFrom((byte[])this.expr.getBytes(this.charset))).setPatternFlags(32).setIsUTF8(this.charset == CharsetUtil.UTF_8).build().toByteString();
    }

    @Override
    protected String getName() {
        return ScanFilter.getFilterId(-489178560);
    }
}

