/*
 * Decompiled with CFR 0.152.
 */
package org.hbase.async;

import com.google.protobuf.AbstractMessageLite;
import org.hbase.async.BatchableRpc;
import org.hbase.async.Bytes;
import org.hbase.async.HBaseClient;
import org.hbase.async.HBaseRpc;
import org.hbase.async.KeyValue;
import org.hbase.async.RowLock;
import org.hbase.async.generated.ClientPB;
import org.jboss.netty.buffer.ChannelBuffer;

public final class DeleteRequest
extends BatchableRpc
implements HBaseRpc.HasTable,
HBaseRpc.HasKey,
HBaseRpc.HasFamily,
HBaseRpc.HasQualifiers,
HBaseRpc.IsEdit {
    private static final byte[] DELETE = new byte[]{100, 101, 108, 101, 116, 101};
    static final byte CODE = 31;
    public static final byte[][] DELETE_FAMILY_MARKER = new byte[][]{HBaseClient.EMPTY_ARRAY};
    static final byte[][] WHOLE_ROW = new byte[][]{HBaseClient.EMPTY_ARRAY};
    private final byte[][][] qualifiers;
    private final long[][] timestamps;
    private boolean at_timestamp_only;

    public DeleteRequest(byte[] table, byte[] key) {
        this(table, key, null, null, null, Long.MAX_VALUE, -1L);
    }

    public DeleteRequest(byte[] table, byte[] key, long timestamp) {
        this(table, key, null, null, null, timestamp, -1L);
    }

    public DeleteRequest(byte[] table, byte[] key, byte[] family) {
        this(table, key, new byte[][]{family}, null, null, Long.MAX_VALUE, -1L);
    }

    public DeleteRequest(byte[] table, byte[] key, byte[][] families) {
        this(table, key, families, null, null, Long.MAX_VALUE, -1L);
    }

    public DeleteRequest(byte[] table, byte[] key, byte[] family, long timestamp) {
        this(table, key, new byte[][]{family}, null, null, timestamp, -1L);
    }

    public DeleteRequest(byte[] table, byte[] key, byte[] family, byte[] qualifier) {
        Object object;
        byte[][] byArrayArray = new byte[][]{family};
        if (qualifier == null) {
            object = null;
        } else {
            byte[][][] byArrayArray2 = new byte[1][][];
            object = byArrayArray2;
            byArrayArray2[0] = new byte[][]{qualifier};
        }
        this(table, key, byArrayArray, (byte[][][])object, null, Long.MAX_VALUE, -1L);
    }

    public DeleteRequest(byte[] table, byte[] key, byte[] family, byte[] qualifier, long timestamp) {
        Object object;
        byte[][] byArrayArray = new byte[][]{family};
        if (qualifier == null) {
            object = null;
        } else {
            byte[][][] byArrayArray2 = new byte[1][][];
            object = byArrayArray2;
            byArrayArray2[0] = new byte[][]{qualifier};
        }
        this(table, key, byArrayArray, (byte[][][])object, null, timestamp, -1L);
    }

    public DeleteRequest(byte[] table, byte[] key, byte[] family, byte[][] qualifiers) {
        this(table, key, new byte[][]{family}, new byte[][][]{qualifiers}, null, Long.MAX_VALUE, -1L);
    }

    public DeleteRequest(byte[] table, byte[] key, byte[] family, byte[][] qualifiers, long[] timestamps) {
        this(table, key, new byte[][]{family}, new byte[][][]{qualifiers}, new long[][]{timestamps}, Long.MAX_VALUE, -1L);
    }

    public DeleteRequest(byte[] table, byte[] key, byte[][] families, byte[][][] qualifiers) {
        this(table, key, families, qualifiers, null, Long.MAX_VALUE, -1L);
    }

    public DeleteRequest(byte[] table, byte[] key, byte[][] families, byte[][][] qualifiers, long[][] timestamps) {
        this(table, key, families, qualifiers, timestamps, Long.MAX_VALUE, -1L);
    }

    public DeleteRequest(byte[] table, byte[] key, byte[][] families, byte[][][] qualifiers, long[][] timestamps, long timestamp) {
        this(table, key, families, qualifiers, timestamps, timestamp, -1L);
    }

    public DeleteRequest(byte[] table, byte[] key, byte[] family, byte[][] qualifiers, long timestamp) {
        this(table, key, new byte[][]{family}, new byte[][][]{qualifiers}, null, timestamp, -1L);
    }

    public DeleteRequest(byte[] table, byte[] key, byte[][] families, byte[][][] qualifiers, long timestamp) {
        this(table, key, families, qualifiers, null, timestamp, -1L);
    }

    public DeleteRequest(byte[] table, byte[] key, byte[] family, byte[] qualifier, RowLock lock) {
        Object object;
        byte[][] byArrayArray = new byte[][]{family};
        if (qualifier == null) {
            object = null;
        } else {
            byte[][][] byArrayArray2 = new byte[1][][];
            object = byArrayArray2;
            byArrayArray2[0] = new byte[][]{qualifier};
        }
        this(table, key, byArrayArray, (byte[][][])object, null, Long.MAX_VALUE, lock.id());
    }

    public DeleteRequest(byte[] table, byte[] key, byte[] family, byte[] qualifier, long timestamp, RowLock lock) {
        Object object;
        byte[][] byArrayArray = new byte[][]{family};
        if (qualifier == null) {
            object = null;
        } else {
            byte[][][] byArrayArray2 = new byte[1][][];
            object = byArrayArray2;
            byArrayArray2[0] = new byte[][]{qualifier};
        }
        this(table, key, byArrayArray, (byte[][][])object, null, timestamp, lock.id());
    }

    public DeleteRequest(byte[] table, byte[] key, byte[] family, byte[][] qualifiers, RowLock lock) {
        this(table, key, new byte[][]{family}, new byte[][][]{qualifiers}, null, Long.MAX_VALUE, lock.id());
    }

    public DeleteRequest(byte[] table, byte[] key, byte[][] families, byte[][][] qualifiers, RowLock lock) {
        this(table, key, families, qualifiers, null, Long.MAX_VALUE, lock.id());
    }

    public DeleteRequest(byte[] table, byte[] key, byte[] family, byte[][] qualifiers, long timestamp, RowLock lock) {
        this(table, key, new byte[][]{family}, new byte[][][]{qualifiers}, null, timestamp, lock.id());
    }

    public DeleteRequest(byte[] table, byte[] key, byte[][] families, byte[][][] qualifiers, long timestamp, RowLock lock) {
        this(table, key, families, qualifiers, null, timestamp, lock.id());
    }

    public DeleteRequest(String table, String key) {
        this(table.getBytes(), key.getBytes(), null, null, null, Long.MAX_VALUE, -1L);
    }

    public DeleteRequest(String table, String key, String family) {
        this(table.getBytes(), key.getBytes(), new byte[][]{family.getBytes()}, null, null, Long.MAX_VALUE, -1L);
    }

    public DeleteRequest(String table, String key, String family, String qualifier) {
        Object object;
        byte[] byArray = table.getBytes();
        byte[] byArray2 = key.getBytes();
        byte[][] byArrayArray = new byte[][]{family.getBytes()};
        if (qualifier == null) {
            object = null;
        } else {
            byte[][][] byArrayArray2 = new byte[1][][];
            object = byArrayArray2;
            byArrayArray2[0] = new byte[][]{qualifier.getBytes()};
        }
        this(byArray, byArray2, byArrayArray, (byte[][][])object, null, Long.MAX_VALUE, -1L);
    }

    public DeleteRequest(String table, String key, String family, String qualifier, RowLock lock) {
        Object object;
        byte[] byArray = table.getBytes();
        byte[] byArray2 = key.getBytes();
        byte[][] byArrayArray = new byte[][]{family.getBytes()};
        if (qualifier == null) {
            object = null;
        } else {
            byte[][][] byArrayArray2 = new byte[1][][];
            object = byArrayArray2;
            byArrayArray2[0] = new byte[][]{qualifier.getBytes()};
        }
        this(byArray, byArray2, byArrayArray, (byte[][][])object, null, Long.MAX_VALUE, lock.id());
    }

    public DeleteRequest(byte[] table, KeyValue kv) {
        this(table, kv.key(), new byte[][]{kv.family()}, new byte[][][]{new byte[][]{kv.qualifier()}}, null, kv.timestamp(), -1L);
    }

    public DeleteRequest(byte[] table, KeyValue kv, RowLock lock) {
        this(table, kv.key(), new byte[][]{kv.family()}, new byte[][][]{new byte[][]{kv.qualifier()}}, null, kv.timestamp(), lock.id());
    }

    private DeleteRequest(byte[] table, byte[] key, byte[][] families, byte[][][] qualifiers, long[][] timestamps, long row_timestamp, long lockid) {
        super(table, key, families == null ? WHOLE_ROW : families, row_timestamp, lockid);
        this.at_timestamp_only = false;
        this.checkParams(families, qualifiers, timestamps);
        this.qualifiers = qualifiers;
        this.timestamps = timestamps;
    }

    private void checkParams(byte[][] families, byte[][][] qualifiers, long[][] timestamps) {
        if (families != null) {
            for (byte[] family : families) {
                KeyValue.checkFamily(family);
            }
        }
        if (qualifiers != null) {
            if (families == null) {
                throw new IllegalArgumentException("You can't delete specific qualifiers without specifying which family they belong to. table=" + Bytes.pretty(this.table) + ", key=" + Bytes.pretty(this.key));
            }
            if (families.length != qualifiers.length) {
                throw new IllegalArgumentException("Length of the qualifier array does not match that of the family. table=" + Bytes.pretty(this.table) + ", key=" + Bytes.pretty(this.key));
            }
            if (timestamps != null && families.length != timestamps.length) {
                throw new IllegalArgumentException(String.format("Mismatch in number of families(%d) and timestamps(%d) array size.", families.length, timestamps.length));
            }
            for (int idx = 0; idx < families.length; ++idx) {
                if (qualifiers[idx] == null) continue;
                if (qualifiers[idx].length == 0) {
                    throw new IllegalArgumentException("Don't pass an empty list of qualifiers, this would delete the entire row of table=" + Bytes.pretty(this.table) + " at key " + Bytes.pretty(this.key));
                }
                if (timestamps != null && qualifiers[idx].length != timestamps[idx].length) {
                    throw new IllegalArgumentException("Found " + qualifiers[idx].length + " qualifiers and " + timestamps[idx].length + " timestamps for family " + families[idx] + " at index " + idx + ". Should be equal.");
                }
                for (byte[] qualifier : qualifiers[idx]) {
                    KeyValue.checkQualifier(qualifier);
                }
            }
        } else if (timestamps != null) {
            throw new IllegalArgumentException("Timestamps have been specified without specifying qualifiers.");
        }
    }

    public void setDeleteAtTimestampOnly(boolean at_timestamp_only) {
        this.at_timestamp_only = at_timestamp_only;
    }

    public boolean deleteAtTimestampOnly() {
        return this.at_timestamp_only;
    }

    @Override
    byte[] method(byte server_version) {
        return server_version >= 95 ? MUTATE : DELETE;
    }

    @Override
    public byte[] table() {
        return this.table;
    }

    @Override
    public byte[] key() {
        return this.key;
    }

    @Override
    public byte[][] qualifiers() {
        return this.qualifiers == null ? (byte[][])null : this.qualifiers[0];
    }

    @Override
    public byte[][][] getQualifiers() {
        return this.qualifiers;
    }

    @Override
    public String toString() {
        return super.toStringWithQualifiers("DeleteRequest", this.families, this.qualifiers);
    }

    @Override
    byte version(byte unused_server_version) {
        return 3;
    }

    @Override
    byte code() {
        return 31;
    }

    @Override
    int numKeyValues() {
        return this.qualifiers != null && this.qualifiers[0] != null ? this.qualifiers[0].length : 1;
    }

    @Override
    void serializePayload(ChannelBuffer buf) {
        this.serializePayload(buf, 0);
    }

    private void serializePayload(ChannelBuffer buf, int family_idx) {
        boolean has_timestamps;
        if (this.families == WHOLE_ROW) {
            return;
        }
        boolean has_qualifiers = this.qualifiers != null && this.qualifiers[family_idx] != null;
        boolean bl = has_timestamps = this.timestamps != null && this.timestamps[family_idx] != null;
        byte type = !has_qualifiers ? (byte)14 : (this.at_timestamp_only ? (byte)8 : 12);
        byte[][] family_qualifiers = !has_qualifiers ? DELETE_FAMILY_MARKER : this.qualifiers[family_idx];
        for (int i = 0; i < family_qualifiers.length; ++i) {
            byte[] qualifier = family_qualifiers[i];
            KeyValue.serialize(buf, type, has_timestamps ? this.timestamps[family_idx][i] : this.timestamp, this.key, this.families[family_idx], qualifier, null);
        }
    }

    private int predictSerializedSize() {
        int size = 0;
        size += 4;
        ++size;
        size += 3;
        size += this.region.name().length;
        ++size;
        ++size;
        ++size;
        size += 3;
        size += this.key.length;
        size += 8;
        size += 8;
        size += 4;
        return size += this.payloadsSize();
    }

    @Override
    int payloadsSize() {
        int size = 0;
        if (this.families != WHOLE_ROW) {
            for (int i = 0; i < this.families.length; ++i) {
                ++size;
                size += this.families[i].length;
                size += 4;
                size += this.payloadSize(i);
            }
        }
        return size;
    }

    @Override
    int payloadSize() {
        return this.payloadSize(0);
    }

    private int payloadSize(int family_idx) {
        if (this.families == WHOLE_ROW) {
            return 0;
        }
        int size = 0;
        size += 4;
        size += 4;
        size += 4;
        size += 2;
        size += this.key.length;
        ++size;
        size += this.families[family_idx].length;
        size += 8;
        ++size;
        byte[][] family_qualifiers = this.qualifiers == null || this.qualifiers[family_idx] == null ? DELETE_FAMILY_MARKER : this.qualifiers[family_idx];
        size *= family_qualifiers.length;
        for (byte[] qualifier : family_qualifiers) {
            size += qualifier.length;
        }
        return size;
    }

    @Override
    ClientPB.MutationProto toMutationProto() {
        ClientPB.MutationProto.Builder del = ClientPB.MutationProto.newBuilder().setRow(Bytes.wrap(this.key)).setMutateType(ClientPB.MutationProto.MutationType.DELETE);
        if (this.families != WHOLE_ROW) {
            ClientPB.MutationProto.ColumnValue.Builder columns = ClientPB.MutationProto.ColumnValue.newBuilder();
            for (int i = 0; i < this.families.length; ++i) {
                byte[] family = this.families[i];
                columns.clear();
                columns.setFamily(Bytes.wrap(family));
                if (this.qualifiers == null) {
                    ClientPB.MutationProto.DeleteType type = ClientPB.MutationProto.DeleteType.DELETE_FAMILY;
                    ClientPB.MutationProto.ColumnValue.QualifierValue column = ClientPB.MutationProto.ColumnValue.QualifierValue.newBuilder().setQualifier(Bytes.wrap(HBaseClient.EMPTY_ARRAY)).setValue(Bytes.wrap(HBaseClient.EMPTY_ARRAY)).setTimestamp(this.timestamp).setDeleteType(type).build();
                    columns.addQualifierValue(column);
                } else {
                    ClientPB.MutationProto.DeleteType type;
                    boolean has_timestamps;
                    boolean bl = has_timestamps = this.timestamps != null && this.timestamps[i] != null;
                    ClientPB.MutationProto.DeleteType deleteType = this.qualifiers[i] == null ? ClientPB.MutationProto.DeleteType.DELETE_FAMILY : (type = this.at_timestamp_only ? ClientPB.MutationProto.DeleteType.DELETE_ONE_VERSION : ClientPB.MutationProto.DeleteType.DELETE_MULTIPLE_VERSIONS);
                    if (this.qualifiers[i] != null) {
                        for (int j = 0; j < this.qualifiers[i].length; ++j) {
                            ClientPB.MutationProto.ColumnValue.QualifierValue column = ClientPB.MutationProto.ColumnValue.QualifierValue.newBuilder().setQualifier(Bytes.wrap(this.qualifiers[i][j])).setTimestamp(has_timestamps ? this.timestamps[i][j] : this.timestamp).setDeleteType(type).build();
                            columns.addQualifierValue(column);
                        }
                    }
                }
                del.addColumnValue(columns);
            }
        }
        if (!this.durable) {
            del.setDurability(ClientPB.MutationProto.Durability.SKIP_WAL);
        }
        return del.build();
    }

    @Override
    ChannelBuffer serialize(byte server_version) {
        if (server_version < 95) {
            return this.serializeOld(server_version);
        }
        ClientPB.MutateRequest req = ClientPB.MutateRequest.newBuilder().setRegion(this.region.toProtobuf()).setMutation(this.toMutationProto()).build();
        return DeleteRequest.toChannelBuffer(MUTATE, (AbstractMessageLite)req);
    }

    private ChannelBuffer serializeOld(byte server_version) {
        ChannelBuffer buf = this.newBuffer(server_version, this.predictSerializedSize());
        buf.writeInt(2);
        DeleteRequest.writeHBaseByteArray(buf, this.region.name());
        buf.writeByte(31);
        buf.writeByte(31);
        buf.writeByte(1);
        DeleteRequest.writeByteArray(buf, this.key);
        buf.writeLong(this.timestamp);
        buf.writeLong(this.lockid);
        if (this.families == WHOLE_ROW) {
            buf.writeInt(0);
            return buf;
        }
        buf.writeInt(this.families.length);
        this.serializePayloads(buf);
        return buf;
    }

    @Override
    void serializePayloads(ChannelBuffer buf) {
        for (int i = 0; i < this.families.length; ++i) {
            DeleteRequest.writeByteArray(buf, this.families[i]);
            byte[][] family_qualifiers = this.qualifiers != null && this.qualifiers[i] != null ? this.qualifiers[i] : DELETE_FAMILY_MARKER;
            buf.writeInt(family_qualifiers.length);
            this.serializePayload(buf, i);
        }
    }

    @Override
    Object deserialize(ChannelBuffer buf, int cell_size) {
        HBaseRpc.ensureNoCell(cell_size);
        ClientPB.MutateResponse resp = DeleteRequest.readProtobuf(buf, ClientPB.MutateResponse.PARSER);
        return null;
    }
}

