/*
 * Decompiled with CFR 0.152.
 */
package org.hbase.async;

import com.google.protobuf.ByteString;
import com.mapr.fs.proto.Dbfilters;
import org.hbase.async.Bytes;
import org.hbase.async.ScanFilter;
import org.hbase.async.generated.FilterPB;
import org.jboss.netty.buffer.ChannelBuffer;

public final class ColumnPaginationFilter
extends ScanFilter {
    private static final byte[] NAME = Bytes.UTF8("org.apache.hadoop.hbase.filter.ColumnPaginationFilter");
    private int limit = 0;
    private int offset = -1;
    private byte[] columnOffset = null;
    public static final int kColumnPaginationFilter = -2105150122;

    public ColumnPaginationFilter(int limit, int offset) {
        this.limit = limit;
        this.offset = offset;
    }

    public ColumnPaginationFilter(int limit, byte[] columnOffset) {
        this.limit = limit;
        this.columnOffset = columnOffset;
    }

    public ColumnPaginationFilter(int limit, String columnOffset) {
        this.limit = limit;
        this.columnOffset = Bytes.UTF8(columnOffset);
    }

    @Override
    byte[] serialize() {
        FilterPB.ColumnPaginationFilter.Builder builder = FilterPB.ColumnPaginationFilter.newBuilder();
        builder.setLimit(this.limit);
        if (this.offset >= 0) {
            builder.setOffset(this.offset);
        }
        if (this.columnOffset != null) {
            builder.setColumnOffset(Bytes.wrap(this.columnOffset));
        }
        return builder.build().toByteArray();
    }

    @Override
    byte[] name() {
        return NAME;
    }

    @Override
    int predictSerializedSize() {
        int size = 1 + NAME.length + 3 + (this.columnOffset == null ? 0 : this.columnOffset.length) + 4 + 4;
        return size;
    }

    @Override
    void serializeOld(ChannelBuffer buf) {
        buf.writeByte((int)((byte)NAME.length));
        buf.writeBytes(NAME);
        buf.writeInt(this.limit);
        buf.writeInt(this.offset);
        if (this.columnOffset != null) {
            throw new UnsupportedOperationException("Setting a column offset by byte array is not supported before HBase 0.96");
        }
    }

    public String toString() {
        if (this.columnOffset != null) {
            return this.getClass().getSimpleName() + "(" + this.limit + ", " + Bytes.pretty(this.columnOffset) + ")";
        }
        return String.format("%s (%d, %d): predict:%d serialize:%d %s", this.getClass().getSimpleName(), this.limit, this.offset, this.predictSerializedSize(), this.serialize().length, Bytes.pretty(this.serialize()));
    }

    @Override
    protected ByteString getState() {
        return Dbfilters.ColumnPaginationFilterProto.newBuilder().setLimit(this.limit).setOffset(this.offset).build().toByteString();
    }

    @Override
    protected String getId() {
        return ColumnPaginationFilter.getFilterId(-2105150122);
    }
}

