/*
 * Decompiled with CFR 0.152.
 */
package org.hbase.async;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Config {
    private static final Logger LOG = LoggerFactory.getLogger(Config.class);
    public static final boolean RUNNING_WINDOWS = System.getProperty("os.name") != null ? System.getProperty("os.name").contains("Windows") : false;
    protected final HashMap<String, String> properties = new HashMap();
    protected final HashMap<String, String> default_map = new HashMap();
    protected String config_location;

    public Config() {
        this.loadSystemAndDefaults();
        try {
            InputStream file_stream = this.getClass().getClassLoader().getResourceAsStream("asynchbase.conf");
            this.loadConfig(file_stream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Config(String file) throws IOException {
        this.loadSystemAndDefaults();
        this.loadConfig(file);
    }

    public Config(Config parent) {
        this.properties.putAll(parent.properties);
        this.config_location = parent.config_location;
        this.loadSystemAndDefaults();
    }

    public void overrideConfig(String property, String value) {
        this.properties.put(property, value);
    }

    public final String getString(String property) {
        return this.properties.get(property);
    }

    public final int getInt(String property) {
        return Integer.parseInt(this.properties.get(property));
    }

    public final short getShort(String property) {
        return Short.parseShort(this.properties.get(property));
    }

    public final long getLong(String property) {
        return Long.parseLong(this.properties.get(property));
    }

    public final float getFloat(String property) {
        return Float.parseFloat(this.properties.get(property));
    }

    public final double getDouble(String property) {
        return Double.parseDouble(this.properties.get(property));
    }

    public final boolean getBoolean(String property) {
        if (this.properties.containsKey(property)) {
            String val = this.properties.get(property).toUpperCase();
            if (val.equals("1")) {
                return true;
            }
            if (val.equals("TRUE")) {
                return true;
            }
            if (val.equals("YES")) {
                return true;
            }
        }
        return false;
    }

    public final String getDirectoryName(String property) {
        String directory = this.properties.get(property);
        if (directory == null || directory.isEmpty()) {
            return null;
        }
        if (RUNNING_WINDOWS) {
            if (directory.charAt(directory.length() - 1) == '\\' || directory.charAt(directory.length() - 1) == '/') {
                return directory;
            }
            if (directory.contains("/")) {
                return directory + "/";
            }
            return directory + "\\";
        }
        if (directory.contains("\\")) {
            throw new IllegalArgumentException("Unix path names cannot contain a back slash");
        }
        if (directory.charAt(directory.length() - 1) == '/') {
            return directory;
        }
        return directory + "/";
    }

    public final boolean hasProperty(String property) {
        String val = this.properties.get(property);
        if (val == null) {
            return false;
        }
        return !val.isEmpty();
    }

    public final String dumpConfiguration() {
        if (this.properties.isEmpty()) {
            return "No configuration settings stored";
        }
        StringBuilder response = new StringBuilder("Configuration:\n");
        response.append("File [" + this.config_location + "]\n");
        int line = 0;
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            if (line > 0) {
                response.append("\n");
            }
            response.append("Key [" + entry.getKey() + "]  Value [");
            if (entry.getKey().toUpperCase().contains("PASS")) {
                response.append("********");
            } else {
                response.append(entry.getValue());
            }
            response.append("]");
            ++line;
        }
        return response.toString();
    }

    public final Map<String, String> getMap() {
        return new HashMap<String, String>(this.properties);
    }

    private void loadSystemAndDefaults() {
        this.default_map.put("hbase.rpcs.buffered_flush_interval", "1000");
        this.default_map.put("hbase.rpcs.batch.size", "1024");
        this.default_map.put("hbase.region_client.check_channel_write_status", "false");
        this.default_map.put("hbase.region_client.inflight_limit", "0");
        this.default_map.put("hbase.region_client.pending_limit", "0");
        this.default_map.put("hbase.nsre.low_watermark", "1000");
        this.default_map.put("hbase.nsre.high_watermark", "10000");
        this.default_map.put("hbase.timer.tick", "20");
        this.default_map.put("hbase.timer.ticks_per_wheel", "512");
        this.default_map.put("hbase.security.auth.enable", "false");
        this.default_map.put("hbase.zookeeper.getroot.retry_delay", "1000");
        this.default_map.put("hbase.hbase.ipc.client.connection.idle_timeout", "300");
        this.default_map.put("hbase.increments.buffer_size", "65535");
        this.default_map.put("hbase.zookeeper.quorum", "localhost");
        this.default_map.put("hbase.zookeeper.znode.parent", "/hbase");
        this.default_map.put("hbase.zookeeper.session.timeout", "5000");
        this.default_map.put("hbase.client.retries.number", "10");
        this.default_map.put("hbase.rpc.timeout", "0");
        this.default_map.put("hbase.ipc.client.connection.maxidletime", "0");
        this.default_map.put("hbase.ipc.client.connect.max.retries", "0");
        this.default_map.put("hbase.ipc.client.socket.timeout.connect", "5000");
        this.default_map.put("hbase.ipc.client.tcpnodelay", "true");
        this.default_map.put("hbase.ipc.client.tcpkeepalive", "true");
        for (Map.Entry<String, String> entry : this.default_map.entrySet()) {
            if (this.properties.containsKey(entry.getKey())) continue;
            this.properties.put(entry.getKey(), entry.getValue());
        }
    }

    protected void loadConfig(String file) throws FileNotFoundException, IOException {
        FileInputStream file_stream = new FileInputStream(file);
        this.loadConfig(file_stream);
        LOG.info("Successfully loaded configuration file: " + file);
        this.config_location = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadConfig(InputStream file_stream) throws IOException {
        if (file_stream == null) {
            throw new IOException("File stream is null");
        }
        try {
            Properties props = new Properties();
            props.load(file_stream);
            this.loadHashMap(props);
        }
        finally {
            file_stream.close();
        }
    }

    private void loadHashMap(Properties props) {
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            this.properties.put(key, props.getProperty(key));
        }
    }
}

