/*
 * Decompiled with CFR 0.152.
 */
package org.hbase.async;

import com.google.protobuf.ByteString;
import com.mapr.fs.proto.Dbfilters;
import org.hbase.async.Bytes;
import org.hbase.async.FilterComparator;
import org.hbase.async.HBaseRpc;
import org.hbase.async.ScanFilter;
import org.hbase.async.generated.ComparatorPB;
import org.jboss.netty.buffer.ChannelBuffer;

public final class BitComparator
extends FilterComparator {
    private static final byte[] NAME = Bytes.UTF8("org.apache.hadoop.hbase.filter.BitComparator");
    private static final byte CODE = 48;
    private final byte[] value;
    private final BitwiseOp bit_operator;
    public static final int kBitComparator = 1829255125;

    public BitComparator(byte[] value, BitwiseOp bitOperator) {
        this.value = value;
        this.bit_operator = bitOperator;
    }

    public byte[] value() {
        return (byte[])this.value.clone();
    }

    public BitwiseOp bitwiseOperator() {
        return this.bit_operator;
    }

    @Override
    byte[] name() {
        return NAME;
    }

    @Override
    ComparatorPB.Comparator toProtobuf() {
        ByteString byte_string = ComparatorPB.BitComparator.newBuilder().setComparable(ComparatorPB.ByteArrayComparable.newBuilder().setValue(Bytes.wrap(this.value))).setBitwiseOp(ComparatorPB.BitComparator.BitwiseOp.valueOf(this.bit_operator.name())).build().toByteString();
        return super.toProtobuf(byte_string);
    }

    @Override
    void serializeOld(ChannelBuffer buf) {
        super.serializeOld(buf);
        buf.writeByte(48);
        HBaseRpc.writeByteArray(buf, this.value);
        byte[] op_name = Bytes.UTF8(this.bit_operator.name());
        buf.writeShort(op_name.length);
        buf.writeBytes(op_name);
    }

    @Override
    int predictSerializedSize() {
        return 4 + this.value.length + 2 + Bytes.UTF8(this.bit_operator.name()).length;
    }

    public String toString() {
        return String.format("%s(%s)", this.getClass().getSimpleName(), Bytes.pretty(this.value));
    }

    @Override
    protected ByteString getState() {
        return Dbfilters.BitComparatorProto.newBuilder().setComparable(ByteString.copyFrom((byte[])this.value)).setBitwiseOp(Dbfilters.BitComparatorProto.BitwiseOpProto.valueOf((String)this.bit_operator.name())).build().toByteString();
    }

    @Override
    protected String getName() {
        return ScanFilter.getFilterId(1829255125);
    }

    public static enum BitwiseOp {
        AND,
        OR,
        XOR;

    }
}

